/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.AbstractMultimap;
import com.google.common.collect.Collections2;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.FilteredMultimap;
import com.google.common.collect.FilteredMultimapValues;
import com.google.common.collect.ForwardingCollection;
import com.google.common.collect.ForwardingList;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.ParametricNullness;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

@ElementTypesAreNonnullByDefault
@GwtCompatible
class FilteredKeyMultimap<K, V>
extends AbstractMultimap<K, V>
implements FilteredMultimap<K, V> {
    final Multimap<K, V> unfiltered;
    final Predicate<? super K> keyPredicate;

    /*
     * WARNING - void declaration
     */
    FilteredKeyMultimap(Multimap<K, V> unfiltered, Predicate<? super K> keyPredicate) {
        void var2_2;
        void var1_1;
        this.unfiltered = (Multimap)Preconditions.checkNotNull(var1_1);
        this.keyPredicate = (Predicate)Preconditions.checkNotNull(var2_2);
    }

    @Override
    public Multimap<K, V> unfiltered() {
        return this.unfiltered;
    }

    @Override
    public Predicate<? super Map.Entry<K, V>> entryPredicate() {
        return Maps.keyPredicateOnEntries(this.keyPredicate);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int size() {
        void var1_1;
        int size = 0;
        for (Collection collection : this.asMap().values()) {
            void var3_3;
            size += var3_3.size();
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsKey(Object key) {
        if (this.unfiltered.containsKey(key)) {
            void var1_1;
            return this.keyPredicate.apply(var1_1);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Collection<V> removeAll(Object key) {
        if (this.containsKey(key)) {
            void var1_1;
            return this.unfiltered.removeAll(var1_1);
        }
        return this.unmodifiableEmptyCollection();
    }

    Collection<V> unmodifiableEmptyCollection() {
        if (this.unfiltered instanceof SetMultimap) {
            return Collections.emptySet();
        }
        return Collections.emptyList();
    }

    @Override
    public void clear() {
        this.keySet().clear();
    }

    @Override
    Set<K> createKeySet() {
        return Sets.filter(this.unfiltered.keySet(), this.keyPredicate);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Collection<V> get(@ParametricNullness K key) {
        void var1_1;
        if (this.keyPredicate.apply(key)) {
            return this.unfiltered.get(key);
        }
        if (this.unfiltered instanceof SetMultimap) {
            return new AddRejectingSet(key);
        }
        return new AddRejectingList(var1_1);
    }

    @Override
    Iterator<Map.Entry<K, V>> entryIterator() {
        throw new AssertionError((Object)"should never be called");
    }

    @Override
    Collection<Map.Entry<K, V>> createEntries() {
        return new Entries(this);
    }

    @Override
    Collection<V> createValues() {
        return new FilteredMultimapValues(this);
    }

    @Override
    Map<K, Collection<V>> createAsMap() {
        return Maps.filterKeys(this.unfiltered.asMap(), this.keyPredicate);
    }

    @Override
    Multiset<K> createKeys() {
        return Multisets.filter(this.unfiltered.keys(), this.keyPredicate);
    }

    class Entries
    extends ForwardingCollection<Map.Entry<K, V>> {
        final /* synthetic */ FilteredKeyMultimap this$0;

        /*
         * WARNING - void declaration
         */
        Entries(FilteredKeyMultimap this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        protected Collection<Map.Entry<K, V>> delegate() {
            return Collections2.filter(this.this$0.unfiltered.entries(), this.this$0.entryPredicate());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean remove(Object o) {
            Map.Entry entry;
            if (o instanceof Map.Entry && this.this$0.unfiltered.containsKey((entry = (Map.Entry)o).getKey()) && this.this$0.keyPredicate.apply(entry.getKey())) {
                void var1_1;
                return this.this$0.unfiltered.remove(entry.getKey(), var1_1.getValue());
            }
            return false;
        }
    }

    static class AddRejectingList<K, V>
    extends ForwardingList<V> {
        @ParametricNullness
        final K key;

        /*
         * WARNING - void declaration
         */
        AddRejectingList(@ParametricNullness K key) {
            void var1_1;
            this.key = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean add(@ParametricNullness V v) {
            void var1_1;
            ((ForwardingList)this).add(0, var1_1);
            return true;
        }

        @Override
        public void add(int index, @ParametricNullness V element) {
            Preconditions.checkPositionIndex(index, 0);
            String string = String.valueOf(this.key);
            throw new IllegalArgumentException(new StringBuilder(32 + String.valueOf(string).length()).append("Key does not satisfy predicate: ").append(string).toString());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean addAll(Collection<? extends V> collection) {
            void var1_1;
            ((ForwardingList)this).addAll(0, var1_1);
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean addAll(int index, Collection<? extends V> elements) {
            void var1_1;
            Preconditions.checkNotNull(elements);
            Preconditions.checkPositionIndex((int)var1_1, 0);
            String string = String.valueOf(this.key);
            throw new IllegalArgumentException(new StringBuilder(32 + String.valueOf(string).length()).append("Key does not satisfy predicate: ").append(string).toString());
        }

        @Override
        protected List<V> delegate() {
            return Collections.emptyList();
        }
    }

    static class AddRejectingSet<K, V>
    extends ForwardingSet<V> {
        @ParametricNullness
        final K key;

        /*
         * WARNING - void declaration
         */
        AddRejectingSet(@ParametricNullness K key) {
            void var1_1;
            this.key = var1_1;
        }

        @Override
        public boolean add(@ParametricNullness V element) {
            String string = String.valueOf(this.key);
            throw new IllegalArgumentException(new StringBuilder(32 + String.valueOf(string).length()).append("Key does not satisfy predicate: ").append(string).toString());
        }

        @Override
        public boolean addAll(Collection<? extends V> collection) {
            Preconditions.checkNotNull(collection);
            String string = String.valueOf(this.key);
            throw new IllegalArgumentException(new StringBuilder(32 + String.valueOf(string).length()).append("Key does not satisfy predicate: ").append(string).toString());
        }

        @Override
        protected Set<V> delegate() {
            return Collections.emptySet();
        }
    }
}

