/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.AbstractMultimap;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.FilteredMultimap;
import com.google.common.collect.FilteredMultimapValues;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.ParametricNullness;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

@ElementTypesAreNonnullByDefault
@GwtCompatible
class FilteredEntryMultimap<K, V>
extends AbstractMultimap<K, V>
implements FilteredMultimap<K, V> {
    final Multimap<K, V> unfiltered;
    final Predicate<? super Map.Entry<K, V>> predicate;

    /*
     * WARNING - void declaration
     */
    FilteredEntryMultimap(Multimap<K, V> unfiltered, Predicate<? super Map.Entry<K, V>> predicate) {
        void var2_2;
        void var1_1;
        this.unfiltered = (Multimap)Preconditions.checkNotNull(var1_1);
        this.predicate = (Predicate)Preconditions.checkNotNull(var2_2);
    }

    @Override
    public Multimap<K, V> unfiltered() {
        return this.unfiltered;
    }

    @Override
    public Predicate<? super Map.Entry<K, V>> entryPredicate() {
        return this.predicate;
    }

    @Override
    public int size() {
        return this.entries().size();
    }

    /*
     * WARNING - void declaration
     */
    private boolean satisfies(@ParametricNullness K key, @ParametricNullness V value) {
        void var2_2;
        void var1_1;
        return this.predicate.apply(Maps.immutableEntry(var1_1, var2_2));
    }

    /*
     * WARNING - void declaration
     */
    static <E> Collection<E> filterCollection(Collection<E> collection, Predicate<? super E> predicate) {
        void var1_1;
        Collection<E> collection2;
        if (collection instanceof Set) {
            return Sets.filter((Set)collection, predicate);
        }
        return Collections2.filter(collection2, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsKey(Object key) {
        void var1_1;
        return this.asMap().get(var1_1) != null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Collection<V> removeAll(Object key) {
        void var1_1;
        return MoreObjects.firstNonNull(this.asMap().remove(var1_1), this.unmodifiableEmptyCollection());
    }

    Collection<V> unmodifiableEmptyCollection() {
        if (this.unfiltered instanceof SetMultimap) {
            return Collections.emptySet();
        }
        return Collections.emptyList();
    }

    @Override
    public void clear() {
        this.entries().clear();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Collection<V> get(@ParametricNullness K key) {
        void var1_1;
        return FilteredEntryMultimap.filterCollection(this.unfiltered.get(key), new ValuePredicate(this, var1_1));
    }

    @Override
    Collection<Map.Entry<K, V>> createEntries() {
        return FilteredEntryMultimap.filterCollection(this.unfiltered.entries(), this.predicate);
    }

    @Override
    Collection<V> createValues() {
        return new FilteredMultimapValues(this);
    }

    @Override
    Iterator<Map.Entry<K, V>> entryIterator() {
        throw new AssertionError((Object)"should never be called");
    }

    @Override
    Map<K, Collection<V>> createAsMap() {
        return new AsMap(this);
    }

    @Override
    Set<K> createKeySet() {
        return this.asMap().keySet();
    }

    /*
     * WARNING - void declaration
     */
    boolean removeEntriesIf(Predicate<? super Map.Entry<K, Collection<V>>> predicate) {
        void var3_3;
        Iterator<Map.Entry<K, Collection<V>>> entryIterator = this.unfiltered.asMap().entrySet().iterator();
        boolean changed = false;
        while (entryIterator.hasNext()) {
            Map.Entry<K, Collection<V>> entry = entryIterator.next();
            K key = entry.getKey();
            Collection<V> collection = FilteredEntryMultimap.filterCollection(entry.getValue(), new ValuePredicate(this, key));
            if (collection.isEmpty() || !predicate.apply(Maps.immutableEntry(key, collection))) continue;
            if (collection.size() == entry.getValue().size()) {
                entryIterator.remove();
            } else {
                collection.clear();
            }
            changed = true;
        }
        return (boolean)var3_3;
    }

    @Override
    Multiset<K> createKeys() {
        return new Keys();
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$000(FilteredEntryMultimap x0, Object x1, Object x2) {
        void var2_2;
        void var1_1;
        return x0.satisfies(var1_1, var2_2);
    }

    class Keys
    extends Multimaps.Keys<K, V> {
        /*
         * WARNING - void declaration
         */
        Keys() {
            void var1_1;
            super(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int remove(Object key, int occurrences) {
            CollectPreconditions.checkNonnegative(occurrences, "occurrences");
            if (occurrences == 0) {
                return this.count(key);
            }
            Collection collection = FilteredEntryMultimap.this.unfiltered.asMap().get(key);
            if (collection == null) {
                return 0;
            }
            int oldCount = 0;
            Iterator itr = collection.iterator();
            while (itr.hasNext()) {
                void k;
                Object v = itr.next();
                if (!FilteredEntryMultimap.access$000(FilteredEntryMultimap.this, k, v) || ++oldCount > occurrences) continue;
                itr.remove();
            }
            return oldCount;
        }

        @Override
        public Set<Multiset.Entry<K>> entrySet() {
            return new Multisets.EntrySet<K>(this){
                final /* synthetic */ Keys this$1;
                {
                    void var1_1;
                    this.this$1 = var1_1;
                }

                @Override
                Multiset<K> multiset() {
                    return this.this$1;
                }

                @Override
                public Iterator<Multiset.Entry<K>> iterator() {
                    return this.this$1.entryIterator();
                }

                @Override
                public int size() {
                    return this.this$1.FilteredEntryMultimap.this.keySet().size();
                }

                /*
                 * WARNING - void declaration
                 */
                private boolean removeEntriesIf(Predicate<? super Multiset.Entry<K>> predicate) {
                    void var1_1;
                    return this.this$1.FilteredEntryMultimap.this.removeEntriesIf(arg_0 -> 1.lambda$removeEntriesIf$0((Predicate)var1_1, arg_0));
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public boolean removeAll(Collection<?> c) {
                    void var1_1;
                    return this.removeEntriesIf(Predicates.in(var1_1));
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public boolean retainAll(Collection<?> c) {
                    void var1_1;
                    return this.removeEntriesIf(Predicates.not(Predicates.in(var1_1)));
                }

                /*
                 * WARNING - void declaration
                 */
                private static /* synthetic */ boolean lambda$removeEntriesIf$0(Predicate predicate, Map.Entry entry) {
                    void var1_1;
                    return predicate.apply(Multisets.immutableEntry(entry.getKey(), ((Collection)var1_1.getValue()).size()));
                }
            };
        }
    }

    class AsMap
    extends Maps.ViewCachingAbstractMap<K, Collection<V>> {
        final /* synthetic */ FilteredEntryMultimap this$0;

        /*
         * WARNING - void declaration
         */
        AsMap(FilteredEntryMultimap this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean containsKey(Object key) {
            void var1_1;
            return this.get(var1_1) != null;
        }

        @Override
        public void clear() {
            this.this$0.clear();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Collection<V> get(Object key) {
            void var2_2;
            void var1_1;
            Collection result = this.this$0.unfiltered.asMap().get(key);
            if (result == null) {
                return null;
            }
            if ((result = FilteredEntryMultimap.filterCollection(result, new ValuePredicate(this.this$0, var1_1))).isEmpty()) {
                return null;
            }
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Collection<V> remove(Object key) {
            void var3_3;
            Collection collection = this.this$0.unfiltered.asMap().get(key);
            if (collection == null) {
                return null;
            }
            ArrayList result = Lists.newArrayList();
            Iterator itr = collection.iterator();
            while (itr.hasNext()) {
                void k;
                Object v = itr.next();
                if (!FilteredEntryMultimap.access$000(this.this$0, k, v)) continue;
                itr.remove();
                result.add(v);
            }
            if (result.isEmpty()) {
                return null;
            }
            if (this.this$0.unfiltered instanceof SetMultimap) {
                return Collections.unmodifiableSet(Sets.newLinkedHashSet(result));
            }
            return Collections.unmodifiableList(var3_3);
        }

        @Override
        Set<K> createKeySet() {
            class KeySetImpl
            extends Maps.KeySet<K, Collection<V>> {
                /*
                 * WARNING - void declaration
                 */
                KeySetImpl() {
                    void var1_1;
                    super(var1_1);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public boolean removeAll(Collection<?> c) {
                    void var1_1;
                    return AsMap.this.this$0.removeEntriesIf(Maps.keyPredicateOnEntries(Predicates.in(var1_1)));
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public boolean retainAll(Collection<?> c) {
                    void var1_1;
                    return AsMap.this.this$0.removeEntriesIf(Maps.keyPredicateOnEntries(Predicates.not(Predicates.in(var1_1))));
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public boolean remove(Object o) {
                    void var1_1;
                    return AsMap.this.remove(var1_1) != null;
                }
            }
            return new KeySetImpl();
        }

        @Override
        Set<Map.Entry<K, Collection<V>>> createEntrySet() {
            class EntrySetImpl
            extends Maps.EntrySet<K, Collection<V>> {
                final /* synthetic */ AsMap this$1;

                /*
                 * WARNING - void declaration
                 */
                EntrySetImpl(AsMap this$1) {
                    void var1_1;
                    this.this$1 = var1_1;
                }

                @Override
                Map<K, Collection<V>> map() {
                    return this.this$1;
                }

                @Override
                public Iterator<Map.Entry<K, Collection<V>>> iterator() {
                    return new AbstractIterator<Map.Entry<K, Collection<V>>>(this){
                        final Iterator<Map.Entry<K, Collection<V>>> backingIterator;
                        final /* synthetic */ EntrySetImpl this$2;
                        {
                            void var1_1;
                            this.this$2 = var1_1;
                            this.backingIterator = this.this$2.this$1.this$0.unfiltered.asMap().entrySet().iterator();
                        }

                        /*
                         * WARNING - void declaration
                         */
                        @Override
                        protected Map.Entry<K, Collection<V>> computeNext() {
                            while (this.backingIterator.hasNext()) {
                                void var1_1;
                                void var2_2;
                                Map.Entry entry = this.backingIterator.next();
                                Object key = entry.getKey();
                                Collection collection = FilteredEntryMultimap.filterCollection(entry.getValue(), new ValuePredicate(this.this$2.this$1.this$0, key));
                                if (collection.isEmpty()) continue;
                                return Maps.immutableEntry(var2_2, var1_1);
                            }
                            return (Map.Entry)this.endOfData();
                        }
                    };
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public boolean removeAll(Collection<?> c) {
                    void var1_1;
                    return this.this$1.this$0.removeEntriesIf(Predicates.in(var1_1));
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public boolean retainAll(Collection<?> c) {
                    void var1_1;
                    return this.this$1.this$0.removeEntriesIf(Predicates.not(Predicates.in(var1_1)));
                }

                @Override
                public int size() {
                    return Iterators.size(this.iterator());
                }
            }
            return new EntrySetImpl(this);
        }

        @Override
        Collection<Collection<V>> createValues() {
            class ValuesImpl
            extends Maps.Values<K, Collection<V>> {
                /*
                 * WARNING - void declaration
                 */
                ValuesImpl() {
                    void var1_1;
                    super(var1_1);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public boolean remove(Object o) {
                    if (o instanceof Collection) {
                        Collection c = (Collection)o;
                        Iterator entryIterator = AsMap.this.this$0.unfiltered.asMap().entrySet().iterator();
                        while (entryIterator.hasNext()) {
                            void var3_3;
                            Map.Entry entry = entryIterator.next();
                            Object key = entry.getKey();
                            Collection collection = FilteredEntryMultimap.filterCollection(entry.getValue(), new ValuePredicate(AsMap.this.this$0, key));
                            if (collection.isEmpty() || !c.equals(collection)) continue;
                            if (collection.size() == ((Collection)var3_3.getValue()).size()) {
                                entryIterator.remove();
                            } else {
                                collection.clear();
                            }
                            return true;
                        }
                    }
                    return false;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public boolean removeAll(Collection<?> c) {
                    void var1_1;
                    return AsMap.this.this$0.removeEntriesIf(Maps.valuePredicateOnEntries(Predicates.in(var1_1)));
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public boolean retainAll(Collection<?> c) {
                    void var1_1;
                    return AsMap.this.this$0.removeEntriesIf(Maps.valuePredicateOnEntries(Predicates.not(Predicates.in(var1_1))));
                }
            }
            return new ValuesImpl();
        }
    }

    final class ValuePredicate
    implements Predicate<V> {
        @ParametricNullness
        private final K key;
        final /* synthetic */ FilteredEntryMultimap this$0;

        /*
         * WARNING - void declaration
         */
        ValuePredicate(@ParametricNullness FilteredEntryMultimap this$0, K key) {
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            this.key = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean apply(@ParametricNullness V value) {
            void var1_1;
            return FilteredEntryMultimap.access$000(this.this$0, this.key, var1_1);
        }
    }
}

