/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import java.io.Serializable;
import java.util.List;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true)
final class ExplicitOrdering<T>
extends Ordering<T>
implements Serializable {
    final ImmutableMap<T, Integer> rankMap;
    private static final long serialVersionUID = 0L;

    /*
     * WARNING - void declaration
     */
    ExplicitOrdering(List<T> valuesInOrder) {
        this(Maps.indexMap(var1_1));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    ExplicitOrdering(ImmutableMap<T, Integer> rankMap) {
        void var1_1;
        this.rankMap = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int compare(T left, T right) {
        void var2_2;
        void var1_1;
        return this.rank(var1_1) - this.rank(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private int rank(T value) {
        void var2_2;
        Integer rank = this.rankMap.get(value);
        if (rank == null) {
            void var1_1;
            throw new Ordering.IncomparableValueException(var1_1);
        }
        return var2_2.intValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean equals(Object object) {
        if (object instanceof ExplicitOrdering) {
            void var1_1;
            ExplicitOrdering that = (ExplicitOrdering)object;
            return this.rankMap.equals(var1_1.rankMap);
        }
        return false;
    }

    public final int hashCode() {
        return this.rankMap.hashCode();
    }

    public final String toString() {
        String string = String.valueOf(this.rankMap.keySet());
        return new StringBuilder(19 + String.valueOf(string).length()).append("Ordering.explicit(").append(string).append(")").toString();
    }
}

