/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ForwardingCollection;
import com.google.common.collect.ForwardingQueue;
import com.google.common.collect.Iterables;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Queue;

@ElementTypesAreNonnullByDefault
@Beta
@GwtCompatible
public final class EvictingQueue<E>
extends ForwardingQueue<E>
implements Serializable {
    private final Queue<E> delegate;
    @VisibleForTesting
    final int maxSize;
    private static final long serialVersionUID = 0L;

    /*
     * WARNING - void declaration
     */
    private EvictingQueue(int maxSize) {
        void var1_1;
        Preconditions.checkArgument(maxSize >= 0, "maxSize (%s) must >= 0", maxSize);
        this.delegate = new ArrayDeque(maxSize);
        this.maxSize = var1_1;
    }

    public static <E> EvictingQueue<E> create(int maxSize) {
        int n;
        return new EvictingQueue<E>(n);
    }

    public final int remainingCapacity() {
        return this.maxSize - this.size();
    }

    @Override
    protected final Queue<E> delegate() {
        return this.delegate;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean offer(E e) {
        void var1_1;
        return ((ForwardingCollection)this).add(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean add(E e) {
        void var1_1;
        Preconditions.checkNotNull(e);
        if (this.maxSize == 0) {
            return true;
        }
        if (this.size() == this.maxSize) {
            this.delegate.remove();
        }
        this.delegate.add(var1_1);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean addAll(Collection<? extends E> collection) {
        void var1_1;
        int size = collection.size();
        if (size >= this.maxSize) {
            void var2_2;
            this.clear();
            return Iterables.addAll(this, Iterables.skip(collection, (int)(var2_2 - this.maxSize)));
        }
        return this.standardAddAll(var1_1);
    }

    @Override
    public final Object[] toArray() {
        return super.toArray();
    }
}

