/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractMultiset;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.Serialization;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.ObjIntConsumer;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class EnumMultiset<E extends Enum<E>>
extends AbstractMultiset<E>
implements Serializable {
    private transient Class<E> type;
    private transient E[] enumConstants;
    private transient int[] counts;
    private transient int distinctElements;
    private transient long size;
    @GwtIncompatible
    private static final long serialVersionUID = 0L;

    public static <E extends Enum<E>> EnumMultiset<E> create(Class<E> type) {
        Class<E> clazz;
        return new EnumMultiset<E>(clazz);
    }

    /*
     * WARNING - void declaration
     */
    public static <E extends Enum<E>> EnumMultiset<E> create(Iterable<E> elements) {
        void var1_1;
        Iterable<E> iterable;
        Iterator<E> iterator = elements.iterator();
        Preconditions.checkArgument(iterator.hasNext(), "EnumMultiset constructor passed empty Iterable");
        EnumMultiset multiset = new EnumMultiset(((Enum)iterator.next()).getDeclaringClass());
        Iterables.addAll(multiset, iterable);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static <E extends Enum<E>> EnumMultiset<E> create(Iterable<E> elements, Class<E> type) {
        void var1_1;
        Iterable<E> iterable;
        EnumMultiset<E> result = EnumMultiset.create(type);
        Iterables.addAll(result, iterable);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private EnumMultiset(Class<E> type) {
        void var1_1;
        this.type = type;
        Preconditions.checkArgument(type.isEnum());
        this.enumConstants = (Enum[])var1_1.getEnumConstants();
        this.counts = new int[this.enumConstants.length];
    }

    /*
     * WARNING - void declaration
     */
    private boolean isActuallyE(Object o) {
        if (o instanceof Enum) {
            void var1_1;
            void var2_2;
            Enum e = (Enum)o;
            int index = e.ordinal();
            return index < this.enumConstants.length && this.enumConstants[var2_2] == var1_1;
        }
        return false;
    }

    private void checkIsE(Object element) {
        Preconditions.checkNotNull(element);
        if (!this.isActuallyE(element)) {
            String string;
            String string2 = String.valueOf(this.type);
            string = String.valueOf(string);
            throw new ClassCastException(new StringBuilder(21 + String.valueOf(string2).length() + String.valueOf(string).length()).append("Expected an ").append(string2).append(" but got ").append(string).toString());
        }
    }

    @Override
    final int distinctElements() {
        return this.distinctElements;
    }

    @Override
    public final int size() {
        return Ints.saturatedCast(this.size);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int count(Object element) {
        void var1_1;
        if (element == null || !this.isActuallyE(element)) {
            return 0;
        }
        Enum e = (Enum)element;
        return this.counts[var1_1.ordinal()];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int add(E element, int occurrences) {
        void var3_4;
        void var2_3;
        this.checkIsE(element);
        CollectPreconditions.checkNonnegative(occurrences, "occurrences");
        if (occurrences == 0) {
            return this.count(element);
        }
        int index = ((Enum)element).ordinal();
        int oldCount = this.counts[index];
        long newCount = (long)oldCount + (long)occurrences;
        Preconditions.checkArgument(newCount <= Integer.MAX_VALUE, "too many occurrences: %s", newCount);
        this.counts[var1_2] = (int)newCount;
        if (oldCount == 0) {
            ++this.distinctElements;
        }
        this.size += (long)var2_3;
        return (int)var3_4;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int remove(Object element, int occurrences) {
        void var3_5;
        if (element == null || !this.isActuallyE(element)) {
            return 0;
        }
        Enum e = (Enum)element;
        CollectPreconditions.checkNonnegative(occurrences, "occurrences");
        if (occurrences == 0) {
            return this.count(element);
        }
        int index = e.ordinal();
        int oldCount = this.counts[index];
        if (oldCount == 0) {
            return 0;
        }
        if (oldCount <= occurrences) {
            this.counts[index] = 0;
            --this.distinctElements;
            this.size -= (long)oldCount;
        } else {
            void var2_3;
            this.counts[var1_2] = oldCount - occurrences;
            this.size -= (long)var2_3;
        }
        return (int)var3_5;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int setCount(E element, int count) {
        void var3_4;
        void var2_3;
        this.checkIsE(element);
        CollectPreconditions.checkNonnegative(count, "count");
        int index = ((Enum)element).ordinal();
        int oldCount = this.counts[index];
        this.counts[var1_2] = count;
        this.size += (long)(count - oldCount);
        if (oldCount == 0 && count > 0) {
            ++this.distinctElements;
        } else if (oldCount > 0 && var2_3 == false) {
            --this.distinctElements;
        }
        return (int)var3_4;
    }

    @Override
    public final void clear() {
        Arrays.fill(this.counts, 0);
        this.size = 0L;
        this.distinctElements = 0;
    }

    @Override
    final Iterator<E> elementIterator() {
        return new Itr<E>(){
            {
                void var1_1;
                super((EnumMultiset)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            E output(int index) {
                void var1_1;
                return EnumMultiset.this.enumConstants[var1_1];
            }
        };
    }

    @Override
    final Iterator<Multiset.Entry<E>> entryIterator() {
        return new Itr<Multiset.Entry<E>>(){
            {
                void var1_1;
                super((EnumMultiset)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            Multiset.Entry<E> output(int index) {
                void var1_1;
                return new Multisets.AbstractEntry<E>(this, (int)var1_1){
                    final /* synthetic */ int val$index;
                    final /* synthetic */ 2 this$1;
                    {
                        void var1_1;
                        this.this$1 = var1_1;
                        this.val$index = n;
                    }

                    @Override
                    public E getElement() {
                        return this.this$1.EnumMultiset.this.enumConstants[this.val$index];
                    }

                    @Override
                    public int getCount() {
                        return this.this$1.EnumMultiset.this.counts[this.val$index];
                    }
                };
            }
        };
    }

    @Override
    public final void forEachEntry(ObjIntConsumer<? super E> action) {
        Preconditions.checkNotNull(action);
        for (int i = 0; i < this.enumConstants.length; ++i) {
            if (this.counts[i] <= 0) continue;
            action.accept(this.enumConstants[i], this.counts[i]);
        }
    }

    @Override
    public final Iterator<E> iterator() {
        return Multisets.iteratorImpl(this);
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    private void writeObject(ObjectOutputStream stream) throws IOException {
        void var1_1;
        stream.defaultWriteObject();
        stream.writeObject(this.type);
        Serialization.writeMultiset(this, (ObjectOutputStream)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        void var1_1;
        void var2_2;
        stream.defaultReadObject();
        Class localType = (Class)stream.readObject();
        this.type = var2_2;
        this.enumConstants = (Enum[])this.type.getEnumConstants();
        this.counts = new int[this.enumConstants.length];
        Serialization.populateMultiset(this, (ObjectInputStream)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ long access$322(EnumMultiset x0, long x1) {
        void var1_1;
        return x0.size -= var1_1;
    }

    abstract class Itr<T>
    implements Iterator<T> {
        int index = 0;
        int toRemove = -1;
        final /* synthetic */ EnumMultiset this$0;

        /*
         * WARNING - void declaration
         */
        Itr(EnumMultiset this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        abstract T output(int var1);

        @Override
        public boolean hasNext() {
            while (this.index < this.this$0.enumConstants.length) {
                if (this.this$0.counts[this.index] > 0) {
                    return true;
                }
                ++this.index;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public T next() {
            void var1_1;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Itr itr = this;
            T result = itr.output(itr.index);
            this.toRemove = this.index++;
            return var1_1;
        }

        @Override
        public void remove() {
            CollectPreconditions.checkRemove(this.toRemove >= 0);
            if (this.this$0.counts[this.toRemove] > 0) {
                this.this$0.distinctElements--;
                EnumMultiset.access$322(this.this$0, this.this$0.counts[this.toRemove]);
                ((EnumMultiset)this.this$0).counts[this.toRemove] = 0;
            }
            this.toRemove = -1;
        }
    }
}

