/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractBiMap;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.EnumBiMap;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.Maps;
import com.google.common.collect.ParametricNullness;
import com.google.common.collect.Serialization;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class EnumHashBiMap<K extends Enum<K>, V>
extends AbstractBiMap<K, V> {
    private transient Class<K> keyType;
    @GwtIncompatible
    private static final long serialVersionUID = 0L;

    public static <K extends Enum<K>, V> EnumHashBiMap<K, V> create(Class<K> keyType) {
        Class<K> clazz;
        return new EnumHashBiMap<K, V>(clazz);
    }

    /*
     * WARNING - void declaration
     */
    public static <K extends Enum<K>, V> EnumHashBiMap<K, V> create(Map<K, ? extends V> map) {
        void var1_1;
        Map<K, ? extends V> map2;
        EnumHashBiMap<K, ? extends V> bimap = EnumHashBiMap.create(EnumBiMap.inferKeyType(map));
        ((ForwardingMap)bimap).putAll(map2);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private EnumHashBiMap(Class<K> keyType) {
        super(new EnumMap(keyType), Maps.newHashMapWithExpectedSize(((Enum[])keyType.getEnumConstants()).length));
        void var1_1;
        this.keyType = var1_1;
    }

    @Override
    final K checkKey(K key) {
        return (K)((Enum)Preconditions.checkNotNull(key));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V put(K key, @ParametricNullness V value) {
        void var2_2;
        void var1_1;
        return super.put(var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V forcePut(K key, @ParametricNullness V value) {
        void var2_2;
        void var1_1;
        return super.forcePut(var1_1, var2_2);
    }

    public final Class<K> keyType() {
        return this.keyType;
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    private void writeObject(ObjectOutputStream stream) throws IOException {
        void var1_1;
        stream.defaultWriteObject();
        stream.writeObject(this.keyType);
        Serialization.writeMap(this, (ObjectOutputStream)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        void var1_1;
        stream.defaultReadObject();
        this.keyType = (Class)stream.readObject();
        this.setDelegates(new EnumMap(this.keyType), new HashMap(((Enum[])this.keyType.getEnumConstants()).length * 3 / 2));
        Serialization.populateMap(this, (ObjectInputStream)var1_1);
    }
}

