/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractBiMap;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.EnumHashBiMap;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.Serialization;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.EnumMap;
import java.util.Map;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class EnumBiMap<K extends Enum<K>, V extends Enum<V>>
extends AbstractBiMap<K, V> {
    private transient Class<K> keyType;
    private transient Class<V> valueType;
    @GwtIncompatible
    private static final long serialVersionUID = 0L;

    /*
     * WARNING - void declaration
     */
    public static <K extends Enum<K>, V extends Enum<V>> EnumBiMap<K, V> create(Class<K> keyType, Class<V> valueType) {
        void var1_1;
        Class<K> clazz;
        return new EnumBiMap<K, V>(clazz, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <K extends Enum<K>, V extends Enum<V>> EnumBiMap<K, V> create(Map<K, V> map) {
        void var1_1;
        Map<K, V> map2;
        EnumBiMap<K, V> bimap = EnumBiMap.create(EnumBiMap.inferKeyType(map), EnumBiMap.inferValueType(map));
        ((ForwardingMap)bimap).putAll(map2);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private EnumBiMap(Class<K> keyType, Class<V> valueType) {
        super(new EnumMap(keyType), new EnumMap(valueType));
        void var2_2;
        void var1_1;
        this.keyType = var1_1;
        this.valueType = var2_2;
    }

    static <K extends Enum<K>> Class<K> inferKeyType(Map<K, ?> map) {
        Map<K, ?> map2;
        if (map instanceof EnumBiMap) {
            return ((EnumBiMap)map).keyType();
        }
        if (map instanceof EnumHashBiMap) {
            return ((EnumHashBiMap)map).keyType();
        }
        Preconditions.checkArgument(!map.isEmpty());
        return ((Enum)map2.keySet().iterator().next()).getDeclaringClass();
    }

    private static <V extends Enum<V>> Class<V> inferValueType(Map<?, V> map) {
        Map<?, V> map2;
        if (map instanceof EnumBiMap) {
            return ((EnumBiMap)map).valueType;
        }
        Preconditions.checkArgument(!map.isEmpty());
        return ((Enum)map2.values().iterator().next()).getDeclaringClass();
    }

    public final Class<K> keyType() {
        return this.keyType;
    }

    public final Class<V> valueType() {
        return this.valueType;
    }

    @Override
    final K checkKey(K key) {
        return (K)((Enum)Preconditions.checkNotNull(key));
    }

    @Override
    final V checkValue(V value) {
        return (V)((Enum)Preconditions.checkNotNull(value));
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    private void writeObject(ObjectOutputStream stream) throws IOException {
        void var1_1;
        stream.defaultWriteObject();
        stream.writeObject(this.keyType);
        stream.writeObject(this.valueType);
        Serialization.writeMap(this, (ObjectOutputStream)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        void var1_1;
        stream.defaultReadObject();
        this.keyType = (Class)stream.readObject();
        this.valueType = (Class)stream.readObject();
        this.setDelegates(new EnumMap(this.keyType), new EnumMap(this.valueType));
        Serialization.populateMap(this, (ObjectInputStream)var1_1);
    }
}

