/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.BoundType;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Ordering;
import com.google.common.collect.Range;
import com.google.common.collect.UnmodifiableIterator;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Set;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
final class EmptyContiguousSet<C extends Comparable>
extends ContiguousSet<C> {
    /*
     * WARNING - void declaration
     */
    EmptyContiguousSet(DiscreteDomain<C> domain) {
        super(var1_1);
        void var1_1;
    }

    @Override
    public final C first() {
        throw new NoSuchElementException();
    }

    @Override
    public final C last() {
        throw new NoSuchElementException();
    }

    @Override
    public final int size() {
        return 0;
    }

    @Override
    public final ContiguousSet<C> intersection(ContiguousSet<C> other) {
        return this;
    }

    @Override
    public final Range<C> range() {
        throw new NoSuchElementException();
    }

    @Override
    public final Range<C> range(BoundType lowerBoundType, BoundType upperBoundType) {
        throw new NoSuchElementException();
    }

    @Override
    final ContiguousSet<C> headSetImpl(C toElement, boolean inclusive) {
        return this;
    }

    @Override
    final ContiguousSet<C> subSetImpl(C fromElement, boolean fromInclusive, C toElement, boolean toInclusive) {
        return this;
    }

    @Override
    final ContiguousSet<C> tailSetImpl(C fromElement, boolean fromInclusive) {
        return this;
    }

    @Override
    public final boolean contains(Object object) {
        return false;
    }

    @Override
    @GwtIncompatible
    final int indexOf(Object target) {
        return -1;
    }

    @Override
    public final UnmodifiableIterator<C> iterator() {
        return Iterators.emptyIterator();
    }

    @Override
    @GwtIncompatible
    public final UnmodifiableIterator<C> descendingIterator() {
        return Iterators.emptyIterator();
    }

    @Override
    final boolean isPartialView() {
        return false;
    }

    @Override
    public final boolean isEmpty() {
        return true;
    }

    @Override
    public final ImmutableList<C> asList() {
        return ImmutableList.of();
    }

    @Override
    public final String toString() {
        return "[]";
    }

    @Override
    public final boolean equals(Object object) {
        if (object instanceof Set) {
            Set set;
            set = set;
            return set.isEmpty();
        }
        return false;
    }

    @Override
    @GwtIncompatible
    final boolean isHashCodeFast() {
        return true;
    }

    @Override
    public final int hashCode() {
        return 0;
    }

    @Override
    @GwtIncompatible
    final Object writeReplace() {
        return new SerializedForm(this.domain);
    }

    @Override
    @GwtIncompatible
    final ImmutableSortedSet<C> createDescendingSet() {
        return ImmutableSortedSet.emptySet(Ordering.natural().reverse());
    }

    @GwtIncompatible
    private static final class SerializedForm<C extends Comparable>
    implements Serializable {
        private final DiscreteDomain<C> domain;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        private SerializedForm(DiscreteDomain<C> domain) {
            void var1_1;
            this.domain = var1_1;
        }

        private Object readResolve() {
            return new EmptyContiguousSet<C>(this.domain);
        }
    }
}

