/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.primitives.Ints;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.NoSuchElementException;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public abstract class DiscreteDomain<C extends Comparable> {
    final boolean supportsFastOffset;

    public static DiscreteDomain<Integer> integers() {
        return IntegerDomain.INSTANCE;
    }

    public static DiscreteDomain<Long> longs() {
        return LongDomain.INSTANCE;
    }

    public static DiscreteDomain<BigInteger> bigIntegers() {
        return BigIntegerDomain.INSTANCE;
    }

    protected DiscreteDomain() {
        this(false);
    }

    /*
     * WARNING - void declaration
     */
    private DiscreteDomain(boolean supportsFastOffset) {
        void var1_1;
        this.supportsFastOffset = var1_1;
    }

    C offset(C origin, long distance) {
        C current = origin;
        CollectPreconditions.checkNonnegative(distance, "distance");
        for (long i = 0L; i < distance; ++i) {
            if ((current = this.next(current)) != null) continue;
            origin = String.valueOf(origin);
            throw new IllegalArgumentException(new StringBuilder(51 + String.valueOf(origin).length()).append("overflowed computing offset(").append((String)origin).append(", ").append(distance).append(")").toString());
        }
        return current;
    }

    public abstract C next(C var1);

    public abstract C previous(C var1);

    public abstract long distance(C var1, C var2);

    public C minValue() {
        throw new NoSuchElementException();
    }

    public C maxValue() {
        throw new NoSuchElementException();
    }

    private static final class BigIntegerDomain
    extends DiscreteDomain<BigInteger>
    implements Serializable {
        private static final BigIntegerDomain INSTANCE = new BigIntegerDomain();
        private static final BigInteger MIN_LONG = BigInteger.valueOf(Long.MIN_VALUE);
        private static final BigInteger MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
        private static final long serialVersionUID = 0L;

        BigIntegerDomain() {
            super(true);
        }

        @Override
        public final BigInteger next(BigInteger value) {
            return value.add(BigInteger.ONE);
        }

        @Override
        public final BigInteger previous(BigInteger value) {
            return value.subtract(BigInteger.ONE);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final BigInteger offset(BigInteger origin, long distance) {
            void var2_2;
            void var1_1;
            CollectPreconditions.checkNonnegative(distance, "distance");
            return var1_1.add(BigInteger.valueOf((long)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final long distance(BigInteger start, BigInteger end) {
            void var1_1;
            return end.subtract((BigInteger)var1_1).max(MIN_LONG).min(MAX_LONG).longValue();
        }

        private Object readResolve() {
            return INSTANCE;
        }

        public final String toString() {
            return "DiscreteDomain.bigIntegers()";
        }
    }

    private static final class LongDomain
    extends DiscreteDomain<Long>
    implements Serializable {
        private static final LongDomain INSTANCE = new LongDomain();
        private static final long serialVersionUID = 0L;

        LongDomain() {
            super(true);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Long next(Long value) {
            void var2_2;
            long l = value;
            if (l == Long.MAX_VALUE) {
                return null;
            }
            return (long)(var2_2 + 1L);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Long previous(Long value) {
            void var2_2;
            long l = value;
            if (l == Long.MIN_VALUE) {
                return null;
            }
            return (long)(var2_2 - 1L);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final Long offset(Long origin, long distance) {
            void var2_2;
            CollectPreconditions.checkNonnegative(distance, "distance");
            long result = origin + var2_2;
            if (result < 0L) {
                void var1_1;
                Preconditions.checkArgument(var1_1.longValue() < 0L, "overflow");
            }
            return result;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final long distance(Long start, Long end) {
            void var3_3;
            void var1_1;
            void var2_2;
            long result = end - start;
            if (end > start && result < 0L) {
                return Long.MAX_VALUE;
            }
            if (var2_2.longValue() < var1_1.longValue() && result > 0L) {
                return Long.MIN_VALUE;
            }
            return (long)var3_3;
        }

        @Override
        public final Long minValue() {
            return Long.MIN_VALUE;
        }

        @Override
        public final Long maxValue() {
            return Long.MAX_VALUE;
        }

        private Object readResolve() {
            return INSTANCE;
        }

        public final String toString() {
            return "DiscreteDomain.longs()";
        }
    }

    private static final class IntegerDomain
    extends DiscreteDomain<Integer>
    implements Serializable {
        private static final IntegerDomain INSTANCE = new IntegerDomain();
        private static final long serialVersionUID = 0L;

        IntegerDomain() {
            super(true);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Integer next(Integer value) {
            void var1_2;
            int i = value;
            if (i == Integer.MAX_VALUE) {
                return null;
            }
            return (int)(var1_2 + true);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Integer previous(Integer value) {
            void var1_2;
            int i = value;
            if (i == Integer.MIN_VALUE) {
                return null;
            }
            return (int)(var1_2 - true);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final Integer offset(Integer origin, long distance) {
            void var2_2;
            void var1_1;
            CollectPreconditions.checkNonnegative(distance, "distance");
            return Ints.checkedCast(var1_1.longValue() + var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final long distance(Integer start, Integer end) {
            void var1_1;
            return (long)end.intValue() - (long)var1_1.intValue();
        }

        @Override
        public final Integer minValue() {
            return Integer.MIN_VALUE;
        }

        @Override
        public final Integer maxValue() {
            return Integer.MAX_VALUE;
        }

        private Object readResolve() {
            return INSTANCE;
        }

        public final String toString() {
            return "DiscreteDomain.integers()";
        }
    }
}

