/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.BoundType;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ForwardingMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.Ordering;
import com.google.common.collect.ParametricNullness;
import com.google.common.collect.SortedMultiset;
import com.google.common.collect.SortedMultisets;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.Set;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
abstract class DescendingMultiset<E>
extends ForwardingMultiset<E>
implements SortedMultiset<E> {
    private transient Comparator<? super E> comparator;
    private transient NavigableSet<E> elementSet;
    private transient Set<Multiset.Entry<E>> entrySet;

    DescendingMultiset() {
    }

    abstract SortedMultiset<E> forwardMultiset();

    /*
     * WARNING - void declaration
     */
    @Override
    public Comparator<? super E> comparator() {
        void var1_1;
        Comparator<? super E> result = this.comparator;
        if (result == null) {
            this.comparator = Ordering.from(this.forwardMultiset().comparator()).reverse();
            return this.comparator;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public NavigableSet<E> elementSet() {
        void var1_1;
        NavigableSet<E> result = this.elementSet;
        if (result == null) {
            this.elementSet = new SortedMultisets.NavigableElementSet(this);
            return this.elementSet;
        }
        return var1_1;
    }

    @Override
    public Multiset.Entry<E> pollFirstEntry() {
        return this.forwardMultiset().pollLastEntry();
    }

    @Override
    public Multiset.Entry<E> pollLastEntry() {
        return this.forwardMultiset().pollFirstEntry();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SortedMultiset<E> headMultiset(@ParametricNullness E toElement, BoundType boundType) {
        void var2_2;
        void var1_1;
        return this.forwardMultiset().tailMultiset(var1_1, (BoundType)var2_2).descendingMultiset();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SortedMultiset<E> subMultiset(@ParametricNullness E fromElement, BoundType fromBoundType, @ParametricNullness E toElement, BoundType toBoundType) {
        void var2_2;
        void var1_1;
        void var3_3;
        return this.forwardMultiset().subMultiset(var3_3, toBoundType, var1_1, (BoundType)var2_2).descendingMultiset();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SortedMultiset<E> tailMultiset(@ParametricNullness E fromElement, BoundType boundType) {
        void var2_2;
        void var1_1;
        return this.forwardMultiset().headMultiset(var1_1, (BoundType)var2_2).descendingMultiset();
    }

    @Override
    protected Multiset<E> delegate() {
        return this.forwardMultiset();
    }

    @Override
    public SortedMultiset<E> descendingMultiset() {
        return this.forwardMultiset();
    }

    @Override
    public Multiset.Entry<E> firstEntry() {
        return this.forwardMultiset().lastEntry();
    }

    @Override
    public Multiset.Entry<E> lastEntry() {
        return this.forwardMultiset().firstEntry();
    }

    abstract Iterator<Multiset.Entry<E>> entryIterator();

    /*
     * WARNING - void declaration
     */
    @Override
    public Set<Multiset.Entry<E>> entrySet() {
        void var1_1;
        Set<Multiset.Entry<E>> result = this.entrySet;
        if (result == null) {
            this.entrySet = this.createEntrySet();
            return this.entrySet;
        }
        return var1_1;
    }

    Set<Multiset.Entry<E>> createEntrySet() {
        class EntrySetImpl
        extends Multisets.EntrySet<E> {
            final /* synthetic */ DescendingMultiset this$0;

            /*
             * WARNING - void declaration
             */
            EntrySetImpl(DescendingMultiset this$0) {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            Multiset<E> multiset() {
                return this.this$0;
            }

            @Override
            public Iterator<Multiset.Entry<E>> iterator() {
                return this.this$0.entryIterator();
            }

            @Override
            public int size() {
                return this.this$0.forwardMultiset().entrySet().size();
            }
        }
        return new EntrySetImpl(this);
    }

    @Override
    public Iterator<E> iterator() {
        return Multisets.iteratorImpl(this);
    }

    @Override
    public Object[] toArray() {
        return this.standardToArray();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> T[] toArray(T[] array) {
        void var1_1;
        return this.standardToArray((T[])var1_1);
    }

    @Override
    public String toString() {
        return ((ForwardingMultiset)this).entrySet().toString();
    }
}

