/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Ordering;
import com.google.common.collect.UnmodifiableIterator;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
final class DescendingImmutableSortedSet<E>
extends ImmutableSortedSet<E> {
    private final ImmutableSortedSet<E> forward;

    /*
     * WARNING - void declaration
     */
    DescendingImmutableSortedSet(ImmutableSortedSet<E> forward) {
        super(Ordering.from(forward.comparator()).reverse());
        void var1_1;
        this.forward = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean contains(Object object) {
        void var1_1;
        return this.forward.contains(var1_1);
    }

    @Override
    public final int size() {
        return this.forward.size();
    }

    @Override
    public final UnmodifiableIterator<E> iterator() {
        return this.forward.descendingIterator();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final ImmutableSortedSet<E> headSetImpl(E toElement, boolean inclusive) {
        void var2_2;
        void var1_1;
        return ((ImmutableSortedSet)this.forward.tailSet((Object)var1_1, (boolean)var2_2)).descendingSet();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final ImmutableSortedSet<E> subSetImpl(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        void var2_2;
        void var1_1;
        void var3_3;
        return ((ImmutableSortedSet)this.forward.subSet((Object)var3_3, toInclusive, (Object)var1_1, (boolean)var2_2)).descendingSet();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final ImmutableSortedSet<E> tailSetImpl(E fromElement, boolean inclusive) {
        void var2_2;
        void var1_1;
        return ((ImmutableSortedSet)this.forward.headSet((Object)var1_1, (boolean)var2_2)).descendingSet();
    }

    @Override
    @GwtIncompatible(value="NavigableSet")
    public final ImmutableSortedSet<E> descendingSet() {
        return this.forward;
    }

    @Override
    @GwtIncompatible(value="NavigableSet")
    public final UnmodifiableIterator<E> descendingIterator() {
        return ((ImmutableCollection)this.forward).iterator();
    }

    @Override
    @GwtIncompatible(value="NavigableSet")
    final ImmutableSortedSet<E> createDescendingSet() {
        throw new AssertionError((Object)"should never be called");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final E lower(E element) {
        void var1_1;
        return this.forward.higher(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final E floor(E element) {
        void var1_1;
        return this.forward.ceiling(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final E ceiling(E element) {
        void var1_1;
        return this.forward.floor(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final E higher(E element) {
        void var1_1;
        return this.forward.lower(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final int indexOf(Object target) {
        void var1_2;
        int index = this.forward.indexOf(target);
        if (index == -1) {
            return index;
        }
        return this.size() - 1 - var1_2;
    }

    @Override
    final boolean isPartialView() {
        return this.forward.isPartialView();
    }
}

