/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Maps;
import com.google.common.collect.RegularImmutableTable;
import com.google.common.collect.Table;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Map;
import java.util.Objects;

@ElementTypesAreNonnullByDefault
@GwtCompatible
final class DenseImmutableTable<R, C, V>
extends RegularImmutableTable<R, C, V> {
    private final ImmutableMap<R, Integer> rowKeyToIndex;
    private final ImmutableMap<C, Integer> columnKeyToIndex;
    private final ImmutableMap<R, ImmutableMap<C, V>> rowMap;
    private final ImmutableMap<C, ImmutableMap<R, V>> columnMap;
    private final int[] rowCounts;
    private final int[] columnCounts;
    private final V[][] values;
    private final int[] cellRowIndices;
    private final int[] cellColumnIndices;

    /*
     * WARNING - void declaration
     */
    DenseImmutableTable(ImmutableList<Table.Cell<R, C, V>> cellList, ImmutableSet<R> rowSpace, ImmutableSet<C> columnSpace) {
        void var3_3;
        void var2_2;
        Object[][] array = new Object[rowSpace.size()][columnSpace.size()];
        this.values = array;
        this.rowKeyToIndex = Maps.indexMap(rowSpace);
        this.columnKeyToIndex = Maps.indexMap(columnSpace);
        this.rowCounts = new int[this.rowKeyToIndex.size()];
        this.columnCounts = new int[this.columnKeyToIndex.size()];
        int[] cellRowIndices = new int[cellList.size()];
        int[] cellColumnIndices = new int[cellList.size()];
        for (int i = 0; i < cellList.size(); ++i) {
            Table.Cell cell = (Table.Cell)cellList.get(i);
            Object rowKey = cell.getRowKey();
            Object columnKey = cell.getColumnKey();
            int rowIndex = Objects.requireNonNull(this.rowKeyToIndex.get(rowKey));
            int columnIndex = Objects.requireNonNull(this.columnKeyToIndex.get(columnKey));
            V existingValue = this.values[rowIndex][columnIndex];
            this.checkNoDuplicate(rowKey, columnKey, existingValue, cell.getValue());
            this.values[rowIndex][columnIndex] = cell.getValue();
            int n = rowIndex;
            this.rowCounts[n] = this.rowCounts[n] + 1;
            int n2 = columnIndex;
            this.columnCounts[n2] = this.columnCounts[n2] + 1;
            cellRowIndices[i] = rowIndex;
            cellColumnIndices[i] = columnIndex;
        }
        this.cellRowIndices = var2_2;
        this.cellColumnIndices = var3_3;
        this.rowMap = new RowMap();
        this.columnMap = new ColumnMap();
    }

    @Override
    public final ImmutableMap<C, Map<R, V>> columnMap() {
        ImmutableMap<C, ImmutableMap<R, V>> immutableMap = this.columnMap;
        return ImmutableMap.copyOf(immutableMap);
    }

    @Override
    public final ImmutableMap<R, Map<C, V>> rowMap() {
        ImmutableMap<R, ImmutableMap<C, V>> immutableMap = this.rowMap;
        return ImmutableMap.copyOf(immutableMap);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V get(Object rowKey, Object columnKey) {
        void var2_2;
        void var1_1;
        Integer rowIndex = this.rowKeyToIndex.get(rowKey);
        Integer columnIndex = this.columnKeyToIndex.get(columnKey);
        if (rowIndex == null || columnIndex == null) {
            return null;
        }
        return this.values[var1_1.intValue()][var2_2.intValue()];
    }

    @Override
    public final int size() {
        return this.cellRowIndices.length;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final Table.Cell<R, C, V> getCell(int index) {
        void var1_2;
        void var3_4;
        void var2_3;
        int rowIndex = this.cellRowIndices[index];
        int columnIndex = this.cellColumnIndices[index];
        Object rowKey = ((ImmutableCollection)((Object)this.rowKeySet())).asList().get(rowIndex);
        Object columnKey = ((ImmutableCollection)((Object)this.columnKeySet())).asList().get(columnIndex);
        V value = Objects.requireNonNull(this.values[var2_3][columnIndex]);
        return DenseImmutableTable.cellOf(var3_4, columnKey, var1_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final V getValue(int index) {
        void var1_1;
        return Objects.requireNonNull(this.values[this.cellRowIndices[index]][this.cellColumnIndices[var1_1]]);
    }

    @Override
    final ImmutableTable.SerializedForm createSerializedForm() {
        DenseImmutableTable denseImmutableTable = this;
        return ImmutableTable.SerializedForm.create(denseImmutableTable, denseImmutableTable.cellRowIndices, this.cellColumnIndices);
    }

    private final class ColumnMap
    extends ImmutableArrayMap<C, ImmutableMap<R, V>> {
        private ColumnMap() {
            super(DenseImmutableTable.this.columnCounts.length);
        }

        @Override
        final ImmutableMap<C, Integer> keyToIndex() {
            return DenseImmutableTable.this.columnKeyToIndex;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final ImmutableMap<R, V> getValue(int keyIndex) {
            void var1_1;
            return new Column((int)var1_1);
        }

        @Override
        final boolean isPartialView() {
            return false;
        }
    }

    private final class RowMap
    extends ImmutableArrayMap<R, ImmutableMap<C, V>> {
        private RowMap() {
            super(DenseImmutableTable.this.rowCounts.length);
        }

        @Override
        final ImmutableMap<R, Integer> keyToIndex() {
            return DenseImmutableTable.this.rowKeyToIndex;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final ImmutableMap<C, V> getValue(int keyIndex) {
            void var1_1;
            return new Row((int)var1_1);
        }

        @Override
        final boolean isPartialView() {
            return false;
        }
    }

    private final class Column
    extends ImmutableArrayMap<R, V> {
        private final int columnIndex;

        /*
         * WARNING - void declaration
         */
        Column(int columnIndex) {
            void var2_2;
            super(DenseImmutableTable.this.columnCounts[columnIndex]);
            this.columnIndex = var2_2;
        }

        @Override
        final ImmutableMap<R, Integer> keyToIndex() {
            return DenseImmutableTable.this.rowKeyToIndex;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final V getValue(int keyIndex) {
            void var1_1;
            return DenseImmutableTable.this.values[var1_1][this.columnIndex];
        }

        @Override
        final boolean isPartialView() {
            return true;
        }
    }

    private final class Row
    extends ImmutableArrayMap<C, V> {
        private final int rowIndex;

        /*
         * WARNING - void declaration
         */
        Row(int rowIndex) {
            void var2_2;
            super(DenseImmutableTable.this.rowCounts[rowIndex]);
            this.rowIndex = var2_2;
        }

        @Override
        final ImmutableMap<C, Integer> keyToIndex() {
            return DenseImmutableTable.this.columnKeyToIndex;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final V getValue(int keyIndex) {
            void var1_1;
            return DenseImmutableTable.this.values[this.rowIndex][var1_1];
        }

        @Override
        final boolean isPartialView() {
            return true;
        }
    }

    private static abstract class ImmutableArrayMap<K, V>
    extends ImmutableMap.IteratorBasedImmutableMap<K, V> {
        private final int size;

        /*
         * WARNING - void declaration
         */
        ImmutableArrayMap(int size) {
            void var1_1;
            this.size = var1_1;
        }

        abstract ImmutableMap<K, Integer> keyToIndex();

        private boolean isFull() {
            return this.size == this.keyToIndex().size();
        }

        /*
         * WARNING - void declaration
         */
        K getKey(int index) {
            void var1_1;
            return (K)((ImmutableCollection)((Object)this.keyToIndex().keySet())).asList().get((int)var1_1);
        }

        abstract V getValue(int var1);

        @Override
        ImmutableSet<K> createKeySet() {
            if (this.isFull()) {
                return this.keyToIndex().keySet();
            }
            return super.createKeySet();
        }

        @Override
        public int size() {
            return this.size;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V get(Object key) {
            void var1_1;
            Integer keyIndex = this.keyToIndex().get(key);
            if (keyIndex == null) {
                return null;
            }
            return this.getValue(var1_1.intValue());
        }

        @Override
        UnmodifiableIterator<Map.Entry<K, V>> entryIterator() {
            return new AbstractIterator<Map.Entry<K, V>>(this){
                private int index = -1;
                private final int maxIndex = this.this$0.keyToIndex().size();
                final /* synthetic */ ImmutableArrayMap this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                protected Map.Entry<K, V> computeNext() {
                    ++this.index;
                    while (this.index < this.maxIndex) {
                        Object value = this.this$0.getValue(this.index);
                        if (value != null) {
                            void var1_1;
                            return Maps.immutableEntry(this.this$0.getKey(this.index), var1_1);
                        }
                        ++this.index;
                    }
                    return (Map.Entry)this.endOfData();
                }
            };
        }
    }
}

