/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.BoundType;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.Range;
import com.google.common.primitives.Booleans;
import java.io.Serializable;
import java.util.NoSuchElementException;

@ElementTypesAreNonnullByDefault
@GwtCompatible
abstract class Cut<C extends Comparable>
implements Serializable,
Comparable<Cut<C>> {
    final C endpoint;
    private static final long serialVersionUID = 0L;

    /*
     * WARNING - void declaration
     */
    Cut(C endpoint) {
        void var1_1;
        this.endpoint = var1_1;
    }

    abstract boolean isLessThan(C var1);

    abstract BoundType typeAsLowerBound();

    abstract BoundType typeAsUpperBound();

    abstract Cut<C> withLowerBoundType(BoundType var1, DiscreteDomain<C> var2);

    abstract Cut<C> withUpperBoundType(BoundType var1, DiscreteDomain<C> var2);

    abstract void describeAsLowerBound(StringBuilder var1);

    abstract void describeAsUpperBound(StringBuilder var1);

    abstract C leastValueAbove(DiscreteDomain<C> var1);

    abstract C greatestValueBelow(DiscreteDomain<C> var1);

    Cut<C> canonical(DiscreteDomain<C> domain) {
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int compareTo(Cut<C> that) {
        void var1_1;
        if (that == Cut.belowAll()) {
            return 1;
        }
        if (that == Cut.aboveAll()) {
            return -1;
        }
        int result = Range.compareOrThrow(this.endpoint, that.endpoint);
        if (result != 0) {
            void var2_2;
            return (int)var2_2;
        }
        return Booleans.compare(this instanceof AboveValue, var1_1 instanceof AboveValue);
    }

    C endpoint() {
        return this.endpoint;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object obj) {
        if (obj instanceof Cut) {
            Cut that = (Cut)obj;
            try {
                void var1_1;
                int n = this.compareTo((Cut<C>)var1_1);
                return n == 0;
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }
        return false;
    }

    public abstract int hashCode();

    static <C extends Comparable> Cut<C> belowAll() {
        return BelowAll.INSTANCE;
    }

    static <C extends Comparable> Cut<C> aboveAll() {
        return AboveAll.INSTANCE;
    }

    static <C extends Comparable> Cut<C> belowValue(C endpoint) {
        C c;
        return new BelowValue<C>(c);
    }

    static <C extends Comparable> Cut<C> aboveValue(C endpoint) {
        C c;
        return new AboveValue<C>(c);
    }

    private static final class AboveValue<C extends Comparable>
    extends Cut<C> {
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        AboveValue(C endpoint) {
            super((Comparable)Preconditions.checkNotNull(var1_1));
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean isLessThan(C value) {
            void var1_1;
            return Range.compareOrThrow(this.endpoint, (Comparable)var1_1) < 0;
        }

        @Override
        final BoundType typeAsLowerBound() {
            return BoundType.OPEN;
        }

        @Override
        final BoundType typeAsUpperBound() {
            return BoundType.CLOSED;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final Cut<C> withLowerBoundType(BoundType boundType, DiscreteDomain<C> domain) {
            switch (boundType) {
                case OPEN: {
                    return this;
                }
                case CLOSED: {
                    void var1_1;
                    void var2_2;
                    Object next = var2_2.next(this.endpoint);
                    if (next == null) {
                        return Cut.belowAll();
                    }
                    return AboveValue.belowValue(var1_1);
                }
            }
            throw new AssertionError();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final Cut<C> withUpperBoundType(BoundType boundType, DiscreteDomain<C> domain) {
            switch (boundType) {
                case OPEN: {
                    void var1_1;
                    void var2_2;
                    Object next = var2_2.next(this.endpoint);
                    if (next == null) {
                        return Cut.aboveAll();
                    }
                    return AboveValue.belowValue(var1_1);
                }
                case CLOSED: {
                    return this;
                }
            }
            throw new AssertionError();
        }

        @Override
        final void describeAsLowerBound(StringBuilder sb) {
            sb.append('(').append(this.endpoint);
        }

        @Override
        final void describeAsUpperBound(StringBuilder sb) {
            sb.append(this.endpoint).append(']');
        }

        @Override
        final C leastValueAbove(DiscreteDomain<C> domain) {
            return domain.next(this.endpoint);
        }

        @Override
        final C greatestValueBelow(DiscreteDomain<C> domain) {
            return this.endpoint;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final Cut<C> canonical(DiscreteDomain<C> domain) {
            C next = this.leastValueAbove(domain);
            if (next != null) {
                void var1_1;
                return AboveValue.belowValue(var1_1);
            }
            return Cut.aboveAll();
        }

        @Override
        public final int hashCode() {
            return ~this.endpoint.hashCode();
        }

        public final String toString() {
            String string = String.valueOf(this.endpoint);
            return new StringBuilder(2 + String.valueOf(string).length()).append("/").append(string).append("\\").toString();
        }
    }

    private static final class BelowValue<C extends Comparable>
    extends Cut<C> {
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        BelowValue(C endpoint) {
            super((Comparable)Preconditions.checkNotNull(var1_1));
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean isLessThan(C value) {
            void var1_1;
            return Range.compareOrThrow(this.endpoint, (Comparable)var1_1) <= 0;
        }

        @Override
        final BoundType typeAsLowerBound() {
            return BoundType.CLOSED;
        }

        @Override
        final BoundType typeAsUpperBound() {
            return BoundType.OPEN;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final Cut<C> withLowerBoundType(BoundType boundType, DiscreteDomain<C> domain) {
            switch (boundType) {
                case CLOSED: {
                    return this;
                }
                case OPEN: {
                    void var1_1;
                    void var2_2;
                    Object previous = var2_2.previous(this.endpoint);
                    if (previous == null) {
                        return Cut.belowAll();
                    }
                    return new AboveValue<void>(var1_1);
                }
            }
            throw new AssertionError();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final Cut<C> withUpperBoundType(BoundType boundType, DiscreteDomain<C> domain) {
            switch (boundType) {
                case CLOSED: {
                    void var1_1;
                    void var2_2;
                    Object previous = var2_2.previous(this.endpoint);
                    if (previous == null) {
                        return Cut.aboveAll();
                    }
                    return new AboveValue<void>(var1_1);
                }
                case OPEN: {
                    return this;
                }
            }
            throw new AssertionError();
        }

        @Override
        final void describeAsLowerBound(StringBuilder sb) {
            sb.append('[').append(this.endpoint);
        }

        @Override
        final void describeAsUpperBound(StringBuilder sb) {
            sb.append(this.endpoint).append(')');
        }

        @Override
        final C leastValueAbove(DiscreteDomain<C> domain) {
            return this.endpoint;
        }

        @Override
        final C greatestValueBelow(DiscreteDomain<C> domain) {
            return domain.previous(this.endpoint);
        }

        @Override
        public final int hashCode() {
            return this.endpoint.hashCode();
        }

        public final String toString() {
            String string = String.valueOf(this.endpoint);
            return new StringBuilder(2 + String.valueOf(string).length()).append("\\").append(string).append("/").toString();
        }
    }

    private static final class AboveAll
    extends Cut<Comparable<?>> {
        private static final AboveAll INSTANCE = new AboveAll();
        private static final long serialVersionUID = 0L;

        private AboveAll() {
            super("");
        }

        @Override
        final Comparable<?> endpoint() {
            throw new IllegalStateException("range unbounded on this side");
        }

        @Override
        final boolean isLessThan(Comparable<?> value) {
            return false;
        }

        @Override
        final BoundType typeAsLowerBound() {
            throw new AssertionError((Object)"this statement should be unreachable");
        }

        @Override
        final BoundType typeAsUpperBound() {
            throw new IllegalStateException();
        }

        @Override
        final Cut<Comparable<?>> withLowerBoundType(BoundType boundType, DiscreteDomain<Comparable<?>> domain) {
            throw new AssertionError((Object)"this statement should be unreachable");
        }

        @Override
        final Cut<Comparable<?>> withUpperBoundType(BoundType boundType, DiscreteDomain<Comparable<?>> domain) {
            throw new IllegalStateException();
        }

        @Override
        final void describeAsLowerBound(StringBuilder sb) {
            throw new AssertionError();
        }

        @Override
        final void describeAsUpperBound(StringBuilder sb) {
            sb.append("+\u221e)");
        }

        @Override
        final Comparable<?> leastValueAbove(DiscreteDomain<Comparable<?>> domain) {
            throw new AssertionError();
        }

        @Override
        final Comparable<?> greatestValueBelow(DiscreteDomain<Comparable<?>> domain) {
            return domain.maxValue();
        }

        @Override
        public final int compareTo(Cut<Comparable<?>> o) {
            if (o == this) {
                return 0;
            }
            return 1;
        }

        @Override
        public final int hashCode() {
            return System.identityHashCode(this);
        }

        public final String toString() {
            return "+\u221e";
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    private static final class BelowAll
    extends Cut<Comparable<?>> {
        private static final BelowAll INSTANCE = new BelowAll();
        private static final long serialVersionUID = 0L;

        private BelowAll() {
            super("");
        }

        @Override
        final Comparable<?> endpoint() {
            throw new IllegalStateException("range unbounded on this side");
        }

        @Override
        final boolean isLessThan(Comparable<?> value) {
            return true;
        }

        @Override
        final BoundType typeAsLowerBound() {
            throw new IllegalStateException();
        }

        @Override
        final BoundType typeAsUpperBound() {
            throw new AssertionError((Object)"this statement should be unreachable");
        }

        @Override
        final Cut<Comparable<?>> withLowerBoundType(BoundType boundType, DiscreteDomain<Comparable<?>> domain) {
            throw new IllegalStateException();
        }

        @Override
        final Cut<Comparable<?>> withUpperBoundType(BoundType boundType, DiscreteDomain<Comparable<?>> domain) {
            throw new AssertionError((Object)"this statement should be unreachable");
        }

        @Override
        final void describeAsLowerBound(StringBuilder sb) {
            sb.append("(-\u221e");
        }

        @Override
        final void describeAsUpperBound(StringBuilder sb) {
            throw new AssertionError();
        }

        @Override
        final Comparable<?> leastValueAbove(DiscreteDomain<Comparable<?>> domain) {
            return domain.minValue();
        }

        @Override
        final Comparable<?> greatestValueBelow(DiscreteDomain<Comparable<?>> domain) {
            throw new AssertionError();
        }

        @Override
        final Cut<Comparable<?>> canonical(DiscreteDomain<Comparable<?>> domain) {
            try {
                return Cut.belowValue(domain.minValue());
            }
            catch (NoSuchElementException noSuchElementException) {
                return this;
            }
        }

        @Override
        public final int compareTo(Cut<Comparable<?>> o) {
            if (o == this) {
                return 0;
            }
            return -1;
        }

        @Override
        public final int hashCode() {
            return System.identityHashCode(this);
        }

        public final String toString() {
            return "-\u221e";
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }
}

