/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.BoundType;
import com.google.common.collect.DescendingImmutableSortedSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.EmptyContiguousSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Ordering;
import com.google.common.collect.Range;
import com.google.common.collect.RegularContiguousSet;
import java.util.NoSuchElementException;
import java.util.Objects;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public abstract class ContiguousSet<C extends Comparable>
extends ImmutableSortedSet<C> {
    final DiscreteDomain<C> domain;

    /*
     * WARNING - void declaration
     */
    public static <C extends Comparable> ContiguousSet<C> create(Range<C> range, DiscreteDomain<C> domain) {
        void var1_3;
        void var2_4;
        boolean bl;
        Preconditions.checkNotNull(range);
        Preconditions.checkNotNull(domain);
        Range<C> effectiveRange = range;
        try {
            if (!range.hasLowerBound()) {
                effectiveRange = effectiveRange.intersection(Range.atLeast(domain.minValue()));
            }
            if (!range.hasUpperBound()) {
                effectiveRange = effectiveRange.intersection(Range.atMost(domain.maxValue()));
            }
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException(e);
        }
        if (effectiveRange.isEmpty()) {
            bl = true;
        } else {
            Comparable comparable;
            void var3_5;
            boolean bl2;
            Comparable afterLower = (Comparable)Objects.requireNonNull(((Range)((Object)e)).lowerBound.leastValueAbove(domain));
            Comparable beforeUpper = (Comparable)Objects.requireNonNull(((Range)((Object)e)).upperBound.greatestValueBelow(domain));
            bl = bl2 = Range.compareOrThrow((Comparable)var3_5, comparable) > 0;
        }
        if (bl) {
            return new EmptyContiguousSet<C>(domain);
        }
        return new RegularContiguousSet(var2_4, var1_3);
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    public static ContiguousSet<Integer> closed(int lower, int upper) {
        void var1_1;
        return ContiguousSet.create(Range.closed(lower, (int)var1_1), DiscreteDomain.integers());
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    public static ContiguousSet<Long> closed(long lower, long upper) {
        void var2_1;
        return ContiguousSet.create(Range.closed(lower, (long)var2_1), DiscreteDomain.longs());
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    public static ContiguousSet<Integer> closedOpen(int lower, int upper) {
        void var1_1;
        return ContiguousSet.create(Range.closedOpen(lower, (int)var1_1), DiscreteDomain.integers());
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    public static ContiguousSet<Long> closedOpen(long lower, long upper) {
        void var2_1;
        return ContiguousSet.create(Range.closedOpen(lower, (long)var2_1), DiscreteDomain.longs());
    }

    /*
     * WARNING - void declaration
     */
    ContiguousSet(DiscreteDomain<C> domain) {
        super(Ordering.natural());
        void var1_1;
        this.domain = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ContiguousSet<C> headSet(C toElement) {
        void var1_1;
        return this.headSetImpl((C)((Comparable)Preconditions.checkNotNull(var1_1)), false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @GwtIncompatible
    public ContiguousSet<C> headSet(C toElement, boolean inclusive) {
        void var2_2;
        void var1_1;
        return this.headSetImpl((C)((Comparable)Preconditions.checkNotNull(var1_1)), (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ContiguousSet<C> subSet(C fromElement, C toElement) {
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull(fromElement);
        Preconditions.checkNotNull(toElement);
        Preconditions.checkArgument(this.comparator().compare(fromElement, toElement) <= 0);
        return this.subSetImpl(var1_1, true, var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @GwtIncompatible
    public ContiguousSet<C> subSet(C fromElement, boolean fromInclusive, C toElement, boolean toInclusive) {
        void var3_3;
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull(fromElement);
        Preconditions.checkNotNull(toElement);
        Preconditions.checkArgument(this.comparator().compare(fromElement, toElement) <= 0);
        return this.subSetImpl(var1_1, (boolean)var2_2, var3_3, toInclusive);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ContiguousSet<C> tailSet(C fromElement) {
        void var1_1;
        return this.tailSetImpl((C)((Comparable)Preconditions.checkNotNull(var1_1)), true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @GwtIncompatible
    public ContiguousSet<C> tailSet(C fromElement, boolean inclusive) {
        void var2_2;
        void var1_1;
        return this.tailSetImpl((C)((Comparable)Preconditions.checkNotNull(var1_1)), (boolean)var2_2);
    }

    @Override
    abstract ContiguousSet<C> headSetImpl(C var1, boolean var2);

    @Override
    abstract ContiguousSet<C> subSetImpl(C var1, boolean var2, C var3, boolean var4);

    @Override
    abstract ContiguousSet<C> tailSetImpl(C var1, boolean var2);

    public abstract ContiguousSet<C> intersection(ContiguousSet<C> var1);

    public abstract Range<C> range();

    public abstract Range<C> range(BoundType var1, BoundType var2);

    @Override
    @GwtIncompatible
    ImmutableSortedSet<C> createDescendingSet() {
        return new DescendingImmutableSortedSet(this);
    }

    @Override
    public String toString() {
        return this.range().toString();
    }

    @Deprecated
    public static <E> ImmutableSortedSet.Builder<E> builder() {
        throw new UnsupportedOperationException();
    }
}

