/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.AbstractMultiset;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ForwardingIterator;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.Serialization;
import com.google.common.math.IntMath;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
public final class ConcurrentHashMultiset<E>
extends AbstractMultiset<E>
implements Serializable {
    private final transient ConcurrentMap<E, AtomicInteger> countMap;
    private static final long serialVersionUID = 1L;

    public static <E> ConcurrentHashMultiset<E> create() {
        return new ConcurrentHashMultiset(new ConcurrentHashMap());
    }

    /*
     * WARNING - void declaration
     */
    public static <E> ConcurrentHashMultiset<E> create(Iterable<? extends E> elements) {
        void var1_1;
        Iterable<? extends E> iterable;
        ConcurrentHashMultiset<E> multiset = ConcurrentHashMultiset.create();
        Iterables.addAll(multiset, iterable);
        return var1_1;
    }

    @Beta
    public static <E> ConcurrentHashMultiset<E> create(ConcurrentMap<E, AtomicInteger> countMap) {
        ConcurrentMap<E, AtomicInteger> concurrentMap;
        return new ConcurrentHashMultiset<E>(concurrentMap);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    ConcurrentHashMultiset(ConcurrentMap<E, AtomicInteger> countMap) {
        void var1_1;
        Preconditions.checkArgument(countMap.isEmpty(), "the backing map (%s) must be empty", countMap);
        this.countMap = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int count(Object element) {
        void var1_1;
        AtomicInteger existingCounter = Maps.safeGet(this.countMap, element);
        if (existingCounter == null) {
            return 0;
        }
        return var1_1.get();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int size() {
        void var1_1;
        long sum = 0L;
        for (AtomicInteger value : this.countMap.values()) {
            sum += (long)value.get();
        }
        return Ints.saturatedCast((long)var1_1);
    }

    @Override
    public final Object[] toArray() {
        return this.snapshot().toArray();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T> T[] toArray(T[] array) {
        void var1_1;
        return this.snapshot().toArray((T[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private List<E> snapshot() {
        void var1_1;
        ArrayList list = Lists.newArrayListWithExpectedSize(this.size());
        for (Multiset.Entry entry : this.entrySet()) {
            Object element = entry.getElement();
            for (int i = entry.getCount(); i > 0; --i) {
                list.add(element);
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int add(E element, int occurrences) {
        void var3_3;
        AtomicInteger newCounter;
        Preconditions.checkNotNull(element);
        if (occurrences == 0) {
            return this.count(element);
        }
        CollectPreconditions.checkPositive(occurrences, "occurrences");
        do {
            int oldValue;
            AtomicInteger existingCounter;
            if ((existingCounter = Maps.safeGet(this.countMap, element)) == null && (existingCounter = this.countMap.putIfAbsent(element, new AtomicInteger(occurrences))) == null) {
                return 0;
            }
            while ((oldValue = existingCounter.get()) != 0) {
                try {
                    int newValue = IntMath.checkedAdd(oldValue, occurrences);
                    if (!existingCounter.compareAndSet(oldValue, newValue)) continue;
                    return oldValue;
                }
                catch (ArithmeticException arithmeticException) {
                    throw new IllegalArgumentException(new StringBuilder(65).append("Overflow adding ").append(occurrences).append(" occurrences to a count of ").append(oldValue).toString());
                }
            }
        } while (this.countMap.putIfAbsent(element, newCounter = new AtomicInteger(occurrences)) != null && !this.countMap.replace(element, (AtomicInteger)var3_3, newCounter));
        return 0;
    }

    @Override
    public final int remove(Object element, int occurrences) {
        int oldValue;
        if (occurrences == 0) {
            return this.count(element);
        }
        CollectPreconditions.checkPositive(occurrences, "occurrences");
        AtomicInteger existingCounter = Maps.safeGet(this.countMap, element);
        if (existingCounter == null) {
            return 0;
        }
        while ((oldValue = existingCounter.get()) != 0) {
            int newValue = Math.max(0, oldValue - occurrences);
            if (!existingCounter.compareAndSet(oldValue, newValue)) continue;
            if (newValue == 0) {
                this.countMap.remove(element, existingCounter);
            }
            return oldValue;
        }
        return 0;
    }

    public final boolean removeExactly(Object element, int occurrences) {
        int newValue;
        int oldValue;
        if (occurrences == 0) {
            return true;
        }
        CollectPreconditions.checkPositive(occurrences, "occurrences");
        AtomicInteger existingCounter = Maps.safeGet(this.countMap, element);
        if (existingCounter == null) {
            return false;
        }
        do {
            if ((oldValue = existingCounter.get()) >= occurrences) continue;
            return false;
        } while (!existingCounter.compareAndSet(oldValue, newValue = oldValue - occurrences));
        if (newValue == 0) {
            this.countMap.remove(element, existingCounter);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int setCount(E element, int count) {
        void var4_5;
        AtomicInteger existingCounter;
        Preconditions.checkNotNull(element);
        CollectPreconditions.checkNonnegative(count, "count");
        block0: while (true) {
            if ((existingCounter = Maps.safeGet(this.countMap, element)) == null) {
                if (count == 0) {
                    return 0;
                }
                existingCounter = this.countMap.putIfAbsent(element, new AtomicInteger(count));
                if (existingCounter == null) {
                    return 0;
                }
            }
            do {
                int oldValue;
                if ((oldValue = existingCounter.get()) != 0) continue;
                if (count == 0) {
                    return 0;
                }
                AtomicInteger newCounter = new AtomicInteger(count);
                if (this.countMap.putIfAbsent(element, newCounter) != null && !this.countMap.replace(element, existingCounter, newCounter)) continue block0;
                return 0;
            } while (!existingCounter.compareAndSet((int)var4_5, count));
            break;
        }
        if (count == 0) {
            this.countMap.remove(element, existingCounter);
        }
        return (int)var4_5;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean setCount(E element, int expectedOldCount, int newCount) {
        Preconditions.checkNotNull(element);
        CollectPreconditions.checkNonnegative(expectedOldCount, "oldCount");
        CollectPreconditions.checkNonnegative(newCount, "newCount");
        AtomicInteger existingCounter = Maps.safeGet(this.countMap, element);
        if (existingCounter == null) {
            if (expectedOldCount != 0) {
                return false;
            }
            if (newCount == 0) {
                return true;
            }
            return this.countMap.putIfAbsent(element, new AtomicInteger(newCount)) == null;
        }
        int oldValue = existingCounter.get();
        if (oldValue == expectedOldCount) {
            if (oldValue == 0) {
                void var2_3;
                if (newCount == 0) {
                    this.countMap.remove(element, existingCounter);
                    return true;
                }
                AtomicInteger newCounter = new AtomicInteger(newCount);
                return this.countMap.putIfAbsent(element, newCounter) == null || this.countMap.replace(element, existingCounter, (AtomicInteger)var2_3);
            }
            if (existingCounter.compareAndSet(oldValue, newCount)) {
                void var3_4;
                if (var3_4 == false) {
                    void var1_1;
                    this.countMap.remove(var1_1, existingCounter);
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final Set<E> createElementSet() {
        void var1_1;
        Set delegate = this.countMap.keySet();
        return new ForwardingSet<E>(this, (Set)var1_1){
            final /* synthetic */ Set val$delegate;
            {
                this.val$delegate = set;
            }

            @Override
            protected Set<E> delegate() {
                return this.val$delegate;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean contains(Object object) {
                void var1_1;
                return object != null && Collections2.safeContains(this.val$delegate, var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean containsAll(Collection<?> collection) {
                void var1_1;
                return this.standardContainsAll((Collection<?>)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean remove(Object object) {
                void var1_1;
                return object != null && Collections2.safeRemove(this.val$delegate, var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean removeAll(Collection<?> c) {
                void var1_1;
                return this.standardRemoveAll((Collection<?>)var1_1);
            }
        };
    }

    @Override
    final Iterator<E> elementIterator() {
        throw new AssertionError((Object)"should never be called");
    }

    @Override
    @Deprecated
    public final Set<Multiset.Entry<E>> createEntrySet() {
        return new EntrySet();
    }

    @Override
    final int distinctElements() {
        return this.countMap.size();
    }

    @Override
    public final boolean isEmpty() {
        return this.countMap.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final Iterator<Multiset.Entry<E>> entryIterator() {
        void var1_1;
        AbstractIterator readOnlyIterator = new AbstractIterator<Multiset.Entry<E>>(this){
            private final Iterator<Map.Entry<E, AtomicInteger>> mapEntries;
            final /* synthetic */ ConcurrentHashMultiset this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.mapEntries = this.this$0.countMap.entrySet().iterator();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            protected Multiset.Entry<E> computeNext() {
                void var2_2;
                void var1_1;
                Map.Entry mapEntry;
                int count;
                do {
                    if (this.mapEntries.hasNext()) continue;
                    return (Multiset.Entry)this.endOfData();
                } while ((count = (mapEntry = this.mapEntries.next()).getValue().get()) == 0);
                return Multisets.immutableEntry(var1_1.getKey(), (int)var2_2);
            }
        };
        return new ForwardingIterator<Multiset.Entry<E>>(this, (Iterator)var1_1){
            private Multiset.Entry<E> last;
            final /* synthetic */ Iterator val$readOnlyIterator;
            final /* synthetic */ ConcurrentHashMultiset this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$readOnlyIterator = iterator;
            }

            @Override
            protected Iterator<Multiset.Entry<E>> delegate() {
                return this.val$readOnlyIterator;
            }

            @Override
            public Multiset.Entry<E> next() {
                this.last = (Multiset.Entry)super.next();
                return this.last;
            }

            @Override
            public void remove() {
                Preconditions.checkState(this.last != null, "no calls to next() since the last call to remove()");
                this.this$0.setCount(this.last.getElement(), 0);
                this.last = null;
            }
        };
    }

    @Override
    public final Iterator<E> iterator() {
        return Multisets.iteratorImpl(this);
    }

    @Override
    public final void clear() {
        this.countMap.clear();
    }

    /*
     * WARNING - void declaration
     */
    private void writeObject(ObjectOutputStream stream) throws IOException {
        void var1_1;
        stream.defaultWriteObject();
        var1_1.writeObject(this.countMap);
    }

    /*
     * WARNING - void declaration
     */
    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        void var1_1;
        stream.defaultReadObject();
        ConcurrentMap deserializedCountMap = (ConcurrentMap)stream.readObject();
        FieldSettersHolder.COUNT_MAP_FIELD_SETTER.set(this, var1_1);
    }

    private class EntrySet
    extends AbstractMultiset.EntrySet {
        private EntrySet() {
            super(ConcurrentHashMultiset.this);
        }

        @Override
        ConcurrentHashMultiset<E> multiset() {
            return ConcurrentHashMultiset.this;
        }

        @Override
        public Object[] toArray() {
            return this.snapshot().toArray();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public <T> T[] toArray(T[] array) {
            void var1_1;
            return this.snapshot().toArray((T[])var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private List<Multiset.Entry<E>> snapshot() {
            void var1_1;
            ArrayList list = Lists.newArrayListWithExpectedSize(this.size());
            Iterators.addAll(list, this.iterator());
            return var1_1;
        }
    }

    private static class FieldSettersHolder {
        static final Serialization.FieldSetter<ConcurrentHashMultiset> COUNT_MAP_FIELD_SETTER = Serialization.getFieldSetter(ConcurrentHashMultiset.class, "countMap");

        private FieldSettersHolder() {
        }
    }
}

