/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.common.collect.ParametricNullness;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true)
final class CompoundOrdering<T>
extends Ordering<T>
implements Serializable {
    final Comparator<? super T>[] comparators;
    private static final long serialVersionUID = 0L;

    /*
     * WARNING - void declaration
     */
    CompoundOrdering(Comparator<? super T> primary, Comparator<? super T> secondary) {
        void var2_2;
        void var1_1;
        this.comparators = new Comparator[]{var1_1, var2_2};
    }

    /*
     * WARNING - void declaration
     */
    CompoundOrdering(Iterable<? extends Comparator<? super T>> comparators) {
        void var1_1;
        this.comparators = Iterables.toArray(var1_1, new Comparator[0]);
    }

    @Override
    public final int compare(@ParametricNullness T left, @ParametricNullness T right) {
        for (int i = 0; i < this.comparators.length; ++i) {
            int result = this.comparators[i].compare(left, right);
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof CompoundOrdering) {
            void var1_1;
            CompoundOrdering that = (CompoundOrdering)object;
            return Arrays.equals(this.comparators, var1_1.comparators);
        }
        return false;
    }

    public final int hashCode() {
        return Arrays.hashCode(this.comparators);
    }

    public final String toString() {
        String string = Arrays.toString(this.comparators);
        return new StringBuilder(19 + String.valueOf(string).length()).append("Ordering.compound(").append(string).append(")").toString();
    }
}

