/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ParametricNullness;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.util.Comparator;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public abstract class ComparisonChain {
    private static final ComparisonChain ACTIVE = new ComparisonChain(){

        /*
         * WARNING - void declaration
         */
        @Override
        public ComparisonChain compare(Comparable<?> left, Comparable<?> right) {
            void var2_2;
            void var1_1;
            return this.classify(var1_1.compareTo(var2_2));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public <T> ComparisonChain compare(@ParametricNullness T left, @ParametricNullness T right, Comparator<T> comparator) {
            void var2_2;
            void var1_1;
            void var3_3;
            return this.classify(var3_3.compare(var1_1, var2_2));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ComparisonChain compare(int left, int right) {
            void var2_2;
            void var1_1;
            return this.classify(Ints.compare((int)var1_1, (int)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ComparisonChain compare(long left, long right) {
            void var3_2;
            void var1_1;
            return this.classify(Longs.compare((long)var1_1, (long)var3_2));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ComparisonChain compare(float left, float right) {
            void var2_2;
            void var1_1;
            return this.classify(Float.compare((float)var1_1, (float)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ComparisonChain compare(double left, double right) {
            void var3_2;
            void var1_1;
            return this.classify(Double.compare((double)var1_1, (double)var3_2));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ComparisonChain compareTrueFirst(boolean left, boolean right) {
            void var1_1;
            void var2_2;
            return this.classify(Booleans.compare((boolean)var2_2, (boolean)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ComparisonChain compareFalseFirst(boolean left, boolean right) {
            void var2_2;
            void var1_1;
            return this.classify(Booleans.compare((boolean)var1_1, (boolean)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        ComparisonChain classify(int result) {
            void var1_1;
            if (result < 0) {
                return LESS;
            }
            if (var1_1 > 0) {
                return GREATER;
            }
            return ACTIVE;
        }

        @Override
        public int result() {
            return 0;
        }
    };
    private static final ComparisonChain LESS = new InactiveComparisonChain(-1);
    private static final ComparisonChain GREATER = new InactiveComparisonChain(1);

    private ComparisonChain() {
    }

    public static ComparisonChain start() {
        return ACTIVE;
    }

    public abstract ComparisonChain compare(Comparable<?> var1, Comparable<?> var2);

    public abstract <T> ComparisonChain compare(@ParametricNullness T var1, @ParametricNullness T var2, Comparator<T> var3);

    public abstract ComparisonChain compare(int var1, int var2);

    public abstract ComparisonChain compare(long var1, long var3);

    public abstract ComparisonChain compare(float var1, float var2);

    public abstract ComparisonChain compare(double var1, double var3);

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public final ComparisonChain compare(Boolean left, Boolean right) {
        void var2_2;
        void var1_1;
        return this.compareFalseFirst(var1_1.booleanValue(), var2_2.booleanValue());
    }

    public abstract ComparisonChain compareTrueFirst(boolean var1, boolean var2);

    public abstract ComparisonChain compareFalseFirst(boolean var1, boolean var2);

    public abstract int result();

    private static final class InactiveComparisonChain
    extends ComparisonChain {
        final int result;

        /*
         * WARNING - void declaration
         */
        InactiveComparisonChain(int result) {
            void var1_1;
            this.result = var1_1;
        }

        @Override
        public final ComparisonChain compare(Comparable<?> left, Comparable<?> right) {
            return this;
        }

        @Override
        public final <T> ComparisonChain compare(@ParametricNullness T left, @ParametricNullness T right, Comparator<T> comparator) {
            return this;
        }

        @Override
        public final ComparisonChain compare(int left, int right) {
            return this;
        }

        @Override
        public final ComparisonChain compare(long left, long right) {
            return this;
        }

        @Override
        public final ComparisonChain compare(float left, float right) {
            return this;
        }

        @Override
        public final ComparisonChain compare(double left, double right) {
            return this;
        }

        @Override
        public final ComparisonChain compareTrueFirst(boolean left, boolean right) {
            return this;
        }

        @Override
        public final ComparisonChain compareFalseFirst(boolean left, boolean right) {
            return this;
        }

        @Override
        public final int result() {
            return this.result;
        }
    }
}

