/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.LexicographicalOrdering;
import com.google.common.collect.ParametricNullness;
import com.google.common.collect.TopKSelector;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collector;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public final class Comparators {
    private Comparators() {
    }

    public static <T, S extends T> Comparator<Iterable<S>> lexicographical(Comparator<T> comparator) {
        Comparator<T> comparator2;
        return new LexicographicalOrdering<T>(Preconditions.checkNotNull(comparator2));
    }

    /*
     * WARNING - void declaration
     */
    public static <T> boolean isInOrder(Iterable<? extends T> iterable, Comparator<T> comparator) {
        Preconditions.checkNotNull(comparator);
        Iterator<T> it = iterable.iterator();
        if (it.hasNext()) {
            Object prev = it.next();
            while (it.hasNext()) {
                void var3_3;
                Object next = it.next();
                if (comparator.compare(prev, next) > 0) {
                    return false;
                }
                prev = var3_3;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> boolean isInStrictOrder(Iterable<? extends T> iterable, Comparator<T> comparator) {
        Preconditions.checkNotNull(comparator);
        Iterator<T> it = iterable.iterator();
        if (it.hasNext()) {
            Object prev = it.next();
            while (it.hasNext()) {
                void var3_3;
                Object next = it.next();
                if (comparator.compare(prev, next) >= 0) {
                    return false;
                }
                prev = var3_3;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Collector<T, ?, List<T>> least(int k, Comparator<? super T> comparator) {
        void var1_1;
        int n;
        CollectPreconditions.checkNonnegative(k, "k");
        Preconditions.checkNotNull(comparator);
        return Collector.of(() -> Comparators.lambda$least$0(n, (Comparator)var1_1), TopKSelector::offer, TopKSelector::combine, TopKSelector::topK, Collector.Characteristics.UNORDERED);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Collector<T, ?, List<T>> greatest(int k, Comparator<? super T> comparator) {
        void var1_1;
        return Comparators.least(k, var1_1.reversed());
    }

    public static <T> Comparator<Optional<T>> emptiesFirst(Comparator<? super T> valueComparator) {
        Comparator<? super T> comparator;
        Preconditions.checkNotNull(valueComparator);
        return Comparator.comparing(o -> o.orElse(null), Comparator.nullsFirst(comparator));
    }

    public static <T> Comparator<Optional<T>> emptiesLast(Comparator<? super T> valueComparator) {
        Comparator<? super T> comparator;
        Preconditions.checkNotNull(valueComparator);
        return Comparator.comparing(o -> o.orElse(null), Comparator.nullsLast(comparator));
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Comparable<? super T>> T min(T a, T b) {
        void var1_1;
        if (a.compareTo(b) <= 0) {
            T t;
            return t;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @ParametricNullness
    public static <T> T min(@ParametricNullness T a, @ParametricNullness T b, Comparator<T> comparator) {
        void var1_1;
        if (comparator.compare(a, b) <= 0) {
            T t;
            return t;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Comparable<? super T>> T max(T a, T b) {
        void var1_1;
        if (a.compareTo(b) >= 0) {
            T t;
            return t;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @ParametricNullness
    public static <T> T max(@ParametricNullness T a, @ParametricNullness T b, Comparator<T> comparator) {
        void var1_1;
        if (comparator.compare(a, b) >= 0) {
            T t;
            return t;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ TopKSelector lambda$least$0(int k, Comparator comparator) {
        void var1_1;
        return TopKSelector.least(k, var1_1);
    }
}

