/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.CompactHashSet;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.ParametricNullness;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
class CompactLinkedHashSet<E>
extends CompactHashSet<E> {
    private static final int ENDPOINT = -2;
    private transient int[] predecessor;
    private transient int[] successor;
    private transient int firstEntry;
    private transient int lastEntry;

    public static <E> CompactLinkedHashSet<E> create() {
        return new CompactLinkedHashSet<E>();
    }

    /*
     * WARNING - void declaration
     */
    public static <E> CompactLinkedHashSet<E> create(Collection<? extends E> collection) {
        void var1_1;
        Collection<? extends E> collection2;
        CompactLinkedHashSet<? extends E> set = CompactLinkedHashSet.createWithExpectedSize(collection.size());
        set.addAll(collection2);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    public static <E> CompactLinkedHashSet<E> create(E ... elements) {
        void var1_1;
        E[] EArray;
        CompactLinkedHashSet<E> set = CompactLinkedHashSet.createWithExpectedSize(elements.length);
        Collections.addAll(set, EArray);
        return var1_1;
    }

    public static <E> CompactLinkedHashSet<E> createWithExpectedSize(int expectedSize) {
        int n;
        return new CompactLinkedHashSet<E>(n);
    }

    CompactLinkedHashSet() {
    }

    /*
     * WARNING - void declaration
     */
    CompactLinkedHashSet(int expectedSize) {
        super((int)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void init(int expectedSize) {
        void var1_1;
        super.init((int)var1_1);
        this.firstEntry = -2;
        this.lastEntry = -2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    int allocArrays() {
        void var1_1;
        int expectedSize = super.allocArrays();
        this.predecessor = new int[expectedSize];
        this.successor = new int[expectedSize];
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Set<E> convertToHashFloodingResistantImplementation() {
        void var1_1;
        Set result = super.convertToHashFloodingResistantImplementation();
        this.predecessor = null;
        this.successor = null;
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private int getPredecessor(int entry) {
        void var1_1;
        return this.requirePredecessors()[var1_1] - 1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    int getSuccessor(int entry) {
        void var1_1;
        return this.requireSuccessors()[var1_1] - 1;
    }

    /*
     * WARNING - void declaration
     */
    private void setSuccessor(int entry, int succ) {
        void var2_2;
        this.requireSuccessors()[var1_1] = var2_2 + true;
    }

    /*
     * WARNING - void declaration
     */
    private void setPredecessor(int entry, int pred) {
        void var2_2;
        this.requirePredecessors()[var1_1] = var2_2 + true;
    }

    /*
     * WARNING - void declaration
     */
    private void setSucceeds(int pred, int succ) {
        void var1_1;
        void var2_2;
        if (pred == -2) {
            this.firstEntry = succ;
        } else {
            this.setSuccessor(pred, succ);
        }
        if (succ == -2) {
            this.lastEntry = pred;
            return;
        }
        this.setPredecessor((int)var2_2, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void insertEntry(int entryIndex, @ParametricNullness E object, int hash, int mask) {
        void var1_1;
        void var3_3;
        void var2_2;
        super.insertEntry(entryIndex, var2_2, (int)var3_3, mask);
        CompactLinkedHashSet compactLinkedHashSet = this;
        compactLinkedHashSet.setSucceeds(compactLinkedHashSet.lastEntry, entryIndex);
        this.setSucceeds((int)var1_1, -2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void moveLastEntry(int dstIndex, int mask) {
        void var2_2;
        int srcIndex = this.size() - 1;
        super.moveLastEntry(dstIndex, (int)var2_2);
        CompactLinkedHashSet compactLinkedHashSet = this;
        compactLinkedHashSet.setSucceeds(compactLinkedHashSet.getPredecessor(dstIndex), this.getSuccessor(dstIndex));
        if (dstIndex < srcIndex) {
            void var1_1;
            CompactLinkedHashSet compactLinkedHashSet2 = this;
            compactLinkedHashSet2.setSucceeds(compactLinkedHashSet2.getPredecessor(srcIndex), dstIndex);
            this.setSucceeds((int)var1_1, this.getSuccessor(srcIndex));
        }
        this.requirePredecessors()[srcIndex] = 0;
        this.requireSuccessors()[var3_3] = 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void resizeEntries(int newCapacity) {
        void var1_1;
        super.resizeEntries(newCapacity);
        this.predecessor = Arrays.copyOf(this.requirePredecessors(), newCapacity);
        this.successor = Arrays.copyOf(this.requireSuccessors(), (int)var1_1);
    }

    @Override
    int firstEntryIndex() {
        return this.firstEntry;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    int adjustAfterRemove(int indexBeforeRemove, int indexRemoved) {
        void var1_1;
        if (indexBeforeRemove >= this.size()) {
            void var2_2;
            return (int)var2_2;
        }
        return (int)var1_1;
    }

    @Override
    public Object[] toArray() {
        return ObjectArrays.toArrayImpl(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> T[] toArray(T[] a) {
        void var1_1;
        return ObjectArrays.toArrayImpl(this, var1_1);
    }

    @Override
    public Spliterator<E> spliterator() {
        return Spliterators.spliterator(this, 17);
    }

    @Override
    public void clear() {
        if (this.needsAllocArrays()) {
            return;
        }
        this.firstEntry = -2;
        this.lastEntry = -2;
        if (this.predecessor != null && this.successor != null) {
            Arrays.fill(this.predecessor, 0, this.size(), 0);
            Arrays.fill(this.successor, 0, this.size(), 0);
        }
        super.clear();
    }

    private int[] requirePredecessors() {
        return Objects.requireNonNull(this.predecessor);
    }

    private int[] requireSuccessors() {
        return Objects.requireNonNull(this.successor);
    }
}

