/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.CompactHashMap;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.ParametricNullness;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
class CompactLinkedHashMap<K, V>
extends CompactHashMap<K, V> {
    private static final int ENDPOINT = -2;
    @VisibleForTesting
    transient long[] links;
    private transient int firstEntry;
    private transient int lastEntry;
    private final boolean accessOrder;

    public static <K, V> CompactLinkedHashMap<K, V> create() {
        return new CompactLinkedHashMap<K, V>();
    }

    public static <K, V> CompactLinkedHashMap<K, V> createWithExpectedSize(int expectedSize) {
        int n;
        return new CompactLinkedHashMap<K, V>(n);
    }

    CompactLinkedHashMap() {
        this(3);
    }

    /*
     * WARNING - void declaration
     */
    CompactLinkedHashMap(int expectedSize) {
        this((int)var1_1, false);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    CompactLinkedHashMap(int expectedSize, boolean accessOrder) {
        super((int)var1_1);
        void var2_2;
        void var1_1;
        this.accessOrder = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void init(int expectedSize) {
        void var1_1;
        super.init((int)var1_1);
        this.firstEntry = -2;
        this.lastEntry = -2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    int allocArrays() {
        void var1_1;
        int expectedSize = super.allocArrays();
        this.links = new long[expectedSize];
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Map<K, V> createHashFloodingResistantDelegate(int tableSize) {
        void var1_1;
        return new LinkedHashMap((int)var1_1, 1.0f, this.accessOrder);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Map<K, V> convertToHashFloodingResistantImplementation() {
        void var1_1;
        Map result = super.convertToHashFloodingResistantImplementation();
        this.links = null;
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private int getPredecessor(int entry) {
        void var1_1;
        return (int)(this.link((int)var1_1) >>> 32) - 1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    int getSuccessor(int entry) {
        void var1_1;
        return (int)this.link((int)var1_1) - 1;
    }

    /*
     * WARNING - void declaration
     */
    private void setSuccessor(int entry, int succ) {
        void var2_2;
        void var1_1;
        this.setLink(entry, this.link((int)var1_1) & 0xFFFFFFFF00000000L | (long)(var2_2 + true) & 0xFFFFFFFFL);
    }

    /*
     * WARNING - void declaration
     */
    private void setPredecessor(int entry, int pred) {
        void var2_2;
        void var1_1;
        this.setLink(entry, this.link((int)var1_1) & 0xFFFFFFFFL | (long)(var2_2 + true) << 32);
    }

    /*
     * WARNING - void declaration
     */
    private void setSucceeds(int pred, int succ) {
        void var1_1;
        void var2_2;
        if (pred == -2) {
            this.firstEntry = succ;
        } else {
            this.setSuccessor(pred, succ);
        }
        if (succ == -2) {
            this.lastEntry = pred;
            return;
        }
        this.setPredecessor((int)var2_2, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void insertEntry(int entryIndex, @ParametricNullness K key, @ParametricNullness V value, int hash, int mask) {
        void var1_1;
        void var3_3;
        void var2_2;
        super.insertEntry(entryIndex, var2_2, var3_3, hash, mask);
        CompactLinkedHashMap compactLinkedHashMap = this;
        compactLinkedHashMap.setSucceeds(compactLinkedHashMap.lastEntry, entryIndex);
        this.setSucceeds((int)var1_1, -2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void accessEntry(int index) {
        if (this.accessOrder) {
            void var1_1;
            CompactLinkedHashMap compactLinkedHashMap = this;
            compactLinkedHashMap.setSucceeds(compactLinkedHashMap.getPredecessor(index), this.getSuccessor(index));
            CompactLinkedHashMap compactLinkedHashMap2 = this;
            compactLinkedHashMap2.setSucceeds(compactLinkedHashMap2.lastEntry, index);
            this.setSucceeds((int)var1_1, -2);
            this.incrementModCount();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void moveLastEntry(int dstIndex, int mask) {
        void var3_3;
        void var2_2;
        int srcIndex = this.size() - 1;
        super.moveLastEntry(dstIndex, (int)var2_2);
        CompactLinkedHashMap compactLinkedHashMap = this;
        compactLinkedHashMap.setSucceeds(compactLinkedHashMap.getPredecessor(dstIndex), this.getSuccessor(dstIndex));
        if (dstIndex < srcIndex) {
            void var1_1;
            CompactLinkedHashMap compactLinkedHashMap2 = this;
            compactLinkedHashMap2.setSucceeds(compactLinkedHashMap2.getPredecessor(srcIndex), dstIndex);
            this.setSucceeds((int)var1_1, this.getSuccessor(srcIndex));
        }
        this.setLink((int)var3_3, 0L);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void resizeEntries(int newCapacity) {
        void var1_1;
        super.resizeEntries(newCapacity);
        this.links = Arrays.copyOf(this.requireLinks(), (int)var1_1);
    }

    @Override
    int firstEntryIndex() {
        return this.firstEntry;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    int adjustAfterRemove(int indexBeforeRemove, int indexRemoved) {
        void var1_1;
        if (indexBeforeRemove >= this.size()) {
            void var2_2;
            return (int)var2_2;
        }
        return (int)var1_1;
    }

    @Override
    Set<Map.Entry<K, V>> createEntrySet() {
        class EntrySetImpl
        extends CompactHashMap.EntrySetView {
            /*
             * WARNING - void declaration
             */
            EntrySetImpl(CompactLinkedHashMap this$0) {
                super((CompactHashMap)var1_1);
                void var1_1;
            }

            @Override
            public Spliterator<Map.Entry<K, V>> spliterator() {
                return Spliterators.spliterator(this, 17);
            }
        }
        return new EntrySetImpl(this);
    }

    @Override
    Set<K> createKeySet() {
        class KeySetImpl
        extends CompactHashMap.KeySetView {
            /*
             * WARNING - void declaration
             */
            KeySetImpl(CompactLinkedHashMap this$0) {
                void var1_1;
            }

            @Override
            public Object[] toArray() {
                return ObjectArrays.toArrayImpl(this);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public <T> T[] toArray(T[] a) {
                void var1_1;
                return ObjectArrays.toArrayImpl(this, var1_1);
            }

            @Override
            public Spliterator<K> spliterator() {
                return Spliterators.spliterator(this, 17);
            }
        }
        return new KeySetImpl(this);
    }

    @Override
    Collection<V> createValues() {
        class ValuesImpl
        extends CompactHashMap.ValuesView {
            /*
             * WARNING - void declaration
             */
            ValuesImpl(CompactLinkedHashMap this$0) {
                void var1_1;
            }

            @Override
            public Object[] toArray() {
                return ObjectArrays.toArrayImpl(this);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public <T> T[] toArray(T[] a) {
                void var1_1;
                return ObjectArrays.toArrayImpl(this, var1_1);
            }

            @Override
            public Spliterator<V> spliterator() {
                return Spliterators.spliterator(this, 16);
            }
        }
        return new ValuesImpl(this);
    }

    @Override
    public void clear() {
        if (this.needsAllocArrays()) {
            return;
        }
        this.firstEntry = -2;
        this.lastEntry = -2;
        if (this.links != null) {
            Arrays.fill(this.links, 0, this.size(), 0L);
        }
        super.clear();
    }

    private long[] requireLinks() {
        return Objects.requireNonNull(this.links);
    }

    /*
     * WARNING - void declaration
     */
    private long link(int i) {
        void var1_1;
        return this.requireLinks()[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    private void setLink(int i, long value) {
        void var2_2;
        this.requireLinks()[var1_1] = var2_2;
    }
}

