/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.CompactHashing;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.Hashing;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.ParametricNullness;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
class CompactHashSet<E>
extends AbstractSet<E>
implements Serializable {
    @VisibleForTesting
    static final double HASH_FLOODING_FPP = 0.001;
    private static final int MAX_HASH_BUCKET_LENGTH = 9;
    private transient Object table;
    private transient int[] entries;
    @VisibleForTesting
    transient Object[] elements;
    private transient int metadata;
    private transient int size;

    public static <E> CompactHashSet<E> create() {
        return new CompactHashSet<E>();
    }

    /*
     * WARNING - void declaration
     */
    public static <E> CompactHashSet<E> create(Collection<? extends E> collection) {
        void var1_1;
        Collection<? extends E> collection2;
        CompactHashSet<? extends E> set = CompactHashSet.createWithExpectedSize(collection.size());
        set.addAll(collection2);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    public static <E> CompactHashSet<E> create(E ... elements) {
        void var1_1;
        E[] EArray;
        CompactHashSet<E> set = CompactHashSet.createWithExpectedSize(elements.length);
        Collections.addAll(set, EArray);
        return var1_1;
    }

    public static <E> CompactHashSet<E> createWithExpectedSize(int expectedSize) {
        int n;
        return new CompactHashSet<E>(n);
    }

    CompactHashSet() {
        this.init(3);
    }

    /*
     * WARNING - void declaration
     */
    CompactHashSet(int expectedSize) {
        void var1_1;
        this.init((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    void init(int expectedSize) {
        void var1_1;
        Preconditions.checkArgument(expectedSize >= 0, "Expected size must be >= 0");
        this.metadata = Ints.constrainToRange((int)var1_1, 1, 0x3FFFFFFF);
    }

    @VisibleForTesting
    boolean needsAllocArrays() {
        return this.table == null;
    }

    /*
     * WARNING - void declaration
     */
    int allocArrays() {
        void var1_1;
        void var2_2;
        Preconditions.checkState(this.needsAllocArrays(), "Arrays already allocated");
        int expectedSize = this.metadata;
        int buckets = CompactHashing.tableSize(expectedSize);
        this.table = CompactHashing.createTable(buckets);
        this.setHashTableMask((int)(var2_2 - true));
        this.entries = new int[expectedSize];
        this.elements = new Object[expectedSize];
        return (int)var1_1;
    }

    @VisibleForTesting
    Set<E> delegateOrNull() {
        if (this.table instanceof Set) {
            return (Set)this.table;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private Set<E> createHashFloodingResistantDelegate(int tableSize) {
        void var1_1;
        return new LinkedHashSet((int)var1_1, 1.0f);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    Set<E> convertToHashFloodingResistantImplementation() {
        void var1_1;
        CompactHashSet compactHashSet = this;
        Set<E> newDelegate = compactHashSet.createHashFloodingResistantDelegate(compactHashSet.hashTableMask() + 1);
        int i = this.firstEntryIndex();
        while (i >= 0) {
            newDelegate.add(this.element(i));
            i = this.getSuccessor(i);
        }
        this.table = newDelegate;
        this.entries = null;
        this.elements = null;
        this.incrementModCount();
        return var1_1;
    }

    @VisibleForTesting
    boolean isUsingHashFloodingResistance() {
        return this.delegateOrNull() != null;
    }

    /*
     * WARNING - void declaration
     */
    private void setHashTableMask(int mask) {
        void var1_1;
        int hashTableBits = 32 - Integer.numberOfLeadingZeros(mask);
        this.metadata = CompactHashing.maskCombine(this.metadata, (int)var1_1, 31);
    }

    private int hashTableMask() {
        return (1 << (this.metadata & 0x1F)) - 1;
    }

    void incrementModCount() {
        this.metadata += 32;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean add(@ParametricNullness E object) {
        void var1_1;
        Set<E> delegate;
        if (this.needsAllocArrays()) {
            this.allocArrays();
        }
        if ((delegate = this.delegateOrNull()) != null) {
            return delegate.add(object);
        }
        int[] entries = this.requireEntries();
        Object[] elements = this.requireElements();
        int newEntryIndex = this.size;
        int newSize = newEntryIndex + 1;
        int hash = Hashing.smearedHash(object);
        int mask = this.hashTableMask();
        int tableIndex = hash & mask;
        int next = CompactHashing.tableGet(this.requireTable(), tableIndex);
        if (next == 0) {
            if (newSize > mask) {
                int n = mask;
                mask = this.resizeTable(n, CompactHashing.newCapacity(n), hash, newEntryIndex);
            } else {
                CompactHashing.tableSet(this.requireTable(), tableIndex, newEntryIndex + 1);
            }
        } else {
            int entry;
            int hashPrefix = CompactHashing.getHashPrefix(hash, mask);
            int bucketLength = 0;
            do {
                int entryIndex;
                if (CompactHashing.getHashPrefix(entry = entries[entryIndex = next - 1], mask) == hashPrefix && com.google.common.base.Objects.equal(object, elements[entryIndex])) {
                    return false;
                }
                next = CompactHashing.getNext(entry, mask);
                ++bucketLength;
            } while (next != 0);
            if (bucketLength >= 9) {
                return this.convertToHashFloodingResistantImplementation().add(object);
            }
            if (newSize > mask) {
                int n = mask;
                mask = this.resizeTable(n, CompactHashing.newCapacity(n), hash, newEntryIndex);
            } else {
                var2_2[entryIndex] = CompactHashing.maskCombine(entry, newEntryIndex + 1, mask);
            }
        }
        this.resizeMeMaybe(newSize);
        this.insertEntry(newEntryIndex, var1_1, hash, mask);
        this.size = newSize;
        this.incrementModCount();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    void insertEntry(int entryIndex, @ParametricNullness E object, int hash, int mask) {
        void var2_2;
        void var1_1;
        void var3_3;
        this.setEntry(entryIndex, CompactHashing.maskCombine((int)var3_3, 0, mask));
        this.setElement((int)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void resizeMeMaybe(int newSize) {
        void var2_2;
        int newCapacity;
        int entriesSize = this.requireEntries().length;
        if (newSize > entriesSize && (newCapacity = Math.min(0x3FFFFFFF, entriesSize + Math.max(1, entriesSize >>> 1) | 1)) != var2_2) {
            void var1_1;
            this.resizeEntries((int)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    void resizeEntries(int newCapacity) {
        void var1_1;
        this.entries = Arrays.copyOf(this.requireEntries(), newCapacity);
        this.elements = Arrays.copyOf(this.requireElements(), (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private int resizeTable(int oldMask, int newCapacity, int targetHash, int targetEntryIndex) {
        void var2_2;
        Object newTable = CompactHashing.createTable(newCapacity);
        int newMask = newCapacity - 1;
        if (targetEntryIndex != 0) {
            CompactHashing.tableSet(newTable, targetHash & newMask, targetEntryIndex + 1);
        }
        Object oldTable = this.requireTable();
        int[] entries = this.requireEntries();
        for (int oldTableIndex = 0; oldTableIndex <= oldMask; ++oldTableIndex) {
            int oldNext = CompactHashing.tableGet(oldTable, oldTableIndex);
            while (oldNext != 0) {
                int entryIndex = oldNext - 1;
                int oldEntry = entries[entryIndex];
                int hash = CompactHashing.getHashPrefix(oldEntry, oldMask) | oldTableIndex;
                int newTableIndex = hash & newMask;
                int newNext = CompactHashing.tableGet(newTable, newTableIndex);
                CompactHashing.tableSet(newTable, newTableIndex, oldNext);
                entries[entryIndex] = CompactHashing.maskCombine(hash, newNext, newMask);
                oldNext = CompactHashing.getNext(oldEntry, oldMask);
            }
        }
        this.table = newTable;
        this.setHashTableMask(newMask);
        return (int)var2_2;
    }

    @Override
    public boolean contains(Object object) {
        int entry;
        int n;
        if (this.needsAllocArrays()) {
            return false;
        }
        Set<E> delegate = this.delegateOrNull();
        if (delegate != null) {
            return delegate.contains(object);
        }
        int hash = Hashing.smearedHash(object);
        int mask = this.hashTableMask();
        int next = CompactHashing.tableGet(this.requireTable(), hash & mask);
        if (next == 0) {
            return false;
        }
        int hashPrefix = CompactHashing.getHashPrefix(hash, mask);
        do {
            int entryIndex;
            if (CompactHashing.getHashPrefix(entry = this.entry(entryIndex = next - 1), mask) != hashPrefix || !com.google.common.base.Objects.equal(object, this.element(entryIndex))) continue;
            return true;
        } while ((n = CompactHashing.getNext(entry, mask)) != 0);
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean remove(Object object) {
        void var2_4;
        void var1_2;
        if (this.needsAllocArrays()) {
            return false;
        }
        Set<E> delegate = this.delegateOrNull();
        if (delegate != null) {
            return delegate.remove(object);
        }
        int mask = this.hashTableMask();
        int index = CompactHashing.remove(object, null, mask, this.requireTable(), this.requireEntries(), this.requireElements(), null);
        if (index == -1) {
            return false;
        }
        this.moveLastEntry((int)var1_2, (int)var2_4);
        --this.size;
        this.incrementModCount();
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    void moveLastEntry(int dstIndex, int mask) {
        void var2_2;
        int entryIndex;
        int entry;
        int srcNext;
        Object object;
        Object table = this.requireTable();
        int[] entries = this.requireEntries();
        Object[] elements = this.requireElements();
        int srcIndex = this.size() - 1;
        if (dstIndex >= srcIndex) {
            var5_6[dstIndex] = null;
            entries[var1_1] = 0;
            return;
        }
        elements[dstIndex] = object = elements[srcIndex];
        elements[srcIndex] = null;
        entries[dstIndex] = entries[srcIndex];
        entries[srcIndex] = 0;
        int tableIndex = Hashing.smearedHash(object) & mask;
        int next = CompactHashing.tableGet(table, tableIndex);
        if (next == (srcNext = srcIndex + 1)) {
            CompactHashing.tableSet(table, tableIndex, dstIndex + 1);
            return;
        }
        while ((next = CompactHashing.getNext(entry = entries[entryIndex = next - 1], mask)) != srcNext) {
        }
        entries[var3_4] = CompactHashing.maskCombine(entry, dstIndex + 1, (int)var2_2);
    }

    int firstEntryIndex() {
        if (this.isEmpty()) {
            return -1;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    int getSuccessor(int entryIndex) {
        if (entryIndex + 1 < this.size) {
            void var1_1;
            return (int)(var1_1 + true);
        }
        return -1;
    }

    int adjustAfterRemove(int indexBeforeRemove, int indexRemoved) {
        return indexBeforeRemove - 1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Iterator<E> iterator() {
        Set<E> delegate = this.delegateOrNull();
        if (delegate != null) {
            void var1_1;
            return var1_1.iterator();
        }
        return new Iterator<E>(this){
            int expectedMetadata;
            int currentIndex;
            int indexToRemove;
            final /* synthetic */ CompactHashSet this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.expectedMetadata = this.this$0.metadata;
                this.currentIndex = this.this$0.firstEntryIndex();
                this.indexToRemove = -1;
            }

            @Override
            public boolean hasNext() {
                return this.currentIndex >= 0;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            @ParametricNullness
            public E next() {
                void var1_1;
                this.checkForConcurrentModification();
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.indexToRemove = this.currentIndex;
                Object result = CompactHashSet.access$100(this.this$0, this.currentIndex);
                this.currentIndex = this.this$0.getSuccessor(this.currentIndex);
                return var1_1;
            }

            @Override
            public void remove() {
                this.checkForConcurrentModification();
                CollectPreconditions.checkRemove(this.indexToRemove >= 0);
                this.incrementExpectedModCount();
                this.this$0.remove(CompactHashSet.access$100(this.this$0, this.indexToRemove));
                this.currentIndex = this.this$0.adjustAfterRemove(this.currentIndex, this.indexToRemove);
                this.indexToRemove = -1;
            }

            void incrementExpectedModCount() {
                this.expectedMetadata += 32;
            }

            private void checkForConcurrentModification() {
                if (this.this$0.metadata != this.expectedMetadata) {
                    throw new ConcurrentModificationException();
                }
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Spliterator<E> spliterator() {
        if (this.needsAllocArrays()) {
            return Spliterators.spliterator(new Object[0], 17);
        }
        Set<E> delegate = this.delegateOrNull();
        if (delegate != null) {
            void var1_1;
            return var1_1.spliterator();
        }
        return Spliterators.spliterator(this.requireElements(), 0, this.size, 17);
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        Preconditions.checkNotNull(action);
        Set<E> delegate = this.delegateOrNull();
        if (delegate != null) {
            delegate.forEach(action);
            return;
        }
        int i = this.firstEntryIndex();
        while (i >= 0) {
            action.accept(this.element(i));
            i = this.getSuccessor(i);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int size() {
        Set<E> delegate = this.delegateOrNull();
        if (delegate != null) {
            void var1_1;
            return var1_1.size();
        }
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object[] toArray() {
        if (this.needsAllocArrays()) {
            return new Object[0];
        }
        Set<E> delegate = this.delegateOrNull();
        if (delegate != null) {
            void var1_1;
            return var1_1.toArray();
        }
        return Arrays.copyOf(this.requireElements(), this.size);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> T[] toArray(T[] a) {
        void var1_1;
        if (this.needsAllocArrays()) {
            if (a.length > 0) {
                a[0] = null;
            }
            return a;
        }
        Set<E> delegate = this.delegateOrNull();
        if (delegate != null) {
            void var2_2;
            return var2_2.toArray(a);
        }
        return ObjectArrays.toArrayImpl(this.requireElements(), 0, this.size, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void trimToSize() {
        int mask;
        int minimumTableSize;
        if (this.needsAllocArrays()) {
            return;
        }
        Set<E> delegate = this.delegateOrNull();
        if (delegate != null) {
            CompactHashSet compactHashSet = this;
            Set<E> newDelegate = compactHashSet.createHashFloodingResistantDelegate(compactHashSet.size());
            newDelegate.addAll(delegate);
            this.table = newDelegate;
            return;
        }
        int size = this.size;
        if (size < this.requireEntries().length) {
            this.resizeEntries(size);
        }
        if ((minimumTableSize = CompactHashing.tableSize(size)) < (mask = this.hashTableMask())) {
            void var1_2;
            void var2_4;
            this.resizeTable((int)var2_4, (int)var1_2, 0, 0);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void clear() {
        if (this.needsAllocArrays()) {
            return;
        }
        this.incrementModCount();
        Set<E> delegate = this.delegateOrNull();
        if (delegate != null) {
            void var1_1;
            this.metadata = Ints.constrainToRange(this.size(), 3, 0x3FFFFFFF);
            var1_1.clear();
            this.table = null;
            this.size = 0;
            return;
        }
        Arrays.fill(this.requireElements(), 0, this.size, null);
        CompactHashing.tableClear(this.requireTable());
        Arrays.fill(this.requireEntries(), 0, this.size, 0);
        this.size = 0;
    }

    /*
     * WARNING - void declaration
     */
    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this.size());
        for (E e : this) {
            void var3_3;
            stream.writeObject(var3_3);
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int elementCount = stream.readInt();
        if (elementCount < 0) {
            throw new InvalidObjectException(new StringBuilder(25).append("Invalid size: ").append(elementCount).toString());
        }
        this.init(elementCount);
        for (int i = 0; i < elementCount; ++i) {
            Object element = stream.readObject();
            this.add(element);
        }
    }

    private Object requireTable() {
        return Objects.requireNonNull(this.table);
    }

    private int[] requireEntries() {
        return Objects.requireNonNull(this.entries);
    }

    private Object[] requireElements() {
        return Objects.requireNonNull(this.elements);
    }

    /*
     * WARNING - void declaration
     */
    private E element(int i) {
        void var1_1;
        return (E)this.requireElements()[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    private int entry(int i) {
        void var1_1;
        return this.requireEntries()[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    private void setElement(int i, E value) {
        void var2_2;
        this.requireElements()[var1_1] = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private void setEntry(int i, int value) {
        void var2_2;
        this.requireEntries()[var1_1] = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Object access$100(CompactHashSet x0, int x1) {
        void var1_1;
        return x0.element((int)var1_1);
    }
}

