/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractMapEntry;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.CollectSpliterators;
import com.google.common.collect.CompactHashing;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.Hashing;
import com.google.common.collect.Maps;
import com.google.common.collect.NullnessCasts;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.ParametricNullness;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
class CompactHashMap<K, V>
extends AbstractMap<K, V>
implements Serializable {
    private static final Object NOT_FOUND = new Object();
    @VisibleForTesting
    static final double HASH_FLOODING_FPP = 0.001;
    private static final int MAX_HASH_BUCKET_LENGTH = 9;
    private transient Object table;
    @VisibleForTesting
    transient int[] entries;
    @VisibleForTesting
    transient Object[] keys;
    @VisibleForTesting
    transient Object[] values;
    private transient int metadata;
    private transient int size;
    private transient Set<K> keySetView;
    private transient Set<Map.Entry<K, V>> entrySetView;
    private transient Collection<V> valuesView;

    public static <K, V> CompactHashMap<K, V> create() {
        return new CompactHashMap<K, V>();
    }

    public static <K, V> CompactHashMap<K, V> createWithExpectedSize(int expectedSize) {
        int n;
        return new CompactHashMap<K, V>(n);
    }

    CompactHashMap() {
        this.init(3);
    }

    /*
     * WARNING - void declaration
     */
    CompactHashMap(int expectedSize) {
        void var1_1;
        this.init((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    void init(int expectedSize) {
        void var1_1;
        Preconditions.checkArgument(expectedSize >= 0, "Expected size must be >= 0");
        this.metadata = Ints.constrainToRange((int)var1_1, 1, 0x3FFFFFFF);
    }

    @VisibleForTesting
    boolean needsAllocArrays() {
        return this.table == null;
    }

    /*
     * WARNING - void declaration
     */
    int allocArrays() {
        void var1_1;
        void var2_2;
        Preconditions.checkState(this.needsAllocArrays(), "Arrays already allocated");
        int expectedSize = this.metadata;
        int buckets = CompactHashing.tableSize(expectedSize);
        this.table = CompactHashing.createTable(buckets);
        this.setHashTableMask((int)(var2_2 - true));
        this.entries = new int[expectedSize];
        this.keys = new Object[expectedSize];
        this.values = new Object[expectedSize];
        return (int)var1_1;
    }

    @VisibleForTesting
    Map<K, V> delegateOrNull() {
        if (this.table instanceof Map) {
            return (Map)this.table;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    Map<K, V> createHashFloodingResistantDelegate(int tableSize) {
        void var1_1;
        return new LinkedHashMap((int)var1_1, 1.0f);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    Map<K, V> convertToHashFloodingResistantImplementation() {
        void var1_1;
        CompactHashMap compactHashMap = this;
        Map<K, V> newDelegate = compactHashMap.createHashFloodingResistantDelegate(compactHashMap.hashTableMask() + 1);
        int i = this.firstEntryIndex();
        while (i >= 0) {
            newDelegate.put(this.key(i), this.value(i));
            i = this.getSuccessor(i);
        }
        this.table = newDelegate;
        this.entries = null;
        this.keys = null;
        this.values = null;
        this.incrementModCount();
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void setHashTableMask(int mask) {
        void var1_1;
        int hashTableBits = 32 - Integer.numberOfLeadingZeros(mask);
        this.metadata = CompactHashing.maskCombine(this.metadata, (int)var1_1, 31);
    }

    private int hashTableMask() {
        return (1 << (this.metadata & 0x1F)) - 1;
    }

    void incrementModCount() {
        this.metadata += 32;
    }

    void accessEntry(int index) {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V put(@ParametricNullness K key, @ParametricNullness V value) {
        void var2_2;
        void var1_1;
        Map<K, V> delegate;
        if (this.needsAllocArrays()) {
            this.allocArrays();
        }
        if ((delegate = this.delegateOrNull()) != null) {
            return delegate.put(key, value);
        }
        int[] entries = this.requireEntries();
        Object[] keys = this.requireKeys();
        Object[] values = this.requireValues();
        int newEntryIndex = this.size;
        int newSize = newEntryIndex + 1;
        int hash = Hashing.smearedHash(key);
        int mask = this.hashTableMask();
        int tableIndex = hash & mask;
        int next = CompactHashing.tableGet(this.requireTable(), tableIndex);
        if (next == 0) {
            if (newSize > mask) {
                int n = mask;
                mask = this.resizeTable(n, CompactHashing.newCapacity(n), hash, newEntryIndex);
            } else {
                CompactHashing.tableSet(this.requireTable(), tableIndex, newEntryIndex + 1);
            }
        } else {
            int entry;
            int hashPrefix = CompactHashing.getHashPrefix(hash, mask);
            int bucketLength = 0;
            do {
                int entryIndex;
                if (CompactHashing.getHashPrefix(entry = entries[entryIndex = next - 1], mask) == hashPrefix && com.google.common.base.Objects.equal(key, keys[entryIndex])) {
                    Object oldValue = values[entryIndex];
                    values[entryIndex] = value;
                    this.accessEntry(entryIndex);
                    return var1_1;
                }
                next = CompactHashing.getNext(entry, mask);
                ++bucketLength;
            } while (next != 0);
            if (bucketLength >= 9) {
                return this.convertToHashFloodingResistantImplementation().put(var1_1, value);
            }
            if (newSize > mask) {
                int n = mask;
                mask = this.resizeTable(n, CompactHashing.newCapacity(n), hash, newEntryIndex);
            } else {
                var3_3[entryIndex] = CompactHashing.maskCombine(entry, newEntryIndex + 1, mask);
            }
        }
        this.resizeMeMaybe(newSize);
        this.insertEntry(newEntryIndex, var1_1, var2_2, hash, mask);
        this.size = newSize;
        this.incrementModCount();
        return null;
    }

    /*
     * WARNING - void declaration
     */
    void insertEntry(int entryIndex, @ParametricNullness K key, @ParametricNullness V value, int hash, int mask) {
        void var3_3;
        void var1_1;
        void var2_2;
        this.setEntry(entryIndex, CompactHashing.maskCombine(hash, 0, mask));
        this.setKey(entryIndex, var2_2);
        this.setValue((int)var1_1, var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private void resizeMeMaybe(int newSize) {
        void var2_2;
        int newCapacity;
        int entriesSize = this.requireEntries().length;
        if (newSize > entriesSize && (newCapacity = Math.min(0x3FFFFFFF, entriesSize + Math.max(1, entriesSize >>> 1) | 1)) != var2_2) {
            void var1_1;
            this.resizeEntries((int)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    void resizeEntries(int newCapacity) {
        void var1_1;
        this.entries = Arrays.copyOf(this.requireEntries(), newCapacity);
        this.keys = Arrays.copyOf(this.requireKeys(), newCapacity);
        this.values = Arrays.copyOf(this.requireValues(), (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private int resizeTable(int oldMask, int newCapacity, int targetHash, int targetEntryIndex) {
        void var2_2;
        Object newTable = CompactHashing.createTable(newCapacity);
        int newMask = newCapacity - 1;
        if (targetEntryIndex != 0) {
            CompactHashing.tableSet(newTable, targetHash & newMask, targetEntryIndex + 1);
        }
        Object oldTable = this.requireTable();
        int[] entries = this.requireEntries();
        for (int oldTableIndex = 0; oldTableIndex <= oldMask; ++oldTableIndex) {
            int oldNext = CompactHashing.tableGet(oldTable, oldTableIndex);
            while (oldNext != 0) {
                int entryIndex = oldNext - 1;
                int oldEntry = entries[entryIndex];
                int hash = CompactHashing.getHashPrefix(oldEntry, oldMask) | oldTableIndex;
                int newTableIndex = hash & newMask;
                int newNext = CompactHashing.tableGet(newTable, newTableIndex);
                CompactHashing.tableSet(newTable, newTableIndex, oldNext);
                entries[entryIndex] = CompactHashing.maskCombine(hash, newNext, newMask);
                oldNext = CompactHashing.getNext(oldEntry, oldMask);
            }
        }
        this.table = newTable;
        this.setHashTableMask(newMask);
        return (int)var2_2;
    }

    private int indexOf(Object key) {
        int entry;
        int n;
        if (this.needsAllocArrays()) {
            return -1;
        }
        int hash = Hashing.smearedHash(key);
        int mask = this.hashTableMask();
        int next = CompactHashing.tableGet(this.requireTable(), hash & mask);
        if (next == 0) {
            return -1;
        }
        int hashPrefix = CompactHashing.getHashPrefix(hash, mask);
        do {
            int entryIndex;
            if (CompactHashing.getHashPrefix(entry = this.entry(entryIndex = next - 1), mask) != hashPrefix || !com.google.common.base.Objects.equal(key, this.key(entryIndex))) continue;
            return entryIndex;
        } while ((n = CompactHashing.getNext(entry, mask)) != 0);
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsKey(Object key) {
        void var1_1;
        Map<K, V> delegate = this.delegateOrNull();
        if (delegate != null) {
            void var2_2;
            return var2_2.containsKey(key);
        }
        return this.indexOf(var1_1) != -1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V get(Object key) {
        void var1_2;
        Map<K, V> delegate = this.delegateOrNull();
        if (delegate != null) {
            void var2_3;
            return var2_3.get(key);
        }
        int index = this.indexOf(key);
        if (index == -1) {
            return null;
        }
        this.accessEntry(index);
        return this.value((int)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V remove(Object key) {
        void var1_1;
        Map<K, V> delegate = this.delegateOrNull();
        if (delegate != null) {
            void var2_2;
            return var2_2.remove(key);
        }
        Object oldValue = this.removeHelper(key);
        if (oldValue == NOT_FOUND) {
            return null;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Object removeHelper(Object key) {
        void var3_4;
        void var2_3;
        void var1_2;
        if (this.needsAllocArrays()) {
            return NOT_FOUND;
        }
        int mask = this.hashTableMask();
        int index = CompactHashing.remove(key, null, mask, this.requireTable(), this.requireEntries(), this.requireKeys(), null);
        if (index == -1) {
            return NOT_FOUND;
        }
        V oldValue = this.value(index);
        this.moveLastEntry((int)var1_2, (int)var2_3);
        --this.size;
        this.incrementModCount();
        return var3_4;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    void moveLastEntry(int dstIndex, int mask) {
        void var2_2;
        int entryIndex;
        int entry;
        int srcNext;
        Object key;
        Object table = this.requireTable();
        int[] entries = this.requireEntries();
        Object[] keys = this.requireKeys();
        Object[] values = this.requireValues();
        int srcIndex = this.size() - 1;
        if (dstIndex >= srcIndex) {
            var5_6[dstIndex] = null;
            var6_8[dstIndex] = null;
            entries[var1_1] = 0;
            return;
        }
        keys[dstIndex] = key = keys[srcIndex];
        values[dstIndex] = values[srcIndex];
        keys[srcIndex] = null;
        values[srcIndex] = null;
        entries[dstIndex] = entries[srcIndex];
        entries[srcIndex] = 0;
        int tableIndex = Hashing.smearedHash(key) & mask;
        int next = CompactHashing.tableGet(table, tableIndex);
        if (next == (srcNext = srcIndex + 1)) {
            CompactHashing.tableSet(table, tableIndex, dstIndex + 1);
            return;
        }
        while ((next = CompactHashing.getNext(entry = entries[entryIndex = next - 1], mask)) != srcNext) {
        }
        entries[var3_4] = CompactHashing.maskCombine(entry, dstIndex + 1, (int)var2_2);
    }

    int firstEntryIndex() {
        if (this.isEmpty()) {
            return -1;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    int getSuccessor(int entryIndex) {
        if (entryIndex + 1 < this.size) {
            void var1_1;
            return (int)(var1_1 + true);
        }
        return -1;
    }

    int adjustAfterRemove(int indexBeforeRemove, int indexRemoved) {
        return indexBeforeRemove - 1;
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        Preconditions.checkNotNull(function);
        Map<? super K, ? extends V> delegate = this.delegateOrNull();
        if (delegate != null) {
            delegate.replaceAll(function);
            return;
        }
        for (int i = 0; i < this.size; ++i) {
            this.setValue(i, function.apply(this.key(i), this.value(i)));
        }
    }

    @Override
    public Set<K> keySet() {
        if (this.keySetView == null) {
            this.keySetView = this.createKeySet();
            return this.keySetView;
        }
        return this.keySetView;
    }

    Set<K> createKeySet() {
        return new KeySetView();
    }

    /*
     * WARNING - void declaration
     */
    Iterator<K> keySetIterator() {
        Map<K, V> delegate = this.delegateOrNull();
        if (delegate != null) {
            void var1_1;
            return var1_1.keySet().iterator();
        }
        return new Itr<K>(){
            {
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            @ParametricNullness
            K getOutput(int entry) {
                void var1_1;
                return CompactHashMap.access$100(CompactHashMap.this, (int)var1_1);
            }
        };
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        Preconditions.checkNotNull(action);
        Map<? super K, ? super V> delegate = this.delegateOrNull();
        if (delegate != null) {
            delegate.forEach(action);
            return;
        }
        int i = this.firstEntryIndex();
        while (i >= 0) {
            action.accept(this.key(i), this.value(i));
            i = this.getSuccessor(i);
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySetView == null) {
            this.entrySetView = this.createEntrySet();
            return this.entrySetView;
        }
        return this.entrySetView;
    }

    Set<Map.Entry<K, V>> createEntrySet() {
        return new EntrySetView(this);
    }

    /*
     * WARNING - void declaration
     */
    Iterator<Map.Entry<K, V>> entrySetIterator() {
        Map<K, V> delegate = this.delegateOrNull();
        if (delegate != null) {
            void var1_1;
            return var1_1.entrySet().iterator();
        }
        return new Itr<Map.Entry<K, V>>(){
            {
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            Map.Entry<K, V> getOutput(int entry) {
                void var1_1;
                return new MapEntry((int)var1_1);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int size() {
        Map<K, V> delegate = this.delegateOrNull();
        if (delegate != null) {
            void var1_1;
            return var1_1.size();
        }
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsValue(Object value) {
        Map<K, V> delegate = this.delegateOrNull();
        if (delegate != null) {
            return delegate.containsValue(value);
        }
        for (int i = 0; i < this.size; ++i) {
            if (!com.google.common.base.Objects.equal(value, this.value(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<V> values() {
        if (this.valuesView == null) {
            this.valuesView = this.createValues();
            return this.valuesView;
        }
        return this.valuesView;
    }

    Collection<V> createValues() {
        return new ValuesView();
    }

    /*
     * WARNING - void declaration
     */
    Iterator<V> valuesIterator() {
        Map<K, V> delegate = this.delegateOrNull();
        if (delegate != null) {
            void var1_1;
            return var1_1.values().iterator();
        }
        return new Itr<V>(){
            {
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            @ParametricNullness
            V getOutput(int entry) {
                void var1_1;
                return CompactHashMap.access$800(CompactHashMap.this, (int)var1_1);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public void trimToSize() {
        int mask;
        int minimumTableSize;
        if (this.needsAllocArrays()) {
            return;
        }
        Map<K, V> delegate = this.delegateOrNull();
        if (delegate != null) {
            CompactHashMap compactHashMap = this;
            Map<K, V> newDelegate = compactHashMap.createHashFloodingResistantDelegate(compactHashMap.size());
            newDelegate.putAll(delegate);
            this.table = newDelegate;
            return;
        }
        int size = this.size;
        if (size < this.requireEntries().length) {
            this.resizeEntries(size);
        }
        if ((minimumTableSize = CompactHashing.tableSize(size)) < (mask = this.hashTableMask())) {
            void var1_2;
            void var2_4;
            this.resizeTable((int)var2_4, (int)var1_2, 0, 0);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void clear() {
        if (this.needsAllocArrays()) {
            return;
        }
        this.incrementModCount();
        Map<K, V> delegate = this.delegateOrNull();
        if (delegate != null) {
            void var1_1;
            this.metadata = Ints.constrainToRange(this.size(), 3, 0x3FFFFFFF);
            var1_1.clear();
            this.table = null;
            this.size = 0;
            return;
        }
        Arrays.fill(this.requireKeys(), 0, this.size, null);
        Arrays.fill(this.requireValues(), 0, this.size, null);
        CompactHashing.tableClear(this.requireTable());
        Arrays.fill(this.requireEntries(), 0, this.size, 0);
        this.size = 0;
    }

    /*
     * WARNING - void declaration
     */
    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this.size());
        Iterator<Map.Entry<K, V>> entryIterator = this.entrySetIterator();
        while (entryIterator.hasNext()) {
            void var3_3;
            Map.Entry<K, V> e = entryIterator.next();
            stream.writeObject(e.getKey());
            stream.writeObject(var3_3.getValue());
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int elementCount = stream.readInt();
        if (elementCount < 0) {
            throw new InvalidObjectException(new StringBuilder(25).append("Invalid size: ").append(elementCount).toString());
        }
        this.init(elementCount);
        for (int i = 0; i < elementCount; ++i) {
            Object key = stream.readObject();
            Object value = stream.readObject();
            this.put(key, value);
        }
    }

    private Object requireTable() {
        return Objects.requireNonNull(this.table);
    }

    private int[] requireEntries() {
        return Objects.requireNonNull(this.entries);
    }

    private Object[] requireKeys() {
        return Objects.requireNonNull(this.keys);
    }

    private Object[] requireValues() {
        return Objects.requireNonNull(this.values);
    }

    /*
     * WARNING - void declaration
     */
    private K key(int i) {
        void var1_1;
        return (K)this.requireKeys()[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    private V value(int i) {
        void var1_1;
        return (V)this.requireValues()[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    private int entry(int i) {
        void var1_1;
        return this.requireEntries()[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    private void setKey(int i, K key) {
        void var2_2;
        this.requireKeys()[var1_1] = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private void setValue(int i, V value) {
        void var2_2;
        this.requireValues()[var1_1] = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private void setEntry(int i, int value) {
        void var2_2;
        this.requireEntries()[var1_1] = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Object access$100(CompactHashMap x0, int x1) {
        void var1_1;
        return x0.key((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Object access$400(CompactHashMap x0, Object x1) {
        void var1_1;
        return x0.removeHelper(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$700(CompactHashMap x0, Object x1) {
        void var1_1;
        return x0.indexOf(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Object access$800(CompactHashMap x0, int x1) {
        void var1_1;
        return x0.value((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$1300(CompactHashMap x0, int x1, Object x2) {
        void var2_2;
        void var1_1;
        x0.setValue((int)var1_1, var2_2);
    }

    class ValuesView
    extends Maps.Values<K, V> {
        /*
         * WARNING - void declaration
         */
        ValuesView() {
            void var1_1;
            super(var1_1);
        }

        @Override
        public Iterator<V> iterator() {
            return CompactHashMap.this.valuesIterator();
        }

        @Override
        public void forEach(Consumer<? super V> action) {
            Preconditions.checkNotNull(action);
            Map delegate = CompactHashMap.this.delegateOrNull();
            if (delegate != null) {
                delegate.values().forEach(action);
                return;
            }
            int i = CompactHashMap.this.firstEntryIndex();
            while (i >= 0) {
                action.accept(CompactHashMap.access$800(CompactHashMap.this, i));
                i = CompactHashMap.this.getSuccessor(i);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Spliterator<V> spliterator() {
            if (CompactHashMap.this.needsAllocArrays()) {
                return Spliterators.spliterator(new Object[0], 16);
            }
            Map delegate = CompactHashMap.this.delegateOrNull();
            if (delegate != null) {
                void var1_1;
                return var1_1.values().spliterator();
            }
            return Spliterators.spliterator(CompactHashMap.this.requireValues(), 0, CompactHashMap.this.size, 16);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Object[] toArray() {
            if (CompactHashMap.this.needsAllocArrays()) {
                return new Object[0];
            }
            Map delegate = CompactHashMap.this.delegateOrNull();
            if (delegate != null) {
                void var1_1;
                return var1_1.values().toArray();
            }
            return ObjectArrays.copyAsObjectArray(CompactHashMap.this.requireValues(), 0, CompactHashMap.this.size);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public <T> T[] toArray(T[] a) {
            void var1_1;
            if (CompactHashMap.this.needsAllocArrays()) {
                if (a.length > 0) {
                    T[] TArray = a;
                    a[0] = null;
                }
                return a;
            }
            Map delegate = CompactHashMap.this.delegateOrNull();
            if (delegate != null) {
                void var2_3;
                return var2_3.values().toArray(a);
            }
            return ObjectArrays.toArrayImpl(CompactHashMap.this.requireValues(), 0, CompactHashMap.this.size, var1_1);
        }
    }

    final class MapEntry
    extends AbstractMapEntry<K, V> {
        @ParametricNullness
        private final K key;
        private int lastKnownIndex;

        /*
         * WARNING - void declaration
         */
        MapEntry(int index) {
            void var2_2;
            void var1_1;
            this.key = CompactHashMap.access$100((CompactHashMap)var1_1, index);
            this.lastKnownIndex = var2_2;
        }

        @Override
        @ParametricNullness
        public final K getKey() {
            return this.key;
        }

        private void updateLastKnownIndex() {
            if (this.lastKnownIndex == -1 || this.lastKnownIndex >= CompactHashMap.this.size() || !com.google.common.base.Objects.equal(this.key, CompactHashMap.access$100(CompactHashMap.this, this.lastKnownIndex))) {
                this.lastKnownIndex = CompactHashMap.access$700(CompactHashMap.this, this.key);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @ParametricNullness
        public final V getValue() {
            Map delegate = CompactHashMap.this.delegateOrNull();
            if (delegate != null) {
                void var1_1;
                return NullnessCasts.uncheckedCastNullableTToT(var1_1.get(this.key));
            }
            this.updateLastKnownIndex();
            if (this.lastKnownIndex == -1) {
                return NullnessCasts.unsafeNull();
            }
            return CompactHashMap.access$800(CompactHashMap.this, this.lastKnownIndex);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @ParametricNullness
        public final V setValue(@ParametricNullness V value) {
            void var2_2;
            void var1_1;
            Map delegate = CompactHashMap.this.delegateOrNull();
            if (delegate != null) {
                return NullnessCasts.uncheckedCastNullableTToT(delegate.put(this.key, value));
            }
            this.updateLastKnownIndex();
            if (this.lastKnownIndex == -1) {
                CompactHashMap.this.put(this.key, value);
                return NullnessCasts.unsafeNull();
            }
            Object old = CompactHashMap.access$800(CompactHashMap.this, this.lastKnownIndex);
            CompactHashMap.access$1300(CompactHashMap.this, this.lastKnownIndex, var1_1);
            return var2_2;
        }
    }

    class EntrySetView
    extends Maps.EntrySet<K, V> {
        final /* synthetic */ CompactHashMap this$0;

        /*
         * WARNING - void declaration
         */
        EntrySetView(CompactHashMap this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        Map<K, V> map() {
            return this.this$0;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return this.this$0.entrySetIterator();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Spliterator<Map.Entry<K, V>> spliterator() {
            Map delegate = this.this$0.delegateOrNull();
            if (delegate != null) {
                void var1_1;
                return var1_1.entrySet().spliterator();
            }
            return CollectSpliterators.indexed(this.this$0.size, 17, x$0 -> {
                void var1_1;
                return this.this$0.new MapEntry((int)var1_1);
            });
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean contains(Object o) {
            Map delegate = this.this$0.delegateOrNull();
            if (delegate != null) {
                return delegate.entrySet().contains(o);
            }
            if (o instanceof Map.Entry) {
                void var1_1;
                void var2_3;
                Map.Entry entry = (Map.Entry)o;
                int index = CompactHashMap.access$700(this.this$0, entry.getKey());
                return index != -1 && com.google.common.base.Objects.equal(CompactHashMap.access$800(this.this$0, (int)var2_3), var1_1.getValue());
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean remove(Object o) {
            Map delegate = this.this$0.delegateOrNull();
            if (delegate != null) {
                return delegate.entrySet().remove(o);
            }
            if (o instanceof Map.Entry) {
                void var2_4;
                void var1_2;
                Map.Entry entry = (Map.Entry)o;
                if (this.this$0.needsAllocArrays()) {
                    return false;
                }
                int mask = this.this$0.hashTableMask();
                int index = CompactHashing.remove(entry.getKey(), entry.getValue(), mask, this.this$0.requireTable(), this.this$0.requireEntries(), this.this$0.requireKeys(), this.this$0.requireValues());
                if (index == -1) {
                    return false;
                }
                this.this$0.moveLastEntry((int)var1_2, (int)var2_4);
                this.this$0.size--;
                this.this$0.incrementModCount();
                return true;
            }
            return false;
        }
    }

    class KeySetView
    extends Maps.KeySet<K, V> {
        /*
         * WARNING - void declaration
         */
        KeySetView() {
            void var1_1;
            super(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Object[] toArray() {
            if (CompactHashMap.this.needsAllocArrays()) {
                return new Object[0];
            }
            Map delegate = CompactHashMap.this.delegateOrNull();
            if (delegate != null) {
                void var1_1;
                return var1_1.keySet().toArray();
            }
            return ObjectArrays.copyAsObjectArray(CompactHashMap.this.requireKeys(), 0, CompactHashMap.this.size);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public <T> T[] toArray(T[] a) {
            void var1_1;
            if (CompactHashMap.this.needsAllocArrays()) {
                if (a.length > 0) {
                    T[] TArray = a;
                    a[0] = null;
                }
                return a;
            }
            Map delegate = CompactHashMap.this.delegateOrNull();
            if (delegate != null) {
                void var2_3;
                return var2_3.keySet().toArray(a);
            }
            return ObjectArrays.toArrayImpl(CompactHashMap.this.requireKeys(), 0, CompactHashMap.this.size, var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean remove(Object o) {
            void var1_1;
            Map delegate = CompactHashMap.this.delegateOrNull();
            if (delegate != null) {
                void var2_2;
                return var2_2.keySet().remove(o);
            }
            return CompactHashMap.access$400(CompactHashMap.this, var1_1) != NOT_FOUND;
        }

        @Override
        public Iterator<K> iterator() {
            return CompactHashMap.this.keySetIterator();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Spliterator<K> spliterator() {
            if (CompactHashMap.this.needsAllocArrays()) {
                return Spliterators.spliterator(new Object[0], 17);
            }
            Map delegate = CompactHashMap.this.delegateOrNull();
            if (delegate != null) {
                void var1_1;
                return var1_1.keySet().spliterator();
            }
            return Spliterators.spliterator(CompactHashMap.this.requireKeys(), 0, CompactHashMap.this.size, 17);
        }

        @Override
        public void forEach(Consumer<? super K> action) {
            Preconditions.checkNotNull(action);
            Map delegate = CompactHashMap.this.delegateOrNull();
            if (delegate != null) {
                delegate.keySet().forEach(action);
                return;
            }
            int i = CompactHashMap.this.firstEntryIndex();
            while (i >= 0) {
                action.accept(CompactHashMap.access$100(CompactHashMap.this, i));
                i = CompactHashMap.this.getSuccessor(i);
            }
        }
    }

    private abstract class Itr<T>
    implements Iterator<T> {
        int expectedMetadata;
        int currentIndex;
        int indexToRemove;

        private Itr() {
            this.expectedMetadata = CompactHashMap.this.metadata;
            this.currentIndex = CompactHashMap.this.firstEntryIndex();
            this.indexToRemove = -1;
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex >= 0;
        }

        @ParametricNullness
        abstract T getOutput(int var1);

        /*
         * WARNING - void declaration
         */
        @Override
        @ParametricNullness
        public T next() {
            void var1_1;
            this.checkForConcurrentModification();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.indexToRemove = this.currentIndex;
            Itr itr = this;
            T result = itr.getOutput(itr.currentIndex);
            this.currentIndex = CompactHashMap.this.getSuccessor(this.currentIndex);
            return var1_1;
        }

        @Override
        public void remove() {
            this.checkForConcurrentModification();
            CollectPreconditions.checkRemove(this.indexToRemove >= 0);
            this.incrementExpectedModCount();
            CompactHashMap.this.remove(CompactHashMap.access$100(CompactHashMap.this, this.indexToRemove));
            this.currentIndex = CompactHashMap.this.adjustAfterRemove(this.currentIndex, this.indexToRemove);
            this.indexToRemove = -1;
        }

        void incrementExpectedModCount() {
            this.expectedMetadata += 32;
        }

        private void checkForConcurrentModification() {
            if (CompactHashMap.this.metadata != this.expectedMetadata) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

