/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.CollectSpliterators;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.ParametricNullness;
import com.google.common.math.IntMath;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public final class Collections2 {
    private Collections2() {
    }

    /*
     * WARNING - void declaration
     */
    public static <E> Collection<E> filter(Collection<E> unfiltered, com.google.common.base.Predicate<? super E> predicate) {
        void var1_1;
        Collection<E> collection;
        if (unfiltered instanceof FilteredCollection) {
            return ((FilteredCollection)unfiltered).createCombined(predicate);
        }
        return new FilteredCollection<E>(Preconditions.checkNotNull(collection), (com.google.common.base.Predicate)Preconditions.checkNotNull(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    static boolean safeContains(Collection<?> collection, Object object) {
        Preconditions.checkNotNull(collection);
        try {
            void var1_1;
            Collection<?> collection2;
            return collection2.contains(var1_1);
        }
        catch (ClassCastException | NullPointerException runtimeException) {
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    static boolean safeRemove(Collection<?> collection, Object object) {
        Preconditions.checkNotNull(collection);
        try {
            void var1_1;
            Collection<?> collection2;
            return collection2.remove(var1_1);
        }
        catch (ClassCastException | NullPointerException runtimeException) {
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <F, T> Collection<T> transform(Collection<F> fromCollection, Function<? super F, T> function) {
        void var1_1;
        Collection<F> collection;
        return new TransformedCollection(collection, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static boolean containsAllImpl(Collection<?> self, Collection<?> c) {
        for (Object o : c) {
            void var2_2;
            if (self.contains(var2_2)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    static String toStringImpl(Collection<?> collection) {
        void var1_1;
        StringBuilder sb = Collections2.newStringBuilderForCollection(collection.size()).append('[');
        boolean first = true;
        for (Object o : collection) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            if (o == collection) {
                sb.append("(this Collection)");
                continue;
            }
            sb.append(o);
        }
        return var1_1.append(']').toString();
    }

    static StringBuilder newStringBuilderForCollection(int size) {
        int n;
        CollectPreconditions.checkNonnegative(size, "size");
        return new StringBuilder((int)Math.min((long)n << 3, 0x40000000L));
    }

    @Beta
    public static <E extends Comparable<? super E>> Collection<List<E>> orderedPermutations(Iterable<E> elements) {
        return Collections2.orderedPermutations(elements, Ordering.natural());
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    public static <E> Collection<List<E>> orderedPermutations(Iterable<E> elements, Comparator<? super E> comparator) {
        void var1_1;
        Iterable<E> iterable;
        return new OrderedPermutationCollection<E>(iterable, var1_1);
    }

    @Beta
    public static <E> Collection<List<E>> permutations(Collection<E> elements) {
        Collection<E> collection;
        return new PermutationCollection<E>(ImmutableList.copyOf(collection));
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isPermutation(List<?> first, List<?> second) {
        void var1_1;
        Collection<?> collection;
        if (first.size() != second.size()) {
            return false;
        }
        Collection<?> firstMultiset = HashMultiset.create(first);
        HashMultiset<?> secondMultiset = HashMultiset.create(second);
        return collection.equals(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$000(List x0, List x1) {
        void var1_1;
        return Collections2.isPermutation(x0, var1_1);
    }

    private static class PermutationIterator<E>
    extends AbstractIterator<List<E>> {
        final List<E> list;
        final int[] c;
        final int[] o;
        int j;

        /*
         * WARNING - void declaration
         */
        PermutationIterator(List<E> list) {
            void var1_2;
            this.list = new ArrayList<E>(list);
            int n = list.size();
            this.c = new int[n];
            this.o = new int[var1_2];
            Arrays.fill(this.c, 0);
            Arrays.fill(this.o, 1);
            this.j = Integer.MAX_VALUE;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected List<E> computeNext() {
            void var1_1;
            if (this.j <= 0) {
                return (List)this.endOfData();
            }
            ImmutableList<E> next = ImmutableList.copyOf(this.list);
            this.calculateNextPermutation();
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        void calculateNextPermutation() {
            block4: {
                void var2_2;
                void var1_1;
                int q;
                this.j = this.list.size() - 1;
                int s = 0;
                if (this.j == -1) {
                    return;
                }
                while (true) {
                    if ((q = this.c[this.j] + this.o[this.j]) < 0) {
                        this.switchDirection();
                        continue;
                    }
                    if (q != this.j + 1) break;
                    if (this.j != 0) {
                        ++s;
                        this.switchDirection();
                        continue;
                    }
                    break block4;
                    break;
                }
                Collections.swap(this.list, this.j - this.c[this.j] + s, this.j - q + var1_1);
                this.c[this.j] = var2_2;
            }
        }

        void switchDirection() {
            this.o[this.j] = -this.o[this.j];
            --this.j;
        }
    }

    private static final class PermutationCollection<E>
    extends AbstractCollection<List<E>> {
        final ImmutableList<E> inputList;

        /*
         * WARNING - void declaration
         */
        PermutationCollection(ImmutableList<E> input) {
            void var1_1;
            this.inputList = var1_1;
        }

        @Override
        public final int size() {
            return IntMath.factorial(this.inputList.size());
        }

        @Override
        public final boolean isEmpty() {
            return false;
        }

        @Override
        public final Iterator<List<E>> iterator() {
            return new PermutationIterator<E>(this.inputList);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean contains(Object obj) {
            if (obj instanceof List) {
                void var1_1;
                List list = (List)obj;
                return Collections2.access$000(this.inputList, (List)var1_1);
            }
            return false;
        }

        @Override
        public final String toString() {
            String string = String.valueOf(this.inputList);
            return new StringBuilder(14 + String.valueOf(string).length()).append("permutations(").append(string).append(")").toString();
        }
    }

    private static final class OrderedPermutationIterator<E>
    extends AbstractIterator<List<E>> {
        List<E> nextPermutation;
        final Comparator<? super E> comparator;

        /*
         * WARNING - void declaration
         */
        OrderedPermutationIterator(List<E> list, Comparator<? super E> comparator) {
            void var2_2;
            void var1_1;
            this.nextPermutation = Lists.newArrayList(var1_1);
            this.comparator = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final List<E> computeNext() {
            void var1_1;
            if (this.nextPermutation == null) {
                return (List)this.endOfData();
            }
            ImmutableList<E> next = ImmutableList.copyOf(this.nextPermutation);
            this.calculateNextPermutation();
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        final void calculateNextPermutation() {
            void var2_2;
            void var1_1;
            int j = this.findNextJ();
            if (j == -1) {
                this.nextPermutation = null;
                return;
            }
            Objects.requireNonNull(this.nextPermutation);
            int l = this.findNextL(j);
            Collections.swap(this.nextPermutation, j, l);
            int n = this.nextPermutation.size();
            Collections.reverse(this.nextPermutation.subList((int)(var1_1 + true), (int)var2_2));
        }

        final int findNextJ() {
            Objects.requireNonNull(this.nextPermutation);
            for (int k = this.nextPermutation.size() - 2; k >= 0; --k) {
                if (this.comparator.compare(this.nextPermutation.get(k), this.nextPermutation.get(k + 1)) >= 0) continue;
                return k;
            }
            return -1;
        }

        final int findNextL(int j) {
            Objects.requireNonNull(this.nextPermutation);
            E ak = this.nextPermutation.get(j);
            for (int l = this.nextPermutation.size() - 1; l > j; --l) {
                if (this.comparator.compare(ak, this.nextPermutation.get(l)) >= 0) continue;
                return l;
            }
            throw new AssertionError((Object)"this statement should be unreachable");
        }
    }

    private static final class OrderedPermutationCollection<E>
    extends AbstractCollection<List<E>> {
        final ImmutableList<E> inputList;
        final Comparator<? super E> comparator;
        final int size;

        /*
         * WARNING - void declaration
         */
        OrderedPermutationCollection(Iterable<E> input, Comparator<? super E> comparator) {
            void var2_2;
            void var1_1;
            this.inputList = ImmutableList.sortedCopyOf(comparator, var1_1);
            this.comparator = comparator;
            this.size = OrderedPermutationCollection.calculateSize(this.inputList, var2_2);
        }

        /*
         * WARNING - void declaration
         */
        private static <E> int calculateSize(List<E> sortedInputList, Comparator<? super E> comparator) {
            void var3_3;
            void var2_2;
            int permutations = 1;
            int n = 1;
            int r = 1;
            while (n < sortedInputList.size()) {
                int n2 = comparator.compare(sortedInputList.get(n - 1), sortedInputList.get(n));
                if (n2 < 0) {
                    permutations = IntMath.saturatedMultiply(permutations, IntMath.binomial(n, r));
                    r = 0;
                    if (permutations == Integer.MAX_VALUE) {
                        return Integer.MAX_VALUE;
                    }
                }
                ++n;
                ++r;
            }
            return IntMath.saturatedMultiply((int)var2_2, IntMath.binomial((int)var3_3, r));
        }

        @Override
        public final int size() {
            return this.size;
        }

        @Override
        public final boolean isEmpty() {
            return false;
        }

        @Override
        public final Iterator<List<E>> iterator() {
            return new OrderedPermutationIterator<E>(this.inputList, this.comparator);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean contains(Object obj) {
            if (obj instanceof List) {
                void var1_1;
                List list = (List)obj;
                return Collections2.access$000(this.inputList, (List)var1_1);
            }
            return false;
        }

        @Override
        public final String toString() {
            String string = String.valueOf(this.inputList);
            return new StringBuilder(30 + String.valueOf(string).length()).append("orderedPermutationCollection(").append(string).append(")").toString();
        }
    }

    static class TransformedCollection<F, T>
    extends AbstractCollection<T> {
        final Collection<F> fromCollection;
        final Function<? super F, ? extends T> function;

        /*
         * WARNING - void declaration
         */
        TransformedCollection(Collection<F> fromCollection, Function<? super F, ? extends T> function) {
            void var2_2;
            void var1_1;
            this.fromCollection = (Collection)Preconditions.checkNotNull(var1_1);
            this.function = (Function)Preconditions.checkNotNull(var2_2);
        }

        @Override
        public void clear() {
            this.fromCollection.clear();
        }

        @Override
        public boolean isEmpty() {
            return this.fromCollection.isEmpty();
        }

        @Override
        public Iterator<T> iterator() {
            return Iterators.transform(this.fromCollection.iterator(), this.function);
        }

        @Override
        public Spliterator<T> spliterator() {
            return CollectSpliterators.map(this.fromCollection.spliterator(), this.function);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void forEach(Consumer<? super T> action) {
            void var1_1;
            Preconditions.checkNotNull(action);
            this.fromCollection.forEach(arg_0 -> this.lambda$forEach$0((Consumer)var1_1, arg_0));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean removeIf(Predicate<? super T> filter) {
            void var1_1;
            Preconditions.checkNotNull(filter);
            return this.fromCollection.removeIf(arg_0 -> this.lambda$removeIf$1((Predicate)var1_1, arg_0));
        }

        @Override
        public int size() {
            return this.fromCollection.size();
        }

        /*
         * WARNING - void declaration
         */
        private /* synthetic */ boolean lambda$removeIf$1(Predicate filter, Object element) {
            void var2_2;
            return filter.test(this.function.apply(var2_2));
        }

        /*
         * WARNING - void declaration
         */
        private /* synthetic */ void lambda$forEach$0(Consumer action, Object f) {
            void var2_2;
            action.accept(this.function.apply(var2_2));
        }
    }

    static class FilteredCollection<E>
    extends AbstractCollection<E> {
        final Collection<E> unfiltered;
        final com.google.common.base.Predicate<? super E> predicate;

        /*
         * WARNING - void declaration
         */
        FilteredCollection(Collection<E> unfiltered, com.google.common.base.Predicate<? super E> predicate) {
            void var2_2;
            void var1_1;
            this.unfiltered = var1_1;
            this.predicate = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        FilteredCollection<E> createCombined(com.google.common.base.Predicate<? super E> newPredicate) {
            void var1_1;
            return new FilteredCollection<E>(this.unfiltered, Predicates.and(this.predicate, var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean add(@ParametricNullness E element) {
            void var1_1;
            Preconditions.checkArgument(this.predicate.apply(element));
            return this.unfiltered.add(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean addAll(Collection<? extends E> collection) {
            void var1_1;
            for (E element : collection) {
                void var3_3;
                Preconditions.checkArgument(this.predicate.apply(var3_3));
            }
            return this.unfiltered.addAll((Collection<E>)var1_1);
        }

        @Override
        public void clear() {
            Iterables.removeIf(this.unfiltered, this.predicate);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean contains(Object element) {
            if (Collections2.safeContains(this.unfiltered, element)) {
                void var1_1;
                return this.predicate.apply(var1_1);
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean containsAll(Collection<?> collection) {
            void var1_1;
            return Collections2.containsAllImpl(this, var1_1);
        }

        @Override
        public boolean isEmpty() {
            return !Iterables.any(this.unfiltered, this.predicate);
        }

        @Override
        public Iterator<E> iterator() {
            return Iterators.filter(this.unfiltered.iterator(), this.predicate);
        }

        @Override
        public Spliterator<E> spliterator() {
            return CollectSpliterators.filter(this.unfiltered.spliterator(), this.predicate);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void forEach(Consumer<? super E> action) {
            void var1_1;
            Preconditions.checkNotNull(action);
            this.unfiltered.forEach(arg_0 -> this.lambda$forEach$0((Consumer)var1_1, arg_0));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean remove(Object element) {
            void var1_1;
            return this.contains(element) && this.unfiltered.remove(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean removeAll(Collection<?> collection) {
            void var1_1;
            return this.removeIf(((Collection)var1_1)::contains);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean retainAll(Collection<?> collection) {
            void var1_1;
            return this.removeIf(arg_0 -> FilteredCollection.lambda$retainAll$1((Collection)var1_1, arg_0));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean removeIf(Predicate<? super E> filter) {
            void var1_1;
            Preconditions.checkNotNull(filter);
            return this.unfiltered.removeIf(arg_0 -> this.lambda$removeIf$2((Predicate)var1_1, arg_0));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int size() {
            void var1_1;
            int size = 0;
            for (E e : this.unfiltered) {
                void var3_3;
                if (!this.predicate.apply(var3_3)) continue;
                ++size;
            }
            return (int)var1_1;
        }

        @Override
        public Object[] toArray() {
            return Lists.newArrayList(this.iterator()).toArray();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public <T> T[] toArray(T[] array) {
            void var1_1;
            return Lists.newArrayList(this.iterator()).toArray((T[])var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private /* synthetic */ boolean lambda$removeIf$2(Predicate filter, Object element) {
            void var2_2;
            void var1_1;
            return this.predicate.apply(element) && var1_1.test(var2_2);
        }

        /*
         * WARNING - void declaration
         */
        private static /* synthetic */ boolean lambda$retainAll$1(Collection collection, Object element) {
            void var1_1;
            return !collection.contains(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private /* synthetic */ void lambda$forEach$0(Consumer action, Object e) {
            if (this.predicate.test(e)) {
                void var2_2;
                void var1_1;
                var1_1.accept(var2_2);
            }
        }
    }
}

