/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;

@ElementTypesAreNonnullByDefault
@GwtCompatible
final class CollectPreconditions {
    CollectPreconditions() {
    }

    /*
     * WARNING - void declaration
     */
    static void checkEntryNotNull(Object key, Object value) {
        void var1_1;
        if (key == null) {
            key = String.valueOf(value);
            throw new NullPointerException(new StringBuilder(24 + String.valueOf(key).length()).append("null key in entry: null=").append((String)key).toString());
        }
        if (var1_1 == null) {
            Object object;
            object = String.valueOf(object);
            throw new NullPointerException(new StringBuilder(26 + String.valueOf(object).length()).append("null value in entry: ").append((String)object).append("=null").toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    static int checkNonnegative(int value, String name) {
        int n;
        if (value < 0) {
            void var1_1;
            throw new IllegalArgumentException(new StringBuilder(40 + String.valueOf(name).length()).append((String)var1_1).append(" cannot be negative but was: ").append(value).toString());
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    static long checkNonnegative(long value, String name) {
        long l;
        if (value < 0L) {
            void var2_1;
            throw new IllegalArgumentException(new StringBuilder(49 + String.valueOf(name).length()).append((String)var2_1).append(" cannot be negative but was: ").append(value).toString());
        }
        return l;
    }

    /*
     * WARNING - void declaration
     */
    static void checkPositive(int value, String name) {
        if (value <= 0) {
            int n;
            void var1_1;
            throw new IllegalArgumentException(new StringBuilder(38 + String.valueOf(name).length()).append((String)var1_1).append(" must be positive but was: ").append(n).toString());
        }
    }

    static void checkRemove(boolean canRemove) {
        Preconditions.checkState(canRemove, "no calls to next() since the last call to remove()");
    }
}

