/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableEnumMap;
import com.google.common.collect.ImmutableEnumSet;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableRangeMap;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multiset;
import com.google.common.collect.Range;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.TreeMap;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@ElementTypesAreNonnullByDefault
@GwtCompatible
final class CollectCollectors {
    private static final Collector<Object, ?, ImmutableList<Object>> TO_IMMUTABLE_LIST = Collector.of(ImmutableList::builder, ImmutableList.Builder::add, ImmutableList.Builder::combine, ImmutableList.Builder::build, new Collector.Characteristics[0]);
    private static final Collector<Object, ?, ImmutableSet<Object>> TO_IMMUTABLE_SET = Collector.of(ImmutableSet::builder, ImmutableSet.Builder::add, ImmutableSet.Builder::combine, ImmutableSet.Builder::build, new Collector.Characteristics[0]);
    @GwtIncompatible
    private static final Collector<Range<Comparable<?>>, ?, ImmutableRangeSet<Comparable<?>>> TO_IMMUTABLE_RANGE_SET = Collector.of(ImmutableRangeSet::builder, ImmutableRangeSet.Builder::add, ImmutableRangeSet.Builder::combine, ImmutableRangeSet.Builder::build, new Collector.Characteristics[0]);

    CollectCollectors() {
    }

    static <E> Collector<E, ?, ImmutableList<E>> toImmutableList() {
        return TO_IMMUTABLE_LIST;
    }

    static <E> Collector<E, ?, ImmutableSet<E>> toImmutableSet() {
        return TO_IMMUTABLE_SET;
    }

    static <E> Collector<E, ?, ImmutableSortedSet<E>> toImmutableSortedSet(Comparator<? super E> comparator) {
        Comparator<? super E> comparator2;
        Preconditions.checkNotNull(comparator);
        return Collector.of(() -> {
            Comparator comparator2;
            return new ImmutableSortedSet.Builder(comparator2);
        }, ImmutableSortedSet.Builder::add, ImmutableSortedSet.Builder::combine, ImmutableSortedSet.Builder::build, new Collector.Characteristics[0]);
    }

    static <E extends Enum<E>> Collector<E, ?, ImmutableSet<E>> toImmutableEnumSet() {
        return EnumSetAccumulator.TO_IMMUTABLE_ENUM_SET;
    }

    @GwtIncompatible
    static <E extends Comparable<? super E>> Collector<Range<E>, ?, ImmutableRangeSet<E>> toImmutableRangeSet() {
        return TO_IMMUTABLE_RANGE_SET;
    }

    /*
     * WARNING - void declaration
     */
    static <T, E> Collector<T, ?, ImmutableMultiset<E>> toImmutableMultiset(Function<? super T, ? extends E> elementFunction, ToIntFunction<? super T> countFunction) {
        void var1_1;
        Function<? super T, ? extends E> function;
        Preconditions.checkNotNull(elementFunction);
        Preconditions.checkNotNull(countFunction);
        return Collector.of(LinkedHashMultiset::create, (arg_0, arg_1) -> CollectCollectors.lambda$toImmutableMultiset$1(function, (ToIntFunction)var1_1, arg_0, arg_1), (multiset1, multiset2) -> {
            Multiset multiset;
            void var1_1;
            multiset1.addAll(var1_1);
            return multiset;
        }, multiset -> ImmutableMultiset.copyFromEntries(multiset.entrySet()), new Collector.Characteristics[0]);
    }

    /*
     * WARNING - void declaration
     */
    static <T, E, M extends Multiset<E>> Collector<T, ?, M> toMultiset(Function<? super T, E> elementFunction, ToIntFunction<? super T> countFunction, Supplier<M> multisetSupplier) {
        void var1_1;
        Function<? super T, E> function;
        void var2_2;
        Preconditions.checkNotNull(elementFunction);
        Preconditions.checkNotNull(countFunction);
        Preconditions.checkNotNull(multisetSupplier);
        return Collector.of(var2_2, (arg_0, arg_1) -> CollectCollectors.lambda$toMultiset$4(function, (ToIntFunction)var1_1, arg_0, arg_1), (ms1, ms2) -> {
            Multiset multiset;
            void var1_1;
            ms1.addAll(var1_1);
            return multiset;
        }, new Collector.Characteristics[0]);
    }

    /*
     * WARNING - void declaration
     */
    static <T, K, V> Collector<T, ?, ImmutableMap<K, V>> toImmutableMap(Function<? super T, ? extends K> keyFunction, Function<? super T, ? extends V> valueFunction) {
        void var1_1;
        Function<? super T, ? extends K> function;
        Preconditions.checkNotNull(keyFunction);
        Preconditions.checkNotNull(valueFunction);
        return Collector.of(ImmutableMap.Builder::new, (arg_0, arg_1) -> CollectCollectors.lambda$toImmutableMap$6(function, (Function)var1_1, arg_0, arg_1), ImmutableMap.Builder::combine, ImmutableMap.Builder::build, new Collector.Characteristics[0]);
    }

    /*
     * WARNING - void declaration
     */
    public static <T, K, V> Collector<T, ?, ImmutableMap<K, V>> toImmutableMap(Function<? super T, ? extends K> keyFunction, Function<? super T, ? extends V> valueFunction, BinaryOperator<V> mergeFunction) {
        void var2_2;
        void var1_1;
        Function<? super T, ? extends K> function;
        Preconditions.checkNotNull(keyFunction);
        Preconditions.checkNotNull(valueFunction);
        Preconditions.checkNotNull(mergeFunction);
        return Collectors.collectingAndThen(Collectors.toMap(function, var1_1, var2_2, LinkedHashMap::new), ImmutableMap::copyOf);
    }

    /*
     * WARNING - void declaration
     */
    static <T, K, V> Collector<T, ?, ImmutableSortedMap<K, V>> toImmutableSortedMap(Comparator<? super K> comparator, Function<? super T, ? extends K> keyFunction, Function<? super T, ? extends V> valueFunction) {
        void var2_2;
        void var1_1;
        Comparator<? super K> comparator2;
        Preconditions.checkNotNull(comparator);
        Preconditions.checkNotNull(keyFunction);
        Preconditions.checkNotNull(valueFunction);
        return Collector.of(() -> {
            Comparator comparator2;
            return new ImmutableSortedMap.Builder(comparator2);
        }, (arg_0, arg_1) -> CollectCollectors.lambda$toImmutableSortedMap$8((Function)var1_1, (Function)var2_2, arg_0, arg_1), ImmutableSortedMap.Builder::combine, ImmutableSortedMap.Builder::build, Collector.Characteristics.UNORDERED);
    }

    /*
     * WARNING - void declaration
     */
    static <T, K, V> Collector<T, ?, ImmutableSortedMap<K, V>> toImmutableSortedMap(Comparator<? super K> comparator, Function<? super T, ? extends K> keyFunction, Function<? super T, ? extends V> valueFunction, BinaryOperator<V> mergeFunction) {
        Comparator<? super K> comparator2;
        void var3_3;
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull(comparator);
        Preconditions.checkNotNull(keyFunction);
        Preconditions.checkNotNull(valueFunction);
        Preconditions.checkNotNull(mergeFunction);
        return Collectors.collectingAndThen(Collectors.toMap(var1_1, var2_2, var3_3, () -> {
            Comparator comparator2;
            return new TreeMap(comparator2);
        }), ImmutableSortedMap::copyOfSorted);
    }

    /*
     * WARNING - void declaration
     */
    static <T, K, V> Collector<T, ?, ImmutableBiMap<K, V>> toImmutableBiMap(Function<? super T, ? extends K> keyFunction, Function<? super T, ? extends V> valueFunction) {
        void var1_1;
        Function<? super T, ? extends K> function;
        Preconditions.checkNotNull(keyFunction);
        Preconditions.checkNotNull(valueFunction);
        return Collector.of(ImmutableBiMap.Builder::new, (arg_0, arg_1) -> CollectCollectors.lambda$toImmutableBiMap$10(function, (Function)var1_1, arg_0, arg_1), ImmutableBiMap.Builder::combine, ImmutableBiMap.Builder::build, new Collector.Characteristics[0]);
    }

    /*
     * WARNING - void declaration
     */
    static <T, K extends Enum<K>, V> Collector<T, ?, ImmutableMap<K, V>> toImmutableEnumMap(Function<? super T, ? extends K> keyFunction, Function<? super T, ? extends V> valueFunction) {
        void var1_1;
        Function<? super T, ? extends K> function;
        Preconditions.checkNotNull(keyFunction);
        Preconditions.checkNotNull(valueFunction);
        return Collector.of(() -> new EnumMapAccumulator((v1, v2) -> {
            String string;
            Object object;
            object = String.valueOf(object);
            string = String.valueOf(string);
            throw new IllegalArgumentException(new StringBuilder(27 + String.valueOf(object).length() + String.valueOf(string).length()).append("Multiple values for key: ").append((String)object).append(", ").append(string).toString());
        }), (arg_0, arg_1) -> CollectCollectors.lambda$toImmutableEnumMap$13(function, (Function)var1_1, arg_0, arg_1), EnumMapAccumulator::combine, EnumMapAccumulator::toImmutableMap, Collector.Characteristics.UNORDERED);
    }

    /*
     * WARNING - void declaration
     */
    static <T, K extends Enum<K>, V> Collector<T, ?, ImmutableMap<K, V>> toImmutableEnumMap(Function<? super T, ? extends K> keyFunction, Function<? super T, ? extends V> valueFunction, BinaryOperator<V> mergeFunction) {
        void var1_1;
        Function<? super T, ? extends K> function;
        void var2_2;
        Preconditions.checkNotNull(keyFunction);
        Preconditions.checkNotNull(valueFunction);
        Preconditions.checkNotNull(mergeFunction);
        return Collector.of(() -> CollectCollectors.lambda$toImmutableEnumMap$14((BinaryOperator)var2_2), (arg_0, arg_1) -> CollectCollectors.lambda$toImmutableEnumMap$15(function, (Function)var1_1, arg_0, arg_1), EnumMapAccumulator::combine, EnumMapAccumulator::toImmutableMap, new Collector.Characteristics[0]);
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    static <T, K extends Comparable<? super K>, V> Collector<T, ?, ImmutableRangeMap<K, V>> toImmutableRangeMap(Function<? super T, Range<K>> keyFunction, Function<? super T, ? extends V> valueFunction) {
        void var1_1;
        Function<? super T, Range<K>> function;
        Preconditions.checkNotNull(keyFunction);
        Preconditions.checkNotNull(valueFunction);
        return Collector.of(ImmutableRangeMap::builder, (arg_0, arg_1) -> CollectCollectors.lambda$toImmutableRangeMap$16(function, (Function)var1_1, arg_0, arg_1), ImmutableRangeMap.Builder::combine, ImmutableRangeMap.Builder::build, new Collector.Characteristics[0]);
    }

    /*
     * WARNING - void declaration
     */
    static <T, K, V> Collector<T, ?, ImmutableListMultimap<K, V>> toImmutableListMultimap(Function<? super T, ? extends K> keyFunction, Function<? super T, ? extends V> valueFunction) {
        void var1_1;
        Function<? super T, ? extends K> function;
        Preconditions.checkNotNull(keyFunction, "keyFunction");
        Preconditions.checkNotNull(valueFunction, "valueFunction");
        return Collector.of(ImmutableListMultimap::builder, (arg_0, arg_1) -> CollectCollectors.lambda$toImmutableListMultimap$17(function, (Function)var1_1, arg_0, arg_1), ImmutableListMultimap.Builder::combine, ImmutableListMultimap.Builder::build, new Collector.Characteristics[0]);
    }

    /*
     * WARNING - void declaration
     */
    static <T, K, V> Collector<T, ?, ImmutableListMultimap<K, V>> flatteningToImmutableListMultimap(Function<? super T, ? extends K> keyFunction, Function<? super T, ? extends Stream<? extends V>> valuesFunction) {
        void var1_1;
        Function function;
        Preconditions.checkNotNull(keyFunction);
        Preconditions.checkNotNull(valuesFunction);
        return Collectors.collectingAndThen(CollectCollectors.flatteningToMultimap(input -> {
            void var1_1;
            return Preconditions.checkNotNull(function.apply(var1_1));
        }, arg_0 -> CollectCollectors.lambda$flatteningToImmutableListMultimap$19((Function)var1_1, arg_0), MultimapBuilder.linkedHashKeys().arrayListValues()::build), ImmutableListMultimap::copyOf);
    }

    /*
     * WARNING - void declaration
     */
    static <T, K, V> Collector<T, ?, ImmutableSetMultimap<K, V>> toImmutableSetMultimap(Function<? super T, ? extends K> keyFunction, Function<? super T, ? extends V> valueFunction) {
        void var1_1;
        Function<? super T, ? extends K> function;
        Preconditions.checkNotNull(keyFunction, "keyFunction");
        Preconditions.checkNotNull(valueFunction, "valueFunction");
        return Collector.of(ImmutableSetMultimap::builder, (arg_0, arg_1) -> CollectCollectors.lambda$toImmutableSetMultimap$20(function, (Function)var1_1, arg_0, arg_1), ImmutableSetMultimap.Builder::combine, ImmutableSetMultimap.Builder::build, new Collector.Characteristics[0]);
    }

    /*
     * WARNING - void declaration
     */
    static <T, K, V> Collector<T, ?, ImmutableSetMultimap<K, V>> flatteningToImmutableSetMultimap(Function<? super T, ? extends K> keyFunction, Function<? super T, ? extends Stream<? extends V>> valuesFunction) {
        void var1_1;
        Function function;
        Preconditions.checkNotNull(keyFunction);
        Preconditions.checkNotNull(valuesFunction);
        return Collectors.collectingAndThen(CollectCollectors.flatteningToMultimap(input -> {
            void var1_1;
            return Preconditions.checkNotNull(function.apply(var1_1));
        }, arg_0 -> CollectCollectors.lambda$flatteningToImmutableSetMultimap$22((Function)var1_1, arg_0), MultimapBuilder.linkedHashKeys().linkedHashSetValues()::build), ImmutableSetMultimap::copyOf);
    }

    /*
     * WARNING - void declaration
     */
    static <T, K, V, M extends Multimap<K, V>> Collector<T, ?, M> toMultimap(Function<? super T, ? extends K> keyFunction, Function<? super T, ? extends V> valueFunction, Supplier<M> multimapSupplier) {
        void var1_1;
        Function<? super T, ? extends K> function;
        void var2_2;
        Preconditions.checkNotNull(keyFunction);
        Preconditions.checkNotNull(valueFunction);
        Preconditions.checkNotNull(multimapSupplier);
        return Collector.of(var2_2, (arg_0, arg_1) -> CollectCollectors.lambda$toMultimap$23(function, (Function)var1_1, arg_0, arg_1), (multimap1, multimap2) -> {
            Multimap multimap;
            void var1_1;
            multimap1.putAll(var1_1);
            return multimap;
        }, new Collector.Characteristics[0]);
    }

    /*
     * WARNING - void declaration
     */
    static <T, K, V, M extends Multimap<K, V>> Collector<T, ?, M> flatteningToMultimap(Function<? super T, ? extends K> keyFunction, Function<? super T, ? extends Stream<? extends V>> valueFunction, Supplier<M> multimapSupplier) {
        void var1_1;
        Function<? super T, ? extends K> function;
        void var2_2;
        Preconditions.checkNotNull(keyFunction);
        Preconditions.checkNotNull(valueFunction);
        Preconditions.checkNotNull(multimapSupplier);
        return Collector.of(var2_2, (arg_0, arg_1) -> CollectCollectors.lambda$flatteningToMultimap$25(function, (Function)var1_1, arg_0, arg_1), (multimap1, multimap2) -> {
            Multimap multimap;
            void var1_1;
            multimap1.putAll(var1_1);
            return multimap;
        }, new Collector.Characteristics[0]);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$flatteningToMultimap$25(Function keyFunction, Function valueFunction, Multimap multimap, Object input) {
        Object r;
        void var3_3;
        void var1_1;
        void var2_2;
        Object key = keyFunction.apply(input);
        Object valuesForKey = var2_2.get(key);
        ((Stream)var1_1.apply(var3_3)).forEachOrdered(((Collection)r)::add);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$toMultimap$23(Function keyFunction, Function valueFunction, Multimap multimap, Object input) {
        void var3_3;
        void var1_1;
        Function function;
        multimap.put(function.apply(input), var1_1.apply(var3_3));
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ Stream lambda$flatteningToImmutableSetMultimap$22(Function valuesFunction, Object input) {
        void var1_1;
        return ((Stream)valuesFunction.apply(var1_1)).peek(Preconditions::checkNotNull);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$toImmutableSetMultimap$20(Function keyFunction, Function valueFunction, ImmutableSetMultimap.Builder builder, Object t) {
        void var3_3;
        void var1_1;
        Function function;
        builder.put(function.apply(t), var1_1.apply(var3_3));
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ Stream lambda$flatteningToImmutableListMultimap$19(Function valuesFunction, Object input) {
        void var1_1;
        return ((Stream)valuesFunction.apply(var1_1)).peek(Preconditions::checkNotNull);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$toImmutableListMultimap$17(Function keyFunction, Function valueFunction, ImmutableListMultimap.Builder builder, Object t) {
        void var3_3;
        void var1_1;
        Function function;
        builder.put(function.apply(t), var1_1.apply(var3_3));
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$toImmutableRangeMap$16(Function keyFunction, Function valueFunction, ImmutableRangeMap.Builder builder, Object input) {
        void var3_3;
        void var1_1;
        Function function;
        builder.put((Range)function.apply(input), var1_1.apply(var3_3));
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$toImmutableEnumMap$15(Function keyFunction, Function valueFunction, EnumMapAccumulator accum, Object t) {
        void var3_3;
        void var1_1;
        Enum enum_;
        void var2_2;
        Enum key = (Enum)keyFunction.apply(t);
        Object newValue = valueFunction.apply(t);
        var2_2.put((Enum)Preconditions.checkNotNull(enum_, "Null key for input %s", t), Preconditions.checkNotNull(var1_1, "Null value for input %s", (Object)var3_3));
    }

    private static /* synthetic */ EnumMapAccumulator lambda$toImmutableEnumMap$14(BinaryOperator mergeFunction) {
        BinaryOperator binaryOperator;
        return new EnumMapAccumulator(binaryOperator);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$toImmutableEnumMap$13(Function keyFunction, Function valueFunction, EnumMapAccumulator accum, Object t) {
        void var3_3;
        void var1_1;
        Enum enum_;
        void var2_2;
        Enum key = (Enum)keyFunction.apply(t);
        Object newValue = valueFunction.apply(t);
        var2_2.put((Enum)Preconditions.checkNotNull(enum_, "Null key for input %s", t), Preconditions.checkNotNull(var1_1, "Null value for input %s", (Object)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$toImmutableBiMap$10(Function keyFunction, Function valueFunction, ImmutableBiMap.Builder builder, Object input) {
        void var3_3;
        void var1_1;
        Function function;
        builder.put(function.apply(input), var1_1.apply(var3_3));
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$toImmutableSortedMap$8(Function keyFunction, Function valueFunction, ImmutableSortedMap.Builder builder, Object input) {
        void var3_3;
        void var1_1;
        Function function;
        builder.put(function.apply(input), var1_1.apply(var3_3));
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$toImmutableMap$6(Function keyFunction, Function valueFunction, ImmutableMap.Builder builder, Object input) {
        void var3_3;
        void var1_1;
        Function function;
        builder.put(function.apply(input), var1_1.apply(var3_3));
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$toMultiset$4(Function elementFunction, ToIntFunction countFunction, Multiset ms, Object t) {
        void var3_3;
        void var1_1;
        Function function;
        ms.add(function.apply(t), var1_1.applyAsInt(var3_3));
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$toImmutableMultiset$1(Function elementFunction, ToIntFunction countFunction, Multiset multiset, Object t) {
        void var3_3;
        void var1_1;
        Function function;
        multiset.add(Preconditions.checkNotNull(function.apply(t)), var1_1.applyAsInt(var3_3));
    }

    private static class EnumMapAccumulator<K extends Enum<K>, V> {
        private final BinaryOperator<V> mergeFunction;
        private EnumMap<K, V> map = null;

        /*
         * WARNING - void declaration
         */
        EnumMapAccumulator(BinaryOperator<V> mergeFunction) {
            void var1_1;
            this.mergeFunction = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        void put(K key, V value) {
            void var2_2;
            void var1_1;
            if (this.map == null) {
                this.map = new EnumMap(((Enum)key).getDeclaringClass());
            }
            this.map.merge(var1_1, var2_2, this.mergeFunction);
        }

        /*
         * WARNING - void declaration
         */
        EnumMapAccumulator<K, V> combine(EnumMapAccumulator<K, V> other) {
            void var1_1;
            if (this.map == null) {
                return other;
            }
            if (other.map == null) {
                return this;
            }
            var1_1.map.forEach(this::put);
            return this;
        }

        ImmutableMap<K, V> toImmutableMap() {
            if (this.map == null) {
                return ImmutableMap.of();
            }
            return ImmutableEnumMap.asImmutable(this.map);
        }
    }

    private static final class EnumSetAccumulator<E extends Enum<E>> {
        static final Collector<Enum<?>, ?, ImmutableSet<? extends Enum<?>>> TO_IMMUTABLE_ENUM_SET = Collector.of(EnumSetAccumulator::new, EnumSetAccumulator::add, EnumSetAccumulator::combine, EnumSetAccumulator::toImmutableSet, Collector.Characteristics.UNORDERED);
        private EnumSet<E> set;

        private EnumSetAccumulator() {
        }

        /*
         * WARNING - void declaration
         */
        final void add(E e) {
            void var1_1;
            if (this.set == null) {
                this.set = EnumSet.of(e);
                return;
            }
            this.set.add(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        final EnumSetAccumulator<E> combine(EnumSetAccumulator<E> other) {
            void var1_1;
            if (this.set == null) {
                return other;
            }
            if (other.set == null) {
                return this;
            }
            this.set.addAll(var1_1.set);
            return this;
        }

        final ImmutableSet<E> toImmutableSet() {
            if (this.set == null) {
                return ImmutableSet.of();
            }
            return ImmutableEnumSet.asImmutable(this.set);
        }
    }
}

