/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ImmutableList;
import com.google.common.math.IntMath;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;

@ElementTypesAreNonnullByDefault
@GwtCompatible
final class CartesianList<E>
extends AbstractList<List<E>>
implements RandomAccess {
    private final transient ImmutableList<List<E>> axes;
    private final transient int[] axesSizeProduct;

    /*
     * WARNING - void declaration
     */
    static <E> List<List<E>> create(List<? extends List<? extends E>> lists) {
        void var1_1;
        Iterator<? extends List<? extends E>> iterator;
        ImmutableList.Builder axesBuilder = new ImmutableList.Builder(lists.size());
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            List list = (List)iterator.next();
            ImmutableList copy = ImmutableList.copyOf(list);
            if (copy.isEmpty()) {
                return ImmutableList.of();
            }
            axesBuilder.add(list);
        }
        return new CartesianList<E>(var1_1.build());
    }

    /*
     * WARNING - void declaration
     */
    CartesianList(ImmutableList<List<E>> axes) {
        void var2_2;
        this.axes = axes;
        int[] nArray = new int[axes.size() + 1];
        int[] axesSizeProduct = nArray;
        nArray[axes.size()] = 1;
        try {
            for (int i = axes.size() - 1; i >= 0; --i) {
                axesSizeProduct[i] = IntMath.checkedMultiply(axesSizeProduct[i + 1], ((List)axes.get(i)).size());
            }
        }
        catch (ArithmeticException arithmeticException) {
            throw new IllegalArgumentException("Cartesian product too large; must have size at most Integer.MAX_VALUE");
        }
        this.axesSizeProduct = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private int getAxisIndexForProductIndex(int index, int axis) {
        void var2_2;
        return index / this.axesSizeProduct[axis + 1] % ((List)this.axes.get((int)var2_2)).size();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int indexOf(Object o) {
        void var2_2;
        if (!(o instanceof List)) {
            return -1;
        }
        List list = (List)o;
        if (list.size() != this.axes.size()) {
            return -1;
        }
        ListIterator itr = list.listIterator();
        int computedIndex = 0;
        while (itr.hasNext()) {
            void var3_3;
            int axisIndex = itr.nextIndex();
            int elemIndex = ((List)this.axes.get(axisIndex)).indexOf(itr.next());
            if (elemIndex == -1) {
                return -1;
            }
            computedIndex += elemIndex * this.axesSizeProduct[var3_3 + true];
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int lastIndexOf(Object o) {
        void var2_2;
        if (!(o instanceof List)) {
            return -1;
        }
        List list = (List)o;
        if (list.size() != this.axes.size()) {
            return -1;
        }
        ListIterator itr = list.listIterator();
        int computedIndex = 0;
        while (itr.hasNext()) {
            void var3_3;
            int axisIndex = itr.nextIndex();
            int elemIndex = ((List)this.axes.get(axisIndex)).lastIndexOf(itr.next());
            if (elemIndex == -1) {
                return -1;
            }
            computedIndex += elemIndex * this.axesSizeProduct[var3_3 + true];
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ImmutableList<E> get(int index) {
        void var1_1;
        Preconditions.checkElementIndex(index, this.size());
        return new ImmutableList<E>(this, (int)var1_1){
            final /* synthetic */ int val$index;
            final /* synthetic */ CartesianList this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$index = n;
            }

            @Override
            public int size() {
                return this.this$0.axes.size();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public E get(int axis) {
                void var2_2;
                void var1_1;
                Preconditions.checkElementIndex(axis, this.size());
                int axisIndex = CartesianList.access$100(this.this$0, this.val$index, axis);
                return ((List)this.this$0.axes.get((int)var1_1)).get((int)var2_2);
            }

            @Override
            boolean isPartialView() {
                return true;
            }
        };
    }

    @Override
    public final int size() {
        return this.axesSizeProduct[0];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean contains(Object object) {
        Iterator iterator;
        if (!(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        if (list.size() != this.axes.size()) {
            return false;
        }
        int i = 0;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_3;
            Object o = iterator.next();
            if (!((List)this.axes.get(i)).contains(var3_3)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$100(CartesianList x0, int x1, int x2) {
        void var2_2;
        void var1_1;
        return x0.getAxisIndexForProductIndex((int)var1_1, (int)var2_2);
    }
}

