/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.Ordering;
import com.google.common.collect.ParametricNullness;
import java.io.Serializable;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true)
final class ByFunctionOrdering<F, T>
extends Ordering<F>
implements Serializable {
    final Function<F, ? extends T> function;
    final Ordering<T> ordering;
    private static final long serialVersionUID = 0L;

    /*
     * WARNING - void declaration
     */
    ByFunctionOrdering(Function<F, ? extends T> function, Ordering<T> ordering) {
        void var2_2;
        void var1_1;
        this.function = (Function)Preconditions.checkNotNull(var1_1);
        this.ordering = (Ordering)Preconditions.checkNotNull(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int compare(@ParametricNullness F left, @ParametricNullness F right) {
        void var2_2;
        void var1_1;
        return this.ordering.compare(this.function.apply(var1_1), this.function.apply(var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ByFunctionOrdering) {
            void var1_1;
            ByFunctionOrdering that = (ByFunctionOrdering)object;
            return this.function.equals(that.function) && this.ordering.equals(var1_1.ordering);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hashCode(this.function, this.ordering);
    }

    public final String toString() {
        String string = String.valueOf(this.ordering);
        String string2 = String.valueOf(this.function);
        return new StringBuilder(13 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(".onResultOf(").append(string2).append(")").toString();
    }
}

