/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIndexedListIterator;
import com.google.common.collect.AbstractMapEntry;
import com.google.common.collect.AbstractTable;
import com.google.common.collect.CollectSpliterators;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.ParametricNullness;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;

@ElementTypesAreNonnullByDefault
@Beta
@GwtCompatible(emulated=true)
public final class ArrayTable<R, C, V>
extends AbstractTable<R, C, V>
implements Serializable {
    private final ImmutableList<R> rowList;
    private final ImmutableList<C> columnList;
    private final ImmutableMap<R, Integer> rowKeyToIndex;
    private final ImmutableMap<C, Integer> columnKeyToIndex;
    private final V[][] array;
    private transient ColumnMap columnMap;
    private transient RowMap rowMap;
    private static final long serialVersionUID = 0L;

    /*
     * WARNING - void declaration
     */
    public static <R, C, V> ArrayTable<R, C, V> create(Iterable<? extends R> rowKeys, Iterable<? extends C> columnKeys) {
        void var1_1;
        Iterable<? extends R> iterable;
        return new ArrayTable<R, C, V>(iterable, var1_1);
    }

    public static <R, C, V> ArrayTable<R, C, V> create(Table<R, C, ? extends V> table) {
        Table<R, C, ? extends V> table2;
        if (table instanceof ArrayTable) {
            return new ArrayTable<R, C, V>((ArrayTable)table);
        }
        return new ArrayTable<R, C, V>(table2);
    }

    /*
     * WARNING - void declaration
     */
    private ArrayTable(Iterable<? extends R> rowKeys, Iterable<? extends C> columnKeys) {
        void var1_1;
        void var2_2;
        this.rowList = ImmutableList.copyOf(rowKeys);
        this.columnList = ImmutableList.copyOf(var2_2);
        Preconditions.checkArgument(this.rowList.isEmpty() == this.columnList.isEmpty());
        this.rowKeyToIndex = Maps.indexMap(this.rowList);
        this.columnKeyToIndex = Maps.indexMap(this.columnList);
        Object[][] tmpArray = new Object[this.rowList.size()][this.columnList.size()];
        this.array = var1_1;
        this.eraseAll();
    }

    /*
     * WARNING - void declaration
     */
    private ArrayTable(Table<R, C, ? extends V> table) {
        this(table.rowKeySet(), table.columnKeySet());
        void var1_1;
        this.putAll((Table<R, C, V>)var1_1);
    }

    private ArrayTable(ArrayTable<R, C, V> table) {
        this.rowList = table.rowList;
        this.columnList = table.columnList;
        this.rowKeyToIndex = table.rowKeyToIndex;
        this.columnKeyToIndex = table.columnKeyToIndex;
        Object[][] copy = new Object[this.rowList.size()][this.columnList.size()];
        this.array = copy;
        for (int i = 0; i < this.rowList.size(); ++i) {
            System.arraycopy(table.array[i], 0, copy[i], 0, table.array[i].length);
        }
    }

    public final ImmutableList<R> rowKeyList() {
        return this.rowList;
    }

    public final ImmutableList<C> columnKeyList() {
        return this.columnList;
    }

    /*
     * WARNING - void declaration
     */
    public final V at(int rowIndex, int columnIndex) {
        void var2_2;
        void var1_1;
        Preconditions.checkElementIndex(rowIndex, this.rowList.size());
        Preconditions.checkElementIndex(columnIndex, this.columnList.size());
        return this.array[var1_1][var2_2];
    }

    /*
     * WARNING - void declaration
     */
    public final V set(int rowIndex, int columnIndex, V value) {
        void var3_3;
        Preconditions.checkElementIndex(rowIndex, this.rowList.size());
        Preconditions.checkElementIndex(columnIndex, this.columnList.size());
        V oldValue = this.array[rowIndex][columnIndex];
        this.array[var1_1][var2_2] = var3_3;
        return oldValue;
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    public final V[][] toArray(Class<V> valueClass) {
        void var1_1;
        Object[][] copy = (Object[][])Array.newInstance(valueClass, this.rowList.size(), this.columnList.size());
        for (int i = 0; i < this.rowList.size(); ++i) {
            System.arraycopy(this.array[i], 0, copy[i], 0, this.array[i].length);
        }
        return var1_1;
    }

    @Override
    @Deprecated
    public final void clear() {
        throw new UnsupportedOperationException();
    }

    public final void eraseAll() {
        V[][] VArray = this.array;
        int n = this.array.length;
        for (int i = 0; i < n; ++i) {
            Object[] objectArray = VArray[i];
            Arrays.fill(objectArray, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean contains(Object rowKey, Object columnKey) {
        void var2_2;
        void var1_1;
        return this.containsRow(var1_1) && this.containsColumn(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean containsColumn(Object columnKey) {
        void var1_1;
        return this.columnKeyToIndex.containsKey(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean containsRow(Object rowKey) {
        void var1_1;
        return this.rowKeyToIndex.containsKey(var1_1);
    }

    @Override
    public final boolean containsValue(Object value) {
        V[][] VArray = this.array;
        int n = this.array.length;
        for (int i = 0; i < n; ++i) {
            V[] VArray2 = VArray[i];
            V[] VArray3 = VArray2;
            VArray3 = VArray2;
            int n2 = VArray2.length;
            for (int j = 0; j < n2; ++j) {
                V element = VArray3[j];
                if (!Objects.equal(value, element)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V get(Object rowKey, Object columnKey) {
        void var2_2;
        void var1_1;
        Integer rowIndex = this.rowKeyToIndex.get(rowKey);
        Integer columnIndex = this.columnKeyToIndex.get(columnKey);
        if (rowIndex == null || columnIndex == null) {
            return null;
        }
        return this.at(var1_1.intValue(), var2_2.intValue());
    }

    @Override
    public final boolean isEmpty() {
        return this.rowList.isEmpty() || this.columnList.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V put(R rowKey, C columnKey, V value) {
        void var3_3;
        void var1_1;
        void var2_2;
        Preconditions.checkNotNull(rowKey);
        Preconditions.checkNotNull(columnKey);
        Integer rowIndex = this.rowKeyToIndex.get(rowKey);
        Preconditions.checkArgument(rowIndex != null, "Row %s not in %s", rowKey, this.rowList);
        Integer columnIndex = this.columnKeyToIndex.get(columnKey);
        Preconditions.checkArgument(columnIndex != null, "Column %s not in %s", (Object)var2_2, this.columnList);
        return this.set(rowIndex, var1_1.intValue(), var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void putAll(Table<? extends R, ? extends C, ? extends V> table) {
        void var1_1;
        super.putAll(var1_1);
    }

    @Override
    @Deprecated
    public final V remove(Object rowKey, Object columnKey) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    public final V erase(Object rowKey, Object columnKey) {
        void var2_2;
        void var1_1;
        Integer rowIndex = this.rowKeyToIndex.get(rowKey);
        Integer columnIndex = this.columnKeyToIndex.get(columnKey);
        if (rowIndex == null || columnIndex == null) {
            return null;
        }
        return this.set(var1_1.intValue(), var2_2.intValue(), null);
    }

    @Override
    public final int size() {
        return this.rowList.size() * this.columnList.size();
    }

    @Override
    public final Set<Table.Cell<R, C, V>> cellSet() {
        return super.cellSet();
    }

    @Override
    final Iterator<Table.Cell<R, C, V>> cellIterator() {
        ArrayTable arrayTable = this;
        return new AbstractIndexedListIterator<Table.Cell<R, C, V>>(arrayTable, arrayTable.size()){
            final /* synthetic */ ArrayTable this$0;
            {
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                super((int)var2_2);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            protected Table.Cell<R, C, V> get(int index) {
                void var1_1;
                return ArrayTable.access$000(this.this$0, (int)var1_1);
            }
        };
    }

    @Override
    final Spliterator<Table.Cell<R, C, V>> cellSpliterator() {
        return CollectSpliterators.indexed(this.size(), 273, this::getCell);
    }

    /*
     * WARNING - void declaration
     */
    private Table.Cell<R, C, V> getCell(int index) {
        void var1_1;
        return new Tables.AbstractCell<R, C, V>(this, (int)var1_1){
            final int rowIndex;
            final int columnIndex;
            final /* synthetic */ int val$index;
            final /* synthetic */ ArrayTable this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$index = n;
                this.rowIndex = this.val$index / this.this$0.columnList.size();
                this.columnIndex = this.val$index % this.this$0.columnList.size();
            }

            @Override
            public R getRowKey() {
                return this.this$0.rowList.get(this.rowIndex);
            }

            @Override
            public C getColumnKey() {
                return this.this$0.columnList.get(this.columnIndex);
            }

            @Override
            public V getValue() {
                return this.this$0.at(this.rowIndex, this.columnIndex);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private V getValue(int index) {
        void var1_1;
        void var2_2;
        int rowIndex = index / this.columnList.size();
        int columnIndex = index % this.columnList.size();
        return this.at((int)var2_2, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Map<R, V> column(C columnKey) {
        void var1_1;
        Preconditions.checkNotNull(columnKey);
        Integer columnIndex = this.columnKeyToIndex.get(columnKey);
        if (columnIndex == null) {
            return Collections.emptyMap();
        }
        return new Column(var1_1.intValue());
    }

    @Override
    public final ImmutableSet<C> columnKeySet() {
        return this.columnKeyToIndex.keySet();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Map<C, Map<R, V>> columnMap() {
        void var1_1;
        ColumnMap map = this.columnMap;
        if (map == null) {
            this.columnMap = new ColumnMap();
            return this.columnMap;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Map<C, V> row(R rowKey) {
        void var1_1;
        Preconditions.checkNotNull(rowKey);
        Integer rowIndex = this.rowKeyToIndex.get(rowKey);
        if (rowIndex == null) {
            return Collections.emptyMap();
        }
        return new Row(var1_1.intValue());
    }

    @Override
    public final ImmutableSet<R> rowKeySet() {
        return this.rowKeyToIndex.keySet();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Map<R, Map<C, V>> rowMap() {
        void var1_1;
        RowMap map = this.rowMap;
        if (map == null) {
            this.rowMap = new RowMap();
            return this.rowMap;
        }
        return var1_1;
    }

    @Override
    public final Collection<V> values() {
        return super.values();
    }

    @Override
    final Iterator<V> valuesIterator() {
        ArrayTable arrayTable = this;
        return new AbstractIndexedListIterator<V>(arrayTable, arrayTable.size()){
            final /* synthetic */ ArrayTable this$0;
            {
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                super((int)var2_2);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            protected V get(int index) {
                void var1_1;
                return ArrayTable.access$800(this.this$0, (int)var1_1);
            }
        };
    }

    @Override
    final Spliterator<V> valuesSpliterator() {
        return CollectSpliterators.indexed(this.size(), 16, this::getValue);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Table.Cell access$000(ArrayTable x0, int x1) {
        void var1_1;
        return x0.getCell((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Object access$800(ArrayTable x0, int x1) {
        void var1_1;
        return x0.getValue((int)var1_1);
    }

    private class RowMap
    extends ArrayMap<R, Map<C, V>> {
        private RowMap() {
            super(ArrayTable.this.rowKeyToIndex);
        }

        @Override
        String getKeyRole() {
            return "Row";
        }

        /*
         * WARNING - void declaration
         */
        @Override
        Map<C, V> getValue(int index) {
            void var1_1;
            return new Row((int)var1_1);
        }

        @Override
        Map<C, V> setValue(int index, Map<C, V> newValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<C, V> put(R key, Map<C, V> value) {
            throw new UnsupportedOperationException();
        }
    }

    private class Row
    extends ArrayMap<C, V> {
        final int rowIndex;

        /*
         * WARNING - void declaration
         */
        Row(int rowIndex) {
            void var2_2;
            super(ArrayTable.this.columnKeyToIndex);
            this.rowIndex = var2_2;
        }

        @Override
        String getKeyRole() {
            return "Column";
        }

        /*
         * WARNING - void declaration
         */
        @Override
        V getValue(int index) {
            void var1_1;
            return ArrayTable.this.at(this.rowIndex, (int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        V setValue(int index, V newValue) {
            void var2_2;
            void var1_1;
            return ArrayTable.this.set(this.rowIndex, (int)var1_1, var2_2);
        }
    }

    private class ColumnMap
    extends ArrayMap<C, Map<R, V>> {
        private ColumnMap() {
            super(ArrayTable.this.columnKeyToIndex);
        }

        @Override
        String getKeyRole() {
            return "Column";
        }

        /*
         * WARNING - void declaration
         */
        @Override
        Map<R, V> getValue(int index) {
            void var1_1;
            return new Column((int)var1_1);
        }

        @Override
        Map<R, V> setValue(int index, Map<R, V> newValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<R, V> put(C key, Map<R, V> value) {
            throw new UnsupportedOperationException();
        }
    }

    private class Column
    extends ArrayMap<R, V> {
        final int columnIndex;

        /*
         * WARNING - void declaration
         */
        Column(int columnIndex) {
            void var2_2;
            super(ArrayTable.this.rowKeyToIndex);
            this.columnIndex = var2_2;
        }

        @Override
        String getKeyRole() {
            return "Row";
        }

        /*
         * WARNING - void declaration
         */
        @Override
        V getValue(int index) {
            void var1_1;
            return ArrayTable.this.at((int)var1_1, this.columnIndex);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        V setValue(int index, V newValue) {
            void var2_2;
            void var1_1;
            return ArrayTable.this.set((int)var1_1, this.columnIndex, var2_2);
        }
    }

    private static abstract class ArrayMap<K, V>
    extends Maps.IteratorBasedAbstractMap<K, V> {
        private final ImmutableMap<K, Integer> keyIndex;

        /*
         * WARNING - void declaration
         */
        private ArrayMap(ImmutableMap<K, Integer> keyIndex) {
            void var1_1;
            this.keyIndex = var1_1;
        }

        @Override
        public Set<K> keySet() {
            return this.keyIndex.keySet();
        }

        /*
         * WARNING - void declaration
         */
        K getKey(int index) {
            void var1_1;
            return (K)((ImmutableCollection)((Object)this.keyIndex.keySet())).asList().get((int)var1_1);
        }

        abstract String getKeyRole();

        @ParametricNullness
        abstract V getValue(int var1);

        @ParametricNullness
        abstract V setValue(int var1, @ParametricNullness V var2);

        @Override
        public int size() {
            return this.keyIndex.size();
        }

        @Override
        public boolean isEmpty() {
            return this.keyIndex.isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        Map.Entry<K, V> getEntry(int index) {
            void var1_1;
            Preconditions.checkElementIndex(index, this.size());
            return new AbstractMapEntry<K, V>(this, (int)var1_1){
                final /* synthetic */ int val$index;
                final /* synthetic */ ArrayMap this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$index = n;
                }

                @Override
                public K getKey() {
                    return this.this$0.getKey(this.val$index);
                }

                @Override
                @ParametricNullness
                public V getValue() {
                    return this.this$0.getValue(this.val$index);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                @ParametricNullness
                public V setValue(@ParametricNullness V value) {
                    void var1_1;
                    return this.this$0.setValue(this.val$index, var1_1);
                }
            };
        }

        @Override
        Iterator<Map.Entry<K, V>> entryIterator() {
            ArrayMap arrayMap = this;
            return new AbstractIndexedListIterator<Map.Entry<K, V>>(arrayMap, arrayMap.size()){
                final /* synthetic */ ArrayMap this$0;
                {
                    void var2_2;
                    void var1_1;
                    this.this$0 = var1_1;
                    super((int)var2_2);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                protected Map.Entry<K, V> get(int index) {
                    void var1_1;
                    return this.this$0.getEntry((int)var1_1);
                }
            };
        }

        @Override
        Spliterator<Map.Entry<K, V>> entrySpliterator() {
            return CollectSpliterators.indexed(this.size(), 16, this::getEntry);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean containsKey(Object key) {
            void var1_1;
            return this.keyIndex.containsKey(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V get(Object key) {
            void var1_1;
            Integer index = this.keyIndex.get(key);
            if (index == null) {
                return null;
            }
            return this.getValue(var1_1.intValue());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V put(K key, @ParametricNullness V value) {
            void var2_2;
            void var3_3;
            Object index = this.keyIndex.get(key);
            if (index == null) {
                String string;
                value = this.getKeyRole();
                string = String.valueOf(string);
                index = String.valueOf(this.keyIndex.keySet());
                throw new IllegalArgumentException(new StringBuilder(9 + String.valueOf(value).length() + String.valueOf(string).length() + String.valueOf(index).length()).append((String)value).append(" ").append(string).append(" not in ").append((String)index).toString());
            }
            return this.setValue(var3_3.intValue(), var2_2);
        }

        @Override
        public V remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }
}

