/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimapGwtSerializationDependencies;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Platform;
import com.google.common.collect.Serialization;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
public final class ArrayListMultimap<K, V>
extends ArrayListMultimapGwtSerializationDependencies<K, V> {
    private static final int DEFAULT_VALUES_PER_KEY = 3;
    @VisibleForTesting
    transient int expectedValuesPerKey;
    @GwtIncompatible
    private static final long serialVersionUID = 0L;

    public static <K, V> ArrayListMultimap<K, V> create() {
        return new ArrayListMultimap<K, V>();
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> ArrayListMultimap<K, V> create(int expectedKeys, int expectedValuesPerKey) {
        void var1_1;
        int n;
        return new ArrayListMultimap<K, V>(n, (int)var1_1);
    }

    public static <K, V> ArrayListMultimap<K, V> create(Multimap<? extends K, ? extends V> multimap) {
        Multimap<? extends K, ? extends V> multimap2;
        return new ArrayListMultimap<K, V>(multimap2);
    }

    private ArrayListMultimap() {
        this(12, 3);
    }

    /*
     * WARNING - void declaration
     */
    private ArrayListMultimap(int expectedKeys, int expectedValuesPerKey) {
        super(Platform.newHashMapWithExpectedSize((int)var1_1));
        void var2_2;
        void var1_1;
        CollectPreconditions.checkNonnegative(expectedValuesPerKey, "expectedValuesPerKey");
        this.expectedValuesPerKey = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private ArrayListMultimap(Multimap<? extends K, ? extends V> multimap) {
        this(multimap.keySet().size(), multimap instanceof ArrayListMultimap ? ((ArrayListMultimap)multimap).expectedValuesPerKey : 3);
        void var1_1;
        this.putAll((Multimap)var1_1);
    }

    @Override
    final List<V> createCollection() {
        return new ArrayList(this.expectedValuesPerKey);
    }

    @Deprecated
    public final void trimToSize() {
        for (Collection collection : this.backingMap().values()) {
            ArrayList arrayList = (ArrayList)collection;
            arrayList.trimToSize();
        }
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    private void writeObject(ObjectOutputStream stream) throws IOException {
        void var1_1;
        stream.defaultWriteObject();
        Serialization.writeMultimap(this, (ObjectOutputStream)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        void var2_2;
        void var1_1;
        void var3_3;
        stream.defaultReadObject();
        this.expectedValuesPerKey = 3;
        int distinctKeys = Serialization.readCount(stream);
        HashMap map = Maps.newHashMap();
        this.setMap(var3_3);
        Serialization.populateMultimap(this, (ObjectInputStream)var1_1, (int)var2_2);
    }
}

