/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.CollectSpliterators;
import com.google.common.collect.Collections2;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.ParametricNullness;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.google.common.collect.TransformedIterator;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;

@ElementTypesAreNonnullByDefault
@GwtCompatible
abstract class AbstractTable<R, C, V>
implements Table<R, C, V> {
    private transient Set<Table.Cell<R, C, V>> cellSet;
    private transient Collection<V> values;

    AbstractTable() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsRow(Object rowKey) {
        void var1_1;
        return Maps.safeContainsKey(this.rowMap(), var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsColumn(Object columnKey) {
        void var1_1;
        return Maps.safeContainsKey(this.columnMap(), var1_1);
    }

    @Override
    public Set<R> rowKeySet() {
        return this.rowMap().keySet();
    }

    @Override
    public Set<C> columnKeySet() {
        return this.columnMap().keySet();
    }

    @Override
    public boolean containsValue(Object value) {
        for (Map map : this.rowMap().values()) {
            if (!map.containsValue(value)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean contains(Object rowKey, Object columnKey) {
        void var2_2;
        void var1_1;
        Map row = Maps.safeGet(this.rowMap(), rowKey);
        return row != null && Maps.safeContainsKey(var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V get(Object rowKey, Object columnKey) {
        void var2_2;
        void var1_1;
        Map row = Maps.safeGet(this.rowMap(), rowKey);
        if (row == null) {
            return null;
        }
        return Maps.safeGet(var1_1, var2_2);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void clear() {
        Iterators.clear(this.cellSet().iterator());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V remove(Object rowKey, Object columnKey) {
        void var2_2;
        void var1_1;
        Map row = Maps.safeGet(this.rowMap(), rowKey);
        if (row == null) {
            return null;
        }
        return Maps.safeRemove(var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V put(@ParametricNullness R rowKey, @ParametricNullness C columnKey, @ParametricNullness V value) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.row(var1_1).put(var2_2, var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void putAll(Table<? extends R, ? extends C, ? extends V> table) {
        for (Table.Cell<R, C, V> cell : table.cellSet()) {
            void var2_2;
            this.put(cell.getRowKey(), cell.getColumnKey(), var2_2.getValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Set<Table.Cell<R, C, V>> cellSet() {
        void var1_1;
        Set<Table.Cell<R, C, V>> result = this.cellSet;
        if (result == null) {
            this.cellSet = this.createCellSet();
            return this.cellSet;
        }
        return var1_1;
    }

    Set<Table.Cell<R, C, V>> createCellSet() {
        return new CellSet(this);
    }

    abstract Iterator<Table.Cell<R, C, V>> cellIterator();

    abstract Spliterator<Table.Cell<R, C, V>> cellSpliterator();

    /*
     * WARNING - void declaration
     */
    @Override
    public Collection<V> values() {
        void var1_1;
        Collection<V> result = this.values;
        if (result == null) {
            this.values = this.createValues();
            return this.values;
        }
        return var1_1;
    }

    Collection<V> createValues() {
        return new Values(this);
    }

    Iterator<V> valuesIterator() {
        AbstractTable abstractTable = this;
        return new TransformedIterator<Table.Cell<R, C, V>, V>(abstractTable, abstractTable.cellSet().iterator()){
            {
                void var2_2;
            }

            @Override
            @ParametricNullness
            V transform(Table.Cell<R, C, V> cell) {
                return cell.getValue();
            }
        };
    }

    Spliterator<V> valuesSpliterator() {
        return CollectSpliterators.map(this.cellSpliterator(), Table.Cell::getValue);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object obj) {
        void var1_1;
        return Tables.equalsImpl(this, var1_1);
    }

    @Override
    public int hashCode() {
        return this.cellSet().hashCode();
    }

    public String toString() {
        return this.rowMap().toString();
    }

    class Values
    extends AbstractCollection<V> {
        final /* synthetic */ AbstractTable this$0;

        /*
         * WARNING - void declaration
         */
        Values(AbstractTable this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        public Iterator<V> iterator() {
            return this.this$0.valuesIterator();
        }

        @Override
        public Spliterator<V> spliterator() {
            return this.this$0.valuesSpliterator();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean contains(Object o) {
            void var1_1;
            return this.this$0.containsValue(var1_1);
        }

        @Override
        public void clear() {
            this.this$0.clear();
        }

        @Override
        public int size() {
            return this.this$0.size();
        }
    }

    class CellSet
    extends AbstractSet<Table.Cell<R, C, V>> {
        final /* synthetic */ AbstractTable this$0;

        /*
         * WARNING - void declaration
         */
        CellSet(AbstractTable this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean contains(Object o) {
            if (o instanceof Table.Cell) {
                void var1_1;
                void var2_2;
                Table.Cell cell = (Table.Cell)o;
                Map row = Maps.safeGet(this.this$0.rowMap(), cell.getRowKey());
                return row != null && Collections2.safeContains(var2_2.entrySet(), Maps.immutableEntry(cell.getColumnKey(), var1_1.getValue()));
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean remove(Object o) {
            if (o instanceof Table.Cell) {
                void var1_1;
                void var2_2;
                Table.Cell cell = (Table.Cell)o;
                Map row = Maps.safeGet(this.this$0.rowMap(), cell.getRowKey());
                return row != null && Collections2.safeRemove(var2_2.entrySet(), Maps.immutableEntry(cell.getColumnKey(), var1_1.getValue()));
            }
            return false;
        }

        @Override
        public void clear() {
            this.this$0.clear();
        }

        @Override
        public Iterator<Table.Cell<R, C, V>> iterator() {
            return this.this$0.cellIterator();
        }

        @Override
        public Spliterator<Table.Cell<R, C, V>> spliterator() {
            return this.this$0.cellSpliterator();
        }

        @Override
        public int size() {
            return this.this$0.size();
        }
    }
}

