/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.AbstractMapBasedMultimap;
import com.google.common.collect.AbstractSetMultimap;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ParametricNullness;
import com.google.common.collect.Sets;
import com.google.common.collect.SortedSetMultimap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.NavigableSet;
import java.util.SortedSet;

@ElementTypesAreNonnullByDefault
@GwtCompatible
abstract class AbstractSortedSetMultimap<K, V>
extends AbstractSetMultimap<K, V>
implements SortedSetMultimap<K, V> {
    private static final long serialVersionUID = 430848587173315748L;

    /*
     * WARNING - void declaration
     */
    protected AbstractSortedSetMultimap(Map<K, Collection<V>> map) {
        super(var1_1);
        void var1_1;
    }

    @Override
    abstract SortedSet<V> createCollection();

    @Override
    SortedSet<V> createUnmodifiableEmptyCollection() {
        AbstractSortedSetMultimap abstractSortedSetMultimap = this;
        return abstractSortedSetMultimap.unmodifiableCollectionSubclass((Collection)abstractSortedSetMultimap.createCollection());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    <E> SortedSet<E> unmodifiableCollectionSubclass(Collection<E> collection) {
        void var1_1;
        if (collection instanceof NavigableSet) {
            return Sets.unmodifiableNavigableSet((NavigableSet)collection);
        }
        return Collections.unmodifiableSortedSet((SortedSet)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Collection<V> wrapCollection(@ParametricNullness K key, Collection<V> collection) {
        void var2_2;
        void var1_1;
        if (collection instanceof NavigableSet) {
            return (AbstractMapBasedMultimap)this.new AbstractMapBasedMultimap.WrappedNavigableSet(key, (NavigableSet)collection, null);
        }
        return (AbstractMapBasedMultimap)this.new AbstractMapBasedMultimap.WrappedSortedSet(var1_1, (SortedSet)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SortedSet<V> get(@ParametricNullness K key) {
        void var1_1;
        return (SortedSet)super.get((Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SortedSet<V> removeAll(Object key) {
        void var1_1;
        return (SortedSet)super.removeAll(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SortedSet<V> replaceValues(@ParametricNullness K key, Iterable<? extends V> values) {
        void var2_2;
        void var1_1;
        return (SortedSet)super.replaceValues((Object)var1_1, (Iterable)var2_2);
    }

    @Override
    public Map<K, Collection<V>> asMap() {
        return super.asMap();
    }

    @Override
    public Collection<V> values() {
        return super.values();
    }
}

