/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractMultiset;
import com.google.common.collect.BoundType;
import com.google.common.collect.DescendingMultiset;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.GwtTransient;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.Ordering;
import com.google.common.collect.ParametricNullness;
import com.google.common.collect.SortedMultiset;
import com.google.common.collect.SortedMultisets;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
abstract class AbstractSortedMultiset<E>
extends AbstractMultiset<E>
implements SortedMultiset<E> {
    @GwtTransient
    final Comparator<? super E> comparator;
    private transient SortedMultiset<E> descendingMultiset;

    AbstractSortedMultiset() {
        this(Ordering.natural());
    }

    /*
     * WARNING - void declaration
     */
    AbstractSortedMultiset(Comparator<? super E> comparator) {
        void var1_1;
        this.comparator = (Comparator)Preconditions.checkNotNull(var1_1);
    }

    @Override
    public NavigableSet<E> elementSet() {
        return (NavigableSet)super.elementSet();
    }

    @Override
    NavigableSet<E> createElementSet() {
        return new SortedMultisets.NavigableElementSet(this);
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.comparator;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Multiset.Entry<E> firstEntry() {
        Iterator entryIterator = this.entryIterator();
        if (entryIterator.hasNext()) {
            void var1_1;
            return (Multiset.Entry)var1_1.next();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Multiset.Entry<E> lastEntry() {
        Iterator<Multiset.Entry<E>> entryIterator = this.descendingEntryIterator();
        if (entryIterator.hasNext()) {
            void var1_1;
            return (Multiset.Entry)var1_1.next();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Multiset.Entry<E> pollFirstEntry() {
        Iterator entryIterator = this.entryIterator();
        if (entryIterator.hasNext()) {
            void var2_2;
            void var1_1;
            Multiset.Entry result = entryIterator.next();
            result = Multisets.immutableEntry(result.getElement(), result.getCount());
            var1_1.remove();
            return var2_2;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Multiset.Entry<E> pollLastEntry() {
        Iterator<Multiset.Entry<E>> entryIterator = this.descendingEntryIterator();
        if (entryIterator.hasNext()) {
            void var2_2;
            void var1_1;
            Multiset.Entry<E> result = entryIterator.next();
            result = Multisets.immutableEntry(result.getElement(), result.getCount());
            var1_1.remove();
            return var2_2;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SortedMultiset<E> subMultiset(@ParametricNullness E fromElement, BoundType fromBoundType, @ParametricNullness E toElement, BoundType toBoundType) {
        void var3_3;
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull(fromBoundType);
        Preconditions.checkNotNull(toBoundType);
        return this.tailMultiset(var1_1, (BoundType)var2_2).headMultiset(var3_3, toBoundType);
    }

    abstract Iterator<Multiset.Entry<E>> descendingEntryIterator();

    Iterator<E> descendingIterator() {
        return Multisets.iteratorImpl(this.descendingMultiset());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SortedMultiset<E> descendingMultiset() {
        void var1_1;
        SortedMultiset<E> result = this.descendingMultiset;
        if (result == null) {
            this.descendingMultiset = this.createDescendingMultiset();
            return this.descendingMultiset;
        }
        return var1_1;
    }

    SortedMultiset<E> createDescendingMultiset() {
        class DescendingMultisetImpl
        extends DescendingMultiset<E> {
            final /* synthetic */ AbstractSortedMultiset this$0;

            /*
             * WARNING - void declaration
             */
            DescendingMultisetImpl(AbstractSortedMultiset this$0) {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            SortedMultiset<E> forwardMultiset() {
                return this.this$0;
            }

            @Override
            Iterator<Multiset.Entry<E>> entryIterator() {
                return this.this$0.descendingEntryIterator();
            }

            @Override
            public Iterator<E> iterator() {
                return this.this$0.descendingIterator();
            }
        }
        return new DescendingMultisetImpl(this);
    }
}

