/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.ParametricNullness;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
abstract class AbstractNavigableMap<K, V>
extends Maps.IteratorBasedAbstractMap<K, V>
implements NavigableMap<K, V> {
    AbstractNavigableMap() {
    }

    @Override
    public abstract V get(Object var1);

    @Override
    public Map.Entry<K, V> firstEntry() {
        return Iterators.getNext(this.entryIterator(), null);
    }

    @Override
    public Map.Entry<K, V> lastEntry() {
        return Iterators.getNext(this.descendingEntryIterator(), null);
    }

    @Override
    public Map.Entry<K, V> pollFirstEntry() {
        return Iterators.pollNext(this.entryIterator());
    }

    @Override
    public Map.Entry<K, V> pollLastEntry() {
        return Iterators.pollNext(this.descendingEntryIterator());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ParametricNullness
    public K firstKey() {
        void var1_1;
        Map.Entry<K, V> entry = this.firstEntry();
        if (entry == null) {
            throw new NoSuchElementException();
        }
        return var1_1.getKey();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ParametricNullness
    public K lastKey() {
        void var1_1;
        Map.Entry<K, V> entry = this.lastEntry();
        if (entry == null) {
            throw new NoSuchElementException();
        }
        return var1_1.getKey();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Map.Entry<K, V> lowerEntry(@ParametricNullness K key) {
        void var1_1;
        return this.headMap(var1_1, false).lastEntry();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Map.Entry<K, V> floorEntry(@ParametricNullness K key) {
        void var1_1;
        return this.headMap(var1_1, true).lastEntry();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Map.Entry<K, V> ceilingEntry(@ParametricNullness K key) {
        void var1_1;
        return this.tailMap(var1_1, true).firstEntry();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Map.Entry<K, V> higherEntry(@ParametricNullness K key) {
        void var1_1;
        return this.tailMap(var1_1, false).firstEntry();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public K lowerKey(@ParametricNullness K key) {
        void var1_1;
        return Maps.keyOrNull(this.lowerEntry(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public K floorKey(@ParametricNullness K key) {
        void var1_1;
        return Maps.keyOrNull(this.floorEntry(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public K ceilingKey(@ParametricNullness K key) {
        void var1_1;
        return Maps.keyOrNull(this.ceilingEntry(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public K higherKey(@ParametricNullness K key) {
        void var1_1;
        return Maps.keyOrNull(this.higherEntry(var1_1));
    }

    abstract Iterator<Map.Entry<K, V>> descendingEntryIterator();

    /*
     * WARNING - void declaration
     */
    @Override
    public SortedMap<K, V> subMap(@ParametricNullness K fromKey, @ParametricNullness K toKey) {
        void var2_2;
        void var1_1;
        return this.subMap(var1_1, true, var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SortedMap<K, V> headMap(@ParametricNullness K toKey) {
        void var1_1;
        return this.headMap(var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SortedMap<K, V> tailMap(@ParametricNullness K fromKey) {
        void var1_1;
        return this.tailMap(var1_1, true);
    }

    @Override
    public NavigableSet<K> navigableKeySet() {
        return new Maps.NavigableKeySet(this);
    }

    @Override
    public Set<K> keySet() {
        return this.navigableKeySet();
    }

    @Override
    public NavigableSet<K> descendingKeySet() {
        return this.descendingMap().navigableKeySet();
    }

    @Override
    public NavigableMap<K, V> descendingMap() {
        return new DescendingMap();
    }

    private final class DescendingMap
    extends Maps.DescendingMap<K, V> {
        private DescendingMap() {
        }

        @Override
        final NavigableMap<K, V> forward() {
            return AbstractNavigableMap.this;
        }

        @Override
        final Iterator<Map.Entry<K, V>> entryIterator() {
            return AbstractNavigableMap.this.descendingEntryIterator();
        }
    }
}

