/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.ParametricNullness;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

@ElementTypesAreNonnullByDefault
@GwtCompatible
abstract class AbstractMultiset<E>
extends AbstractCollection<E>
implements Multiset<E> {
    private transient Set<E> elementSet;
    private transient Set<Multiset.Entry<E>> entrySet;

    AbstractMultiset() {
    }

    @Override
    public boolean isEmpty() {
        return this.entrySet().isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean contains(Object element) {
        void var1_1;
        return this.count(var1_1) > 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean add(@ParametricNullness E element) {
        void var1_1;
        this.add(var1_1, 1);
        return true;
    }

    @Override
    public int add(@ParametricNullness E element, int occurrences) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean remove(Object element) {
        void var1_1;
        return this.remove(var1_1, 1) > 0;
    }

    @Override
    public int remove(Object element, int occurrences) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int setCount(@ParametricNullness E element, int count) {
        void var2_2;
        void var1_1;
        return Multisets.setCountImpl(this, var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean setCount(@ParametricNullness E element, int oldCount, int newCount) {
        void var3_3;
        void var2_2;
        void var1_1;
        return Multisets.setCountImpl(this, var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean addAll(Collection<? extends E> elementsToAdd) {
        void var1_1;
        return Multisets.addAllImpl(this, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean removeAll(Collection<?> elementsToRemove) {
        void var1_1;
        return Multisets.removeAllImpl(this, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean retainAll(Collection<?> elementsToRetain) {
        void var1_1;
        return Multisets.retainAllImpl(this, var1_1);
    }

    @Override
    public abstract void clear();

    /*
     * WARNING - void declaration
     */
    @Override
    public Set<E> elementSet() {
        void var1_1;
        Set<E> result = this.elementSet;
        if (result == null) {
            this.elementSet = result = this.createElementSet();
        }
        return var1_1;
    }

    Set<E> createElementSet() {
        return new ElementSet(this);
    }

    abstract Iterator<E> elementIterator();

    /*
     * WARNING - void declaration
     */
    @Override
    public Set<Multiset.Entry<E>> entrySet() {
        void var1_1;
        Set<Multiset.Entry<Multiset.Entry<E>>> result = this.entrySet;
        if (result == null) {
            this.entrySet = result = this.createEntrySet();
        }
        return var1_1;
    }

    Set<Multiset.Entry<E>> createEntrySet() {
        return new EntrySet(this);
    }

    abstract Iterator<Multiset.Entry<E>> entryIterator();

    abstract int distinctElements();

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean equals(Object object) {
        void var1_1;
        return Multisets.equalsImpl(this, var1_1);
    }

    @Override
    public final int hashCode() {
        return this.entrySet().hashCode();
    }

    @Override
    public final String toString() {
        return this.entrySet().toString();
    }

    class EntrySet
    extends Multisets.EntrySet<E> {
        final /* synthetic */ AbstractMultiset this$0;

        /*
         * WARNING - void declaration
         */
        EntrySet(AbstractMultiset this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        Multiset<E> multiset() {
            return this.this$0;
        }

        @Override
        public Iterator<Multiset.Entry<E>> iterator() {
            return this.this$0.entryIterator();
        }

        @Override
        public int size() {
            return this.this$0.distinctElements();
        }
    }

    class ElementSet
    extends Multisets.ElementSet<E> {
        final /* synthetic */ AbstractMultiset this$0;

        /*
         * WARNING - void declaration
         */
        ElementSet(AbstractMultiset this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        Multiset<E> multiset() {
            return this.this$0;
        }

        @Override
        public Iterator<E> iterator() {
            return this.this$0.elementIterator();
        }
    }
}

