/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Multiset;
import com.google.common.collect.ParametricNullness;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;

@ElementTypesAreNonnullByDefault
@GwtCompatible
abstract class AbstractMultimap<K, V>
implements Multimap<K, V> {
    private transient Collection<Map.Entry<K, V>> entries;
    private transient Set<K> keySet;
    private transient Multiset<K> keys;
    private transient Collection<V> values;
    private transient Map<K, Collection<V>> asMap;

    AbstractMultimap() {
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsValue(Object value) {
        for (Collection<V> collection : this.asMap().values()) {
            if (!collection.contains(value)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsEntry(Object key, Object value) {
        void var2_2;
        void var1_1;
        Collection<V> collection = this.asMap().get(key);
        return collection != null && var1_1.contains(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean remove(Object key, Object value) {
        void var2_2;
        void var1_1;
        Collection<V> collection = this.asMap().get(key);
        return collection != null && var1_1.remove(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean put(@ParametricNullness K key, @ParametricNullness V value) {
        void var2_2;
        void var1_1;
        return this.get(var1_1).add(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean putAll(@ParametricNullness K key, Iterable<? extends V> values) {
        void var2_2;
        void var1_1;
        Collection valueCollection;
        Preconditions.checkNotNull(values);
        if (values instanceof Collection) {
            valueCollection = (Collection)values;
            return !valueCollection.isEmpty() && this.get(key).addAll(valueCollection);
        }
        Iterator valueItr = valueCollection.iterator();
        return valueItr.hasNext() && Iterators.addAll(this.get(var1_1), var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean putAll(Multimap<? extends K, ? extends V> multimap) {
        void var2_2;
        Iterator iterator;
        boolean changed = false;
        for (Map.Entry entry : iterator.entries()) {
            void var3_3;
            changed |= this.put(entry.getKey(), var3_3.getValue());
        }
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Collection<V> replaceValues(@ParametricNullness K key, Iterable<? extends V> values) {
        void var3_3;
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull(values);
        Collection result = this.removeAll(key);
        this.putAll(var1_1, (Iterable<? extends V>)var2_2);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Collection<Map.Entry<K, V>> entries() {
        void var1_1;
        Collection<Map.Entry<K, V>> result = this.entries;
        if (result == null) {
            this.entries = this.createEntries();
            return this.entries;
        }
        return var1_1;
    }

    abstract Collection<Map.Entry<K, V>> createEntries();

    abstract Iterator<Map.Entry<K, V>> entryIterator();

    Spliterator<Map.Entry<K, V>> entrySpliterator() {
        return Spliterators.spliterator(this.entryIterator(), (long)this.size(), this instanceof SetMultimap ? 1 : 0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Set<K> keySet() {
        void var1_1;
        Set<K> result = this.keySet;
        if (result == null) {
            this.keySet = this.createKeySet();
            return this.keySet;
        }
        return var1_1;
    }

    abstract Set<K> createKeySet();

    /*
     * WARNING - void declaration
     */
    @Override
    public Multiset<K> keys() {
        void var1_1;
        Multiset<K> result = this.keys;
        if (result == null) {
            this.keys = this.createKeys();
            return this.keys;
        }
        return var1_1;
    }

    abstract Multiset<K> createKeys();

    /*
     * WARNING - void declaration
     */
    @Override
    public Collection<V> values() {
        void var1_1;
        Collection<V> result = this.values;
        if (result == null) {
            this.values = this.createValues();
            return this.values;
        }
        return var1_1;
    }

    abstract Collection<V> createValues();

    Iterator<V> valueIterator() {
        return Maps.valueIterator(this.entries().iterator());
    }

    Spliterator<V> valueSpliterator() {
        return Spliterators.spliterator(this.valueIterator(), (long)this.size(), 0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Map<K, Collection<V>> asMap() {
        void var1_1;
        Map<K, Collection<V>> result = this.asMap;
        if (result == null) {
            this.asMap = this.createAsMap();
            return this.asMap;
        }
        return var1_1;
    }

    abstract Map<K, Collection<V>> createAsMap();

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object object) {
        void var1_1;
        return Multimaps.equalsImpl(this, var1_1);
    }

    @Override
    public int hashCode() {
        return this.asMap().hashCode();
    }

    public String toString() {
        return this.asMap().toString();
    }

    class Values
    extends AbstractCollection<V> {
        final /* synthetic */ AbstractMultimap this$0;

        /*
         * WARNING - void declaration
         */
        Values(AbstractMultimap this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        public Iterator<V> iterator() {
            return this.this$0.valueIterator();
        }

        @Override
        public Spliterator<V> spliterator() {
            return this.this$0.valueSpliterator();
        }

        @Override
        public int size() {
            return this.this$0.size();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean contains(Object o) {
            void var1_1;
            return this.this$0.containsValue(var1_1);
        }

        @Override
        public void clear() {
            this.this$0.clear();
        }
    }

    class EntrySet
    extends Entries
    implements Set<Map.Entry<K, V>> {
        /*
         * WARNING - void declaration
         */
        EntrySet(AbstractMultimap this$0) {
            super((AbstractMultimap)var1_1);
            void var1_1;
        }

        @Override
        public int hashCode() {
            return Sets.hashCodeImpl(this);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(Object obj) {
            void var1_1;
            return Sets.equalsImpl(this, var1_1);
        }
    }

    class Entries
    extends Multimaps.Entries<K, V> {
        final /* synthetic */ AbstractMultimap this$0;

        /*
         * WARNING - void declaration
         */
        Entries(AbstractMultimap this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        Multimap<K, V> multimap() {
            return this.this$0;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return this.this$0.entryIterator();
        }

        @Override
        public Spliterator<Map.Entry<K, V>> spliterator() {
            return this.this$0.entrySpliterator();
        }
    }
}

