/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractMultiset;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.Count;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.ParametricNullness;
import com.google.common.primitives.Ints;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.ObjIntConsumer;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
abstract class AbstractMapBasedMultiset<E>
extends AbstractMultiset<E>
implements Serializable {
    private transient Map<E, Count> backingMap;
    private transient long size;
    @GwtIncompatible
    private static final long serialVersionUID = -2250766705698539974L;

    /*
     * WARNING - void declaration
     */
    protected AbstractMapBasedMultiset(Map<E, Count> backingMap) {
        void var1_1;
        Preconditions.checkArgument(backingMap.isEmpty());
        this.backingMap = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    void setBackingMap(Map<E, Count> backingMap) {
        void var1_1;
        this.backingMap = var1_1;
    }

    @Override
    public Set<Multiset.Entry<E>> entrySet() {
        return super.entrySet();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Iterator<E> elementIterator() {
        void var1_1;
        Iterator<Map.Entry<E, Count>> backingEntries = this.backingMap.entrySet().iterator();
        return new Iterator<E>(this, (Iterator)var1_1){
            Map.Entry<E, Count> toRemove;
            final /* synthetic */ Iterator val$backingEntries;
            final /* synthetic */ AbstractMapBasedMultiset this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$backingEntries = iterator;
            }

            @Override
            public boolean hasNext() {
                return this.val$backingEntries.hasNext();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            @ParametricNullness
            public E next() {
                void var1_1;
                Map.Entry mapEntry;
                this.toRemove = mapEntry = (Map.Entry)this.val$backingEntries.next();
                return var1_1.getKey();
            }

            @Override
            public void remove() {
                Preconditions.checkState(this.toRemove != null, "no calls to next() since the last call to remove()");
                AbstractMapBasedMultiset.access$022(this.this$0, this.toRemove.getValue().getAndSet(0));
                this.val$backingEntries.remove();
                this.toRemove = null;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Iterator<Multiset.Entry<E>> entryIterator() {
        void var1_1;
        Iterator<Map.Entry<E, Count>> backingEntries = this.backingMap.entrySet().iterator();
        return new Iterator<Multiset.Entry<E>>(this, (Iterator)var1_1){
            Map.Entry<E, Count> toRemove;
            final /* synthetic */ Iterator val$backingEntries;
            final /* synthetic */ AbstractMapBasedMultiset this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$backingEntries = iterator;
            }

            @Override
            public boolean hasNext() {
                return this.val$backingEntries.hasNext();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Multiset.Entry<E> next() {
                void var1_1;
                Map.Entry mapEntry;
                this.toRemove = mapEntry = (Map.Entry)this.val$backingEntries.next();
                return new Multisets.AbstractEntry<E>(this, (Map.Entry)var1_1){
                    final /* synthetic */ Map.Entry val$mapEntry;
                    final /* synthetic */ 2 this$1;
                    {
                        void var1_1;
                        this.this$1 = var1_1;
                        this.val$mapEntry = entry;
                    }

                    @Override
                    @ParametricNullness
                    public E getElement() {
                        return this.val$mapEntry.getKey();
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public int getCount() {
                        void var1_1;
                        Count frequency;
                        Count count = (Count)this.val$mapEntry.getValue();
                        if ((count == null || count.get() == 0) && (frequency = (Count)this.this$1.this$0.backingMap.get(this.getElement())) != null) {
                            void var2_2;
                            return var2_2.get();
                        }
                        if (count == null) {
                            return 0;
                        }
                        return var1_1.get();
                    }
                };
            }

            @Override
            public void remove() {
                Preconditions.checkState(this.toRemove != null, "no calls to next() since the last call to remove()");
                AbstractMapBasedMultiset.access$022(this.this$0, this.toRemove.getValue().getAndSet(0));
                this.val$backingEntries.remove();
                this.toRemove = null;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void forEachEntry(ObjIntConsumer<? super E> action) {
        void var1_1;
        Preconditions.checkNotNull(action);
        this.backingMap.forEach((arg_0, arg_1) -> AbstractMapBasedMultiset.lambda$forEachEntry$0((ObjIntConsumer)var1_1, arg_0, arg_1));
    }

    @Override
    public void clear() {
        for (Count count : this.backingMap.values()) {
            count.set(0);
        }
        this.backingMap.clear();
        this.size = 0L;
    }

    @Override
    int distinctElements() {
        return this.backingMap.size();
    }

    @Override
    public int size() {
        return Ints.saturatedCast(this.size);
    }

    @Override
    public Iterator<E> iterator() {
        return new MapBasedMultisetIterator();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int count(Object element) {
        void var1_1;
        Count frequency = Maps.safeGet(this.backingMap, element);
        if (frequency == null) {
            return 0;
        }
        return var1_1.get();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int add(@ParametricNullness E element, int occurrences) {
        void var2_2;
        int oldCount;
        if (occurrences == 0) {
            return this.count(element);
        }
        Preconditions.checkArgument(occurrences > 0, "occurrences cannot be negative: %s", occurrences);
        Count frequency = this.backingMap.get(element);
        if (frequency == null) {
            void var1_1;
            oldCount = 0;
            this.backingMap.put(var1_1, new Count(occurrences));
        } else {
            void var3_3;
            oldCount = frequency.get();
            long newCount = (long)oldCount + (long)occurrences;
            Preconditions.checkArgument(newCount <= Integer.MAX_VALUE, "too many occurrences: %s", newCount);
            var3_3.add(occurrences);
        }
        this.size += (long)var2_2;
        return oldCount;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int remove(Object element, int occurrences) {
        void var2_2;
        void var3_3;
        int numberRemoved;
        if (occurrences == 0) {
            return this.count(element);
        }
        Preconditions.checkArgument(occurrences > 0, "occurrences cannot be negative: %s", occurrences);
        Count frequency = this.backingMap.get(element);
        if (frequency == null) {
            return 0;
        }
        int oldCount = frequency.get();
        if (oldCount <= occurrences) {
            void var1_1;
            numberRemoved = oldCount;
            this.backingMap.remove(var1_1);
        }
        var3_3.add(-numberRemoved);
        this.size -= (long)var2_2;
        return oldCount;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int setCount(@ParametricNullness E element, int count) {
        void var2_2;
        int oldCount;
        CollectPreconditions.checkNonnegative(count, "count");
        if (count == 0) {
            Count count2 = this.backingMap.remove(element);
            oldCount = AbstractMapBasedMultiset.getAndSet(count2, count);
        } else {
            void var3_4;
            Count existingCounter = this.backingMap.get(element);
            oldCount = AbstractMapBasedMultiset.getAndSet(existingCounter, count);
            if (var3_4 == null) {
                void var1_1;
                this.backingMap.put(var1_1, new Count(count));
            }
        }
        this.size += (long)(var2_2 - oldCount);
        return oldCount;
    }

    /*
     * WARNING - void declaration
     */
    private static int getAndSet(Count i, int count) {
        void var1_1;
        Count count2;
        if (i == null) {
            return 0;
        }
        return count2.getAndSet((int)var1_1);
    }

    @GwtIncompatible
    private void readObjectNoData() throws ObjectStreamException {
        throw new InvalidObjectException("Stream data required");
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$forEachEntry$0(ObjIntConsumer action, Object element, Count count) {
        void var2_2;
        void var1_1;
        action.accept(var1_1, var2_2.get());
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ long access$022(AbstractMapBasedMultiset x0, long x1) {
        void var1_1;
        return x0.size -= var1_1;
    }

    private class MapBasedMultisetIterator
    implements Iterator<E> {
        final Iterator<Map.Entry<E, Count>> entryIterator;
        Map.Entry<E, Count> currentEntry;
        int occurrencesLeft;
        boolean canRemove;

        MapBasedMultisetIterator() {
            this.entryIterator = AbstractMapBasedMultiset.this.backingMap.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.occurrencesLeft > 0 || this.entryIterator.hasNext();
        }

        @Override
        @ParametricNullness
        public E next() {
            if (this.occurrencesLeft == 0) {
                this.currentEntry = this.entryIterator.next();
                this.occurrencesLeft = this.currentEntry.getValue().get();
            }
            --this.occurrencesLeft;
            this.canRemove = true;
            return Objects.requireNonNull(this.currentEntry).getKey();
        }

        @Override
        public void remove() {
            CollectPreconditions.checkRemove(this.canRemove);
            int n = Objects.requireNonNull(this.currentEntry).getValue().get();
            if (n <= 0) {
                throw new ConcurrentModificationException();
            }
            if (this.currentEntry.getValue().addAndGet(-1) == 0) {
                this.entryIterator.remove();
            }
            AbstractMapBasedMultiset.this.size--;
            this.canRemove = false;
        }
    }
}

