/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractMultimap;
import com.google.common.collect.CollectSpliterators;
import com.google.common.collect.Collections2;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Multiset;
import com.google.common.collect.NullnessCasts;
import com.google.common.collect.ParametricNullness;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.Spliterator;
import java.util.function.BiConsumer;

@ElementTypesAreNonnullByDefault
@GwtCompatible
abstract class AbstractMapBasedMultimap<K, V>
extends AbstractMultimap<K, V>
implements Serializable {
    private transient Map<K, Collection<V>> map;
    private transient int totalSize;
    private static final long serialVersionUID = 2447537837011683357L;

    /*
     * WARNING - void declaration
     */
    protected AbstractMapBasedMultimap(Map<K, Collection<V>> map) {
        void var1_1;
        Preconditions.checkArgument(map.isEmpty());
        this.map = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    final void setMap(Map<K, Collection<V>> map) {
        Iterator iterator;
        this.map = map;
        this.totalSize = 0;
        for (Collection values : iterator.values()) {
            void var2_2;
            Preconditions.checkArgument(!values.isEmpty());
            this.totalSize += var2_2.size();
        }
    }

    Collection<V> createUnmodifiableEmptyCollection() {
        AbstractMapBasedMultimap abstractMapBasedMultimap = this;
        return abstractMapBasedMultimap.unmodifiableCollectionSubclass(abstractMapBasedMultimap.createCollection());
    }

    abstract Collection<V> createCollection();

    Collection<V> createCollection(@ParametricNullness K key) {
        return this.createCollection();
    }

    Map<K, Collection<V>> backingMap() {
        return this.map;
    }

    @Override
    public int size() {
        return this.totalSize;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsKey(Object key) {
        void var1_1;
        return this.map.containsKey(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean put(@ParametricNullness K key, @ParametricNullness V value) {
        void var2_2;
        void var3_3;
        Collection<V> collection = this.map.get(key);
        if (collection == null) {
            collection = this.createCollection(key);
            if (collection.add(value)) {
                void var1_1;
                ++this.totalSize;
                this.map.put(var1_1, collection);
                return true;
            }
            throw new AssertionError((Object)"New Collection violated the Collection spec");
        }
        if (var3_3.add(var2_2)) {
            ++this.totalSize;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private Collection<V> getOrCreateCollection(@ParametricNullness K key) {
        void var2_2;
        Collection<V> collection = this.map.get(key);
        if (collection == null) {
            void var1_1;
            collection = this.createCollection(key);
            this.map.put(var1_1, collection);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Collection<V> replaceValues(@ParametricNullness K key, Iterable<? extends V> values) {
        void var3_3;
        Iterator<V> iterator = values.iterator();
        if (!iterator.hasNext()) {
            return this.removeAll(key);
        }
        Collection<V> collection = this.getOrCreateCollection(key);
        Collection<V> oldValues = this.createCollection();
        oldValues.addAll(collection);
        this.totalSize -= collection.size();
        collection.clear();
        while (iterator.hasNext()) {
            if (!collection.add(iterator.next())) continue;
            ++this.totalSize;
        }
        return this.unmodifiableCollectionSubclass((Collection)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Collection<V> removeAll(Object key) {
        void var2_2;
        void var1_1;
        Collection<V> collection = this.map.remove(key);
        if (collection == null) {
            return this.createUnmodifiableEmptyCollection();
        }
        Collection<V> output = this.createCollection();
        output.addAll(collection);
        this.totalSize -= collection.size();
        var1_1.clear();
        return this.unmodifiableCollectionSubclass((Collection)var2_2);
    }

    <E> Collection<E> unmodifiableCollectionSubclass(Collection<E> collection) {
        return Collections.unmodifiableCollection(collection);
    }

    @Override
    public void clear() {
        for (Collection<V> collection : this.map.values()) {
            collection.clear();
        }
        this.map.clear();
        this.totalSize = 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Collection<V> get(@ParametricNullness K key) {
        void var2_2;
        void var1_1;
        Collection<V> collection = this.map.get(key);
        if (collection == null) {
            collection = this.createCollection(key);
        }
        return this.wrapCollection(var1_1, (Collection<V>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    Collection<V> wrapCollection(@ParametricNullness K key, Collection<V> collection) {
        void var2_2;
        void var1_1;
        return new WrappedCollection(this, var1_1, var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    final List<V> wrapList(@ParametricNullness K key, List<V> list, WrappedCollection ancestor) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (list instanceof RandomAccess) {
            return new RandomAccessWrappedList(this, key, list, ancestor);
        }
        return new WrappedList(var1_1, var2_2, (WrappedCollection)var3_3);
    }

    private static <E> Iterator<E> iteratorOrListIterator(Collection<E> collection) {
        Collection<E> collection2;
        if (collection instanceof List) {
            return ((List)collection).listIterator();
        }
        return collection2.iterator();
    }

    @Override
    Set<K> createKeySet() {
        AbstractMapBasedMultimap abstractMapBasedMultimap = this;
        return abstractMapBasedMultimap.new KeySet(abstractMapBasedMultimap.map);
    }

    final Set<K> createMaybeNavigableKeySet() {
        if (this.map instanceof NavigableMap) {
            AbstractMapBasedMultimap abstractMapBasedMultimap = this;
            return abstractMapBasedMultimap.new NavigableKeySet((NavigableMap)abstractMapBasedMultimap.map);
        }
        if (this.map instanceof SortedMap) {
            AbstractMapBasedMultimap abstractMapBasedMultimap = this;
            return abstractMapBasedMultimap.new SortedKeySet((SortedMap)abstractMapBasedMultimap.map);
        }
        AbstractMapBasedMultimap abstractMapBasedMultimap = this;
        return abstractMapBasedMultimap.new KeySet(abstractMapBasedMultimap.map);
    }

    /*
     * WARNING - void declaration
     */
    private void removeValuesForKey(Object key) {
        Collection<V> collection = Maps.safeRemove(this.map, key);
        if (collection != null) {
            void var2_2;
            void var1_1;
            int count = collection.size();
            var1_1.clear();
            this.totalSize -= var2_2;
        }
    }

    @Override
    public Collection<V> values() {
        return super.values();
    }

    @Override
    Collection<V> createValues() {
        return new AbstractMultimap.Values(this);
    }

    @Override
    Iterator<V> valueIterator() {
        return new Itr<V>(this){
            {
                void var1_1;
            }

            @Override
            @ParametricNullness
            V output(@ParametricNullness K key, @ParametricNullness V value) {
                return value;
            }
        };
    }

    @Override
    Spliterator<V> valueSpliterator() {
        return CollectSpliterators.flatMap(this.map.values().spliterator(), Collection::spliterator, 64, this.size());
    }

    @Override
    Multiset<K> createKeys() {
        return new Multimaps.Keys(this);
    }

    @Override
    public Collection<Map.Entry<K, V>> entries() {
        return super.entries();
    }

    @Override
    Collection<Map.Entry<K, V>> createEntries() {
        if (this instanceof SetMultimap) {
            return new AbstractMultimap.EntrySet(this);
        }
        return new AbstractMultimap.Entries(this);
    }

    @Override
    Iterator<Map.Entry<K, V>> entryIterator() {
        return new Itr<Map.Entry<K, V>>(this){
            {
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            Map.Entry<K, V> output(@ParametricNullness K key, @ParametricNullness V value) {
                void var2_2;
                return Maps.immutableEntry(key, var2_2);
            }
        };
    }

    @Override
    Spliterator<Map.Entry<K, V>> entrySpliterator() {
        return CollectSpliterators.flatMap(this.map.entrySet().spliterator(), keyToValueCollectionEntry -> {
            void var1_1;
            Collection collection;
            Object key = keyToValueCollectionEntry.getKey();
            collection = (Collection)collection.getValue();
            return CollectSpliterators.map(collection.spliterator(), value -> {
                void var1_1;
                return Maps.immutableEntry(var1_1, var1_1);
            });
        }, 64, this.size());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        void var1_1;
        Preconditions.checkNotNull(action);
        this.map.forEach((arg_0, arg_1) -> AbstractMapBasedMultimap.lambda$forEach$3((BiConsumer)var1_1, arg_0, arg_1));
    }

    @Override
    Map<K, Collection<V>> createAsMap() {
        AbstractMapBasedMultimap abstractMapBasedMultimap = this;
        return abstractMapBasedMultimap.new AsMap(abstractMapBasedMultimap.map);
    }

    final Map<K, Collection<V>> createMaybeNavigableAsMap() {
        if (this.map instanceof NavigableMap) {
            AbstractMapBasedMultimap abstractMapBasedMultimap = this;
            return abstractMapBasedMultimap.new NavigableAsMap((NavigableMap)abstractMapBasedMultimap.map);
        }
        if (this.map instanceof SortedMap) {
            AbstractMapBasedMultimap abstractMapBasedMultimap = this;
            return abstractMapBasedMultimap.new SortedAsMap((SortedMap)abstractMapBasedMultimap.map);
        }
        AbstractMapBasedMultimap abstractMapBasedMultimap = this;
        return abstractMapBasedMultimap.new AsMap(abstractMapBasedMultimap.map);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$forEach$3(BiConsumer action, Object key, Collection valueCollection) {
        void var1_1;
        BiConsumer biConsumer;
        valueCollection.forEach((? super T value) -> {
            void var2_2;
            void var1_1;
            biConsumer.accept(var1_1, var2_2);
        });
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$212(AbstractMapBasedMultimap x0, int x1) {
        void var1_1;
        return x0.totalSize += var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$220(AbstractMapBasedMultimap x0, int x1) {
        void var1_1;
        return x0.totalSize -= var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$300(AbstractMapBasedMultimap x0, Object x1) {
        void var1_1;
        x0.removeValuesForKey(var1_1);
    }

    class NavigableAsMap
    extends SortedAsMap
    implements NavigableMap<K, Collection<V>> {
        /*
         * WARNING - void declaration
         */
        NavigableAsMap(NavigableMap<K, Collection<V>> submap) {
            void var2_2;
            void var1_1;
            super(var2_2);
        }

        NavigableMap<K, Collection<V>> sortedMap() {
            return (NavigableMap)super.sortedMap();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Map.Entry<K, Collection<V>> lowerEntry(@ParametricNullness K key) {
            void var1_1;
            Map.Entry entry = this.sortedMap().lowerEntry(key);
            if (entry == null) {
                return null;
            }
            return this.wrapEntry(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public K lowerKey(@ParametricNullness K key) {
            void var1_1;
            return this.sortedMap().lowerKey(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Map.Entry<K, Collection<V>> floorEntry(@ParametricNullness K key) {
            void var1_1;
            Map.Entry entry = this.sortedMap().floorEntry(key);
            if (entry == null) {
                return null;
            }
            return this.wrapEntry(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public K floorKey(@ParametricNullness K key) {
            void var1_1;
            return this.sortedMap().floorKey(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Map.Entry<K, Collection<V>> ceilingEntry(@ParametricNullness K key) {
            void var1_1;
            Map.Entry entry = this.sortedMap().ceilingEntry(key);
            if (entry == null) {
                return null;
            }
            return this.wrapEntry(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public K ceilingKey(@ParametricNullness K key) {
            void var1_1;
            return this.sortedMap().ceilingKey(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Map.Entry<K, Collection<V>> higherEntry(@ParametricNullness K key) {
            void var1_1;
            Map.Entry entry = this.sortedMap().higherEntry(key);
            if (entry == null) {
                return null;
            }
            return this.wrapEntry(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public K higherKey(@ParametricNullness K key) {
            void var1_1;
            return this.sortedMap().higherKey(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Map.Entry<K, Collection<V>> firstEntry() {
            void var1_1;
            Map.Entry entry = this.sortedMap().firstEntry();
            if (entry == null) {
                return null;
            }
            return this.wrapEntry(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Map.Entry<K, Collection<V>> lastEntry() {
            void var1_1;
            Map.Entry entry = this.sortedMap().lastEntry();
            if (entry == null) {
                return null;
            }
            return this.wrapEntry(var1_1);
        }

        @Override
        public Map.Entry<K, Collection<V>> pollFirstEntry() {
            NavigableAsMap navigableAsMap = this;
            return navigableAsMap.pollAsMapEntry(navigableAsMap.entrySet().iterator());
        }

        @Override
        public Map.Entry<K, Collection<V>> pollLastEntry() {
            NavigableAsMap navigableAsMap = this;
            return navigableAsMap.pollAsMapEntry(navigableAsMap.descendingMap().entrySet().iterator());
        }

        /*
         * WARNING - void declaration
         */
        Map.Entry<K, Collection<V>> pollAsMapEntry(Iterator<Map.Entry<K, Collection<V>>> entryIterator) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (!entryIterator.hasNext()) {
                return null;
            }
            Map.Entry entry = entryIterator.next();
            Collection output = AbstractMapBasedMultimap.this.createCollection();
            output.addAll(entry.getValue());
            var1_1.remove();
            return Maps.immutableEntry(var2_2.getKey(), AbstractMapBasedMultimap.this.unmodifiableCollectionSubclass(var3_3));
        }

        @Override
        public NavigableMap<K, Collection<V>> descendingMap() {
            return new NavigableAsMap(this.sortedMap().descendingMap());
        }

        @Override
        public NavigableSet<K> keySet() {
            return (NavigableSet)super.keySet();
        }

        @Override
        NavigableSet<K> createKeySet() {
            return new NavigableKeySet(this.sortedMap());
        }

        @Override
        public NavigableSet<K> navigableKeySet() {
            return this.keySet();
        }

        @Override
        public NavigableSet<K> descendingKeySet() {
            return this.descendingMap().navigableKeySet();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public NavigableMap<K, Collection<V>> subMap(@ParametricNullness K fromKey, @ParametricNullness K toKey) {
            void var2_2;
            void var1_1;
            return this.subMap(var1_1, true, var2_2, false);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public NavigableMap<K, Collection<V>> subMap(@ParametricNullness K fromKey, boolean fromInclusive, @ParametricNullness K toKey, boolean toInclusive) {
            void var3_3;
            void var2_2;
            void var1_1;
            return new NavigableAsMap(this.sortedMap().subMap(var1_1, (boolean)var2_2, var3_3, toInclusive));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public NavigableMap<K, Collection<V>> headMap(@ParametricNullness K toKey) {
            void var1_1;
            return this.headMap(var1_1, false);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public NavigableMap<K, Collection<V>> headMap(@ParametricNullness K toKey, boolean inclusive) {
            void var2_2;
            void var1_1;
            return new NavigableAsMap(this.sortedMap().headMap(var1_1, (boolean)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public NavigableMap<K, Collection<V>> tailMap(@ParametricNullness K fromKey) {
            void var1_1;
            return this.tailMap(var1_1, true);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public NavigableMap<K, Collection<V>> tailMap(@ParametricNullness K fromKey, boolean inclusive) {
            void var2_2;
            void var1_1;
            return new NavigableAsMap(this.sortedMap().tailMap(var1_1, (boolean)var2_2));
        }
    }

    private class SortedAsMap
    extends AsMap
    implements SortedMap<K, Collection<V>> {
        SortedSet<K> sortedKeySet;

        /*
         * WARNING - void declaration
         */
        SortedAsMap(SortedMap<K, Collection<V>> submap) {
            void var2_2;
            super(var2_2);
        }

        SortedMap<K, Collection<V>> sortedMap() {
            return (SortedMap)this.submap;
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.sortedMap().comparator();
        }

        @Override
        @ParametricNullness
        public K firstKey() {
            return this.sortedMap().firstKey();
        }

        @Override
        @ParametricNullness
        public K lastKey() {
            return this.sortedMap().lastKey();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedMap<K, Collection<V>> headMap(@ParametricNullness K toKey) {
            void var1_1;
            return new SortedAsMap(this.sortedMap().headMap(var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedMap<K, Collection<V>> subMap(@ParametricNullness K fromKey, @ParametricNullness K toKey) {
            void var2_2;
            void var1_1;
            return new SortedAsMap(this.sortedMap().subMap(var1_1, var2_2));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedMap<K, Collection<V>> tailMap(@ParametricNullness K fromKey) {
            void var1_1;
            return new SortedAsMap(this.sortedMap().tailMap(var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedSet<K> keySet() {
            void var1_1;
            SortedSet result = this.sortedKeySet;
            if (result == null) {
                this.sortedKeySet = this.createKeySet();
                return this.sortedKeySet;
            }
            return var1_1;
        }

        @Override
        SortedSet<K> createKeySet() {
            return new SortedKeySet(this.sortedMap());
        }
    }

    private class AsMap
    extends Maps.ViewCachingAbstractMap<K, Collection<V>> {
        final transient Map<K, Collection<V>> submap;

        /*
         * WARNING - void declaration
         */
        AsMap(Map<K, Collection<V>> submap) {
            void var2_2;
            this.submap = var2_2;
        }

        @Override
        protected Set<Map.Entry<K, Collection<V>>> createEntrySet() {
            return new AsMapEntries(this);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean containsKey(Object key) {
            void var1_1;
            return Maps.safeContainsKey(this.submap, var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Collection<V> get(Object key) {
            void var2_2;
            void var1_1;
            Collection collection = Maps.safeGet(this.submap, key);
            if (collection == null) {
                return null;
            }
            return AbstractMapBasedMultimap.this.wrapCollection(var1_1, var2_2);
        }

        @Override
        public Set<K> keySet() {
            return AbstractMapBasedMultimap.this.keySet();
        }

        @Override
        public int size() {
            return this.submap.size();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Collection<V> remove(Object key) {
            void var2_2;
            void var1_1;
            Collection collection = this.submap.remove(key);
            if (collection == null) {
                return null;
            }
            Collection output = AbstractMapBasedMultimap.this.createCollection();
            output.addAll(collection);
            AbstractMapBasedMultimap.access$220(AbstractMapBasedMultimap.this, collection.size());
            var1_1.clear();
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(Object object) {
            void var1_1;
            return this == object || this.submap.equals(var1_1);
        }

        @Override
        public int hashCode() {
            return this.submap.hashCode();
        }

        @Override
        public String toString() {
            return this.submap.toString();
        }

        @Override
        public void clear() {
            if (this.submap == AbstractMapBasedMultimap.this.map) {
                AbstractMapBasedMultimap.this.clear();
                return;
            }
            Iterators.clear(new AsMapIterator(this));
        }

        /*
         * WARNING - void declaration
         */
        Map.Entry<K, Collection<V>> wrapEntry(Map.Entry<K, Collection<V>> entry) {
            void var1_1;
            void var2_2;
            Object key = entry.getKey();
            return Maps.immutableEntry(key, AbstractMapBasedMultimap.this.wrapCollection(var2_2, (Collection)var1_1.getValue()));
        }

        class AsMapIterator
        implements Iterator<Map.Entry<K, Collection<V>>> {
            final Iterator<Map.Entry<K, Collection<V>>> delegateIterator;
            Collection<V> collection;
            final /* synthetic */ AsMap this$1;

            /*
             * WARNING - void declaration
             */
            AsMapIterator(AsMap this$1) {
                void var1_1;
                this.this$1 = var1_1;
                this.delegateIterator = this.this$1.submap.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.delegateIterator.hasNext();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Map.Entry<K, Collection<V>> next() {
                void var1_1;
                Map.Entry entry = this.delegateIterator.next();
                this.collection = entry.getValue();
                return this.this$1.wrapEntry(var1_1);
            }

            @Override
            public void remove() {
                Preconditions.checkState(this.collection != null, "no calls to next() since the last call to remove()");
                this.delegateIterator.remove();
                AbstractMapBasedMultimap.access$220(this.this$1.AbstractMapBasedMultimap.this, this.collection.size());
                this.collection.clear();
                this.collection = null;
            }
        }

        class AsMapEntries
        extends Maps.EntrySet<K, Collection<V>> {
            final /* synthetic */ AsMap this$1;

            /*
             * WARNING - void declaration
             */
            AsMapEntries(AsMap this$1) {
                void var1_1;
                this.this$1 = var1_1;
            }

            @Override
            Map<K, Collection<V>> map() {
                return this.this$1;
            }

            @Override
            public Iterator<Map.Entry<K, Collection<V>>> iterator() {
                return new AsMapIterator(this.this$1);
            }

            @Override
            public Spliterator<Map.Entry<K, Collection<V>>> spliterator() {
                return CollectSpliterators.map(this.this$1.submap.entrySet().spliterator(), this.this$1::wrapEntry);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean contains(Object o) {
                void var1_1;
                return Collections2.safeContains(this.this$1.submap.entrySet(), var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean remove(Object o) {
                void var1_1;
                if (!this.contains(o)) {
                    return false;
                }
                Map.Entry entry = Objects.requireNonNull((Map.Entry)o);
                AbstractMapBasedMultimap.access$300(this.this$1.AbstractMapBasedMultimap.this, var1_1.getKey());
                return true;
            }
        }
    }

    private abstract class Itr<T>
    implements Iterator<T> {
        final Iterator<Map.Entry<K, Collection<V>>> keyIterator;
        K key;
        Collection<V> collection;
        Iterator<V> valueIterator;

        Itr() {
            this.keyIterator = AbstractMapBasedMultimap.this.map.entrySet().iterator();
            this.key = null;
            this.collection = null;
            this.valueIterator = Iterators.emptyModifiableIterator();
        }

        abstract T output(@ParametricNullness K var1, @ParametricNullness V var2);

        @Override
        public boolean hasNext() {
            return this.keyIterator.hasNext() || this.valueIterator.hasNext();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public T next() {
            if (!this.valueIterator.hasNext()) {
                void var1_1;
                Map.Entry mapEntry = this.keyIterator.next();
                this.key = mapEntry.getKey();
                this.collection = (Collection)var1_1.getValue();
                this.valueIterator = this.collection.iterator();
            }
            Itr itr = this;
            return itr.output(NullnessCasts.uncheckedCastNullableTToT(itr.key), this.valueIterator.next());
        }

        @Override
        public void remove() {
            this.valueIterator.remove();
            if (Objects.requireNonNull(this.collection).isEmpty()) {
                this.keyIterator.remove();
            }
            AbstractMapBasedMultimap.this.totalSize--;
        }
    }

    class NavigableKeySet
    extends SortedKeySet
    implements NavigableSet<K> {
        /*
         * WARNING - void declaration
         */
        NavigableKeySet(NavigableMap<K, Collection<V>> subMap) {
            void var2_2;
            void var1_1;
            super(var2_2);
        }

        NavigableMap<K, Collection<V>> sortedMap() {
            return (NavigableMap)super.sortedMap();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public K lower(@ParametricNullness K k) {
            void var1_1;
            return this.sortedMap().lowerKey(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public K floor(@ParametricNullness K k) {
            void var1_1;
            return this.sortedMap().floorKey(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public K ceiling(@ParametricNullness K k) {
            void var1_1;
            return this.sortedMap().ceilingKey(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public K higher(@ParametricNullness K k) {
            void var1_1;
            return this.sortedMap().higherKey(var1_1);
        }

        @Override
        public K pollFirst() {
            return Iterators.pollNext(this.iterator());
        }

        @Override
        public K pollLast() {
            return Iterators.pollNext(this.descendingIterator());
        }

        @Override
        public NavigableSet<K> descendingSet() {
            return new NavigableKeySet(this.sortedMap().descendingMap());
        }

        @Override
        public Iterator<K> descendingIterator() {
            return this.descendingSet().iterator();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public NavigableSet<K> headSet(@ParametricNullness K toElement) {
            void var1_1;
            return this.headSet(var1_1, false);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public NavigableSet<K> headSet(@ParametricNullness K toElement, boolean inclusive) {
            void var2_2;
            void var1_1;
            return new NavigableKeySet(this.sortedMap().headMap(var1_1, (boolean)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public NavigableSet<K> subSet(@ParametricNullness K fromElement, @ParametricNullness K toElement) {
            void var2_2;
            void var1_1;
            return this.subSet(var1_1, true, var2_2, false);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public NavigableSet<K> subSet(@ParametricNullness K fromElement, boolean fromInclusive, @ParametricNullness K toElement, boolean toInclusive) {
            void var3_3;
            void var2_2;
            void var1_1;
            return new NavigableKeySet(this.sortedMap().subMap(var1_1, (boolean)var2_2, var3_3, toInclusive));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public NavigableSet<K> tailSet(@ParametricNullness K fromElement) {
            void var1_1;
            return this.tailSet(var1_1, true);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public NavigableSet<K> tailSet(@ParametricNullness K fromElement, boolean inclusive) {
            void var2_2;
            void var1_1;
            return new NavigableKeySet(this.sortedMap().tailMap(var1_1, (boolean)var2_2));
        }
    }

    private class SortedKeySet
    extends KeySet
    implements SortedSet<K> {
        /*
         * WARNING - void declaration
         */
        SortedKeySet(SortedMap<K, Collection<V>> subMap) {
            void var2_2;
            super(var2_2);
        }

        SortedMap<K, Collection<V>> sortedMap() {
            return (SortedMap)super.map();
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.sortedMap().comparator();
        }

        @Override
        @ParametricNullness
        public K first() {
            return this.sortedMap().firstKey();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedSet<K> headSet(@ParametricNullness K toElement) {
            void var1_1;
            return new SortedKeySet(this.sortedMap().headMap(var1_1));
        }

        @Override
        @ParametricNullness
        public K last() {
            return this.sortedMap().lastKey();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedSet<K> subSet(@ParametricNullness K fromElement, @ParametricNullness K toElement) {
            void var2_2;
            void var1_1;
            return new SortedKeySet(this.sortedMap().subMap(var1_1, var2_2));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedSet<K> tailSet(@ParametricNullness K fromElement) {
            void var1_1;
            return new SortedKeySet(this.sortedMap().tailMap(var1_1));
        }
    }

    private class KeySet
    extends Maps.KeySet<K, Collection<V>> {
        /*
         * WARNING - void declaration
         */
        KeySet(Map<K, Collection<V>> subMap) {
            void var2_2;
            super(var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Iterator<K> iterator() {
            void var1_1;
            Iterator entryIterator = this.map().entrySet().iterator();
            return new Iterator<K>(this, (Iterator)var1_1){
                Map.Entry<K, Collection<V>> entry;
                final /* synthetic */ Iterator val$entryIterator;
                final /* synthetic */ KeySet this$1;
                {
                    void var1_1;
                    this.this$1 = var1_1;
                    this.val$entryIterator = iterator;
                }

                @Override
                public boolean hasNext() {
                    return this.val$entryIterator.hasNext();
                }

                @Override
                @ParametricNullness
                public K next() {
                    this.entry = (Map.Entry)this.val$entryIterator.next();
                    return this.entry.getKey();
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void remove() {
                    void var1_1;
                    Preconditions.checkState(this.entry != null, "no calls to next() since the last call to remove()");
                    Collection collection = this.entry.getValue();
                    this.val$entryIterator.remove();
                    AbstractMapBasedMultimap.access$220(this.this$1.AbstractMapBasedMultimap.this, collection.size());
                    var1_1.clear();
                    this.entry = null;
                }
            };
        }

        @Override
        public Spliterator<K> spliterator() {
            return this.map().keySet().spliterator();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean remove(Object key) {
            void var2_2;
            int count = 0;
            Collection collection = (Collection)this.map().remove(key);
            if (collection != null) {
                void var1_1;
                count = collection.size();
                var1_1.clear();
                AbstractMapBasedMultimap.access$220(AbstractMapBasedMultimap.this, count);
            }
            return var2_2 > 0;
        }

        @Override
        public void clear() {
            Iterators.clear(this.iterator());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean containsAll(Collection<?> c) {
            void var1_1;
            return this.map().keySet().containsAll((Collection<?>)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(Object object) {
            void var1_1;
            return this == object || this.map().keySet().equals(var1_1);
        }

        @Override
        public int hashCode() {
            return this.map().keySet().hashCode();
        }
    }

    private class RandomAccessWrappedList
    extends WrappedList
    implements RandomAccess {
        /*
         * WARNING - void declaration
         */
        RandomAccessWrappedList(@ParametricNullness AbstractMapBasedMultimap abstractMapBasedMultimap, K key, List<V> delegate, WrappedCollection ancestor) {
            super(var2_2, var3_3, ancestor);
            void var3_3;
            void var2_2;
        }
    }

    class WrappedList
    extends WrappedCollection
    implements List<V> {
        /*
         * WARNING - void declaration
         */
        WrappedList(K key, List<V> delegate, WrappedCollection ancestor) {
            void var3_3;
            void var2_2;
            void var1_1;
            super((AbstractMapBasedMultimap)var1_1, var2_2, var3_3, ancestor);
        }

        List<V> getListDelegate() {
            return (List)this.getDelegate();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean addAll(int index, Collection<? extends V> c) {
            void var1_1;
            if (c.isEmpty()) {
                return false;
            }
            int oldSize = this.size();
            boolean changed = this.getListDelegate().addAll(index, c);
            if (changed) {
                void var3_4;
                void var2_3;
                int newSize = this.getDelegate().size();
                AbstractMapBasedMultimap.access$212(AbstractMapBasedMultimap.this, (int)(var2_3 - oldSize));
                if (var3_4 == false) {
                    this.addToMap();
                }
            }
            return (boolean)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @ParametricNullness
        public V get(int index) {
            void var1_1;
            this.refreshIfEmpty();
            return this.getListDelegate().get((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @ParametricNullness
        public V set(int index, @ParametricNullness V element) {
            void var2_2;
            void var1_1;
            this.refreshIfEmpty();
            return this.getListDelegate().set((int)var1_1, var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void add(int index, @ParametricNullness V element) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.refreshIfEmpty();
            boolean wasEmpty = this.getDelegate().isEmpty();
            this.getListDelegate().add((int)var1_1, var2_2);
            AbstractMapBasedMultimap.this.totalSize++;
            if (var3_3 != false) {
                this.addToMap();
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @ParametricNullness
        public V remove(int index) {
            void var1_2;
            this.refreshIfEmpty();
            Object value = this.getListDelegate().remove(index);
            AbstractMapBasedMultimap.this.totalSize--;
            this.removeIfEmpty();
            return var1_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int indexOf(Object o) {
            void var1_1;
            this.refreshIfEmpty();
            return this.getListDelegate().indexOf(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int lastIndexOf(Object o) {
            void var1_1;
            this.refreshIfEmpty();
            return this.getListDelegate().lastIndexOf(var1_1);
        }

        @Override
        public ListIterator<V> listIterator() {
            this.refreshIfEmpty();
            return new WrappedListIterator();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ListIterator<V> listIterator(int index) {
            void var1_1;
            this.refreshIfEmpty();
            return new WrappedListIterator((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public List<V> subList(int fromIndex, int toIndex) {
            void var2_2;
            void var1_1;
            this.refreshIfEmpty();
            return AbstractMapBasedMultimap.this.wrapList(this.getKey(), this.getListDelegate().subList((int)var1_1, (int)var2_2), this.getAncestor() == null ? this : this.getAncestor());
        }

        /*
         * Signature claims super is com.google.common.collect.AbstractMapBasedMultimap$WrappedCollection.WrappedIterator, not com.google.common.collect.AbstractMapBasedMultimap$WrappedCollection$WrappedIterator - discarding signature.
         */
        private class WrappedListIterator
        extends WrappedCollection.WrappedIterator
        implements ListIterator {
            WrappedListIterator() {
                super(WrappedList.this);
            }

            /*
             * WARNING - void declaration
             */
            public WrappedListIterator(int index) {
                void var2_2;
                WrappedList wrappedList2 = WrappedList.this;
                super(wrappedList2, wrappedList2.getListDelegate().listIterator((int)var2_2));
            }

            private ListIterator<V> getDelegateListIterator() {
                return (ListIterator)this.getDelegateIterator();
            }

            @Override
            public boolean hasPrevious() {
                return this.getDelegateListIterator().hasPrevious();
            }

            @ParametricNullness
            public V previous() {
                return this.getDelegateListIterator().previous();
            }

            @Override
            public int nextIndex() {
                return this.getDelegateListIterator().nextIndex();
            }

            @Override
            public int previousIndex() {
                return this.getDelegateListIterator().previousIndex();
            }

            /*
             * WARNING - void declaration
             */
            public void set(@ParametricNullness V value) {
                void var1_1;
                this.getDelegateListIterator().set(var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public void add(@ParametricNullness V value) {
                void var2_2;
                void var1_1;
                boolean wasEmpty = WrappedList.this.isEmpty();
                this.getDelegateListIterator().add(var1_1);
                AbstractMapBasedMultimap.this.totalSize++;
                if (var2_2 != false) {
                    WrappedList.this.addToMap();
                }
            }
        }
    }

    class WrappedNavigableSet
    extends WrappedSortedSet
    implements NavigableSet<V> {
        /*
         * WARNING - void declaration
         */
        WrappedNavigableSet(K key, NavigableSet<V> delegate, WrappedCollection ancestor) {
            void var3_3;
            void var2_2;
            void var1_1;
            super(var2_2, var3_3, ancestor);
        }

        NavigableSet<V> getSortedSetDelegate() {
            return (NavigableSet)super.getSortedSetDelegate();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V lower(@ParametricNullness V v) {
            void var1_1;
            return this.getSortedSetDelegate().lower(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V floor(@ParametricNullness V v) {
            void var1_1;
            return this.getSortedSetDelegate().floor(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V ceiling(@ParametricNullness V v) {
            void var1_1;
            return this.getSortedSetDelegate().ceiling(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V higher(@ParametricNullness V v) {
            void var1_1;
            return this.getSortedSetDelegate().higher(var1_1);
        }

        @Override
        public V pollFirst() {
            return Iterators.pollNext(this.iterator());
        }

        @Override
        public V pollLast() {
            return Iterators.pollNext(this.descendingIterator());
        }

        /*
         * WARNING - void declaration
         */
        private NavigableSet<V> wrap(NavigableSet<V> wrapped) {
            void var1_1;
            return new WrappedNavigableSet(this.key, var1_1, this.getAncestor() == null ? this : this.getAncestor());
        }

        @Override
        public NavigableSet<V> descendingSet() {
            WrappedNavigableSet wrappedNavigableSet = this;
            return wrappedNavigableSet.wrap(wrappedNavigableSet.getSortedSetDelegate().descendingSet());
        }

        @Override
        public Iterator<V> descendingIterator() {
            WrappedNavigableSet wrappedNavigableSet = this;
            return new WrappedCollection.WrappedIterator(wrappedNavigableSet, wrappedNavigableSet.getSortedSetDelegate().descendingIterator());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public NavigableSet<V> subSet(@ParametricNullness V fromElement, boolean fromInclusive, @ParametricNullness V toElement, boolean toInclusive) {
            void var3_3;
            void var2_2;
            void var1_1;
            WrappedNavigableSet wrappedNavigableSet = this;
            return wrappedNavigableSet.wrap(wrappedNavigableSet.getSortedSetDelegate().subSet(var1_1, (boolean)var2_2, var3_3, toInclusive));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public NavigableSet<V> headSet(@ParametricNullness V toElement, boolean inclusive) {
            void var2_2;
            void var1_1;
            WrappedNavigableSet wrappedNavigableSet = this;
            return wrappedNavigableSet.wrap(wrappedNavigableSet.getSortedSetDelegate().headSet(var1_1, (boolean)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public NavigableSet<V> tailSet(@ParametricNullness V fromElement, boolean inclusive) {
            void var2_2;
            void var1_1;
            WrappedNavigableSet wrappedNavigableSet = this;
            return wrappedNavigableSet.wrap(wrappedNavigableSet.getSortedSetDelegate().tailSet(var1_1, (boolean)var2_2));
        }
    }

    class WrappedSortedSet
    extends WrappedCollection
    implements SortedSet<V> {
        /*
         * WARNING - void declaration
         */
        WrappedSortedSet(K key, SortedSet<V> delegate, WrappedCollection ancestor) {
            void var3_3;
            void var2_2;
            void var1_1;
            super((AbstractMapBasedMultimap)var1_1, var2_2, var3_3, ancestor);
        }

        SortedSet<V> getSortedSetDelegate() {
            return (SortedSet)this.getDelegate();
        }

        @Override
        public Comparator<? super V> comparator() {
            return this.getSortedSetDelegate().comparator();
        }

        @Override
        @ParametricNullness
        public V first() {
            this.refreshIfEmpty();
            return this.getSortedSetDelegate().first();
        }

        @Override
        @ParametricNullness
        public V last() {
            this.refreshIfEmpty();
            return this.getSortedSetDelegate().last();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedSet<V> headSet(@ParametricNullness V toElement) {
            void var1_1;
            this.refreshIfEmpty();
            return new WrappedSortedSet(this.getKey(), this.getSortedSetDelegate().headSet(var1_1), this.getAncestor() == null ? this : this.getAncestor());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedSet<V> subSet(@ParametricNullness V fromElement, @ParametricNullness V toElement) {
            void var2_2;
            void var1_1;
            this.refreshIfEmpty();
            return new WrappedSortedSet(this.getKey(), this.getSortedSetDelegate().subSet(var1_1, var2_2), this.getAncestor() == null ? this : this.getAncestor());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedSet<V> tailSet(@ParametricNullness V fromElement) {
            void var1_1;
            this.refreshIfEmpty();
            return new WrappedSortedSet(this.getKey(), this.getSortedSetDelegate().tailSet(var1_1), this.getAncestor() == null ? this : this.getAncestor());
        }
    }

    class WrappedSet
    extends WrappedCollection
    implements Set<V> {
        /*
         * WARNING - void declaration
         */
        WrappedSet(K key, Set<V> delegate) {
            void var3_3;
            void var2_2;
            void var1_1;
            super((AbstractMapBasedMultimap)var1_1, var2_2, var3_3, (WrappedCollection)null);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean removeAll(Collection<?> c) {
            void var1_2;
            if (c.isEmpty()) {
                return false;
            }
            int oldSize = this.size();
            boolean changed = Sets.removeAllImpl((Set)this.delegate, c);
            if (changed) {
                void var2_3;
                void var3_4;
                int newSize = this.delegate.size();
                AbstractMapBasedMultimap.access$212(AbstractMapBasedMultimap.this, (int)(var3_4 - var2_3));
                this.removeIfEmpty();
            }
            return (boolean)var1_2;
        }
    }

    class WrappedCollection
    extends AbstractCollection<V> {
        @ParametricNullness
        final K key;
        Collection<V> delegate;
        final WrappedCollection ancestor;
        final Collection<V> ancestorDelegate;
        final /* synthetic */ AbstractMapBasedMultimap this$0;

        /*
         * WARNING - void declaration
         */
        WrappedCollection(@ParametricNullness AbstractMapBasedMultimap this$0, K key, Collection<V> delegate, WrappedCollection ancestor) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            this.key = var2_2;
            this.delegate = var3_3;
            this.ancestor = ancestor;
            this.ancestorDelegate = ancestor == null ? null : ancestor.getDelegate();
        }

        /*
         * WARNING - void declaration
         */
        void refreshIfEmpty() {
            Collection newDelegate;
            if (this.ancestor != null) {
                this.ancestor.refreshIfEmpty();
                if (this.ancestor.getDelegate() != this.ancestorDelegate) {
                    throw new ConcurrentModificationException();
                }
            } else if (this.delegate.isEmpty() && (newDelegate = (Collection)this.this$0.map.get(this.key)) != null) {
                void var1_1;
                this.delegate = var1_1;
            }
        }

        void removeIfEmpty() {
            if (this.ancestor != null) {
                this.ancestor.removeIfEmpty();
                return;
            }
            if (this.delegate.isEmpty()) {
                this.this$0.map.remove(this.key);
            }
        }

        @ParametricNullness
        K getKey() {
            return this.key;
        }

        void addToMap() {
            if (this.ancestor != null) {
                this.ancestor.addToMap();
                return;
            }
            this.this$0.map.put(this.key, this.delegate);
        }

        @Override
        public int size() {
            this.refreshIfEmpty();
            return this.delegate.size();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(Object object) {
            void var1_1;
            if (object == this) {
                return true;
            }
            this.refreshIfEmpty();
            return this.delegate.equals(var1_1);
        }

        @Override
        public int hashCode() {
            this.refreshIfEmpty();
            return this.delegate.hashCode();
        }

        @Override
        public String toString() {
            this.refreshIfEmpty();
            return this.delegate.toString();
        }

        Collection<V> getDelegate() {
            return this.delegate;
        }

        @Override
        public Iterator<V> iterator() {
            this.refreshIfEmpty();
            return new WrappedIterator(this);
        }

        @Override
        public Spliterator<V> spliterator() {
            this.refreshIfEmpty();
            return this.delegate.spliterator();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean add(@ParametricNullness V value) {
            void var1_2;
            this.refreshIfEmpty();
            boolean wasEmpty = this.delegate.isEmpty();
            boolean changed = this.delegate.add(value);
            if (changed) {
                void var2_3;
                this.this$0.totalSize++;
                if (var2_3 != false) {
                    this.addToMap();
                }
            }
            return (boolean)var1_2;
        }

        WrappedCollection getAncestor() {
            return this.ancestor;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean addAll(Collection<? extends V> collection) {
            void var1_2;
            if (collection.isEmpty()) {
                return false;
            }
            int oldSize = this.size();
            boolean changed = this.delegate.addAll(collection);
            if (changed) {
                void var2_3;
                void var3_4;
                int newSize = this.delegate.size();
                AbstractMapBasedMultimap.access$212(this.this$0, (int)(var3_4 - oldSize));
                if (var2_3 == false) {
                    this.addToMap();
                }
            }
            return (boolean)var1_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean contains(Object o) {
            void var1_1;
            this.refreshIfEmpty();
            return this.delegate.contains(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean containsAll(Collection<?> c) {
            void var1_1;
            this.refreshIfEmpty();
            return this.delegate.containsAll((Collection<?>)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void clear() {
            void var1_1;
            int oldSize = this.size();
            if (oldSize == 0) {
                return;
            }
            this.delegate.clear();
            AbstractMapBasedMultimap.access$220(this.this$0, (int)var1_1);
            this.removeIfEmpty();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean remove(Object o) {
            void var1_2;
            this.refreshIfEmpty();
            boolean changed = this.delegate.remove(o);
            if (changed) {
                this.this$0.totalSize--;
                this.removeIfEmpty();
            }
            return (boolean)var1_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean removeAll(Collection<?> c) {
            void var1_2;
            if (c.isEmpty()) {
                return false;
            }
            int oldSize = this.size();
            boolean changed = this.delegate.removeAll(c);
            if (changed) {
                void var2_3;
                void var3_4;
                int newSize = this.delegate.size();
                AbstractMapBasedMultimap.access$212(this.this$0, (int)(var3_4 - var2_3));
                this.removeIfEmpty();
            }
            return (boolean)var1_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean retainAll(Collection<?> c) {
            void var1_2;
            Preconditions.checkNotNull(c);
            int oldSize = this.size();
            boolean changed = this.delegate.retainAll(c);
            if (changed) {
                void var2_3;
                void var3_4;
                int newSize = this.delegate.size();
                AbstractMapBasedMultimap.access$212(this.this$0, (int)(var3_4 - var2_3));
                this.removeIfEmpty();
            }
            return (boolean)var1_2;
        }

        class WrappedIterator
        implements Iterator<V> {
            final Iterator<V> delegateIterator;
            final Collection<V> originalDelegate;
            final /* synthetic */ WrappedCollection this$1;

            /*
             * WARNING - void declaration
             */
            WrappedIterator(WrappedCollection this$1) {
                void var1_1;
                this.this$1 = this$1;
                this.originalDelegate = this.this$1.delegate;
                this.delegateIterator = AbstractMapBasedMultimap.iteratorOrListIterator(var1_1.delegate);
            }

            /*
             * WARNING - void declaration
             */
            WrappedIterator(WrappedCollection this$1, Iterator<V> delegateIterator) {
                void var2_2;
                void var1_1;
                this.this$1 = var1_1;
                this.originalDelegate = this.this$1.delegate;
                this.delegateIterator = var2_2;
            }

            void validateIterator() {
                this.this$1.refreshIfEmpty();
                if (this.this$1.delegate != this.originalDelegate) {
                    throw new ConcurrentModificationException();
                }
            }

            @Override
            public boolean hasNext() {
                this.validateIterator();
                return this.delegateIterator.hasNext();
            }

            @Override
            @ParametricNullness
            public V next() {
                this.validateIterator();
                return this.delegateIterator.next();
            }

            @Override
            public void remove() {
                this.delegateIterator.remove();
                this.this$1.this$0.totalSize--;
                this.this$1.removeIfEmpty();
            }

            Iterator<V> getDelegateIterator() {
                this.validateIterator();
                return this.delegateIterator;
            }
        }
    }
}

