/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.AbstractMapBasedMultimap;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.ParametricNullness;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@ElementTypesAreNonnullByDefault
@GwtCompatible
abstract class AbstractListMultimap<K, V>
extends AbstractMapBasedMultimap<K, V>
implements ListMultimap<K, V> {
    private static final long serialVersionUID = 6588350623831699109L;

    /*
     * WARNING - void declaration
     */
    protected AbstractListMultimap(Map<K, Collection<V>> map) {
        super(var1_1);
        void var1_1;
    }

    @Override
    abstract List<V> createCollection();

    @Override
    List<V> createUnmodifiableEmptyCollection() {
        return Collections.emptyList();
    }

    @Override
    <E> Collection<E> unmodifiableCollectionSubclass(Collection<E> collection) {
        return Collections.unmodifiableList((List)collection);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Collection<V> wrapCollection(@ParametricNullness K key, Collection<V> collection) {
        void var2_2;
        void var1_1;
        return this.wrapList(var1_1, (List)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<V> get(@ParametricNullness K key) {
        void var1_1;
        return (List)super.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<V> removeAll(Object key) {
        void var1_1;
        return (List)super.removeAll(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<V> replaceValues(@ParametricNullness K key, Iterable<? extends V> values) {
        void var2_2;
        void var1_1;
        return (List)super.replaceValues(var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean put(@ParametricNullness K key, @ParametricNullness V value) {
        void var2_2;
        void var1_1;
        return super.put(var1_1, var2_2);
    }

    @Override
    public Map<K, Collection<V>> asMap() {
        return super.asMap();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object object) {
        void var1_1;
        return super.equals(var1_1);
    }
}

