/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ForwardingMapEntry;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.Maps;
import com.google.common.collect.NullnessCasts;
import com.google.common.collect.ParametricNullness;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
abstract class AbstractBiMap<K, V>
extends ForwardingMap<K, V>
implements BiMap<K, V>,
Serializable {
    private transient Map<K, V> delegate;
    transient AbstractBiMap<V, K> inverse;
    private transient Set<K> keySet;
    private transient Set<V> valueSet;
    private transient Set<Map.Entry<K, V>> entrySet;
    @GwtIncompatible
    private static final long serialVersionUID = 0L;

    /*
     * WARNING - void declaration
     */
    AbstractBiMap(Map<K, V> forward, Map<V, K> backward) {
        void var2_2;
        void var1_1;
        this.setDelegates((Map<K, V>)var1_1, (Map<V, K>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private AbstractBiMap(Map<K, V> backward, AbstractBiMap<V, K> forward) {
        void var2_2;
        void var1_1;
        this.delegate = var1_1;
        this.inverse = var2_2;
    }

    @Override
    protected Map<K, V> delegate() {
        return this.delegate;
    }

    @ParametricNullness
    K checkKey(@ParametricNullness K key) {
        return key;
    }

    @ParametricNullness
    V checkValue(@ParametricNullness V value) {
        return value;
    }

    /*
     * WARNING - void declaration
     */
    void setDelegates(Map<K, V> forward, Map<V, K> backward) {
        void var2_2;
        void var1_1;
        Preconditions.checkState(this.delegate == null);
        Preconditions.checkState(this.inverse == null);
        Preconditions.checkArgument(forward.isEmpty());
        Preconditions.checkArgument(backward.isEmpty());
        Preconditions.checkArgument(forward != backward);
        this.delegate = var1_1;
        this.inverse = this.makeInverse((Map<V, K>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    AbstractBiMap<V, K> makeInverse(Map<V, K> backward) {
        void var1_1;
        return new Inverse(var1_1, this);
    }

    /*
     * WARNING - void declaration
     */
    void setInverse(AbstractBiMap<V, K> inverse) {
        void var1_1;
        this.inverse = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsValue(Object value) {
        void var1_1;
        return this.inverse.containsKey(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V put(@ParametricNullness K key, @ParametricNullness V value) {
        void var2_2;
        void var1_1;
        return this.putInBothMaps(var1_1, var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V forcePut(@ParametricNullness K key, @ParametricNullness V value) {
        void var2_2;
        void var1_1;
        return this.putInBothMaps(var1_1, var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    private V putInBothMaps(@ParametricNullness K key, @ParametricNullness V value, boolean force) {
        void var3_4;
        void var2_2;
        void var1_1;
        this.checkKey(key);
        this.checkValue(value);
        boolean containedKey = this.containsKey(key);
        if (containedKey && Objects.equal(value, this.get(key))) {
            return value;
        }
        if (force) {
            this.inverse().remove(value);
        } else {
            Preconditions.checkArgument(!((ForwardingMap)this).containsValue(value), "value already present: %s", value);
        }
        V oldValue = this.delegate.put(key, value);
        this.updateInverseMap(var1_1, containedKey, oldValue, var2_2);
        return var3_4;
    }

    /*
     * WARNING - void declaration
     */
    private void updateInverseMap(@ParametricNullness K key, boolean containedKey, V oldValue, @ParametricNullness V newValue) {
        void var1_1;
        if (containedKey) {
            void var3_3;
            this.removeFromInverseMap(NullnessCasts.uncheckedCastNullableTToT(var3_3));
        }
        this.inverse.delegate.put(newValue, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V remove(Object key) {
        if (this.containsKey(key)) {
            void var1_1;
            return this.removeFromBothMaps(var1_1);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @ParametricNullness
    private V removeFromBothMaps(Object key) {
        void var1_1;
        V oldValue = NullnessCasts.uncheckedCastNullableTToT(this.delegate.remove(key));
        this.removeFromInverseMap(oldValue);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void removeFromInverseMap(@ParametricNullness V oldValue) {
        void var1_1;
        this.inverse.delegate.remove(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            void var2_2;
            ((ForwardingMap)this).put(entry.getKey(), var2_2.getValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        String string;
        this.delegate.replaceAll(function);
        this.inverse.delegate.clear();
        String broken = null;
        Iterator<Map.Entry<K, V>> itr = this.delegate.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<K, V> entry = itr.next();
            K k = entry.getKey();
            V v = entry.getValue();
            V v2 = this.inverse.delegate.putIfAbsent(v, k);
            if (v2 == null) continue;
            broken = string;
            itr.remove();
        }
        if (broken != null) {
            void var1_1;
            string = String.valueOf(var1_1.getValue());
            throw new IllegalArgumentException(new StringBuilder(23 + String.valueOf(string).length()).append("value already present: ").append(string).toString());
        }
    }

    @Override
    public void clear() {
        this.delegate.clear();
        this.inverse.delegate.clear();
    }

    @Override
    public BiMap<V, K> inverse() {
        return this.inverse;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Set<K> keySet() {
        void var1_1;
        Set<K> result = this.keySet;
        if (result == null) {
            this.keySet = new KeySet();
            return this.keySet;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Set<V> values() {
        void var1_1;
        Set<V> result = this.valueSet;
        if (result == null) {
            this.valueSet = new ValueSet();
            return this.valueSet;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        void var1_1;
        Set<Map.Entry<K, V>> result = this.entrySet;
        if (result == null) {
            this.entrySet = new EntrySet();
            return this.entrySet;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    Iterator<Map.Entry<K, V>> entrySetIterator() {
        void var1_1;
        Iterator<Map.Entry<K, V>> iterator = this.delegate.entrySet().iterator();
        return new Iterator<Map.Entry<K, V>>(this, (Iterator)var1_1){
            Map.Entry<K, V> entry;
            final /* synthetic */ Iterator val$iterator;
            final /* synthetic */ AbstractBiMap this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$iterator = iterator;
            }

            @Override
            public boolean hasNext() {
                return this.val$iterator.hasNext();
            }

            @Override
            public Map.Entry<K, V> next() {
                this.entry = (Map.Entry)this.val$iterator.next();
                return new BiMapEntry(this.this$0, this.entry);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void remove() {
                void var1_1;
                if (this.entry == null) {
                    throw new IllegalStateException("no calls to next() since the last call to remove()");
                }
                Object value = this.entry.getValue();
                this.val$iterator.remove();
                AbstractBiMap.access$600(this.this$0, var1_1);
                this.entry = null;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Object access$200(AbstractBiMap x0, Object x1) {
        void var1_1;
        return x0.removeFromBothMaps(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$500(AbstractBiMap x0, Object x1, boolean x2, Object x3, Object x4) {
        void var3_3;
        void var2_2;
        void var1_1;
        x0.updateInverseMap(var1_1, (boolean)var2_2, var3_3, x4);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$600(AbstractBiMap x0, Object x1) {
        void var1_1;
        x0.removeFromInverseMap(var1_1);
    }

    static class Inverse<K, V>
    extends AbstractBiMap<K, V> {
        @GwtIncompatible
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        Inverse(Map<K, V> backward, AbstractBiMap<V, K> forward) {
            super((Map)var1_1, (AbstractBiMap)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @ParametricNullness
        K checkKey(@ParametricNullness K key) {
            void var1_1;
            return this.inverse.checkValue(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @ParametricNullness
        V checkValue(@ParametricNullness V value) {
            void var1_1;
            return this.inverse.checkKey(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @GwtIncompatible
        private void writeObject(ObjectOutputStream stream) throws IOException {
            void var1_1;
            stream.defaultWriteObject();
            var1_1.writeObject(this.inverse());
        }

        /*
         * WARNING - void declaration
         */
        @GwtIncompatible
        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            void var1_1;
            stream.defaultReadObject();
            this.setInverse((AbstractBiMap)var1_1.readObject());
        }

        @GwtIncompatible
        Object readResolve() {
            return this.inverse().inverse();
        }
    }

    private class EntrySet
    extends ForwardingSet<Map.Entry<K, V>> {
        final Set<Map.Entry<K, V>> esDelegate;

        private EntrySet() {
            this.esDelegate = AbstractBiMap.this.delegate.entrySet();
        }

        @Override
        protected Set<Map.Entry<K, V>> delegate() {
            return this.esDelegate;
        }

        @Override
        public void clear() {
            ((ForwardingMap)AbstractBiMap.this).clear();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean remove(Object object) {
            void var1_1;
            if (!this.esDelegate.contains(object) || !(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            AbstractBiMap.this.inverse.delegate.remove(entry.getValue());
            this.esDelegate.remove(var1_1);
            return true;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return AbstractBiMap.this.entrySetIterator();
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = this.standardToArray();
            return objectArray;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public <T> T[] toArray(T[] array) {
            void var1_1;
            return this.standardToArray((T[])var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean contains(Object o) {
            void var1_1;
            return Maps.containsEntryImpl(this.delegate(), var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean containsAll(Collection<?> c) {
            void var1_1;
            return this.standardContainsAll((Collection<?>)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean removeAll(Collection<?> c) {
            void var1_1;
            return this.standardRemoveAll((Collection<?>)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean retainAll(Collection<?> c) {
            void var1_1;
            return this.standardRetainAll((Collection<?>)var1_1);
        }
    }

    class BiMapEntry
    extends ForwardingMapEntry<K, V> {
        private final Map.Entry<K, V> delegate;
        final /* synthetic */ AbstractBiMap this$0;

        /*
         * WARNING - void declaration
         */
        BiMapEntry(AbstractBiMap this$0, Map.Entry<K, V> delegate) {
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            this.delegate = var2_2;
        }

        @Override
        protected Map.Entry<K, V> delegate() {
            return this.delegate;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V setValue(V value) {
            void var2_2;
            void var1_1;
            this.this$0.checkValue(value);
            Preconditions.checkState(((ForwardingMap)this.this$0).entrySet().contains(this), "entry no longer in map");
            if (Objects.equal(value, this.getValue())) {
                return value;
            }
            Preconditions.checkArgument(!((ForwardingMap)this.this$0).containsValue(value), "value already present: %s", value);
            Object oldValue = this.delegate.setValue(value);
            Preconditions.checkState(Objects.equal(value, this.this$0.get(this.getKey())), "entry no longer in map");
            AbstractBiMap.access$500(this.this$0, this.getKey(), true, oldValue, var1_1);
            return var2_2;
        }
    }

    private class ValueSet
    extends ForwardingSet<V> {
        final Set<V> valuesDelegate;

        private ValueSet() {
            this.valuesDelegate = ((ForwardingMap)AbstractBiMap.this.inverse).keySet();
        }

        @Override
        protected Set<V> delegate() {
            return this.valuesDelegate;
        }

        @Override
        public Iterator<V> iterator() {
            return Maps.valueIterator(((ForwardingMap)AbstractBiMap.this).entrySet().iterator());
        }

        @Override
        public Object[] toArray() {
            return this.standardToArray();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public <T> T[] toArray(T[] array) {
            void var1_1;
            return this.standardToArray((T[])var1_1);
        }

        @Override
        public String toString() {
            return this.standardToString();
        }
    }

    private class KeySet
    extends ForwardingSet<K> {
        private KeySet() {
        }

        @Override
        protected Set<K> delegate() {
            return AbstractBiMap.this.delegate.keySet();
        }

        @Override
        public void clear() {
            ((ForwardingMap)AbstractBiMap.this).clear();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean remove(Object key) {
            void var1_1;
            if (!this.contains(key)) {
                return false;
            }
            AbstractBiMap.access$200(AbstractBiMap.this, var1_1);
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean removeAll(Collection<?> keysToRemove) {
            void var1_1;
            return this.standardRemoveAll((Collection<?>)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean retainAll(Collection<?> keysToRetain) {
            void var1_1;
            return this.standardRetainAll((Collection<?>)var1_1);
        }

        @Override
        public Iterator<K> iterator() {
            return Maps.keyIterator(((ForwardingMap)AbstractBiMap.this).entrySet().iterator());
        }
    }
}

