/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.cache;

import com.google.common.annotations.GwtCompatible;
import com.google.common.cache.ElementTypesAreNonnullByDefault;
import com.google.common.cache.LongAddable;
import com.google.common.cache.Striped64;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
final class LongAdder
extends Striped64
implements LongAddable,
Serializable {
    private static final long serialVersionUID = 7249069246863182397L;

    /*
     * WARNING - void declaration
     */
    @Override
    final long fn(long v, long x) {
        void var3_2;
        return v + var3_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void add(long x) {
        block3: {
            void var1_1;
            int[] hc;
            boolean uncontended32;
            block4: {
                void var3_2;
                Striped64.Cell a;
                int n;
                Striped64.Cell[] as;
                block2: {
                    as = this.cells;
                    if (this.cells != null) break block2;
                    LongAdder longAdder = this;
                    long l = longAdder.base;
                    if (longAdder.casBase(l, l + x)) break block3;
                }
                uncontended32 = true;
                hc = (int[])threadHashCode.get();
                if (hc == null || as == null || (n = as.length) <= 0 || (a = as[n - 1 & hc[0]]) == null) break block4;
                void v1 = var3_2;
                long uncontended32 = v1.value;
                uncontended32 = v1.cas(uncontended32, uncontended32 + x);
                if (uncontended32) break block3;
            }
            this.retryUpdate((long)var1_1, hc, uncontended32);
        }
    }

    @Override
    public final void increment() {
        this.add(1L);
    }

    public final void decrement() {
        this.add(-1L);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long sum() {
        void var1_1;
        long sum = this.base;
        Striped64.Cell[] as = this.cells;
        if (this.cells != null) {
            for (Striped64.Cell a : as) {
                if (a == null) continue;
                sum += a.value;
            }
        }
        return (long)var1_1;
    }

    public final void reset() {
        this.internalReset(0L);
    }

    /*
     * WARNING - void declaration
     */
    public final long sumThenReset() {
        void var1_1;
        long sum = this.base;
        Striped64.Cell[] as = this.cells;
        this.base = 0L;
        if (as != null) {
            for (Striped64.Cell a : as) {
                if (a == null) continue;
                sum += a.value;
                a.value = 0L;
            }
        }
        return (long)var1_1;
    }

    public final String toString() {
        return Long.toString(this.sum());
    }

    @Override
    public final long longValue() {
        return this.sum();
    }

    @Override
    public final int intValue() {
        return (int)this.sum();
    }

    @Override
    public final float floatValue() {
        return this.sum();
    }

    @Override
    public final double doubleValue() {
        return this.sum();
    }

    /*
     * WARNING - void declaration
     */
    private void writeObject(ObjectOutputStream s) throws IOException {
        void var1_1;
        s.defaultWriteObject();
        var1_1.writeLong(this.sum());
    }

    /*
     * WARNING - void declaration
     */
    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        void var1_1;
        s.defaultReadObject();
        this.busy = 0;
        this.cells = null;
        this.base = var1_1.readLong();
    }
}

