/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.cache;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Equivalence;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.google.common.cache.AbstractCache;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.CacheStats;
import com.google.common.cache.ForwardingCache;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.ReferenceEntry;
import com.google.common.cache.RemovalCause;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.cache.Weigher;
import com.google.common.collect.AbstractSequentialIterator;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ExecutionError;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractQueue;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;

@GwtCompatible(emulated=true)
class LocalCache<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V> {
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final int MAX_SEGMENTS = 65536;
    static final int CONTAINS_VALUE_RETRIES = 3;
    static final int DRAIN_THRESHOLD = 63;
    static final int DRAIN_MAX = 16;
    static final Logger logger = Logger.getLogger(LocalCache.class.getName());
    final int segmentMask;
    final int segmentShift;
    final Segment<K, V>[] segments;
    final int concurrencyLevel;
    final Equivalence<Object> keyEquivalence;
    final Equivalence<Object> valueEquivalence;
    final Strength keyStrength;
    final Strength valueStrength;
    final long maxWeight;
    final Weigher<K, V> weigher;
    final long expireAfterAccessNanos;
    final long expireAfterWriteNanos;
    final long refreshNanos;
    final Queue<RemovalNotification<K, V>> removalNotificationQueue;
    final RemovalListener<K, V> removalListener;
    final Ticker ticker;
    final EntryFactory entryFactory;
    final AbstractCache.StatsCounter globalStatsCounter;
    final CacheLoader<? super K, V> defaultLoader;
    static final ValueReference<Object, Object> UNSET = new ValueReference<Object, Object>(){

        @Override
        public Object get() {
            return null;
        }

        @Override
        public int getWeight() {
            return 0;
        }

        @Override
        public ReferenceEntry<Object, Object> getEntry() {
            return null;
        }

        @Override
        public ValueReference<Object, Object> copyFor(ReferenceQueue<Object> queue, Object value, ReferenceEntry<Object, Object> entry) {
            return this;
        }

        @Override
        public boolean isLoading() {
            return false;
        }

        @Override
        public boolean isActive() {
            return false;
        }

        @Override
        public Object waitForValue() {
            return null;
        }

        @Override
        public void notifyNewValue(Object newValue) {
        }
    };
    static final Queue<?> DISCARDING_QUEUE = new AbstractQueue<Object>(){

        @Override
        public boolean offer(Object o) {
            return true;
        }

        @Override
        public Object peek() {
            return null;
        }

        @Override
        public Object poll() {
            return null;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Iterator<Object> iterator() {
            return ((ImmutableCollection)ImmutableSet.of()).iterator();
        }
    };
    Set<K> keySet;
    Collection<V> values;
    Set<Map.Entry<K, V>> entrySet;

    LocalCache(CacheBuilder<? super K, ? super V> builder, CacheLoader<? super K, V> loader) {
        int segmentSize;
        int segmentCount;
        this.concurrencyLevel = Math.min(builder.getConcurrencyLevel(), 65536);
        this.keyStrength = builder.getKeyStrength();
        this.valueStrength = builder.getValueStrength();
        this.keyEquivalence = builder.getKeyEquivalence();
        this.valueEquivalence = builder.getValueEquivalence();
        this.maxWeight = builder.getMaximumWeight();
        this.weigher = builder.getWeigher();
        this.expireAfterAccessNanos = builder.getExpireAfterAccessNanos();
        this.expireAfterWriteNanos = builder.getExpireAfterWriteNanos();
        this.refreshNanos = builder.getRefreshNanos();
        this.removalListener = builder.getRemovalListener();
        this.removalNotificationQueue = this.removalListener == CacheBuilder.NullListener.INSTANCE ? LocalCache.discardingQueue() : new ConcurrentLinkedQueue();
        this.ticker = builder.getTicker(this.recordsTime());
        this.entryFactory = EntryFactory.getFactory(this.keyStrength, this.usesAccessEntries(), this.usesWriteEntries());
        this.globalStatsCounter = builder.getStatsCounterSupplier().get();
        this.defaultLoader = loader;
        int initialCapacity = Math.min(builder.getInitialCapacity(), 0x40000000);
        if (this.evictsBySize() && !this.customWeigher()) {
            initialCapacity = (int)Math.min((long)initialCapacity, this.maxWeight);
        }
        int segmentShift = 0;
        for (segmentCount = 1; !(segmentCount >= this.concurrencyLevel || this.evictsBySize() && (long)(segmentCount * 20) > this.maxWeight); segmentCount <<= 1) {
            ++segmentShift;
        }
        this.segmentShift = 32 - segmentShift;
        this.segmentMask = segmentCount - 1;
        this.segments = this.newSegmentArray(segmentCount);
        int segmentCapacity = initialCapacity / segmentCount;
        if (segmentCapacity * segmentCount < initialCapacity) {
            ++segmentCapacity;
        }
        for (segmentSize = 1; segmentSize < segmentCapacity; segmentSize <<= 1) {
        }
        if (this.evictsBySize()) {
            long maxSegmentWeight = this.maxWeight / (long)segmentCount + 1L;
            long remainder = this.maxWeight % (long)segmentCount;
            for (int i = 0; i < this.segments.length; ++i) {
                if ((long)i == remainder) {
                    --maxSegmentWeight;
                }
                this.segments[i] = this.createSegment(segmentSize, maxSegmentWeight, builder.getStatsCounterSupplier().get());
            }
            return;
        }
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i] = this.createSegment(segmentSize, -1L, builder.getStatsCounterSupplier().get());
        }
    }

    boolean evictsBySize() {
        return this.maxWeight >= 0L;
    }

    boolean customWeigher() {
        return this.weigher != CacheBuilder.OneWeigher.INSTANCE;
    }

    boolean expires() {
        return this.expiresAfterWrite() || this.expiresAfterAccess();
    }

    boolean expiresAfterWrite() {
        return this.expireAfterWriteNanos > 0L;
    }

    boolean expiresAfterAccess() {
        return this.expireAfterAccessNanos > 0L;
    }

    boolean refreshes() {
        return this.refreshNanos > 0L;
    }

    boolean usesAccessQueue() {
        return this.expiresAfterAccess() || this.evictsBySize();
    }

    boolean usesWriteQueue() {
        return this.expiresAfterWrite();
    }

    boolean recordsWrite() {
        return this.expiresAfterWrite() || this.refreshes();
    }

    boolean recordsAccess() {
        return this.expiresAfterAccess();
    }

    boolean recordsTime() {
        return this.recordsWrite() || this.recordsAccess();
    }

    boolean usesWriteEntries() {
        return this.usesWriteQueue() || this.recordsWrite();
    }

    boolean usesAccessEntries() {
        return this.usesAccessQueue() || this.recordsAccess();
    }

    boolean usesKeyReferences() {
        return this.keyStrength != Strength.STRONG;
    }

    boolean usesValueReferences() {
        return this.valueStrength != Strength.STRONG;
    }

    static <K, V> ValueReference<K, V> unset() {
        return UNSET;
    }

    static <K, V> ReferenceEntry<K, V> nullEntry() {
        return NullEntry.INSTANCE;
    }

    static <E> Queue<E> discardingQueue() {
        return DISCARDING_QUEUE;
    }

    static int rehash(int h) {
        int n;
        int n2 = h;
        h = n2 + (n2 << 15 ^ 0xFFFFCD7D);
        h ^= h >>> 10;
        h += h << 3;
        h ^= h >>> 6;
        h += (h << 2) + (h << 14);
        return h ^ n >>> 16;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    ReferenceEntry<K, V> newEntry(K key, int hash, ReferenceEntry<K, V> next) {
        Segment<void, V> segment = this.segmentFor(hash);
        segment.lock();
        try {
            void var3_4;
            void var2_3;
            ReferenceEntry<void, V> referenceEntry;
            referenceEntry = segment.newEntry((void)referenceEntry, (int)var2_3, (ReferenceEntry<void, V>)var3_4);
            return referenceEntry;
        }
        finally {
            segment.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    ReferenceEntry<K, V> copyEntry(ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
        void var2_2;
        void var1_1;
        void var3_3;
        int hash = original.getHash();
        return this.segmentFor((int)var3_3).copyEntry((ReferenceEntry<K, V>)var1_1, (ReferenceEntry<K, V>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    ValueReference<K, V> newValueReference(ReferenceEntry<K, V> entry, V value, int weight) {
        void var3_3;
        void var2_2;
        void var1_1;
        int hash = entry.getHash();
        return this.valueStrength.referenceValue(this.segmentFor(hash), var1_1, Preconditions.checkNotNull(var2_2), (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    int hash(Object key) {
        void var1_1;
        int n = this.keyEquivalence.hash(var1_1);
        return LocalCache.rehash(n);
    }

    /*
     * WARNING - void declaration
     */
    void reclaimValue(ValueReference<K, V> valueReference) {
        void var1_1;
        void var3_3;
        void var2_2;
        ReferenceEntry<K, V> entry = valueReference.getEntry();
        int hash = entry.getHash();
        this.segmentFor(hash).reclaimValue(var2_2.getKey(), (int)var3_3, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    void reclaimKey(ReferenceEntry<K, V> entry) {
        void var2_2;
        void var1_1;
        int hash = entry.getHash();
        this.segmentFor(hash).reclaimKey((ReferenceEntry<K, V>)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    boolean isLive(ReferenceEntry<K, V> entry, long now) {
        void var2_2;
        void var1_1;
        return this.segmentFor(entry.getHash()).getLiveValue((ReferenceEntry<K, V>)var1_1, (long)var2_2) != null;
    }

    /*
     * WARNING - void declaration
     */
    Segment<K, V> segmentFor(int hash) {
        void var1_1;
        return this.segments[var1_1 >>> this.segmentShift & this.segmentMask];
    }

    /*
     * WARNING - void declaration
     */
    Segment<K, V> createSegment(int initialCapacity, long maxSegmentWeight, AbstractCache.StatsCounter statsCounter) {
        void var2_2;
        void var1_1;
        return new Segment(this, (int)var1_1, (long)var2_2, statsCounter);
    }

    /*
     * WARNING - void declaration
     */
    V getLiveValue(ReferenceEntry<K, V> entry, long now) {
        void var2_2;
        void var1_1;
        if (entry.getKey() == null) {
            return null;
        }
        V value = entry.getValueReference().get();
        if (value == null) {
            return null;
        }
        if (this.isExpired((ReferenceEntry<K, V>)var1_1, (long)var2_2)) {
            return null;
        }
        return value;
    }

    /*
     * WARNING - void declaration
     */
    boolean isExpired(ReferenceEntry<K, V> entry, long now) {
        void var1_1;
        void var2_2;
        Preconditions.checkNotNull(entry);
        if (this.expiresAfterAccess() && now - entry.getAccessTime() >= this.expireAfterAccessNanos) {
            return true;
        }
        return this.expiresAfterWrite() && var2_2 - var1_1.getWriteTime() >= this.expireAfterWriteNanos;
    }

    /*
     * WARNING - void declaration
     */
    static <K, V> void connectAccessOrder(ReferenceEntry<K, V> previous, ReferenceEntry<K, V> next) {
        ReferenceEntry<K, V> referenceEntry;
        void var1_1;
        previous.setNextInAccessQueue(next);
        var1_1.setPreviousInAccessQueue(referenceEntry);
    }

    /*
     * WARNING - void declaration
     */
    static <K, V> void nullifyAccessOrder(ReferenceEntry<K, V> nulled) {
        void var1_1;
        ReferenceEntry<K, V> referenceEntry;
        ReferenceEntry<K, V> nullEntry = LocalCache.nullEntry();
        nulled.setNextInAccessQueue(nullEntry);
        referenceEntry.setPreviousInAccessQueue((ReferenceEntry<K, V>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static <K, V> void connectWriteOrder(ReferenceEntry<K, V> previous, ReferenceEntry<K, V> next) {
        ReferenceEntry<K, V> referenceEntry;
        void var1_1;
        previous.setNextInWriteQueue(next);
        var1_1.setPreviousInWriteQueue(referenceEntry);
    }

    /*
     * WARNING - void declaration
     */
    static <K, V> void nullifyWriteOrder(ReferenceEntry<K, V> nulled) {
        void var1_1;
        ReferenceEntry<K, V> referenceEntry;
        ReferenceEntry<K, V> nullEntry = LocalCache.nullEntry();
        nulled.setNextInWriteQueue(nullEntry);
        referenceEntry.setPreviousInWriteQueue((ReferenceEntry<K, V>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    void processPendingNotifications() {
        RemovalNotification<K, V> notification;
        while ((notification = this.removalNotificationQueue.poll()) != null) {
            try {
                this.removalListener.onRemoval(notification);
            }
            catch (Throwable e) {
                void var1_2;
                logger.log(Level.WARNING, "Exception thrown by removal listener", (Throwable)var1_2);
            }
        }
    }

    final Segment<K, V>[] newSegmentArray(int ssize) {
        return new Segment[ssize];
    }

    public void cleanUp() {
        Segment<K, V>[] segmentArray = this.segments;
        int n = this.segments.length;
        for (int i = 0; i < n; ++i) {
            Segment<K, V> segment = segmentArray[i];
            segment.cleanUp();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isEmpty() {
        int i;
        long sum = 0L;
        Segment<K, V>[] segments = this.segments;
        for (i = 0; i < segments.length; ++i) {
            if (segments[i].count != 0) {
                return false;
            }
            sum += (long)segments[i].modCount;
        }
        if (sum != 0L) {
            void var1_1;
            for (i = 0; i < segments.length; ++i) {
                if (segments[i].count != 0) {
                    return false;
                }
                sum -= (long)segments[i].modCount;
            }
            return var1_1 == 0L;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    long longSize() {
        void var2_2;
        Segment<K, V>[] segments = this.segments;
        long sum = 0L;
        for (int i = 0; i < segments.length; ++i) {
            sum += (long)segments[i].count;
        }
        return (long)var2_2;
    }

    @Override
    public int size() {
        return Ints.saturatedCast(this.longSize());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V get(Object key) {
        void var2_2;
        void var1_1;
        if (key == null) {
            return null;
        }
        int hash = this.hash(key);
        return this.segmentFor(hash).get(var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    V get(K key, CacheLoader<? super K, V> loader) throws ExecutionException {
        void var2_2;
        void var3_3;
        void var1_1;
        int hash = this.hash(Preconditions.checkNotNull(key));
        return this.segmentFor(hash).get(var1_1, (int)var3_3, (CacheLoader<void, V>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public V getIfPresent(Object key) {
        void var1_1;
        void var2_2;
        int hash = this.hash(Preconditions.checkNotNull(key));
        V value = this.segmentFor(hash).get(key, (int)var2_2);
        if (value == null) {
            this.globalStatsCounter.recordMisses(1);
        } else {
            this.globalStatsCounter.recordHits(1);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V getOrDefault(Object key, V defaultValue) {
        void var2_2;
        V result = this.get(key);
        if (result != null) {
            void var1_1;
            return var1_1;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    V getOrLoad(K key) throws ExecutionException {
        void var1_1;
        return this.get(var1_1, this.defaultLoader);
    }

    /*
     * WARNING - void declaration
     */
    ImmutableMap<K, V> getAllPresent(Iterable<?> keys) {
        void var3_3;
        void var2_2;
        Iterator iterator;
        int hits = 0;
        int misses = 0;
        ImmutableMap.Builder result = ImmutableMap.builder();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            V value = this.get(key);
            if (value == null) {
                ++misses;
                continue;
            }
            Object castKey = key;
            result.put(castKey, value);
            ++hits;
        }
        this.globalStatsCounter.recordHits((int)var2_2);
        this.globalStatsCounter.recordMisses((int)var3_3);
        return result.buildKeepingLast();
    }

    /*
     * WARNING - void declaration
     */
    ImmutableMap<K, V> getAll(Iterable<? extends K> keys) throws ExecutionException {
        int hits = 0;
        int misses = 0;
        LinkedHashMap result = Maps.newLinkedHashMap();
        LinkedHashSet keysToLoad = Sets.newLinkedHashSet();
        keys = keys.iterator();
        while (keys.hasNext()) {
            Object key = keys.next();
            V value = this.get(key);
            if (result.containsKey(key)) continue;
            result.put(key, value);
            if (value == null) {
                ++misses;
                keysToLoad.add(key);
                continue;
            }
            ++hits;
        }
        try {
            if (!keysToLoad.isEmpty()) {
                try {
                    Object newEntries = this.loadAll(Collections.unmodifiableSet(keysToLoad), this.defaultLoader);
                    for (Object key : keysToLoad) {
                        V value = newEntries.get(key);
                        if (value == null) {
                            newEntries = String.valueOf(key);
                            throw new CacheLoader.InvalidCacheLoadException(new StringBuilder(37 + String.valueOf(newEntries).length()).append("loadAll failed to return a value for ").append((String)newEntries).toString());
                        }
                        result.put(key, value);
                    }
                }
                catch (CacheLoader.UnsupportedLoadingOperationException unsupportedLoadingOperationException) {
                    for (Object key : keysToLoad) {
                        --misses;
                        result.put(key, this.get(key, this.defaultLoader));
                    }
                }
            }
            ImmutableMap immutableMap = ImmutableMap.copyOf(result);
            this.globalStatsCounter.recordHits(hits);
            this.globalStatsCounter.recordMisses(misses);
            return immutableMap;
        }
        catch (Throwable throwable) {
            void var3_4;
            void var2_3;
            this.globalStatsCounter.recordHits((int)var2_3);
            this.globalStatsCounter.recordMisses((int)var3_4);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    Map<K, V> loadAll(Set<? extends K> keys, CacheLoader<? super K, V> loader) throws ExecutionException {
        void var1_1;
        void var3_3;
        Map<K, V> result;
        Preconditions.checkNotNull(loader);
        Preconditions.checkNotNull(keys);
        Stopwatch stopwatch = Stopwatch.createStarted();
        boolean success = false;
        try {
            try {
                Map<K, V> map;
                result = map = loader.loadAll(keys);
            }
            catch (CacheLoader.UnsupportedLoadingOperationException e) {
                success = true;
                throw e;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ExecutionException(e);
            }
            catch (RuntimeException e) {
                throw new UncheckedExecutionException(e);
            }
            catch (Exception e) {
                throw new ExecutionException(e);
            }
            catch (Error e) {
                throw new ExecutionError(e);
            }
        }
        catch (Throwable throwable) {
            if (!success) {
                this.globalStatsCounter.recordLoadException(stopwatch.elapsed(TimeUnit.NANOSECONDS));
            }
            throw throwable;
        }
        if (result == null) {
            this.globalStatsCounter.recordLoadException(stopwatch.elapsed(TimeUnit.NANOSECONDS));
            String e = String.valueOf(loader);
            throw new CacheLoader.InvalidCacheLoadException(new StringBuilder(31 + String.valueOf(e).length()).append(e).append(" returned null map from loadAll").toString());
        }
        stopwatch.stop();
        boolean nullsPresent = false;
        for (Map.Entry<K, V> entry : result.entrySet()) {
            K key = entry.getKey();
            V value = entry.getValue();
            if (key == null || value == null) {
                nullsPresent = true;
                continue;
            }
            this.put(key, value);
        }
        if (nullsPresent) {
            void var2_2;
            this.globalStatsCounter.recordLoadException(stopwatch.elapsed(TimeUnit.NANOSECONDS));
            String string = String.valueOf(var2_2);
            throw new CacheLoader.InvalidCacheLoadException(new StringBuilder(42 + String.valueOf(string).length()).append(string).append(" returned null keys or values from loadAll").toString());
        }
        this.globalStatsCounter.recordLoadSuccess(var3_3.elapsed(TimeUnit.NANOSECONDS));
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    ReferenceEntry<K, V> getEntry(Object key) {
        void var2_2;
        void var1_1;
        if (key == null) {
            return null;
        }
        int hash = this.hash(key);
        return this.segmentFor(hash).getEntry(var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    void refresh(K key) {
        void var2_2;
        void var1_1;
        int hash = this.hash(Preconditions.checkNotNull(key));
        this.segmentFor(hash).refresh(var1_1, (int)var2_2, this.defaultLoader, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsKey(Object key) {
        void var2_2;
        void var1_1;
        if (key == null) {
            return false;
        }
        int hash = this.hash(key);
        return this.segmentFor(hash).containsKey(var1_1, (int)var2_2);
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            return false;
        }
        long now = this.ticker.read();
        Segment<K, V>[] segments = this.segments;
        long last = -1L;
        for (int i = 0; i < 3; ++i) {
            long sum = 0L;
            Segment<K, V>[] segmentArray = segments;
            int n = segments.length;
            for (int j = 0; j < n; ++j) {
                Segment segment = segmentArray[j];
                int cfr_ignored_0 = segment.count;
                AtomicReferenceArray table = segment.table;
                for (int j2 = 0; j2 < table.length(); ++j2) {
                    for (ReferenceEntry e = table.get(j2); e != null; e = e.getNext()) {
                        V v = segment.getLiveValue(e, now);
                        if (v == null || !this.valueEquivalence.equivalent(value, v)) continue;
                        return true;
                    }
                }
                sum += (long)segment.modCount;
            }
            if (sum == last) break;
            last = sum;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V put(K key, V value) {
        void var2_2;
        void var3_3;
        void var1_1;
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(value);
        int hash = this.hash(key);
        return this.segmentFor(hash).put(var1_1, (int)var3_3, var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V putIfAbsent(K key, V value) {
        void var2_2;
        void var3_3;
        void var1_1;
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(value);
        int hash = this.hash(key);
        return this.segmentFor(hash).put(var1_1, (int)var3_3, var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> function) {
        void var2_2;
        void var3_3;
        void var1_1;
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(function);
        int hash = this.hash(key);
        return this.segmentFor(hash).compute(var1_1, (int)var3_3, (BiFunction<void, V, V>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V computeIfAbsent(K key, java.util.function.Function<? super K, ? extends V> function) {
        void var1_1;
        void var2_2;
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(function);
        return (V)this.compute(key, (arg_0, arg_1) -> LocalCache.lambda$computeIfAbsent$0((java.util.function.Function)var2_2, var1_1, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> function) {
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(function);
        return (V)this.compute(var1_1, (arg_0, arg_1) -> LocalCache.lambda$computeIfPresent$1((BiFunction)var2_2, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V merge(K key, V newValue, BiFunction<? super V, ? super V, ? extends V> function) {
        void var3_3;
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(newValue);
        Preconditions.checkNotNull(function);
        return (V)this.compute(var1_1, (arg_0, arg_1) -> LocalCache.lambda$merge$2(var2_2, (BiFunction)var3_3, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            void var2_2;
            this.put(e.getKey(), var2_2.getValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V remove(Object key) {
        void var2_2;
        void var1_1;
        if (key == null) {
            return null;
        }
        int hash = this.hash(key);
        return this.segmentFor(hash).remove(var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean remove(Object key, Object value) {
        void var2_2;
        void var3_3;
        void var1_1;
        if (key == null || value == null) {
            return false;
        }
        int hash = this.hash(key);
        return this.segmentFor(hash).remove(var1_1, (int)var3_3, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        void var3_3;
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(newValue);
        if (oldValue == null) {
            return false;
        }
        int hash = this.hash(key);
        return this.segmentFor(hash).replace(var1_1, hash, var2_2, var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V replace(K key, V value) {
        void var2_2;
        void var3_3;
        void var1_1;
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(value);
        int hash = this.hash(key);
        return this.segmentFor(hash).replace(var1_1, (int)var3_3, var2_2);
    }

    @Override
    public void clear() {
        Segment<K, V>[] segmentArray = this.segments;
        int n = this.segments.length;
        for (int i = 0; i < n; ++i) {
            Segment<K, V> segment = segmentArray[i];
            segment.clear();
        }
    }

    /*
     * WARNING - void declaration
     */
    void invalidateAll(Iterable<?> keys) {
        for (Object key : keys) {
            void var2_2;
            this.remove(var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Set<K> keySet() {
        Set<K> ks = this.keySet;
        if (ks != null) {
            void var1_1;
            return var1_1;
        }
        this.keySet = new KeySet();
        return this.keySet;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Collection<V> values() {
        Collection<V> vs = this.values;
        if (vs != null) {
            void var1_1;
            return var1_1;
        }
        this.values = new Values(this);
        return this.values;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @GwtIncompatible
    public Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<K, V>> es = this.entrySet;
        if (es != null) {
            void var1_1;
            return var1_1;
        }
        this.entrySet = new EntrySet();
        return this.entrySet;
    }

    /*
     * WARNING - void declaration
     */
    private static <E> ArrayList<E> toArrayList(Collection<E> c) {
        void var1_1;
        Collection<E> collection;
        ArrayList result = new ArrayList(c.size());
        Iterators.addAll(result, collection.iterator());
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    boolean removeIf(BiPredicate<? super K, ? super V> filter) {
        void var2_2;
        Preconditions.checkNotNull(filter);
        boolean changed = false;
        block0: for (K key : this.keySet()) {
            V value;
            while ((value = this.get(key)) != null && filter.test(key, value)) {
                if (!this.remove(key, value)) continue;
                changed = true;
                continue block0;
            }
        }
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ Object lambda$merge$2(Object newValue, BiFunction function, Object k, Object oldValue) {
        Object object;
        void var3_3;
        void var1_1;
        if (oldValue == null) {
            return newValue;
        }
        return var1_1.apply(var3_3, object);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ Object lambda$computeIfPresent$1(BiFunction function, Object k, Object oldValue) {
        void var2_2;
        void var1_1;
        BiFunction biFunction;
        if (oldValue == null) {
            return null;
        }
        return biFunction.apply(var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ Object lambda$computeIfAbsent$0(java.util.function.Function function, Object key, Object k, Object oldValue) {
        void var3_3;
        if (oldValue == null) {
            void var1_1;
            java.util.function.Function function2;
            return function2.apply(var1_1);
        }
        return var3_3;
    }

    static class LocalLoadingCache<K, V>
    extends LocalManualCache<K, V>
    implements LoadingCache<K, V> {
        private static final long serialVersionUID = 1L;

        /*
         * WARNING - void declaration
         */
        LocalLoadingCache(CacheBuilder<? super K, ? super V> builder, CacheLoader<? super K, V> loader) {
            super(new LocalCache(var1_1, (CacheLoader)Preconditions.checkNotNull(var2_2)));
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V get(K key) throws ExecutionException {
            void var1_1;
            return this.localCache.getOrLoad(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V getUnchecked(K key) {
            try {
                return this.get(key);
            }
            catch (ExecutionException e) {
                void var1_2;
                throw new UncheckedExecutionException(var1_2.getCause());
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ImmutableMap<K, V> getAll(Iterable<? extends K> keys) throws ExecutionException {
            void var1_1;
            return this.localCache.getAll(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void refresh(K key) {
            void var1_1;
            this.localCache.refresh(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final V apply(K key) {
            void var1_1;
            return this.getUnchecked(var1_1);
        }

        @Override
        Object writeReplace() {
            return new LoadingSerializationProxy(this.localCache);
        }
    }

    static class LocalManualCache<K, V>
    implements Cache<K, V>,
    Serializable {
        final LocalCache<K, V> localCache;
        private static final long serialVersionUID = 1L;

        /*
         * WARNING - void declaration
         */
        LocalManualCache(CacheBuilder<? super K, ? super V> builder) {
            this(new LocalCache(var1_1, null));
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private LocalManualCache(LocalCache<K, V> localCache) {
            void var1_1;
            this.localCache = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V getIfPresent(Object key) {
            void var1_1;
            return this.localCache.getIfPresent(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V get(K key, Callable<? extends V> valueLoader) throws ExecutionException {
            void var2_2;
            void var1_1;
            Preconditions.checkNotNull(valueLoader);
            return this.localCache.get(var1_1, new CacheLoader<Object, V>(this, (Callable)var2_2){
                final /* synthetic */ Callable val$valueLoader;
                {
                    this.val$valueLoader = callable;
                }

                @Override
                public V load(Object key) throws Exception {
                    return this.val$valueLoader.call();
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ImmutableMap<K, V> getAllPresent(Iterable<?> keys) {
            void var1_1;
            return this.localCache.getAllPresent((Iterable<?>)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void put(K key, V value) {
            void var2_2;
            void var1_1;
            this.localCache.put(var1_1, var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            void var1_1;
            this.localCache.putAll((Map<K, V>)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void invalidate(Object key) {
            void var1_1;
            Preconditions.checkNotNull(key);
            this.localCache.remove(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void invalidateAll(Iterable<?> keys) {
            void var1_1;
            this.localCache.invalidateAll((Iterable<?>)var1_1);
        }

        @Override
        public void invalidateAll() {
            this.localCache.clear();
        }

        @Override
        public long size() {
            return this.localCache.longSize();
        }

        @Override
        public ConcurrentMap<K, V> asMap() {
            return this.localCache;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public CacheStats stats() {
            void var1_1;
            AbstractCache.SimpleStatsCounter aggregator = new AbstractCache.SimpleStatsCounter();
            aggregator.incrementBy(this.localCache.globalStatsCounter);
            Segment<K, V>[] segmentArray = this.localCache.segments;
            int n = this.localCache.segments.length;
            for (int i = 0; i < n; ++i) {
                Segment segment = segmentArray[i];
                aggregator.incrementBy(segment.statsCounter);
            }
            return var1_1.snapshot();
        }

        @Override
        public void cleanUp() {
            this.localCache.cleanUp();
        }

        Object writeReplace() {
            return new ManualSerializationProxy<K, V>(this.localCache);
        }
    }

    static final class LoadingSerializationProxy<K, V>
    extends ManualSerializationProxy<K, V>
    implements LoadingCache<K, V>,
    Serializable {
        private static final long serialVersionUID = 1L;
        transient LoadingCache<K, V> autoDelegate;

        /*
         * WARNING - void declaration
         */
        LoadingSerializationProxy(LocalCache<K, V> cache) {
            super(var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            void var1_1;
            in.defaultReadObject();
            CacheBuilder builder = this.recreateCacheBuilder();
            this.autoDelegate = var1_1.build(this.loader);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final V get(K key) throws ExecutionException {
            void var1_1;
            return this.autoDelegate.get(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final V getUnchecked(K key) {
            void var1_1;
            return this.autoDelegate.getUnchecked(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ImmutableMap<K, V> getAll(Iterable<? extends K> keys) throws ExecutionException {
            void var1_1;
            return this.autoDelegate.getAll((Iterable<K>)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final V apply(K key) {
            void var1_1;
            return this.autoDelegate.apply(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void refresh(K key) {
            void var1_1;
            this.autoDelegate.refresh(var1_1);
        }

        private Object readResolve() {
            return this.autoDelegate;
        }
    }

    static class ManualSerializationProxy<K, V>
    extends ForwardingCache<K, V>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final Strength keyStrength;
        final Strength valueStrength;
        final Equivalence<Object> keyEquivalence;
        final Equivalence<Object> valueEquivalence;
        final long expireAfterWriteNanos;
        final long expireAfterAccessNanos;
        final long maxWeight;
        final Weigher<K, V> weigher;
        final int concurrencyLevel;
        final RemovalListener<? super K, ? super V> removalListener;
        final Ticker ticker;
        final CacheLoader<? super K, V> loader;
        transient Cache<K, V> delegate;

        /*
         * WARNING - void declaration
         */
        ManualSerializationProxy(LocalCache<K, V> cache) {
            this(cache.keyStrength, cache.valueStrength, cache.keyEquivalence, cache.valueEquivalence, cache.expireAfterWriteNanos, cache.expireAfterAccessNanos, cache.maxWeight, cache.weigher, cache.concurrencyLevel, cache.removalListener, cache.ticker, var1_1.defaultLoader);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private ManualSerializationProxy(Strength keyStrength, Strength valueStrength, Equivalence<Object> keyEquivalence, Equivalence<Object> valueEquivalence, long expireAfterWriteNanos, long expireAfterAccessNanos, long maxWeight, Weigher<K, V> weigher, int concurrencyLevel, RemovalListener<? super K, ? super V> removalListener, Ticker ticker, CacheLoader<? super K, V> loader) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.keyStrength = var1_1;
            this.valueStrength = var2_2;
            this.keyEquivalence = var3_3;
            this.valueEquivalence = valueEquivalence;
            this.expireAfterWriteNanos = expireAfterWriteNanos;
            this.expireAfterAccessNanos = expireAfterAccessNanos;
            this.maxWeight = maxWeight;
            this.weigher = weigher;
            this.concurrencyLevel = concurrencyLevel;
            this.removalListener = removalListener;
            this.ticker = ticker == Ticker.systemTicker() || ticker == CacheBuilder.NULL_TICKER ? null : ticker;
            this.loader = loader;
        }

        /*
         * WARNING - void declaration
         */
        CacheBuilder<K, V> recreateCacheBuilder() {
            void var1_1;
            CacheBuilder<K, V> builder = CacheBuilder.newBuilder().setKeyStrength(this.keyStrength).setValueStrength(this.valueStrength).keyEquivalence(this.keyEquivalence).valueEquivalence(this.valueEquivalence).concurrencyLevel(this.concurrencyLevel).removalListener(this.removalListener);
            CacheBuilder.newBuilder().setKeyStrength(this.keyStrength).setValueStrength(this.valueStrength).keyEquivalence(this.keyEquivalence).valueEquivalence(this.valueEquivalence).concurrencyLevel(this.concurrencyLevel).removalListener(this.removalListener).strictParsing = false;
            if (this.expireAfterWriteNanos > 0L) {
                builder.expireAfterWrite(this.expireAfterWriteNanos, TimeUnit.NANOSECONDS);
            }
            if (this.expireAfterAccessNanos > 0L) {
                builder.expireAfterAccess(this.expireAfterAccessNanos, TimeUnit.NANOSECONDS);
            }
            if (this.weigher != CacheBuilder.OneWeigher.INSTANCE) {
                builder.weigher(this.weigher);
                if (this.maxWeight != -1L) {
                    builder.maximumWeight(this.maxWeight);
                }
            } else if (this.maxWeight != -1L) {
                builder.maximumSize(this.maxWeight);
            }
            if (this.ticker != null) {
                builder.ticker(this.ticker);
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            void var1_1;
            in.defaultReadObject();
            CacheBuilder<K, V> builder = this.recreateCacheBuilder();
            this.delegate = var1_1.build();
        }

        private Object readResolve() {
            return this.delegate;
        }

        @Override
        protected Cache<K, V> delegate() {
            return this.delegate;
        }
    }

    final class EntrySet
    extends AbstractCacheSet<Map.Entry<K, V>> {
        /*
         * WARNING - void declaration
         */
        EntrySet() {
            void var1_1;
            super((LocalCache)var1_1);
        }

        @Override
        public final Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator(LocalCache.this);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean removeIf(Predicate<? super Map.Entry<K, V>> filter) {
            void var1_1;
            Preconditions.checkNotNull(filter);
            return LocalCache.this.removeIf((arg_0, arg_1) -> EntrySet.lambda$removeIf$0((Predicate)var1_1, arg_0, arg_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean contains(Object o) {
            void var2_2;
            void var1_1;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (key == null) {
                return false;
            }
            Object v = LocalCache.this.get(key);
            return v != null && LocalCache.this.valueEquivalence.equivalent(var1_1.getValue(), var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean remove(Object o) {
            void var1_1;
            void var2_2;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            return key != null && LocalCache.this.remove(var2_2, var1_1.getValue());
        }

        /*
         * WARNING - void declaration
         */
        private static /* synthetic */ boolean lambda$removeIf$0(Predicate filter, Object k, Object v) {
            void var2_2;
            void var1_1;
            return filter.test(Maps.immutableEntry(var1_1, var2_2));
        }
    }

    final class Values
    extends AbstractCollection<V> {
        final /* synthetic */ LocalCache this$0;

        /*
         * WARNING - void declaration
         */
        Values(LocalCache this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        public final int size() {
            return this.this$0.size();
        }

        @Override
        public final boolean isEmpty() {
            return this.this$0.isEmpty();
        }

        @Override
        public final void clear() {
            this.this$0.clear();
        }

        @Override
        public final Iterator<V> iterator() {
            return new ValueIterator(this.this$0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean removeIf(Predicate<? super V> filter) {
            void var1_1;
            Preconditions.checkNotNull(filter);
            return this.this$0.removeIf((arg_0, arg_1) -> Values.lambda$removeIf$0((Predicate)var1_1, arg_0, arg_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean contains(Object o) {
            void var1_1;
            return this.this$0.containsValue(var1_1);
        }

        @Override
        public final Object[] toArray() {
            return LocalCache.toArrayList(this).toArray();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final <E> E[] toArray(E[] a) {
            void var1_1;
            return LocalCache.toArrayList(this).toArray((T[])var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private static /* synthetic */ boolean lambda$removeIf$0(Predicate filter, Object k, Object v) {
            void var2_2;
            return filter.test(var2_2);
        }
    }

    final class KeySet
    extends AbstractCacheSet<K> {
        /*
         * WARNING - void declaration
         */
        KeySet() {
            void var1_1;
            super((LocalCache)var1_1);
        }

        @Override
        public final Iterator<K> iterator() {
            return new KeyIterator(LocalCache.this);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean contains(Object o) {
            void var1_1;
            return LocalCache.this.containsKey(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean remove(Object o) {
            void var1_1;
            return LocalCache.this.remove(var1_1) != null;
        }
    }

    abstract class AbstractCacheSet<T>
    extends AbstractSet<T> {
        final /* synthetic */ LocalCache this$0;

        /*
         * WARNING - void declaration
         */
        AbstractCacheSet(LocalCache this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        public int size() {
            return this.this$0.size();
        }

        @Override
        public boolean isEmpty() {
            return this.this$0.isEmpty();
        }

        @Override
        public void clear() {
            this.this$0.clear();
        }

        @Override
        public Object[] toArray() {
            return LocalCache.toArrayList(this).toArray();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public <E> E[] toArray(E[] a) {
            void var1_1;
            return LocalCache.toArrayList(this).toArray((T[])var1_1);
        }
    }

    final class EntryIterator
    extends HashIterator<Map.Entry<K, V>> {
        /*
         * WARNING - void declaration
         */
        EntryIterator(LocalCache this$0) {
            void var1_1;
        }

        @Override
        public final Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    final class WriteThroughEntry
    implements Map.Entry<K, V> {
        final K key;
        V value;
        final /* synthetic */ LocalCache this$0;

        /*
         * WARNING - void declaration
         */
        WriteThroughEntry(LocalCache this$0, K key, V value) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            this.key = var2_2;
            this.value = var3_3;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean equals(Object object) {
            if (object instanceof Map.Entry) {
                void var1_1;
                Map.Entry that = (Map.Entry)object;
                return this.key.equals(that.getKey()) && this.value.equals(var1_1.getValue());
            }
            return false;
        }

        @Override
        public final int hashCode() {
            return this.key.hashCode() ^ this.value.hashCode();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final V setValue(V newValue) {
            void var2_2;
            void var1_1;
            Object oldValue = this.this$0.put(this.key, newValue);
            this.value = var1_1;
            return var2_2;
        }

        public final String toString() {
            String string = String.valueOf(this.getKey());
            String string2 = String.valueOf(this.getValue());
            return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("=").append(string2).toString();
        }
    }

    final class ValueIterator
    extends HashIterator<V> {
        /*
         * WARNING - void declaration
         */
        ValueIterator(LocalCache this$0) {
            void var1_1;
        }

        @Override
        public final V next() {
            return this.nextEntry().getValue();
        }
    }

    final class KeyIterator
    extends HashIterator<K> {
        /*
         * WARNING - void declaration
         */
        KeyIterator(LocalCache this$0) {
            void var1_1;
        }

        @Override
        public final K next() {
            return this.nextEntry().getKey();
        }
    }

    abstract class HashIterator<T>
    implements Iterator<T> {
        int nextSegmentIndex;
        int nextTableIndex;
        Segment<K, V> currentSegment;
        AtomicReferenceArray<ReferenceEntry<K, V>> currentTable;
        ReferenceEntry<K, V> nextEntry;
        WriteThroughEntry nextExternal;
        WriteThroughEntry lastReturned;

        /*
         * WARNING - void declaration
         */
        HashIterator() {
            void var1_1;
            this.nextSegmentIndex = var1_1.segments.length - 1;
            this.nextTableIndex = -1;
            this.advance();
        }

        @Override
        public abstract T next();

        final void advance() {
            this.nextExternal = null;
            if (this.nextInChain()) {
                return;
            }
            if (this.nextInTable()) {
                return;
            }
            while (this.nextSegmentIndex >= 0) {
                this.currentSegment = LocalCache.this.segments[this.nextSegmentIndex--];
                if (this.currentSegment.count == 0) continue;
                this.currentTable = this.currentSegment.table;
                this.nextTableIndex = this.currentTable.length() - 1;
                if (!this.nextInTable()) continue;
                return;
            }
        }

        boolean nextInChain() {
            if (this.nextEntry != null) {
                this.nextEntry = this.nextEntry.getNext();
                while (this.nextEntry != null) {
                    HashIterator hashIterator = this;
                    if (hashIterator.advanceTo(hashIterator.nextEntry)) {
                        return true;
                    }
                    this.nextEntry = this.nextEntry.getNext();
                }
            }
            return false;
        }

        boolean nextInTable() {
            while (this.nextTableIndex >= 0) {
                if ((this.nextEntry = this.currentTable.get(this.nextTableIndex--)) == null) continue;
                HashIterator hashIterator = this;
                if (!hashIterator.advanceTo(hashIterator.nextEntry) && !this.nextInChain()) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        boolean advanceTo(ReferenceEntry<K, V> entry) {
            try {
                void var2_3;
                long now = LocalCache.this.ticker.read();
                Object key = entry.getKey();
                Object value = LocalCache.this.getLiveValue(entry, (long)var2_3);
                if (value != null) {
                    void var1_1;
                    this.nextExternal = new WriteThroughEntry(LocalCache.this, key, var1_1);
                    return true;
                }
                return false;
            }
            finally {
                this.currentSegment.postReadCleanup();
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextExternal != null;
        }

        WriteThroughEntry nextEntry() {
            if (this.nextExternal == null) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.nextExternal;
            this.advance();
            return this.lastReturned;
        }

        @Override
        public void remove() {
            Preconditions.checkState(this.lastReturned != null);
            LocalCache.this.remove(this.lastReturned.getKey());
            this.lastReturned = null;
        }
    }

    static final class AccessQueue<K, V>
    extends AbstractQueue<ReferenceEntry<K, V>> {
        final ReferenceEntry<K, V> head = new AbstractReferenceEntry<K, V>(this){
            ReferenceEntry<K, V> nextAccess = this;
            ReferenceEntry<K, V> previousAccess = this;

            @Override
            public long getAccessTime() {
                return Long.MAX_VALUE;
            }

            @Override
            public void setAccessTime(long time) {
            }

            @Override
            public ReferenceEntry<K, V> getNextInAccessQueue() {
                return this.nextAccess;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void setNextInAccessQueue(ReferenceEntry<K, V> next) {
                void var1_1;
                this.nextAccess = var1_1;
            }

            @Override
            public ReferenceEntry<K, V> getPreviousInAccessQueue() {
                return this.previousAccess;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void setPreviousInAccessQueue(ReferenceEntry<K, V> previous) {
                void var1_1;
                this.previousAccess = var1_1;
            }
        };

        AccessQueue() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean offer(ReferenceEntry<K, V> entry) {
            void var1_1;
            LocalCache.connectAccessOrder(entry.getPreviousInAccessQueue(), entry.getNextInAccessQueue());
            LocalCache.connectAccessOrder(this.head.getPreviousInAccessQueue(), entry);
            LocalCache.connectAccessOrder(var1_1, this.head);
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ReferenceEntry<K, V> peek() {
            void var1_1;
            ReferenceEntry<K, V> next = this.head.getNextInAccessQueue();
            if (next == this.head) {
                return null;
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ReferenceEntry<K, V> poll() {
            void var1_1;
            ReferenceEntry<K, V> next = this.head.getNextInAccessQueue();
            if (next == this.head) {
                return null;
            }
            this.remove(next);
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean remove(Object o) {
            void var3_3;
            void var1_1;
            void var2_2;
            ReferenceEntry e = (ReferenceEntry)o;
            ReferenceEntry previous = e.getPreviousInAccessQueue();
            ReferenceEntry next = e.getNextInAccessQueue();
            LocalCache.connectAccessOrder(var2_2, next);
            LocalCache.nullifyAccessOrder(var1_1);
            return var3_3 != NullEntry.INSTANCE;
        }

        @Override
        public final boolean contains(Object o) {
            ReferenceEntry referenceEntry = (ReferenceEntry)o;
            return referenceEntry.getNextInAccessQueue() != NullEntry.INSTANCE;
        }

        @Override
        public final boolean isEmpty() {
            return this.head.getNextInAccessQueue() == this.head;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int size() {
            void var1_1;
            int size = 0;
            for (ReferenceEntry<K, V> e = this.head.getNextInAccessQueue(); e != this.head; e = e.getNextInAccessQueue()) {
                ++size;
            }
            return (int)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void clear() {
            ReferenceEntry<K, V> e = this.head.getNextInAccessQueue();
            while (e != this.head) {
                void var2_2;
                ReferenceEntry<K, V> next = e.getNextInAccessQueue();
                LocalCache.nullifyAccessOrder(e);
                e = var2_2;
            }
            this.head.setNextInAccessQueue(this.head);
            this.head.setPreviousInAccessQueue(this.head);
        }

        @Override
        public final Iterator<ReferenceEntry<K, V>> iterator() {
            AccessQueue accessQueue = this;
            return new AbstractSequentialIterator<ReferenceEntry<K, V>>(accessQueue, (ReferenceEntry)accessQueue.peek()){
                final /* synthetic */ AccessQueue this$0;
                {
                    void var2_2;
                    void var1_1;
                    this.this$0 = var1_1;
                    super(var2_2);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                protected ReferenceEntry<K, V> computeNext(ReferenceEntry<K, V> previous) {
                    void var1_1;
                    ReferenceEntry next = previous.getNextInAccessQueue();
                    if (next == this.this$0.head) {
                        return null;
                    }
                    return var1_1;
                }
            };
        }
    }

    static final class WriteQueue<K, V>
    extends AbstractQueue<ReferenceEntry<K, V>> {
        final ReferenceEntry<K, V> head = new AbstractReferenceEntry<K, V>(this){
            ReferenceEntry<K, V> nextWrite = this;
            ReferenceEntry<K, V> previousWrite = this;

            @Override
            public long getWriteTime() {
                return Long.MAX_VALUE;
            }

            @Override
            public void setWriteTime(long time) {
            }

            @Override
            public ReferenceEntry<K, V> getNextInWriteQueue() {
                return this.nextWrite;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void setNextInWriteQueue(ReferenceEntry<K, V> next) {
                void var1_1;
                this.nextWrite = var1_1;
            }

            @Override
            public ReferenceEntry<K, V> getPreviousInWriteQueue() {
                return this.previousWrite;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void setPreviousInWriteQueue(ReferenceEntry<K, V> previous) {
                void var1_1;
                this.previousWrite = var1_1;
            }
        };

        WriteQueue() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean offer(ReferenceEntry<K, V> entry) {
            void var1_1;
            LocalCache.connectWriteOrder(entry.getPreviousInWriteQueue(), entry.getNextInWriteQueue());
            LocalCache.connectWriteOrder(this.head.getPreviousInWriteQueue(), entry);
            LocalCache.connectWriteOrder(var1_1, this.head);
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ReferenceEntry<K, V> peek() {
            void var1_1;
            ReferenceEntry<K, V> next = this.head.getNextInWriteQueue();
            if (next == this.head) {
                return null;
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ReferenceEntry<K, V> poll() {
            void var1_1;
            ReferenceEntry<K, V> next = this.head.getNextInWriteQueue();
            if (next == this.head) {
                return null;
            }
            this.remove(next);
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean remove(Object o) {
            void var3_3;
            void var1_1;
            void var2_2;
            ReferenceEntry e = (ReferenceEntry)o;
            ReferenceEntry previous = e.getPreviousInWriteQueue();
            ReferenceEntry next = e.getNextInWriteQueue();
            LocalCache.connectWriteOrder(var2_2, next);
            LocalCache.nullifyWriteOrder(var1_1);
            return var3_3 != NullEntry.INSTANCE;
        }

        @Override
        public final boolean contains(Object o) {
            ReferenceEntry referenceEntry = (ReferenceEntry)o;
            return referenceEntry.getNextInWriteQueue() != NullEntry.INSTANCE;
        }

        @Override
        public final boolean isEmpty() {
            return this.head.getNextInWriteQueue() == this.head;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int size() {
            void var1_1;
            int size = 0;
            for (ReferenceEntry<K, V> e = this.head.getNextInWriteQueue(); e != this.head; e = e.getNextInWriteQueue()) {
                ++size;
            }
            return (int)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void clear() {
            ReferenceEntry<K, V> e = this.head.getNextInWriteQueue();
            while (e != this.head) {
                void var2_2;
                ReferenceEntry<K, V> next = e.getNextInWriteQueue();
                LocalCache.nullifyWriteOrder(e);
                e = var2_2;
            }
            this.head.setNextInWriteQueue(this.head);
            this.head.setPreviousInWriteQueue(this.head);
        }

        @Override
        public final Iterator<ReferenceEntry<K, V>> iterator() {
            WriteQueue writeQueue = this;
            return new AbstractSequentialIterator<ReferenceEntry<K, V>>(writeQueue, (ReferenceEntry)writeQueue.peek()){
                final /* synthetic */ WriteQueue this$0;
                {
                    void var2_2;
                    void var1_1;
                    this.this$0 = var1_1;
                    super(var2_2);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                protected ReferenceEntry<K, V> computeNext(ReferenceEntry<K, V> previous) {
                    void var1_1;
                    ReferenceEntry next = previous.getNextInWriteQueue();
                    if (next == this.this$0.head) {
                        return null;
                    }
                    return var1_1;
                }
            };
        }
    }

    static class ComputingValueReference<K, V>
    extends LoadingValueReference<K, V> {
        /*
         * WARNING - void declaration
         */
        ComputingValueReference(ValueReference<K, V> oldValue) {
            super(var1_1);
            void var1_1;
        }

        @Override
        public boolean isLoading() {
            return false;
        }
    }

    static class LoadingValueReference<K, V>
    implements ValueReference<K, V> {
        volatile ValueReference<K, V> oldValue;
        final SettableFuture<V> futureValue = SettableFuture.create();
        final Stopwatch stopwatch = Stopwatch.createUnstarted();

        public LoadingValueReference() {
            this(null);
        }

        /*
         * WARNING - void declaration
         */
        public LoadingValueReference(ValueReference<K, V> oldValue) {
            void var1_1;
            this.oldValue = oldValue == null ? LocalCache.unset() : var1_1;
        }

        @Override
        public boolean isLoading() {
            return true;
        }

        @Override
        public boolean isActive() {
            return this.oldValue.isActive();
        }

        @Override
        public int getWeight() {
            return this.oldValue.getWeight();
        }

        /*
         * WARNING - void declaration
         */
        public boolean set(V newValue) {
            void var1_1;
            return this.futureValue.set(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public boolean setException(Throwable t) {
            void var1_1;
            return this.futureValue.setException((Throwable)var1_1);
        }

        private ListenableFuture<V> fullyFailedFuture(Throwable t) {
            return Futures.immediateFailedFuture(t);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void notifyNewValue(V newValue) {
            if (newValue != null) {
                void var1_1;
                this.set(var1_1);
                return;
            }
            this.oldValue = LocalCache.unset();
        }

        /*
         * WARNING - void declaration
         */
        public ListenableFuture<V> loadFuture(K key, CacheLoader<? super K, V> loader) {
            try {
                void var2_2;
                Object newValue;
                this.stopwatch.start();
                V previousValue = this.oldValue.get();
                if (previousValue == null) {
                    newValue = loader.load(key);
                    if (this.set(newValue)) {
                        return this.futureValue;
                    }
                    return Futures.immediateFuture(newValue);
                }
                if ((newValue = var2_2.reload(newValue, previousValue)) == null) {
                    return Futures.immediateFuture(null);
                }
                return Futures.transform(newValue, new Function<V, V>(this){
                    final /* synthetic */ LoadingValueReference this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public V apply(V newValue) {
                        void var1_1;
                        this.this$0.set(newValue);
                        return var1_1;
                    }
                }, MoreExecutors.directExecutor());
            }
            catch (Throwable t) {
                void var1_1;
                void var3_4;
                ListenableFuture<V> result;
                ListenableFuture<V> listenableFuture = result = this.setException(t) ? this.futureValue : this.fullyFailedFuture(t);
                if (var3_4 instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                return var1_1;
            }
        }

        /*
         * WARNING - void declaration
         */
        public V compute(K key, BiFunction<? super K, ? super V, ? extends V> function) {
            void var1_1;
            Object newValue;
            V previousValue;
            this.stopwatch.start();
            try {
                previousValue = this.oldValue.waitForValue();
            }
            catch (ExecutionException executionException) {
                previousValue = null;
            }
            try {
                void var3_4;
                void var2_3;
                newValue = var2_3.apply(key, var3_4);
            }
            catch (Throwable th) {
                void newValue2;
                this.setException(th);
                throw newValue2;
            }
            this.set(newValue);
            return var1_1;
        }

        public long elapsedNanos() {
            return this.stopwatch.elapsed(TimeUnit.NANOSECONDS);
        }

        @Override
        public V waitForValue() throws ExecutionException {
            return Uninterruptibles.getUninterruptibly(this.futureValue);
        }

        @Override
        public V get() {
            return this.oldValue.get();
        }

        public ValueReference<K, V> getOldValue() {
            return this.oldValue;
        }

        @Override
        public ReferenceEntry<K, V> getEntry() {
            return null;
        }

        @Override
        public ValueReference<K, V> copyFor(ReferenceQueue<V> queue, V value, ReferenceEntry<K, V> entry) {
            return this;
        }
    }

    static class Segment<K, V>
    extends ReentrantLock {
        final LocalCache<K, V> map;
        volatile int count;
        long totalWeight;
        int modCount;
        int threshold;
        volatile AtomicReferenceArray<ReferenceEntry<K, V>> table;
        final long maxSegmentWeight;
        final ReferenceQueue<K> keyReferenceQueue;
        final ReferenceQueue<V> valueReferenceQueue;
        final Queue<ReferenceEntry<K, V>> recencyQueue;
        final AtomicInteger readCount = new AtomicInteger();
        final Queue<ReferenceEntry<K, V>> writeQueue;
        final Queue<ReferenceEntry<K, V>> accessQueue;
        final AbstractCache.StatsCounter statsCounter;

        /*
         * WARNING - void declaration
         */
        Segment(LocalCache<K, V> map, int initialCapacity, long maxSegmentWeight, AbstractCache.StatsCounter statsCounter) {
            void var1_1;
            void var2_2;
            void var3_3;
            this.map = map;
            this.maxSegmentWeight = var3_3;
            this.statsCounter = Preconditions.checkNotNull(statsCounter);
            Segment segment = this;
            segment.initTable(segment.newEntryArray((int)var2_2));
            this.keyReferenceQueue = map.usesKeyReferences() ? new ReferenceQueue() : null;
            this.valueReferenceQueue = map.usesValueReferences() ? new ReferenceQueue() : null;
            this.recencyQueue = map.usesAccessQueue() ? new ConcurrentLinkedQueue() : LocalCache.discardingQueue();
            this.writeQueue = map.usesWriteQueue() ? new WriteQueue() : LocalCache.discardingQueue();
            this.accessQueue = var1_1.usesAccessQueue() ? new AccessQueue() : LocalCache.discardingQueue();
        }

        /*
         * WARNING - void declaration
         */
        AtomicReferenceArray<ReferenceEntry<K, V>> newEntryArray(int size) {
            void var1_1;
            return new AtomicReferenceArray<ReferenceEntry<K, V>>((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        void initTable(AtomicReferenceArray<ReferenceEntry<K, V>> newTable) {
            void var1_1;
            this.threshold = newTable.length() * 3 / 4;
            if (!this.map.customWeigher() && (long)this.threshold == this.maxSegmentWeight) {
                ++this.threshold;
            }
            this.table = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        ReferenceEntry<K, V> newEntry(K key, int hash, ReferenceEntry<K, V> next) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.map.entryFactory.newEntry(this, Preconditions.checkNotNull(var1_1), (int)var2_2, var3_3);
        }

        /*
         * WARNING - void declaration
         */
        ReferenceEntry<K, V> copyEntry(ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
            void var1_1;
            void var3_3;
            void var2_2;
            if (original.getKey() == null) {
                return null;
            }
            ValueReference<K, V> valueReference = original.getValueReference();
            V value = valueReference.get();
            if (value == null && valueReference.isActive()) {
                return null;
            }
            ReferenceEntry<K, V> newEntry = this.map.entryFactory.copyEntry(this, original, var2_2);
            newEntry.setValueReference(var3_3.copyFor(this.valueReferenceQueue, value, newEntry));
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        void setValue(ReferenceEntry<K, V> entry, K key, V value, long now) {
            void var3_4;
            void var2_3;
            void var1_1;
            ValueReference<K, void> previous = entry.getValueReference();
            int weight = this.map.weigher.weigh(key, value);
            Preconditions.checkState(weight >= 0, "Weights must be non-negative");
            ValueReference<K, V> valueReference = this.map.valueStrength.referenceValue(this, entry, value, weight);
            entry.setValueReference(valueReference);
            this.recordWrite((ReferenceEntry<K, V>)var1_1, (int)var2_3, now);
            previous.notifyNewValue(var3_4);
        }

        /*
         * WARNING - void declaration
         */
        V get(K key, int hash, CacheLoader<? super K, V> loader) throws ExecutionException {
            Preconditions.checkNotNull(key);
            Preconditions.checkNotNull(loader);
            try {
                void var3_4;
                void var2_3;
                void var1_1;
                ReferenceEntry<K, V> e;
                if (this.count != 0 && (e = this.getEntry(key, hash)) != null) {
                    long now2 = this.map.ticker.read();
                    V value = this.getLiveValue(e, now2);
                    if (value != null) {
                        this.recordRead(e, now2);
                        this.statsCounter.recordHits(1);
                        V now2 = this.scheduleRefresh(e, key, hash, value, now2, loader);
                        return now2;
                    }
                    ValueReference<K, V> valueReference = e.getValueReference();
                    if (valueReference.isLoading()) {
                        key = this.waitForLoadingValue(e, key, valueReference);
                        return (V)key;
                    }
                }
                e = this.lockedGetOrLoad(var1_1, (int)var2_3, (CacheLoader<? super K, V>)var3_4);
                return (V)e;
            }
            catch (ExecutionException executionException) {
                ExecutionException ee = executionException;
                Throwable cause = executionException.getCause();
                if (cause instanceof Error) {
                    throw new ExecutionError((Error)cause);
                }
                if (cause instanceof RuntimeException) {
                    throw new UncheckedExecutionException(cause);
                }
                throw ee;
            }
            finally {
                this.postReadCleanup();
            }
        }

        /*
         * WARNING - void declaration
         */
        V get(Object key, int hash) {
            try {
                if (this.count != 0) {
                    long now = this.map.ticker.read();
                    ReferenceEntry<K, V> e = this.getLiveEntry(key, hash, now);
                    if (e == null) {
                        return null;
                    }
                    V value = e.getValueReference().get();
                    if (value != null) {
                        void var3_4;
                        void var2_3;
                        V v;
                        this.recordRead(e, now);
                        void v0 = v;
                        v = this.scheduleRefresh((ReferenceEntry<K, V>)v0, v0.getKey(), (int)var2_3, value, (long)var3_4, this.map.defaultLoader);
                        return v;
                    }
                    this.tryDrainReferenceQueues();
                }
                return null;
            }
            finally {
                this.postReadCleanup();
            }
        }

        /*
         * WARNING - void declaration
         */
        V lockedGetOrLoad(K key, int hash, CacheLoader<? super K, V> loader) throws ExecutionException {
            void var1_1;
            ReferenceEntry e;
            ValueReference<K, V> valueReference = null;
            LoadingValueReference loadingValueReference = null;
            boolean createNewEntry = true;
            this.lock();
            try {
                ReferenceEntry first;
                long now = this.map.ticker.read();
                this.preWriteCleanup(now);
                int newCount = this.count - 1;
                AtomicReferenceArray<ReferenceEntry<K, V>> table = this.table;
                int index = hash & table.length() - 1;
                for (e = first = table.get(index); e != null; e = e.getNext()) {
                    K entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !this.map.keyEquivalence.equivalent(key, entryKey)) continue;
                    valueReference = e.getValueReference();
                    if (valueReference.isLoading()) {
                        createNewEntry = false;
                        break;
                    }
                    V value = valueReference.get();
                    if (value == null) {
                        this.enqueueNotification(entryKey, hash, value, valueReference.getWeight(), RemovalCause.COLLECTED);
                    } else if (this.map.isExpired(e, now)) {
                        this.enqueueNotification(entryKey, hash, value, valueReference.getWeight(), RemovalCause.EXPIRED);
                    } else {
                        this.recordLockedRead(e, now);
                        this.statsCounter.recordHits(1);
                        key = value;
                        return (V)key;
                    }
                    this.writeQueue.remove(e);
                    this.accessQueue.remove(e);
                    this.count = newCount;
                    break;
                }
                if (createNewEntry) {
                    loadingValueReference = new LoadingValueReference();
                    if (e == null) {
                        e = this.newEntry(key, hash, first);
                        e.setValueReference(loadingValueReference);
                        table.set(index, e);
                    } else {
                        e.setValueReference(loadingValueReference);
                    }
                }
            }
            finally {
                this.unlock();
                this.postWriteCleanup();
            }
            if (createNewEntry) {
                try {
                    ReferenceEntry referenceEntry = e;
                    synchronized (referenceEntry) {
                        void var3_6;
                        void var2_5;
                        Object v = this.loadSync(key, (int)var2_5, loadingValueReference, (CacheLoader<? super K, V>)var3_6);
                        return v;
                    }
                }
                finally {
                    this.statsCounter.recordMisses(1);
                }
            }
            return this.waitForLoadingValue(e, var1_1, valueReference);
        }

        /*
         * WARNING - void declaration
         */
        V waitForLoadingValue(ReferenceEntry<K, V> e, K key, ValueReference<K, V> valueReference) throws ExecutionException {
            if (!valueReference.isLoading()) {
                throw new AssertionError();
            }
            Preconditions.checkState(!Thread.holdsLock(e), "Recursive load of: %s", key);
            try {
                void var3_4;
                void var1_1;
                V value = valueReference.waitForValue();
                if (value == null) {
                    void var2_3;
                    String string = String.valueOf(var2_3);
                    throw new CacheLoader.InvalidCacheLoadException(new StringBuilder(35 + String.valueOf(string).length()).append("CacheLoader returned null for key ").append(string).append(".").toString());
                }
                long now = this.map.ticker.read();
                this.recordRead((ReferenceEntry<K, V>)var1_1, now);
                var1_1 = var3_4;
                return var1_1;
            }
            finally {
                this.statsCounter.recordMisses(1);
            }
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        V compute(K key, int hash, BiFunction<? super K, ? super V, ? extends V> function) {
            ValueReference<K, V> valueReference = null;
            boolean createNewEntry = true;
            this.lock();
            try {
                void var2_3;
                ReferenceEntry<K, V> first;
                ReferenceEntry<K, V> e;
                long now = this.map.ticker.read();
                this.preWriteCleanup(now);
                AtomicReferenceArray<ReferenceEntry<K, V>> table = this.table;
                int index = hash & table.length() - 1;
                for (e = first = table.get(index); e != null; e = e.getNext()) {
                    K entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !this.map.keyEquivalence.equivalent(key, entryKey)) continue;
                    valueReference = e.getValueReference();
                    if (this.map.isExpired(e, now)) {
                        this.enqueueNotification(entryKey, hash, valueReference.get(), valueReference.getWeight(), RemovalCause.EXPIRED);
                    }
                    this.writeQueue.remove(e);
                    this.accessQueue.remove(e);
                    createNewEntry = false;
                    break;
                }
                ComputingValueReference<Object, Object> computingValueReference = new ComputingValueReference<K, Object>(valueReference);
                if (e == null) {
                    createNewEntry = true;
                    e = this.newEntry(key, hash, first);
                    e.setValueReference(computingValueReference);
                    table.set(index, e);
                } else {
                    e.setValueReference(computingValueReference);
                }
                V newValue = computingValueReference.compute((K)key, (BiFunction<? super K, Object, Object>)function);
                if (newValue != null) {
                    void var3_4;
                    if (valueReference != null && newValue == valueReference.get()) {
                        computingValueReference.set(newValue);
                        e.setValueReference(valueReference);
                        this.recordWrite(e, 0, now);
                        computingValueReference = newValue;
                        return (V)computingValueReference;
                    }
                    computingValueReference = this.getAndRecordStats(key, hash, computingValueReference, Futures.immediateFuture(var3_4));
                    return (V)computingValueReference;
                }
                if (createNewEntry || valueReference.isLoading()) {
                    void var1_1;
                    this.removeLoadingValue(var1_1, hash, computingValueReference);
                    return null;
                }
                this.removeEntry(e, (int)var2_3, RemovalCause.EXPLICIT);
                return null;
            }
            finally {
                this.unlock();
                this.postWriteCleanup();
            }
        }

        /*
         * WARNING - void declaration
         */
        V loadSync(K key, int hash, LoadingValueReference<K, V> loadingValueReference, CacheLoader<? super K, V> loader) throws ExecutionException {
            void var3_3;
            void var2_2;
            void var1_1;
            ListenableFuture<V> loadingFuture = loadingValueReference.loadFuture((K)key, loader);
            return this.getAndRecordStats(var1_1, (int)var2_2, (LoadingValueReference<K, V>)var3_3, loadingFuture);
        }

        /*
         * WARNING - void declaration
         */
        ListenableFuture<V> loadAsync(K key, int hash, LoadingValueReference<K, V> loadingValueReference, CacheLoader<? super K, V> loader) {
            void var3_3;
            void var2_2;
            void var1_1;
            ListenableFuture<V> loadingFuture = loadingValueReference.loadFuture((K)key, loader);
            loadingFuture.addListener(new Runnable(this, var1_1, (int)var2_2, (LoadingValueReference)var3_3, loadingFuture){
                final /* synthetic */ Object val$key;
                final /* synthetic */ int val$hash;
                final /* synthetic */ LoadingValueReference val$loadingValueReference;
                final /* synthetic */ ListenableFuture val$loadingFuture;
                final /* synthetic */ Segment this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$key = object;
                    this.val$hash = n;
                    this.val$loadingValueReference = loadingValueReference;
                    this.val$loadingFuture = listenableFuture;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void run() {
                    try {
                        this.this$0.getAndRecordStats(this.val$key, this.val$hash, this.val$loadingValueReference, this.val$loadingFuture);
                        return;
                    }
                    catch (Throwable t) {
                        void var1_1;
                        logger.log(Level.WARNING, "Exception thrown during refresh", t);
                        this.val$loadingValueReference.setException((Throwable)var1_1);
                        return;
                    }
                }
            }, MoreExecutors.directExecutor());
            return loadingFuture;
        }

        /*
         * WARNING - void declaration
         */
        V getAndRecordStats(K key, int hash, LoadingValueReference<K, V> loadingValueReference, ListenableFuture<V> newValue) throws ExecutionException {
            String string;
            block4: {
                V value = null;
                try {
                    V v = Uninterruptibles.getUninterruptibly(newValue);
                    value = v;
                    if (v == null) {
                        string = String.valueOf(key);
                        throw new CacheLoader.InvalidCacheLoadException(new StringBuilder(35 + String.valueOf(string).length()).append("CacheLoader returned null for key ").append(string).append(".").toString());
                    }
                    this.statsCounter.recordLoadSuccess(loadingValueReference.elapsedNanos());
                    this.storeLoadedValue(key, hash, loadingValueReference, value);
                    string = value;
                    if (value != null) break block4;
                    this.statsCounter.recordLoadException(loadingValueReference.elapsedNanos());
                    this.removeLoadingValue(key, hash, loadingValueReference);
                }
                catch (Throwable throwable) {
                    if (value == null) {
                        void var3_3;
                        void var2_2;
                        void var1_1;
                        this.statsCounter.recordLoadException(loadingValueReference.elapsedNanos());
                        this.removeLoadingValue(var1_1, (int)var2_2, (LoadingValueReference<K, V>)var3_3);
                    }
                    throw throwable;
                }
            }
            return (V)string;
        }

        /*
         * WARNING - void declaration
         */
        V scheduleRefresh(ReferenceEntry<K, V> entry, K key, int hash, V oldValue, long now, CacheLoader<? super K, V> loader) {
            void var3_3;
            void var2_2;
            V newValue;
            if (this.map.refreshes() && now - entry.getWriteTime() > this.map.refreshNanos && !entry.getValueReference().isLoading() && (newValue = this.refresh(var2_2, (int)var3_3, loader, true)) != null) {
                void var1_1;
                return var1_1;
            }
            return oldValue;
        }

        /*
         * WARNING - void declaration
         */
        V refresh(K key, int hash, CacheLoader<? super K, V> loader, boolean checkTime) {
            void var3_3;
            void var2_2;
            LoadingValueReference<K, V> loadingValueReference = this.insertLoadingValueReference(key, hash, checkTime);
            if (loadingValueReference == null) {
                return null;
            }
            ListenableFuture<V> result = this.loadAsync(key, (int)var2_2, loadingValueReference, (CacheLoader<? super K, V>)var3_3);
            if (result.isDone()) {
                try {
                    void var1_1;
                    return Uninterruptibles.getUninterruptibly(var1_1);
                }
                catch (Throwable throwable) {}
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        LoadingValueReference<K, V> insertLoadingValueReference(K key, int hash, boolean checkTime) {
            this.lock();
            try {
                void var2_3;
                LoadingValueReference loadingValueReference;
                ReferenceEntry<Object, V> e;
                long now = this.map.ticker.read();
                this.preWriteCleanup(now);
                AtomicReferenceArray<ReferenceEntry<K, V>> table = this.table;
                int index = hash & table.length() - 1;
                ReferenceEntry<K, V> first = table.get(index);
                for (e = first; e != null; e = e.getNext()) {
                    K entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !this.map.keyEquivalence.equivalent(key, entryKey)) continue;
                    ValueReference<K, V> valueReference = e.getValueReference();
                    if (valueReference.isLoading() || checkTime && now - e.getWriteTime() < this.map.refreshNanos) {
                        return null;
                    }
                    ++this.modCount;
                    LoadingValueReference<K, V> loadingValueReference2 = new LoadingValueReference<K, V>(valueReference);
                    e.setValueReference(loadingValueReference2);
                    return loadingValueReference;
                }
                ++this.modCount;
                LoadingValueReference loadingValueReference3 = new LoadingValueReference();
                e = this.newEntry(loadingValueReference, (int)var2_3, first);
                e.setValueReference(loadingValueReference3);
                table.set(index, e);
                loadingValueReference = loadingValueReference3;
                return loadingValueReference;
            }
            finally {
                this.unlock();
                this.postWriteCleanup();
            }
        }

        void tryDrainReferenceQueues() {
            if (this.tryLock()) {
                try {
                    this.drainReferenceQueues();
                    return;
                }
                finally {
                    this.unlock();
                }
            }
        }

        void drainReferenceQueues() {
            if (this.map.usesKeyReferences()) {
                this.drainKeyReferenceQueue();
            }
            if (this.map.usesValueReferences()) {
                this.drainValueReferenceQueue();
            }
        }

        /*
         * WARNING - void declaration
         */
        void drainKeyReferenceQueue() {
            Reference<K> ref;
            int i = 0;
            while ((ref = this.keyReferenceQueue.poll()) != null) {
                void var1_2;
                ReferenceEntry entry = (ReferenceEntry)((Object)ref);
                this.map.reclaimKey((ReferenceEntry<K, V>)var1_2);
                if (++i != 16) continue;
            }
        }

        /*
         * WARNING - void declaration
         */
        void drainValueReferenceQueue() {
            Reference<V> ref;
            int i = 0;
            while ((ref = this.valueReferenceQueue.poll()) != null) {
                void var1_2;
                ValueReference valueReference = (ValueReference)((Object)ref);
                this.map.reclaimValue((ValueReference<K, V>)var1_2);
                if (++i != 16) continue;
            }
        }

        void clearReferenceQueues() {
            if (this.map.usesKeyReferences()) {
                this.clearKeyReferenceQueue();
            }
            if (this.map.usesValueReferences()) {
                this.clearValueReferenceQueue();
            }
        }

        void clearKeyReferenceQueue() {
            while (this.keyReferenceQueue.poll() != null) {
            }
        }

        void clearValueReferenceQueue() {
            while (this.valueReferenceQueue.poll() != null) {
            }
        }

        /*
         * WARNING - void declaration
         */
        void recordRead(ReferenceEntry<K, V> entry, long now) {
            void var1_1;
            if (this.map.recordsAccess()) {
                void var2_2;
                entry.setAccessTime((long)var2_2);
            }
            this.recencyQueue.add((ReferenceEntry<K, V>)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        void recordLockedRead(ReferenceEntry<K, V> entry, long now) {
            void var1_1;
            if (this.map.recordsAccess()) {
                void var2_2;
                entry.setAccessTime((long)var2_2);
            }
            this.accessQueue.add((ReferenceEntry<K, V>)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        void recordWrite(ReferenceEntry<K, V> entry, int weight, long now) {
            void var1_1;
            void var2_2;
            this.drainRecencyQueue();
            this.totalWeight += (long)var2_2;
            if (this.map.recordsAccess()) {
                entry.setAccessTime(now);
            }
            if (this.map.recordsWrite()) {
                void var3_3;
                entry.setWriteTime((long)var3_3);
            }
            this.accessQueue.add(entry);
            this.writeQueue.add((ReferenceEntry<K, V>)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        void drainRecencyQueue() {
            ReferenceEntry<K, V> e;
            while ((e = this.recencyQueue.poll()) != null) {
                void var1_1;
                if (!this.accessQueue.contains(e)) continue;
                this.accessQueue.add((ReferenceEntry<K, V>)var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        void tryExpireEntries(long now) {
            if (this.tryLock()) {
                try {
                    void var1_1;
                    this.expireEntries((long)var1_1);
                    return;
                }
                finally {
                    this.unlock();
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        void expireEntries(long now) {
            ReferenceEntry<K, V> e;
            this.drainRecencyQueue();
            while ((e = this.writeQueue.peek()) != null && this.map.isExpired(e, now)) {
                ReferenceEntry<K, V> referenceEntry = e;
                if (!this.removeEntry(referenceEntry, referenceEntry.getHash(), RemovalCause.EXPIRED)) {
                    throw new AssertionError();
                }
            }
            while ((e = this.accessQueue.peek()) != null && this.map.isExpired(e, now)) {
                void var3_2;
                void v1 = var3_2;
                if (!this.removeEntry((ReferenceEntry<K, V>)v1, v1.getHash(), RemovalCause.EXPIRED)) {
                    throw new AssertionError();
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        void enqueueNotification(K key, int hash, V value, int weight, RemovalCause cause) {
            this.totalWeight -= (long)weight;
            if (cause.wasEvicted()) {
                this.statsCounter.recordEviction();
            }
            if (this.map.removalNotificationQueue != DISCARDING_QUEUE) {
                void var1_1;
                void var3_3;
                RemovalNotification<K, void> notification = RemovalNotification.create(key, var3_3, cause);
                this.map.removalNotificationQueue.offer(var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        void evictEntries(ReferenceEntry<K, V> newest) {
            if (!this.map.evictsBySize()) {
                return;
            }
            this.drainRecencyQueue();
            if ((long)newest.getValueReference().getWeight() > this.maxSegmentWeight) {
                ReferenceEntry<K, V> referenceEntry = newest;
                if (!this.removeEntry(referenceEntry, referenceEntry.getHash(), RemovalCause.SIZE)) {
                    throw new AssertionError();
                }
            }
            while (this.totalWeight > this.maxSegmentWeight) {
                void var1_1;
                ReferenceEntry<K, V> e = this.getNextEvictable();
                void v1 = var1_1;
                if (!this.removeEntry((ReferenceEntry<K, V>)v1, v1.getHash(), RemovalCause.SIZE)) {
                    throw new AssertionError();
                }
            }
        }

        ReferenceEntry<K, V> getNextEvictable() {
            for (ReferenceEntry referenceEntry : this.accessQueue) {
                int n = referenceEntry.getValueReference().getWeight();
                if (n <= 0) continue;
                return referenceEntry;
            }
            throw new AssertionError();
        }

        /*
         * WARNING - void declaration
         */
        ReferenceEntry<K, V> getFirst(int hash) {
            void var2_2;
            void var1_1;
            AtomicReferenceArray<ReferenceEntry<K, V>> table = this.table;
            return table.get(var1_1 & var2_2.length() - 1);
        }

        ReferenceEntry<K, V> getEntry(Object key, int hash) {
            for (ReferenceEntry<K, V> e = this.getFirst(hash); e != null; e = e.getNext()) {
                if (e.getHash() != hash) continue;
                K entryKey = e.getKey();
                if (entryKey == null) {
                    this.tryDrainReferenceQueues();
                    continue;
                }
                if (!this.map.keyEquivalence.equivalent(key, entryKey)) continue;
                return e;
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        ReferenceEntry<K, V> getLiveEntry(Object key, int hash, long now) {
            void var1_1;
            void var2_2;
            ReferenceEntry<K, V> e = this.getEntry(key, (int)var2_2);
            if (e == null) {
                return null;
            }
            if (this.map.isExpired(e, now)) {
                void var3_3;
                this.tryExpireEntries((long)var3_3);
                return null;
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        V getLiveValue(ReferenceEntry<K, V> entry, long now) {
            void var1_1;
            if (entry.getKey() == null) {
                this.tryDrainReferenceQueues();
                return null;
            }
            V value = entry.getValueReference().get();
            if (value == null) {
                this.tryDrainReferenceQueues();
                return null;
            }
            if (this.map.isExpired((ReferenceEntry<K, V>)var1_1, now)) {
                void var2_2;
                this.tryExpireEntries((long)var2_2);
                return null;
            }
            return value;
        }

        /*
         * WARNING - void declaration
         */
        boolean containsKey(Object key, int hash) {
            try {
                if (this.count != 0) {
                    void var1_1;
                    void var3_5;
                    void var2_4;
                    long now = this.map.ticker.read();
                    ReferenceEntry<K, V> e = this.getLiveEntry(key, (int)var2_4, (long)var3_5);
                    if (e == null) {
                        return false;
                    }
                    boolean bl = var1_1.getValueReference().get() != null;
                    return bl;
                }
                return false;
            }
            finally {
                this.postReadCleanup();
            }
        }

        @VisibleForTesting
        boolean containsValue(Object value) {
            try {
                if (this.count != 0) {
                    long now = this.map.ticker.read();
                    AtomicReferenceArray<ReferenceEntry<K, V>> table = this.table;
                    int length = table.length();
                    for (int i = 0; i < length; ++i) {
                        for (ReferenceEntry<K, V> e = table.get(i); e != null; e = e.getNext()) {
                            V entryValue = this.getLiveValue(e, now);
                            if (entryValue == null || !this.map.valueEquivalence.equivalent(value, entryValue)) continue;
                            return true;
                        }
                    }
                }
                return false;
            }
            finally {
                this.postReadCleanup();
            }
        }

        /*
         * WARNING - void declaration
         */
        V put(K key, int hash, V value, boolean onlyIfAbsent) {
            this.lock();
            try {
                void var8_11;
                void var3_4;
                void var1_1;
                void var2_3;
                void newCount2;
                ReferenceEntry<K, V> first;
                long now = this.map.ticker.read();
                this.preWriteCleanup(now);
                int n = this.count + 1;
                if (n > this.threshold) {
                    this.expand();
                }
                AtomicReferenceArray<ReferenceEntry<K, V>> table = this.table;
                int index = hash & table.length() - 1;
                for (ReferenceEntry<K, V> e = first = table.get(index); e != null; e = e.getNext()) {
                    K entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !this.map.keyEquivalence.equivalent(key, entryKey)) continue;
                    ValueReference<K, V> valueReference = e.getValueReference();
                    V entryValue = valueReference.get();
                    if (entryValue == null) {
                        int newCount2;
                        ++this.modCount;
                        if (valueReference.isActive()) {
                            this.enqueueNotification(key, hash, entryValue, valueReference.getWeight(), RemovalCause.COLLECTED);
                            this.setValue(e, key, value, now);
                            newCount2 = this.count;
                        } else {
                            this.setValue(e, key, value, now);
                            newCount2 = this.count + 1;
                        }
                        this.count = newCount2;
                        this.evictEntries(e);
                        return null;
                    }
                    if (onlyIfAbsent) {
                        this.recordLockedRead(e, now);
                        key = entryValue;
                        return (V)key;
                    }
                    ++this.modCount;
                    this.enqueueNotification(key, hash, entryValue, newCount2.getWeight(), RemovalCause.REPLACED);
                    this.setValue(e, key, value, now);
                    this.evictEntries(e);
                    key = entryValue;
                    return (V)key;
                }
                ++this.modCount;
                ReferenceEntry<K, V> newEntry = this.newEntry(key, (int)var2_3, first);
                this.setValue(newEntry, var1_1, var3_4, now);
                newCount2.set((int)var8_11, newEntry);
                this.count = newCount2 = this.count + 1;
                this.evictEntries(newEntry);
                return null;
            }
            finally {
                this.unlock();
                this.postWriteCleanup();
            }
        }

        /*
         * WARNING - void declaration
         */
        void expand() {
            void var3_3;
            AtomicReferenceArray<ReferenceEntry<K, V>> oldTable = this.table;
            int oldCapacity = oldTable.length();
            if (oldCapacity >= 0x40000000) {
                return;
            }
            int newCount = this.count;
            AtomicReferenceArray<ReferenceEntry<K, V>> newTable = this.newEntryArray(oldCapacity << 1);
            this.threshold = newTable.length() * 3 / 4;
            int newMask = newTable.length() - 1;
            for (int oldIndex = 0; oldIndex < oldCapacity; ++oldIndex) {
                int newIndex;
                ReferenceEntry<K, V> e;
                ReferenceEntry<K, V> head = oldTable.get(oldIndex);
                if (head == null) continue;
                ReferenceEntry<K, V> next = head.getNext();
                int headIndex = head.getHash() & newMask;
                if (next == null) {
                    newTable.set(headIndex, head);
                    continue;
                }
                ReferenceEntry<K, V> tail = head;
                int tailIndex = headIndex;
                for (e = next; e != null; e = e.getNext()) {
                    newIndex = e.getHash() & newMask;
                    if (newIndex == tailIndex) continue;
                    tailIndex = newIndex;
                    tail = e;
                }
                newTable.set(tailIndex, tail);
                for (e = head; e != tail; e = e.getNext()) {
                    newIndex = e.getHash() & newMask;
                    ReferenceEntry<K, V> newNext = newTable.get(newIndex);
                    ReferenceEntry<K, V> newFirst = this.copyEntry(e, newNext);
                    if (newFirst != null) {
                        newTable.set(newIndex, newFirst);
                        continue;
                    }
                    this.removeCollectedEntry(e);
                    --newCount;
                }
            }
            this.table = newTable;
            this.count = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        boolean replace(K key, int hash, V oldValue, V newValue) {
            this.lock();
            try {
                ReferenceEntry<K, V> first;
                long now = this.map.ticker.read();
                this.preWriteCleanup(now);
                AtomicReferenceArray<ReferenceEntry<K, V>> table = this.table;
                int index = hash & table.length() - 1;
                for (ReferenceEntry<K, V> e = first = table.get(index); e != null; e = e.getNext()) {
                    K entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !this.map.keyEquivalence.equivalent(key, entryKey)) continue;
                    ValueReference<K, V> valueReference = e.getValueReference();
                    V entryValue = valueReference.get();
                    if (entryValue == null) {
                        if (valueReference.isActive()) {
                            void var1_2;
                            void var2_5;
                            ++this.modCount;
                            ReferenceEntry<K, V> newFirst = this.removeValueFromChain(first, e, entryKey, hash, entryValue, valueReference, RemovalCause.COLLECTED);
                            int newCount = this.count - 1;
                            table.set(index, (ReferenceEntry<K, V>)var2_5);
                            this.count = var1_2;
                        }
                        return false;
                    }
                    if (this.map.valueEquivalence.equivalent(oldValue, entryValue)) {
                        void var2_4;
                        void var1_1;
                        ++this.modCount;
                        this.enqueueNotification(var1_1, (int)var2_4, entryValue, valueReference.getWeight(), RemovalCause.REPLACED);
                        this.setValue(e, var1_1, newValue, now);
                        this.evictEntries(e);
                        return true;
                    }
                    this.recordLockedRead(e, now);
                    return false;
                }
                return false;
            }
            finally {
                this.unlock();
                this.postWriteCleanup();
            }
        }

        /*
         * WARNING - void declaration
         */
        V replace(K key, int hash, V newValue) {
            this.lock();
            try {
                ReferenceEntry<K, V> first;
                long now = this.map.ticker.read();
                this.preWriteCleanup(now);
                AtomicReferenceArray<ReferenceEntry<K, V>> table = this.table;
                int index = hash & table.length() - 1;
                for (ReferenceEntry<K, V> e = first = table.get(index); e != null; e = e.getNext()) {
                    void var2_4;
                    V v;
                    K entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !this.map.keyEquivalence.equivalent(key, entryKey)) continue;
                    ValueReference<K, V> valueReference = e.getValueReference();
                    V entryValue = valueReference.get();
                    if (entryValue == null) {
                        if (valueReference.isActive()) {
                            void var1_2;
                            void var2_5;
                            ++this.modCount;
                            ReferenceEntry<K, V> newFirst = this.removeValueFromChain(first, e, entryKey, hash, entryValue, valueReference, RemovalCause.COLLECTED);
                            int newCount = this.count - 1;
                            table.set(index, (ReferenceEntry<K, V>)var2_5);
                            this.count = var1_2;
                        }
                        return null;
                    }
                    ++this.modCount;
                    this.enqueueNotification(v, (int)var2_4, entryValue, valueReference.getWeight(), RemovalCause.REPLACED);
                    this.setValue(e, v, newValue, now);
                    this.evictEntries(e);
                    v = entryValue;
                    return v;
                }
                return null;
            }
            finally {
                this.unlock();
                this.postWriteCleanup();
            }
        }

        /*
         * WARNING - void declaration
         */
        V remove(Object key, int hash) {
            this.lock();
            try {
                ReferenceEntry<K, V> first;
                long now = this.map.ticker.read();
                this.preWriteCleanup(now);
                AtomicReferenceArray<ReferenceEntry<K, V>> table = this.table;
                int index = hash & table.length() - 1;
                for (ReferenceEntry<K, V> e = first = table.get(index); e != null; e = e.getNext()) {
                    void var1_2;
                    void var2_6;
                    RemovalCause cause;
                    K entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !this.map.keyEquivalence.equivalent(key, entryKey)) continue;
                    ValueReference<K, V> valueReference = e.getValueReference();
                    V entryValue = valueReference.get();
                    if (entryValue != null) {
                        cause = RemovalCause.EXPLICIT;
                    } else if (valueReference.isActive()) {
                        cause = RemovalCause.COLLECTED;
                    } else {
                        return null;
                    }
                    ++this.modCount;
                    ReferenceEntry<K, V> newFirst = this.removeValueFromChain(first, e, entryKey, hash, entryValue, valueReference, cause);
                    int newCount = this.count - 1;
                    table.set(index, (ReferenceEntry<K, V>)var2_6);
                    this.count = var1_2;
                    V v = entryValue;
                    return v;
                }
                return null;
            }
            finally {
                this.unlock();
                this.postWriteCleanup();
            }
        }

        /*
         * WARNING - void declaration
         */
        boolean remove(Object key, int hash, Object value) {
            this.lock();
            try {
                ReferenceEntry<K, V> first;
                long now = this.map.ticker.read();
                this.preWriteCleanup(now);
                AtomicReferenceArray<ReferenceEntry<K, V>> table = this.table;
                int index = hash & table.length() - 1;
                for (ReferenceEntry<K, V> e = first = table.get(index); e != null; e = e.getNext()) {
                    void var3_6;
                    boolean bl;
                    void var2_5;
                    RemovalCause cause;
                    K entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !this.map.keyEquivalence.equivalent(key, entryKey)) continue;
                    ValueReference<K, V> valueReference = e.getValueReference();
                    V entryValue = valueReference.get();
                    if (this.map.valueEquivalence.equivalent(value, entryValue)) {
                        cause = RemovalCause.EXPLICIT;
                    } else if (entryValue == null && valueReference.isActive()) {
                        cause = RemovalCause.COLLECTED;
                    } else {
                        return false;
                    }
                    ++this.modCount;
                    ReferenceEntry<K, V> newFirst = this.removeValueFromChain(first, e, entryKey, hash, entryValue, valueReference, cause);
                    int newCount = this.count - 1;
                    table.set(index, (ReferenceEntry<K, V>)var2_5);
                    this.count = bl;
                    bl = var3_6 == RemovalCause.EXPLICIT;
                    return bl;
                }
                return false;
            }
            finally {
                this.unlock();
                this.postWriteCleanup();
            }
        }

        /*
         * WARNING - void declaration
         */
        boolean storeLoadedValue(K key, int hash, LoadingValueReference<K, V> oldValueReference, V newValue) {
            this.lock();
            try {
                void var9_9;
                void var8_8;
                void var1_1;
                void var2_3;
                ReferenceEntry<K, V> first;
                long now = this.map.ticker.read();
                this.preWriteCleanup(now);
                int newCount = this.count + 1;
                if (newCount > this.threshold) {
                    this.expand();
                    newCount = this.count + 1;
                }
                AtomicReferenceArray<ReferenceEntry<K, V>> table = this.table;
                int index = hash & table.length() - 1;
                for (ReferenceEntry<K, V> e = first = table.get(index); e != null; e = e.getNext()) {
                    K entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !this.map.keyEquivalence.equivalent(key, entryKey)) continue;
                    ValueReference<K, V> valueReference = e.getValueReference();
                    V entryValue = valueReference.get();
                    if (oldValueReference == valueReference || entryValue == null && valueReference != UNSET) {
                        ++this.modCount;
                        if (oldValueReference.isActive()) {
                            RemovalCause cause = entryValue == null ? RemovalCause.COLLECTED : RemovalCause.REPLACED;
                            this.enqueueNotification(key, hash, entryValue, oldValueReference.getWeight(), cause);
                            --newCount;
                        }
                        this.setValue(e, key, newValue, now);
                        this.count = newCount;
                        this.evictEntries(e);
                        return true;
                    }
                    this.enqueueNotification(key, hash, newValue, 0, RemovalCause.REPLACED);
                    return false;
                }
                ++this.modCount;
                ReferenceEntry<K, V> newEntry = this.newEntry(key, (int)var2_3, first);
                this.setValue(newEntry, var1_1, newValue, now);
                var8_8.set((int)var9_9, newEntry);
                this.count = newCount;
                this.evictEntries(newEntry);
                return true;
            }
            finally {
                this.unlock();
                this.postWriteCleanup();
            }
        }

        void clear() {
            if (this.count != 0) {
                this.lock();
                try {
                    int i;
                    long now = this.map.ticker.read();
                    this.preWriteCleanup(now);
                    AtomicReferenceArray<ReferenceEntry<K, V>> table = this.table;
                    for (i = 0; i < table.length(); ++i) {
                        for (ReferenceEntry<K, V> e = table.get(i); e != null; e = e.getNext()) {
                            if (!e.getValueReference().isActive()) continue;
                            K key = e.getKey();
                            V value = e.getValueReference().get();
                            RemovalCause cause = key == null || value == null ? RemovalCause.COLLECTED : RemovalCause.EXPLICIT;
                            this.enqueueNotification(key, e.getHash(), value, e.getValueReference().getWeight(), cause);
                        }
                    }
                    for (i = 0; i < table.length(); ++i) {
                        table.set(i, null);
                    }
                    this.clearReferenceQueues();
                    this.writeQueue.clear();
                    this.accessQueue.clear();
                    this.readCount.set(0);
                    ++this.modCount;
                    this.count = 0;
                    return;
                }
                finally {
                    this.unlock();
                    this.postWriteCleanup();
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        ReferenceEntry<K, V> removeValueFromChain(ReferenceEntry<K, V> first, ReferenceEntry<K, V> entry, K key, int hash, V value, ValueReference<K, V> valueReference, RemovalCause cause) {
            void var2_2;
            void var1_1;
            void var3_3;
            this.enqueueNotification(var3_3, hash, value, valueReference.getWeight(), cause);
            this.writeQueue.remove(entry);
            this.accessQueue.remove(entry);
            if (valueReference.isLoading()) {
                valueReference.notifyNewValue(null);
                return first;
            }
            return this.removeEntryFromChain((ReferenceEntry<K, V>)var1_1, (ReferenceEntry<K, V>)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        ReferenceEntry<K, V> removeEntryFromChain(ReferenceEntry<K, V> first, ReferenceEntry<K, V> entry) {
            void var3_3;
            ReferenceEntry e;
            int newCount = this.count;
            ReferenceEntry<K, V> newFirst = entry.getNext();
            while (e != entry) {
                ReferenceEntry<K, V> next = this.copyEntry(e, newFirst);
                if (next != null) {
                    newFirst = next;
                } else {
                    this.removeCollectedEntry(e);
                    --newCount;
                }
                e = e.getNext();
            }
            this.count = var3_3;
            return newFirst;
        }

        /*
         * WARNING - void declaration
         */
        void removeCollectedEntry(ReferenceEntry<K, V> entry) {
            void var1_1;
            this.enqueueNotification(entry.getKey(), entry.getHash(), entry.getValueReference().get(), entry.getValueReference().getWeight(), RemovalCause.COLLECTED);
            this.writeQueue.remove(entry);
            this.accessQueue.remove(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        boolean reclaimKey(ReferenceEntry<K, V> entry, int hash) {
            this.lock();
            try {
                ReferenceEntry<K, V> first;
                AtomicReferenceArray<ReferenceEntry<K, V>> table = this.table;
                int index = hash & table.length() - 1;
                for (ReferenceEntry<K, V> e = first = table.get(index); e != null; e = e.getNext()) {
                    void var1_2;
                    void var2_5;
                    if (e != entry) continue;
                    ++this.modCount;
                    ReferenceEntry<K, V> referenceEntry = e;
                    ReferenceEntry<K, V> newFirst = this.removeValueFromChain(first, referenceEntry, referenceEntry.getKey(), hash, e.getValueReference().get(), e.getValueReference(), RemovalCause.COLLECTED);
                    int newCount = this.count - 1;
                    table.set(index, (ReferenceEntry<K, V>)var2_5);
                    this.count = var1_2;
                    return true;
                }
                return false;
            }
            finally {
                this.unlock();
                this.postWriteCleanup();
            }
        }

        /*
         * WARNING - void declaration
         */
        boolean reclaimValue(K key, int hash, ValueReference<K, V> valueReference) {
            this.lock();
            try {
                ReferenceEntry<K, V> first;
                AtomicReferenceArray<ReferenceEntry<K, V>> table = this.table;
                int index = hash & table.length() - 1;
                for (ReferenceEntry<K, V> e = first = table.get(index); e != null; e = e.getNext()) {
                    K entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !this.map.keyEquivalence.equivalent(key, entryKey)) continue;
                    key = e.getValueReference();
                    if (key == valueReference) {
                        void var1_2;
                        void var2_5;
                        ++this.modCount;
                        ReferenceEntry<K, V> newFirst = this.removeValueFromChain(first, e, entryKey, hash, valueReference.get(), valueReference, RemovalCause.COLLECTED);
                        int newCount = this.count - 1;
                        table.set(index, (ReferenceEntry<K, V>)var2_5);
                        this.count = var1_2;
                        return true;
                    }
                    return false;
                }
                return false;
            }
            finally {
                this.unlock();
                if (!this.isHeldByCurrentThread()) {
                    this.postWriteCleanup();
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        boolean removeLoadingValue(K key, int hash, LoadingValueReference<K, V> valueReference) {
            this.lock();
            try {
                ReferenceEntry<K, V> first;
                AtomicReferenceArray<ReferenceEntry<K, V>> table = this.table;
                int index = hash & table.length() - 1;
                for (ReferenceEntry<K, V> e = first = table.get(index); e != null; e = e.getNext()) {
                    K entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !this.map.keyEquivalence.equivalent(key, entryKey)) continue;
                    key = e.getValueReference();
                    if (key == valueReference) {
                        if (valueReference.isActive()) {
                            e.setValueReference(valueReference.getOldValue());
                        } else {
                            void var1_1;
                            ReferenceEntry<K, V> newFirst = this.removeEntryFromChain(first, e);
                            table.set(index, (ReferenceEntry<K, V>)var1_1);
                        }
                        return true;
                    }
                    return false;
                }
                return false;
            }
            finally {
                this.unlock();
                this.postWriteCleanup();
            }
        }

        /*
         * WARNING - void declaration
         */
        @VisibleForTesting
        boolean removeEntry(ReferenceEntry<K, V> entry, int hash, RemovalCause cause) {
            ReferenceEntry<K, V> first;
            AtomicReferenceArray<ReferenceEntry<K, V>> table = this.table;
            int index = hash & table.length() - 1;
            for (ReferenceEntry<K, V> e = first = table.get(index); e != null; e = e.getNext()) {
                void var1_2;
                void var2_4;
                if (e != entry) continue;
                ++this.modCount;
                ReferenceEntry<K, V> referenceEntry = e;
                ReferenceEntry<K, V> newFirst = this.removeValueFromChain(first, referenceEntry, referenceEntry.getKey(), hash, e.getValueReference().get(), e.getValueReference(), cause);
                int newCount = this.count - 1;
                table.set(index, (ReferenceEntry<K, V>)var2_4);
                this.count = var1_2;
                return true;
            }
            return false;
        }

        void postReadCleanup() {
            if ((this.readCount.incrementAndGet() & 0x3F) == 0) {
                this.cleanUp();
            }
        }

        /*
         * WARNING - void declaration
         */
        void preWriteCleanup(long now) {
            void var1_1;
            this.runLockedCleanup((long)var1_1);
        }

        void postWriteCleanup() {
            this.runUnlockedCleanup();
        }

        /*
         * WARNING - void declaration
         */
        void cleanUp() {
            void var1_1;
            long now = this.map.ticker.read();
            this.runLockedCleanup((long)var1_1);
            this.runUnlockedCleanup();
        }

        /*
         * WARNING - void declaration
         */
        void runLockedCleanup(long now) {
            if (this.tryLock()) {
                try {
                    void var1_1;
                    this.drainReferenceQueues();
                    this.expireEntries((long)var1_1);
                    this.readCount.set(0);
                    return;
                }
                finally {
                    this.unlock();
                }
            }
        }

        void runUnlockedCleanup() {
            if (!this.isHeldByCurrentThread()) {
                this.map.processPendingNotifications();
            }
        }
    }

    static final class WeightedStrongValueReference<K, V>
    extends StrongValueReference<K, V> {
        final int weight;

        /*
         * WARNING - void declaration
         */
        WeightedStrongValueReference(V referent, int weight) {
            super(var1_1);
            void var2_2;
            void var1_1;
            this.weight = var2_2;
        }

        @Override
        public final int getWeight() {
            return this.weight;
        }
    }

    static final class WeightedSoftValueReference<K, V>
    extends SoftValueReference<K, V> {
        final int weight;

        /*
         * WARNING - void declaration
         */
        WeightedSoftValueReference(ReferenceQueue<V> queue, V referent, ReferenceEntry<K, V> entry, int weight) {
            super(var1_1, var2_2, var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
            this.weight = weight;
        }

        @Override
        public final int getWeight() {
            return this.weight;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ValueReference<K, V> copyFor(ReferenceQueue<V> queue, V value, ReferenceEntry<K, V> entry) {
            void var3_3;
            void var2_2;
            void var1_1;
            return new WeightedSoftValueReference<K, void>((ReferenceQueue<void>)var1_1, var2_2, var3_3, this.weight);
        }
    }

    static final class WeightedWeakValueReference<K, V>
    extends WeakValueReference<K, V> {
        final int weight;

        /*
         * WARNING - void declaration
         */
        WeightedWeakValueReference(ReferenceQueue<V> queue, V referent, ReferenceEntry<K, V> entry, int weight) {
            super(var1_1, var2_2, var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
            this.weight = weight;
        }

        @Override
        public final int getWeight() {
            return this.weight;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ValueReference<K, V> copyFor(ReferenceQueue<V> queue, V value, ReferenceEntry<K, V> entry) {
            void var3_3;
            void var2_2;
            void var1_1;
            return new WeightedWeakValueReference<K, void>((ReferenceQueue<void>)var1_1, var2_2, var3_3, this.weight);
        }
    }

    static class StrongValueReference<K, V>
    implements ValueReference<K, V> {
        final V referent;

        /*
         * WARNING - void declaration
         */
        StrongValueReference(V referent) {
            void var1_1;
            this.referent = var1_1;
        }

        @Override
        public V get() {
            return this.referent;
        }

        @Override
        public int getWeight() {
            return 1;
        }

        @Override
        public ReferenceEntry<K, V> getEntry() {
            return null;
        }

        @Override
        public ValueReference<K, V> copyFor(ReferenceQueue<V> queue, V value, ReferenceEntry<K, V> entry) {
            return this;
        }

        @Override
        public boolean isLoading() {
            return false;
        }

        @Override
        public boolean isActive() {
            return true;
        }

        @Override
        public V waitForValue() {
            return this.get();
        }

        @Override
        public void notifyNewValue(V newValue) {
        }
    }

    static class SoftValueReference<K, V>
    extends SoftReference<V>
    implements ValueReference<K, V> {
        final ReferenceEntry<K, V> entry;

        /*
         * WARNING - void declaration
         */
        SoftValueReference(ReferenceQueue<V> queue, V referent, ReferenceEntry<K, V> entry) {
            super(var2_2, var1_1);
            void var3_3;
            void var1_1;
            void var2_2;
            this.entry = var3_3;
        }

        @Override
        public int getWeight() {
            return 1;
        }

        @Override
        public ReferenceEntry<K, V> getEntry() {
            return this.entry;
        }

        @Override
        public void notifyNewValue(V newValue) {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ValueReference<K, V> copyFor(ReferenceQueue<V> queue, V value, ReferenceEntry<K, V> entry) {
            void var3_3;
            void var2_2;
            void var1_1;
            return new SoftValueReference<K, void>((ReferenceQueue<void>)var1_1, var2_2, var3_3);
        }

        @Override
        public boolean isLoading() {
            return false;
        }

        @Override
        public boolean isActive() {
            return true;
        }

        @Override
        public V waitForValue() {
            return (V)this.get();
        }
    }

    static class WeakValueReference<K, V>
    extends WeakReference<V>
    implements ValueReference<K, V> {
        final ReferenceEntry<K, V> entry;

        /*
         * WARNING - void declaration
         */
        WeakValueReference(ReferenceQueue<V> queue, V referent, ReferenceEntry<K, V> entry) {
            super(var2_2, var1_1);
            void var3_3;
            void var1_1;
            void var2_2;
            this.entry = var3_3;
        }

        @Override
        public int getWeight() {
            return 1;
        }

        @Override
        public ReferenceEntry<K, V> getEntry() {
            return this.entry;
        }

        @Override
        public void notifyNewValue(V newValue) {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ValueReference<K, V> copyFor(ReferenceQueue<V> queue, V value, ReferenceEntry<K, V> entry) {
            void var3_3;
            void var2_2;
            void var1_1;
            return new WeakValueReference<K, void>((ReferenceQueue<void>)var1_1, var2_2, var3_3);
        }

        @Override
        public boolean isLoading() {
            return false;
        }

        @Override
        public boolean isActive() {
            return true;
        }

        @Override
        public V waitForValue() {
            return (V)this.get();
        }
    }

    static final class WeakAccessWriteEntry<K, V>
    extends WeakEntry<K, V> {
        volatile long accessTime = Long.MAX_VALUE;
        ReferenceEntry<K, V> nextAccess = LocalCache.nullEntry();
        ReferenceEntry<K, V> previousAccess = LocalCache.nullEntry();
        volatile long writeTime = Long.MAX_VALUE;
        ReferenceEntry<K, V> nextWrite = LocalCache.nullEntry();
        ReferenceEntry<K, V> previousWrite = LocalCache.nullEntry();

        /*
         * WARNING - void declaration
         */
        WeakAccessWriteEntry(ReferenceQueue<K> queue, K key, int hash, ReferenceEntry<K, V> next) {
            super(var1_1, var2_2, (int)var3_3, next);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        @Override
        public final long getAccessTime() {
            return this.accessTime;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setAccessTime(long time) {
            void var1_1;
            this.accessTime = var1_1;
        }

        @Override
        public final ReferenceEntry<K, V> getNextInAccessQueue() {
            return this.nextAccess;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setNextInAccessQueue(ReferenceEntry<K, V> next) {
            void var1_1;
            this.nextAccess = var1_1;
        }

        @Override
        public final ReferenceEntry<K, V> getPreviousInAccessQueue() {
            return this.previousAccess;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setPreviousInAccessQueue(ReferenceEntry<K, V> previous) {
            void var1_1;
            this.previousAccess = var1_1;
        }

        @Override
        public final long getWriteTime() {
            return this.writeTime;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setWriteTime(long time) {
            void var1_1;
            this.writeTime = var1_1;
        }

        @Override
        public final ReferenceEntry<K, V> getNextInWriteQueue() {
            return this.nextWrite;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setNextInWriteQueue(ReferenceEntry<K, V> next) {
            void var1_1;
            this.nextWrite = var1_1;
        }

        @Override
        public final ReferenceEntry<K, V> getPreviousInWriteQueue() {
            return this.previousWrite;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setPreviousInWriteQueue(ReferenceEntry<K, V> previous) {
            void var1_1;
            this.previousWrite = var1_1;
        }
    }

    static final class WeakWriteEntry<K, V>
    extends WeakEntry<K, V> {
        volatile long writeTime = Long.MAX_VALUE;
        ReferenceEntry<K, V> nextWrite = LocalCache.nullEntry();
        ReferenceEntry<K, V> previousWrite = LocalCache.nullEntry();

        /*
         * WARNING - void declaration
         */
        WeakWriteEntry(ReferenceQueue<K> queue, K key, int hash, ReferenceEntry<K, V> next) {
            super(var1_1, var2_2, (int)var3_3, next);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        @Override
        public final long getWriteTime() {
            return this.writeTime;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setWriteTime(long time) {
            void var1_1;
            this.writeTime = var1_1;
        }

        @Override
        public final ReferenceEntry<K, V> getNextInWriteQueue() {
            return this.nextWrite;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setNextInWriteQueue(ReferenceEntry<K, V> next) {
            void var1_1;
            this.nextWrite = var1_1;
        }

        @Override
        public final ReferenceEntry<K, V> getPreviousInWriteQueue() {
            return this.previousWrite;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setPreviousInWriteQueue(ReferenceEntry<K, V> previous) {
            void var1_1;
            this.previousWrite = var1_1;
        }
    }

    static final class WeakAccessEntry<K, V>
    extends WeakEntry<K, V> {
        volatile long accessTime = Long.MAX_VALUE;
        ReferenceEntry<K, V> nextAccess = LocalCache.nullEntry();
        ReferenceEntry<K, V> previousAccess = LocalCache.nullEntry();

        /*
         * WARNING - void declaration
         */
        WeakAccessEntry(ReferenceQueue<K> queue, K key, int hash, ReferenceEntry<K, V> next) {
            super(var1_1, var2_2, (int)var3_3, next);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        @Override
        public final long getAccessTime() {
            return this.accessTime;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setAccessTime(long time) {
            void var1_1;
            this.accessTime = var1_1;
        }

        @Override
        public final ReferenceEntry<K, V> getNextInAccessQueue() {
            return this.nextAccess;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setNextInAccessQueue(ReferenceEntry<K, V> next) {
            void var1_1;
            this.nextAccess = var1_1;
        }

        @Override
        public final ReferenceEntry<K, V> getPreviousInAccessQueue() {
            return this.previousAccess;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setPreviousInAccessQueue(ReferenceEntry<K, V> previous) {
            void var1_1;
            this.previousAccess = var1_1;
        }
    }

    static class WeakEntry<K, V>
    extends WeakReference<K>
    implements ReferenceEntry<K, V> {
        final int hash;
        final ReferenceEntry<K, V> next;
        volatile ValueReference<K, V> valueReference = LocalCache.unset();

        /*
         * WARNING - void declaration
         */
        WeakEntry(ReferenceQueue<K> queue, K key, int hash, ReferenceEntry<K, V> next) {
            super(var2_2, var1_1);
            void var3_3;
            void var1_1;
            void var2_2;
            this.hash = var3_3;
            this.next = next;
        }

        @Override
        public K getKey() {
            return (K)this.get();
        }

        @Override
        public long getAccessTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setAccessTime(long time) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getNextInAccessQueue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setNextInAccessQueue(ReferenceEntry<K, V> next) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getPreviousInAccessQueue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPreviousInAccessQueue(ReferenceEntry<K, V> previous) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getWriteTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setWriteTime(long time) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getNextInWriteQueue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setNextInWriteQueue(ReferenceEntry<K, V> next) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getPreviousInWriteQueue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPreviousInWriteQueue(ReferenceEntry<K, V> previous) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ValueReference<K, V> getValueReference() {
            return this.valueReference;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void setValueReference(ValueReference<K, V> valueReference) {
            void var1_1;
            this.valueReference = var1_1;
        }

        @Override
        public int getHash() {
            return this.hash;
        }

        @Override
        public ReferenceEntry<K, V> getNext() {
            return this.next;
        }
    }

    static final class StrongAccessWriteEntry<K, V>
    extends StrongEntry<K, V> {
        volatile long accessTime = Long.MAX_VALUE;
        ReferenceEntry<K, V> nextAccess = LocalCache.nullEntry();
        ReferenceEntry<K, V> previousAccess = LocalCache.nullEntry();
        volatile long writeTime = Long.MAX_VALUE;
        ReferenceEntry<K, V> nextWrite = LocalCache.nullEntry();
        ReferenceEntry<K, V> previousWrite = LocalCache.nullEntry();

        /*
         * WARNING - void declaration
         */
        StrongAccessWriteEntry(K key, int hash, ReferenceEntry<K, V> next) {
            super(var1_1, (int)var2_2, var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        @Override
        public final long getAccessTime() {
            return this.accessTime;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setAccessTime(long time) {
            void var1_1;
            this.accessTime = var1_1;
        }

        @Override
        public final ReferenceEntry<K, V> getNextInAccessQueue() {
            return this.nextAccess;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setNextInAccessQueue(ReferenceEntry<K, V> next) {
            void var1_1;
            this.nextAccess = var1_1;
        }

        @Override
        public final ReferenceEntry<K, V> getPreviousInAccessQueue() {
            return this.previousAccess;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setPreviousInAccessQueue(ReferenceEntry<K, V> previous) {
            void var1_1;
            this.previousAccess = var1_1;
        }

        @Override
        public final long getWriteTime() {
            return this.writeTime;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setWriteTime(long time) {
            void var1_1;
            this.writeTime = var1_1;
        }

        @Override
        public final ReferenceEntry<K, V> getNextInWriteQueue() {
            return this.nextWrite;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setNextInWriteQueue(ReferenceEntry<K, V> next) {
            void var1_1;
            this.nextWrite = var1_1;
        }

        @Override
        public final ReferenceEntry<K, V> getPreviousInWriteQueue() {
            return this.previousWrite;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setPreviousInWriteQueue(ReferenceEntry<K, V> previous) {
            void var1_1;
            this.previousWrite = var1_1;
        }
    }

    static final class StrongWriteEntry<K, V>
    extends StrongEntry<K, V> {
        volatile long writeTime = Long.MAX_VALUE;
        ReferenceEntry<K, V> nextWrite = LocalCache.nullEntry();
        ReferenceEntry<K, V> previousWrite = LocalCache.nullEntry();

        /*
         * WARNING - void declaration
         */
        StrongWriteEntry(K key, int hash, ReferenceEntry<K, V> next) {
            super(var1_1, (int)var2_2, var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        @Override
        public final long getWriteTime() {
            return this.writeTime;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setWriteTime(long time) {
            void var1_1;
            this.writeTime = var1_1;
        }

        @Override
        public final ReferenceEntry<K, V> getNextInWriteQueue() {
            return this.nextWrite;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setNextInWriteQueue(ReferenceEntry<K, V> next) {
            void var1_1;
            this.nextWrite = var1_1;
        }

        @Override
        public final ReferenceEntry<K, V> getPreviousInWriteQueue() {
            return this.previousWrite;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setPreviousInWriteQueue(ReferenceEntry<K, V> previous) {
            void var1_1;
            this.previousWrite = var1_1;
        }
    }

    static final class StrongAccessEntry<K, V>
    extends StrongEntry<K, V> {
        volatile long accessTime = Long.MAX_VALUE;
        ReferenceEntry<K, V> nextAccess = LocalCache.nullEntry();
        ReferenceEntry<K, V> previousAccess = LocalCache.nullEntry();

        /*
         * WARNING - void declaration
         */
        StrongAccessEntry(K key, int hash, ReferenceEntry<K, V> next) {
            super(var1_1, (int)var2_2, var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        @Override
        public final long getAccessTime() {
            return this.accessTime;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setAccessTime(long time) {
            void var1_1;
            this.accessTime = var1_1;
        }

        @Override
        public final ReferenceEntry<K, V> getNextInAccessQueue() {
            return this.nextAccess;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setNextInAccessQueue(ReferenceEntry<K, V> next) {
            void var1_1;
            this.nextAccess = var1_1;
        }

        @Override
        public final ReferenceEntry<K, V> getPreviousInAccessQueue() {
            return this.previousAccess;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setPreviousInAccessQueue(ReferenceEntry<K, V> previous) {
            void var1_1;
            this.previousAccess = var1_1;
        }
    }

    static class StrongEntry<K, V>
    extends AbstractReferenceEntry<K, V> {
        final K key;
        final int hash;
        final ReferenceEntry<K, V> next;
        volatile ValueReference<K, V> valueReference = LocalCache.unset();

        /*
         * WARNING - void declaration
         */
        StrongEntry(K key, int hash, ReferenceEntry<K, V> next) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.key = var1_1;
            this.hash = var2_2;
            this.next = var3_3;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public ValueReference<K, V> getValueReference() {
            return this.valueReference;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void setValueReference(ValueReference<K, V> valueReference) {
            void var1_1;
            this.valueReference = var1_1;
        }

        @Override
        public int getHash() {
            return this.hash;
        }

        @Override
        public ReferenceEntry<K, V> getNext() {
            return this.next;
        }
    }

    static abstract class AbstractReferenceEntry<K, V>
    implements ReferenceEntry<K, V> {
        AbstractReferenceEntry() {
        }

        @Override
        public ValueReference<K, V> getValueReference() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setValueReference(ValueReference<K, V> valueReference) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getNext() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public K getKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getAccessTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setAccessTime(long time) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getNextInAccessQueue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setNextInAccessQueue(ReferenceEntry<K, V> next) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getPreviousInAccessQueue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPreviousInAccessQueue(ReferenceEntry<K, V> previous) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getWriteTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setWriteTime(long time) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getNextInWriteQueue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setNextInWriteQueue(ReferenceEntry<K, V> next) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getPreviousInWriteQueue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPreviousInWriteQueue(ReferenceEntry<K, V> previous) {
            throw new UnsupportedOperationException();
        }
    }

    private static enum NullEntry implements ReferenceEntry<Object, Object>
    {
        INSTANCE;


        @Override
        public final ValueReference<Object, Object> getValueReference() {
            return null;
        }

        @Override
        public final void setValueReference(ValueReference<Object, Object> valueReference) {
        }

        @Override
        public final ReferenceEntry<Object, Object> getNext() {
            return null;
        }

        @Override
        public final int getHash() {
            return 0;
        }

        @Override
        public final Object getKey() {
            return null;
        }

        @Override
        public final long getAccessTime() {
            return 0L;
        }

        @Override
        public final void setAccessTime(long time) {
        }

        @Override
        public final ReferenceEntry<Object, Object> getNextInAccessQueue() {
            return this;
        }

        @Override
        public final void setNextInAccessQueue(ReferenceEntry<Object, Object> next) {
        }

        @Override
        public final ReferenceEntry<Object, Object> getPreviousInAccessQueue() {
            return this;
        }

        @Override
        public final void setPreviousInAccessQueue(ReferenceEntry<Object, Object> previous) {
        }

        @Override
        public final long getWriteTime() {
            return 0L;
        }

        @Override
        public final void setWriteTime(long time) {
        }

        @Override
        public final ReferenceEntry<Object, Object> getNextInWriteQueue() {
            return this;
        }

        @Override
        public final void setNextInWriteQueue(ReferenceEntry<Object, Object> next) {
        }

        @Override
        public final ReferenceEntry<Object, Object> getPreviousInWriteQueue() {
            return this;
        }

        @Override
        public final void setPreviousInWriteQueue(ReferenceEntry<Object, Object> previous) {
        }
    }

    static interface ValueReference<K, V> {
        public V get();

        public V waitForValue() throws ExecutionException;

        public int getWeight();

        public ReferenceEntry<K, V> getEntry();

        public ValueReference<K, V> copyFor(ReferenceQueue<V> var1, V var2, ReferenceEntry<K, V> var3);

        public void notifyNewValue(V var1);

        public boolean isLoading();

        public boolean isActive();
    }

    static enum EntryFactory {
        STRONG{

            /*
             * WARNING - void declaration
             */
            @Override
            final <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K key, int hash, ReferenceEntry<K, V> next) {
                void var3_3;
                void var2_2;
                return new StrongEntry<void, V>(var2_2, (int)var3_3, next);
            }
        }
        ,
        STRONG_ACCESS{

            /*
             * WARNING - void declaration
             */
            @Override
            final <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K key, int hash, ReferenceEntry<K, V> next) {
                void var3_3;
                void var2_2;
                return new StrongAccessEntry<void, V>(var2_2, (int)var3_3, next);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            final <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> segment, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                void var1_1;
                void var2_2;
                void var3_3;
                ReferenceEntry<K, V> newEntry = super.copyEntry(segment, original, var3_3);
                this.copyAccessEntry(var2_2, newEntry);
                return var1_1;
            }
        }
        ,
        STRONG_WRITE{

            /*
             * WARNING - void declaration
             */
            @Override
            final <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K key, int hash, ReferenceEntry<K, V> next) {
                void var3_3;
                void var2_2;
                return new StrongWriteEntry<void, V>(var2_2, (int)var3_3, next);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            final <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> segment, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                void var1_1;
                void var2_2;
                void var3_3;
                ReferenceEntry<K, V> newEntry = super.copyEntry(segment, original, var3_3);
                this.copyWriteEntry(var2_2, newEntry);
                return var1_1;
            }
        }
        ,
        STRONG_ACCESS_WRITE{

            /*
             * WARNING - void declaration
             */
            @Override
            final <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K key, int hash, ReferenceEntry<K, V> next) {
                void var3_3;
                void var2_2;
                return new StrongAccessWriteEntry<void, V>(var2_2, (int)var3_3, next);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            final <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> segment, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                void var1_1;
                void var2_2;
                void var3_3;
                ReferenceEntry<K, V> newEntry = super.copyEntry(segment, original, var3_3);
                this.copyAccessEntry(original, newEntry);
                this.copyWriteEntry(var2_2, newEntry);
                return var1_1;
            }
        }
        ,
        WEAK{

            /*
             * WARNING - void declaration
             */
            @Override
            final <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K key, int hash, ReferenceEntry<K, V> next) {
                void var3_3;
                void var2_2;
                void var1_1;
                return new WeakEntry<void, V>(var1_1.keyReferenceQueue, var2_2, (int)var3_3, next);
            }
        }
        ,
        WEAK_ACCESS{

            /*
             * WARNING - void declaration
             */
            @Override
            final <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K key, int hash, ReferenceEntry<K, V> next) {
                void var3_3;
                void var2_2;
                void var1_1;
                return new WeakAccessEntry<void, V>(var1_1.keyReferenceQueue, var2_2, (int)var3_3, next);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            final <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> segment, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                void var1_1;
                void var2_2;
                void var3_3;
                ReferenceEntry<K, V> newEntry = super.copyEntry(segment, original, var3_3);
                this.copyAccessEntry(var2_2, newEntry);
                return var1_1;
            }
        }
        ,
        WEAK_WRITE{

            /*
             * WARNING - void declaration
             */
            @Override
            final <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K key, int hash, ReferenceEntry<K, V> next) {
                void var3_3;
                void var2_2;
                void var1_1;
                return new WeakWriteEntry<void, V>(var1_1.keyReferenceQueue, var2_2, (int)var3_3, next);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            final <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> segment, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                void var1_1;
                void var2_2;
                void var3_3;
                ReferenceEntry<K, V> newEntry = super.copyEntry(segment, original, var3_3);
                this.copyWriteEntry(var2_2, newEntry);
                return var1_1;
            }
        }
        ,
        WEAK_ACCESS_WRITE{

            /*
             * WARNING - void declaration
             */
            @Override
            final <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K key, int hash, ReferenceEntry<K, V> next) {
                void var3_3;
                void var2_2;
                void var1_1;
                return new WeakAccessWriteEntry<void, V>(var1_1.keyReferenceQueue, var2_2, (int)var3_3, next);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            final <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> segment, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                void var1_1;
                void var2_2;
                void var3_3;
                ReferenceEntry<K, V> newEntry = super.copyEntry(segment, original, var3_3);
                this.copyAccessEntry(original, newEntry);
                this.copyWriteEntry(var2_2, newEntry);
                return var1_1;
            }
        };

        static final int ACCESS_MASK = 1;
        static final int WRITE_MASK = 2;
        static final int WEAK_MASK = 4;
        static final EntryFactory[] factories;

        /*
         * WARNING - void declaration
         */
        static EntryFactory getFactory(Strength keyStrength, boolean usesAccessQueue, boolean usesWriteQueue) {
            void var0_1;
            void var2_3;
            void var1_2;
            int flags = (keyStrength == Strength.WEAK ? 4 : 0) | (var1_2 != false ? 1 : 0) | (var2_3 != false ? 2 : 0);
            return factories[var0_1];
        }

        abstract <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> var1, K var2, int var3, ReferenceEntry<K, V> var4);

        /*
         * WARNING - void declaration
         */
        <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> segment, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.newEntry((Segment<K, V>)var1_1, original.getKey(), var2_2.getHash(), (ReferenceEntry<K, V>)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        <K, V> void copyAccessEntry(ReferenceEntry<K, V> original, ReferenceEntry<K, V> newEntry) {
            void var1_1;
            void var2_2;
            newEntry.setAccessTime(original.getAccessTime());
            LocalCache.connectAccessOrder(original.getPreviousInAccessQueue(), newEntry);
            LocalCache.connectAccessOrder(var2_2, original.getNextInAccessQueue());
            LocalCache.nullifyAccessOrder(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        <K, V> void copyWriteEntry(ReferenceEntry<K, V> original, ReferenceEntry<K, V> newEntry) {
            void var1_1;
            void var2_2;
            newEntry.setWriteTime(original.getWriteTime());
            LocalCache.connectWriteOrder(original.getPreviousInWriteQueue(), newEntry);
            LocalCache.connectWriteOrder(var2_2, original.getNextInWriteQueue());
            LocalCache.nullifyWriteOrder(var1_1);
        }

        static {
            factories = new EntryFactory[]{STRONG, STRONG_ACCESS, STRONG_WRITE, STRONG_ACCESS_WRITE, WEAK, WEAK_ACCESS, WEAK_WRITE, WEAK_ACCESS_WRITE};
        }
    }

    static enum Strength {
        STRONG{

            /*
             * WARNING - void declaration
             */
            @Override
            final <K, V> ValueReference<K, V> referenceValue(Segment<K, V> segment, ReferenceEntry<K, V> entry, V value, int weight) {
                void var3_3;
                if (weight == 1) {
                    return new StrongValueReference(value);
                }
                return new WeightedStrongValueReference(var3_3, weight);
            }

            @Override
            final Equivalence<Object> defaultEquivalence() {
                return Equivalence.equals();
            }
        }
        ,
        SOFT{

            /*
             * WARNING - void declaration
             */
            @Override
            final <K, V> ValueReference<K, V> referenceValue(Segment<K, V> segment, ReferenceEntry<K, V> entry, V value, int weight) {
                void var2_2;
                void var3_3;
                void var1_1;
                if (weight == 1) {
                    return new SoftValueReference(segment.valueReferenceQueue, value, entry);
                }
                return new WeightedSoftValueReference(var1_1.valueReferenceQueue, var3_3, var2_2, weight);
            }

            @Override
            final Equivalence<Object> defaultEquivalence() {
                return Equivalence.identity();
            }
        }
        ,
        WEAK{

            /*
             * WARNING - void declaration
             */
            @Override
            final <K, V> ValueReference<K, V> referenceValue(Segment<K, V> segment, ReferenceEntry<K, V> entry, V value, int weight) {
                void var2_2;
                void var3_3;
                void var1_1;
                if (weight == 1) {
                    return new WeakValueReference(segment.valueReferenceQueue, value, entry);
                }
                return new WeightedWeakValueReference(var1_1.valueReferenceQueue, var3_3, var2_2, weight);
            }

            @Override
            final Equivalence<Object> defaultEquivalence() {
                return Equivalence.identity();
            }
        };


        abstract <K, V> ValueReference<K, V> referenceValue(Segment<K, V> var1, ReferenceEntry<K, V> var2, V var3, int var4);

        abstract Equivalence<Object> defaultEquivalence();
    }
}

