/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.cache;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.cache.ElementTypesAreNonnullByDefault;
import com.google.common.math.LongMath;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public final class CacheStats {
    private final long hitCount;
    private final long missCount;
    private final long loadSuccessCount;
    private final long loadExceptionCount;
    private final long totalLoadTime;
    private final long evictionCount;

    /*
     * WARNING - void declaration
     */
    public CacheStats(long hitCount, long missCount, long loadSuccessCount, long loadExceptionCount, long totalLoadTime, long evictionCount) {
        void var3_2;
        void var1_1;
        Preconditions.checkArgument(hitCount >= 0L);
        Preconditions.checkArgument(missCount >= 0L);
        Preconditions.checkArgument(loadSuccessCount >= 0L);
        Preconditions.checkArgument(loadExceptionCount >= 0L);
        Preconditions.checkArgument(totalLoadTime >= 0L);
        Preconditions.checkArgument(evictionCount >= 0L);
        this.hitCount = var1_1;
        this.missCount = var3_2;
        this.loadSuccessCount = loadSuccessCount;
        this.loadExceptionCount = loadExceptionCount;
        this.totalLoadTime = totalLoadTime;
        this.evictionCount = evictionCount;
    }

    public final long requestCount() {
        return LongMath.saturatedAdd(this.hitCount, this.missCount);
    }

    public final long hitCount() {
        return this.hitCount;
    }

    /*
     * WARNING - void declaration
     */
    public final double hitRate() {
        void var1_1;
        long requestCount = this.requestCount();
        if (requestCount == 0L) {
            return 1.0;
        }
        return (double)this.hitCount / (double)var1_1;
    }

    public final long missCount() {
        return this.missCount;
    }

    /*
     * WARNING - void declaration
     */
    public final double missRate() {
        void var1_1;
        long requestCount = this.requestCount();
        if (requestCount == 0L) {
            return 0.0;
        }
        return (double)this.missCount / (double)var1_1;
    }

    public final long loadCount() {
        return LongMath.saturatedAdd(this.loadSuccessCount, this.loadExceptionCount);
    }

    public final long loadSuccessCount() {
        return this.loadSuccessCount;
    }

    public final long loadExceptionCount() {
        return this.loadExceptionCount;
    }

    /*
     * WARNING - void declaration
     */
    public final double loadExceptionRate() {
        void var1_1;
        long totalLoadCount = LongMath.saturatedAdd(this.loadSuccessCount, this.loadExceptionCount);
        if (totalLoadCount == 0L) {
            return 0.0;
        }
        return (double)this.loadExceptionCount / (double)var1_1;
    }

    public final long totalLoadTime() {
        return this.totalLoadTime;
    }

    /*
     * WARNING - void declaration
     */
    public final double averageLoadPenalty() {
        void var1_1;
        long totalLoadCount = LongMath.saturatedAdd(this.loadSuccessCount, this.loadExceptionCount);
        if (totalLoadCount == 0L) {
            return 0.0;
        }
        return (double)this.totalLoadTime / (double)var1_1;
    }

    public final long evictionCount() {
        return this.evictionCount;
    }

    /*
     * WARNING - void declaration
     */
    public final CacheStats minus(CacheStats other) {
        void var1_1;
        return new CacheStats(Math.max(0L, LongMath.saturatedSubtract(this.hitCount, other.hitCount)), Math.max(0L, LongMath.saturatedSubtract(this.missCount, other.missCount)), Math.max(0L, LongMath.saturatedSubtract(this.loadSuccessCount, other.loadSuccessCount)), Math.max(0L, LongMath.saturatedSubtract(this.loadExceptionCount, other.loadExceptionCount)), Math.max(0L, LongMath.saturatedSubtract(this.totalLoadTime, other.totalLoadTime)), Math.max(0L, LongMath.saturatedSubtract(this.evictionCount, var1_1.evictionCount)));
    }

    /*
     * WARNING - void declaration
     */
    public final CacheStats plus(CacheStats other) {
        void var1_1;
        return new CacheStats(LongMath.saturatedAdd(this.hitCount, other.hitCount), LongMath.saturatedAdd(this.missCount, other.missCount), LongMath.saturatedAdd(this.loadSuccessCount, other.loadSuccessCount), LongMath.saturatedAdd(this.loadExceptionCount, other.loadExceptionCount), LongMath.saturatedAdd(this.totalLoadTime, other.totalLoadTime), LongMath.saturatedAdd(this.evictionCount, var1_1.evictionCount));
    }

    public final int hashCode() {
        return Objects.hashCode(this.hitCount, this.missCount, this.loadSuccessCount, this.loadExceptionCount, this.totalLoadTime, this.evictionCount);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object object) {
        if (object instanceof CacheStats) {
            void var1_1;
            CacheStats other = (CacheStats)object;
            return this.hitCount == other.hitCount && this.missCount == other.missCount && this.loadSuccessCount == other.loadSuccessCount && this.loadExceptionCount == other.loadExceptionCount && this.totalLoadTime == other.totalLoadTime && this.evictionCount == var1_1.evictionCount;
        }
        return false;
    }

    public final String toString() {
        return MoreObjects.toStringHelper(this).add("hitCount", this.hitCount).add("missCount", this.missCount).add("loadSuccessCount", this.loadSuccessCount).add("loadExceptionCount", this.loadExceptionCount).add("totalLoadTime", this.totalLoadTime).add("evictionCount", this.evictionCount).toString();
    }
}

