/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.cache;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.cache.ElementTypesAreNonnullByDefault;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public abstract class CacheLoader<K, V> {
    protected CacheLoader() {
    }

    public abstract V load(K var1) throws Exception;

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    public ListenableFuture<V> reload(K key, V oldValue) throws Exception {
        void var1_1;
        void var2_2;
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(var2_2);
        return Futures.immediateFuture(this.load(var1_1));
    }

    public Map<K, V> loadAll(Iterable<? extends K> keys) throws Exception {
        throw new UnsupportedLoadingOperationException();
    }

    public static <K, V> CacheLoader<K, V> from(Function<K, V> function) {
        Function<K, V> function2;
        return new FunctionToCacheLoader<K, V>(function2);
    }

    public static <V> CacheLoader<Object, V> from(Supplier<V> supplier) {
        Supplier<V> supplier2;
        return new SupplierToCacheLoader<V>(supplier2);
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    public static <K, V> CacheLoader<K, V> asyncReloading(CacheLoader<K, V> loader, Executor executor) {
        void var1_1;
        CacheLoader<K, V> cacheLoader;
        Preconditions.checkNotNull(loader);
        Preconditions.checkNotNull(executor);
        return new CacheLoader<K, V>((Executor)var1_1){
            final /* synthetic */ Executor val$executor;
            {
                this.val$executor = executor;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public V load(K key) throws Exception {
                void var1_1;
                return cacheLoader.load(var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public ListenableFuture<V> reload(K key, V oldValue) throws Exception {
                void var1_1;
                void var2_2;
                ListenableFutureTask task = ListenableFutureTask.create(new Callable<V>(this, key, var2_2){
                    final /* synthetic */ Object val$key;
                    final /* synthetic */ Object val$oldValue;
                    final /* synthetic */ 1 this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                        this.val$key = object;
                        this.val$oldValue = object2;
                    }

                    @Override
                    public V call() throws Exception {
                        return this.this$0.cacheLoader.reload(this.val$key, this.val$oldValue).get();
                    }
                });
                this.val$executor.execute(task);
                return var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Map<K, V> loadAll(Iterable<? extends K> keys) throws Exception {
                void var1_1;
                return cacheLoader.loadAll(var1_1);
            }
        };
    }

    public static final class InvalidCacheLoadException
    extends RuntimeException {
        /*
         * WARNING - void declaration
         */
        public InvalidCacheLoadException(String message) {
            super((String)var1_1);
            void var1_1;
        }
    }

    public static final class UnsupportedLoadingOperationException
    extends UnsupportedOperationException {
        UnsupportedLoadingOperationException() {
        }
    }

    private static final class SupplierToCacheLoader<V>
    extends CacheLoader<Object, V>
    implements Serializable {
        private final Supplier<V> computingSupplier;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        public SupplierToCacheLoader(Supplier<V> computingSupplier) {
            void var1_1;
            this.computingSupplier = (Supplier)Preconditions.checkNotNull(var1_1);
        }

        @Override
        public final V load(Object key) {
            Preconditions.checkNotNull(key);
            return this.computingSupplier.get();
        }
    }

    private static final class FunctionToCacheLoader<K, V>
    extends CacheLoader<K, V>
    implements Serializable {
        private final Function<K, V> computingFunction;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        public FunctionToCacheLoader(Function<K, V> computingFunction) {
            void var1_1;
            this.computingFunction = (Function)Preconditions.checkNotNull(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final V load(K key) {
            void var1_1;
            return this.computingFunction.apply(Preconditions.checkNotNull(var1_1));
        }
    }
}

