/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.cache;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.ElementTypesAreNonnullByDefault;
import com.google.common.cache.LocalCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
public final class CacheBuilderSpec {
    private static final Splitter KEYS_SPLITTER = Splitter.on(',').trimResults();
    private static final Splitter KEY_VALUE_SPLITTER = Splitter.on('=').trimResults();
    private static final ImmutableMap<String, ValueParser> VALUE_PARSERS = ImmutableMap.builder().put("initialCapacity", new InitialCapacityParser()).put("maximumSize", (InitialCapacityParser)((Object)new MaximumSizeParser())).put("maximumWeight", (InitialCapacityParser)((Object)new MaximumWeightParser())).put("concurrencyLevel", (InitialCapacityParser)((Object)new ConcurrencyLevelParser())).put("weakKeys", (InitialCapacityParser)((Object)new KeyStrengthParser(LocalCache.Strength.WEAK))).put("softValues", (InitialCapacityParser)((Object)new ValueStrengthParser(LocalCache.Strength.SOFT))).put("weakValues", (InitialCapacityParser)((Object)new ValueStrengthParser(LocalCache.Strength.WEAK))).put("recordStats", (InitialCapacityParser)((Object)new RecordStatsParser())).put("expireAfterAccess", (InitialCapacityParser)((Object)new AccessDurationParser())).put("expireAfterWrite", (InitialCapacityParser)((Object)new WriteDurationParser())).put("refreshAfterWrite", (InitialCapacityParser)((Object)new RefreshDurationParser())).put("refreshInterval", (InitialCapacityParser)((Object)new RefreshDurationParser())).buildOrThrow();
    @VisibleForTesting
    Integer initialCapacity;
    @VisibleForTesting
    Long maximumSize;
    @VisibleForTesting
    Long maximumWeight;
    @VisibleForTesting
    Integer concurrencyLevel;
    @VisibleForTesting
    LocalCache.Strength keyStrength;
    @VisibleForTesting
    LocalCache.Strength valueStrength;
    @VisibleForTesting
    Boolean recordStats;
    @VisibleForTesting
    long writeExpirationDuration;
    @VisibleForTesting
    TimeUnit writeExpirationTimeUnit;
    @VisibleForTesting
    long accessExpirationDuration;
    @VisibleForTesting
    TimeUnit accessExpirationTimeUnit;
    @VisibleForTesting
    long refreshDuration;
    @VisibleForTesting
    TimeUnit refreshTimeUnit;
    private final String specification;

    /*
     * WARNING - void declaration
     */
    private CacheBuilderSpec(String specification) {
        void var1_1;
        this.specification = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static CacheBuilderSpec parse(String cacheBuilderSpecification) {
        void var1_1;
        CacheBuilderSpec spec = new CacheBuilderSpec(cacheBuilderSpecification);
        if (!cacheBuilderSpecification.isEmpty()) {
            Object object;
            for (String keyValuePair : KEYS_SPLITTER.split((CharSequence)object)) {
                void var3_3;
                void var2_2;
                ImmutableList<String> keyAndValue = ImmutableList.copyOf(KEY_VALUE_SPLITTER.split(keyValuePair));
                Preconditions.checkArgument(!keyAndValue.isEmpty(), "blank key-value pair");
                Preconditions.checkArgument(keyAndValue.size() <= 2, "key-value pair %s with more than one equals sign", (Object)keyValuePair);
                String key = (String)keyAndValue.get(0);
                ValueParser valueParser = VALUE_PARSERS.get(key);
                Preconditions.checkArgument(valueParser != null, "unknown key %s", (Object)key);
                String value = keyAndValue.size() == 1 ? null : (String)keyAndValue.get(1);
                valueParser.parse(spec, (String)var2_2, (String)var3_3);
            }
        }
        return var1_1;
    }

    public static CacheBuilderSpec disableCaching() {
        return CacheBuilderSpec.parse("maximumSize=0");
    }

    /*
     * WARNING - void declaration
     */
    final CacheBuilder<Object, Object> toCacheBuilder() {
        void var1_1;
        CacheBuilder<Object, Object> builder = CacheBuilder.newBuilder();
        if (this.initialCapacity != null) {
            builder.initialCapacity(this.initialCapacity);
        }
        if (this.maximumSize != null) {
            builder.maximumSize(this.maximumSize);
        }
        if (this.maximumWeight != null) {
            builder.maximumWeight(this.maximumWeight);
        }
        if (this.concurrencyLevel != null) {
            builder.concurrencyLevel(this.concurrencyLevel);
        }
        if (this.keyStrength != null) {
            switch (this.keyStrength) {
                case WEAK: {
                    builder.weakKeys();
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        if (this.valueStrength != null) {
            switch (this.valueStrength) {
                case SOFT: {
                    builder.softValues();
                    break;
                }
                case WEAK: {
                    builder.weakValues();
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        if (this.recordStats != null && this.recordStats.booleanValue()) {
            builder.recordStats();
        }
        if (this.writeExpirationTimeUnit != null) {
            builder.expireAfterWrite(this.writeExpirationDuration, this.writeExpirationTimeUnit);
        }
        if (this.accessExpirationTimeUnit != null) {
            builder.expireAfterAccess(this.accessExpirationDuration, this.accessExpirationTimeUnit);
        }
        if (this.refreshTimeUnit != null) {
            builder.refreshAfterWrite(this.refreshDuration, this.refreshTimeUnit);
        }
        return var1_1;
    }

    public final String toParsableString() {
        return this.specification;
    }

    public final String toString() {
        return MoreObjects.toStringHelper(this).addValue(this.toParsableString()).toString();
    }

    public final int hashCode() {
        return Objects.hashCode(new Object[]{this.initialCapacity, this.maximumSize, this.maximumWeight, this.concurrencyLevel, this.keyStrength, this.valueStrength, this.recordStats, CacheBuilderSpec.durationInNanos(this.writeExpirationDuration, this.writeExpirationTimeUnit), CacheBuilderSpec.durationInNanos(this.accessExpirationDuration, this.accessExpirationTimeUnit), CacheBuilderSpec.durationInNanos(this.refreshDuration, this.refreshTimeUnit)});
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object obj) {
        void var1_1;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CacheBuilderSpec)) {
            return false;
        }
        CacheBuilderSpec that = (CacheBuilderSpec)obj;
        return Objects.equal(this.initialCapacity, that.initialCapacity) && Objects.equal(this.maximumSize, that.maximumSize) && Objects.equal(this.maximumWeight, that.maximumWeight) && Objects.equal(this.concurrencyLevel, that.concurrencyLevel) && Objects.equal((Object)this.keyStrength, (Object)that.keyStrength) && Objects.equal((Object)this.valueStrength, (Object)that.valueStrength) && Objects.equal(this.recordStats, that.recordStats) && Objects.equal(CacheBuilderSpec.durationInNanos(this.writeExpirationDuration, this.writeExpirationTimeUnit), CacheBuilderSpec.durationInNanos(that.writeExpirationDuration, that.writeExpirationTimeUnit)) && Objects.equal(CacheBuilderSpec.durationInNanos(this.accessExpirationDuration, this.accessExpirationTimeUnit), CacheBuilderSpec.durationInNanos(that.accessExpirationDuration, that.accessExpirationTimeUnit)) && Objects.equal(CacheBuilderSpec.durationInNanos(this.refreshDuration, this.refreshTimeUnit), CacheBuilderSpec.durationInNanos(that.refreshDuration, var1_1.refreshTimeUnit));
    }

    /*
     * WARNING - void declaration
     */
    private static Long durationInNanos(long duration, TimeUnit unit) {
        long l;
        void var2_1;
        if (unit == null) {
            return null;
        }
        return var2_1.toNanos(l);
    }

    /*
     * WARNING - void declaration
     */
    private static String format(String format, Object ... args) {
        void var1_1;
        String string;
        return String.format(Locale.ROOT, string, (Object[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$000(String x0, Object[] x1) {
        void var1_1;
        return CacheBuilderSpec.format(x0, (Object[])var1_1);
    }

    static class RefreshDurationParser
    extends DurationParser {
        RefreshDurationParser() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void parseDuration(CacheBuilderSpec spec, long duration, TimeUnit unit) {
            void var2_2;
            Preconditions.checkArgument(spec.refreshTimeUnit == null, "refreshAfterWrite already set");
            spec.refreshDuration = var2_2;
            var1_1.refreshTimeUnit = unit;
        }
    }

    static class WriteDurationParser
    extends DurationParser {
        WriteDurationParser() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void parseDuration(CacheBuilderSpec spec, long duration, TimeUnit unit) {
            void var2_2;
            Preconditions.checkArgument(spec.writeExpirationTimeUnit == null, "expireAfterWrite already set");
            spec.writeExpirationDuration = var2_2;
            var1_1.writeExpirationTimeUnit = unit;
        }
    }

    static class AccessDurationParser
    extends DurationParser {
        AccessDurationParser() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void parseDuration(CacheBuilderSpec spec, long duration, TimeUnit unit) {
            void var2_2;
            Preconditions.checkArgument(spec.accessExpirationTimeUnit == null, "expireAfterAccess already set");
            spec.accessExpirationDuration = var2_2;
            var1_1.accessExpirationTimeUnit = unit;
        }
    }

    static abstract class DurationParser
    implements ValueParser {
        DurationParser() {
        }

        protected abstract void parseDuration(CacheBuilderSpec var1, long var2, TimeUnit var4);

        /*
         * WARNING - void declaration
         */
        @Override
        public void parse(CacheBuilderSpec spec, String key, String value) {
            if (Strings.isNullOrEmpty(value)) {
                throw new IllegalArgumentException(new StringBuilder(21 + String.valueOf(key).length()).append("value of key ").append(key).append(" omitted").toString());
            }
            try {
                void var1_1;
                TimeUnit timeUnit;
                String string = value;
                char c = string.charAt(string.length() - 1);
                switch (c) {
                    case 'd': {
                        timeUnit = TimeUnit.DAYS;
                        break;
                    }
                    case 'h': {
                        timeUnit = TimeUnit.HOURS;
                        break;
                    }
                    case 'm': {
                        timeUnit = TimeUnit.MINUTES;
                        break;
                    }
                    case 's': {
                        timeUnit = TimeUnit.SECONDS;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(CacheBuilderSpec.access$000("key %s invalid unit: was %s, must end with one of [dhms]", new Object[]{key, value}));
                    }
                }
                long duration = Long.parseLong(value.substring(0, value.length() - 1));
                this.parseDuration((CacheBuilderSpec)var1_1, duration, timeUnit);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                void var3_3;
                void var2_2;
                throw new IllegalArgumentException(CacheBuilderSpec.access$000("key %s value set to %s, must be integer", new Object[]{var2_2, var3_3}));
            }
        }
    }

    static class RecordStatsParser
    implements ValueParser {
        RecordStatsParser() {
        }

        @Override
        public void parse(CacheBuilderSpec spec, String key, String value) {
            Preconditions.checkArgument(value == null, "recordStats does not take values");
            Preconditions.checkArgument(spec.recordStats == null, "recordStats already set");
            var1_1.recordStats = Boolean.TRUE;
        }
    }

    static class ValueStrengthParser
    implements ValueParser {
        private final LocalCache.Strength strength;

        /*
         * WARNING - void declaration
         */
        public ValueStrengthParser(LocalCache.Strength strength) {
            void var1_1;
            this.strength = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void parse(CacheBuilderSpec spec, String key, String value) {
            void var2_2;
            Preconditions.checkArgument(value == null, "key %s does not take values", (Object)key);
            Preconditions.checkArgument(spec.valueStrength == null, "%s was already set to %s", (Object)var2_2, (Object)spec.valueStrength);
            var1_1.valueStrength = this.strength;
        }
    }

    static class KeyStrengthParser
    implements ValueParser {
        private final LocalCache.Strength strength;

        /*
         * WARNING - void declaration
         */
        public KeyStrengthParser(LocalCache.Strength strength) {
            void var1_1;
            this.strength = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void parse(CacheBuilderSpec spec, String key, String value) {
            void var2_2;
            Preconditions.checkArgument(value == null, "key %s does not take values", (Object)key);
            Preconditions.checkArgument(spec.keyStrength == null, "%s was already set to %s", (Object)var2_2, (Object)spec.keyStrength);
            var1_1.keyStrength = this.strength;
        }
    }

    static class ConcurrencyLevelParser
    extends IntegerParser {
        ConcurrencyLevelParser() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void parseInteger(CacheBuilderSpec spec, int value) {
            void var2_2;
            Preconditions.checkArgument(spec.concurrencyLevel == null, "concurrency level was already set to ", (Object)spec.concurrencyLevel);
            var1_1.concurrencyLevel = (int)var2_2;
        }
    }

    static class MaximumWeightParser
    extends LongParser {
        MaximumWeightParser() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void parseLong(CacheBuilderSpec spec, long value) {
            void var2_2;
            Preconditions.checkArgument(spec.maximumWeight == null, "maximum weight was already set to ", (Object)spec.maximumWeight);
            Preconditions.checkArgument(spec.maximumSize == null, "maximum size was already set to ", (Object)spec.maximumSize);
            var1_1.maximumWeight = (long)var2_2;
        }
    }

    static class MaximumSizeParser
    extends LongParser {
        MaximumSizeParser() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void parseLong(CacheBuilderSpec spec, long value) {
            void var2_2;
            Preconditions.checkArgument(spec.maximumSize == null, "maximum size was already set to ", (Object)spec.maximumSize);
            Preconditions.checkArgument(spec.maximumWeight == null, "maximum weight was already set to ", (Object)spec.maximumWeight);
            var1_1.maximumSize = (long)var2_2;
        }
    }

    static class InitialCapacityParser
    extends IntegerParser {
        InitialCapacityParser() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void parseInteger(CacheBuilderSpec spec, int value) {
            void var2_2;
            Preconditions.checkArgument(spec.initialCapacity == null, "initial capacity was already set to ", (Object)spec.initialCapacity);
            var1_1.initialCapacity = (int)var2_2;
        }
    }

    static abstract class LongParser
    implements ValueParser {
        LongParser() {
        }

        protected abstract void parseLong(CacheBuilderSpec var1, long var2);

        /*
         * WARNING - void declaration
         */
        @Override
        public void parse(CacheBuilderSpec spec, String key, String value) {
            if (Strings.isNullOrEmpty(value)) {
                throw new IllegalArgumentException(new StringBuilder(21 + String.valueOf(key).length()).append("value of key ").append(key).append(" omitted").toString());
            }
            try {
                this.parseLong(spec, Long.parseLong(value));
                return;
            }
            catch (NumberFormatException e) {
                void var1_2;
                void var3_4;
                void var2_3;
                throw new IllegalArgumentException(CacheBuilderSpec.access$000("key %s value set to %s, must be integer", new Object[]{var2_3, var3_4}), (Throwable)var1_2);
            }
        }
    }

    static abstract class IntegerParser
    implements ValueParser {
        IntegerParser() {
        }

        protected abstract void parseInteger(CacheBuilderSpec var1, int var2);

        /*
         * WARNING - void declaration
         */
        @Override
        public void parse(CacheBuilderSpec spec, String key, String value) {
            if (Strings.isNullOrEmpty(value)) {
                throw new IllegalArgumentException(new StringBuilder(21 + String.valueOf(key).length()).append("value of key ").append(key).append(" omitted").toString());
            }
            try {
                this.parseInteger(spec, Integer.parseInt(value));
                return;
            }
            catch (NumberFormatException e) {
                void var1_2;
                void var3_4;
                void var2_3;
                throw new IllegalArgumentException(CacheBuilderSpec.access$000("key %s value set to %s, must be integer", new Object[]{var2_3, var3_4}), (Throwable)var1_2);
            }
        }
    }

    private static interface ValueParser {
        public void parse(CacheBuilderSpec var1, String var2, String var3);
    }
}

