/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.cache;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Ascii;
import com.google.common.base.Equivalence;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Ticker;
import com.google.common.cache.AbstractCache;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilderSpec;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.CacheStats;
import com.google.common.cache.ElementTypesAreNonnullByDefault;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.LocalCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.cache.Weigher;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class CacheBuilder<K, V> {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int DEFAULT_CONCURRENCY_LEVEL = 4;
    private static final int DEFAULT_EXPIRATION_NANOS = 0;
    private static final int DEFAULT_REFRESH_NANOS = 0;
    static final Supplier<? extends AbstractCache.StatsCounter> NULL_STATS_COUNTER = Suppliers.ofInstance(new AbstractCache.StatsCounter(){

        @Override
        public void recordHits(int count) {
        }

        @Override
        public void recordMisses(int count) {
        }

        @Override
        public void recordLoadSuccess(long loadTime) {
        }

        @Override
        public void recordLoadException(long loadTime) {
        }

        @Override
        public void recordEviction() {
        }

        @Override
        public CacheStats snapshot() {
            return EMPTY_STATS;
        }
    });
    static final CacheStats EMPTY_STATS = new CacheStats(0L, 0L, 0L, 0L, 0L, 0L);
    static final Supplier<AbstractCache.StatsCounter> CACHE_STATS_COUNTER = new Supplier<AbstractCache.StatsCounter>(){

        @Override
        public AbstractCache.StatsCounter get() {
            return new AbstractCache.SimpleStatsCounter();
        }
    };
    static final Ticker NULL_TICKER = new Ticker(){

        @Override
        public long read() {
            return 0L;
        }
    };
    private static final Logger logger = Logger.getLogger(CacheBuilder.class.getName());
    static final int UNSET_INT = -1;
    boolean strictParsing = true;
    int initialCapacity = -1;
    int concurrencyLevel = -1;
    long maximumSize = -1L;
    long maximumWeight = -1L;
    Weigher<? super K, ? super V> weigher;
    LocalCache.Strength keyStrength;
    LocalCache.Strength valueStrength;
    long expireAfterWriteNanos = -1L;
    long expireAfterAccessNanos = -1L;
    long refreshNanos = -1L;
    Equivalence<Object> keyEquivalence;
    Equivalence<Object> valueEquivalence;
    RemovalListener<? super K, ? super V> removalListener;
    Ticker ticker;
    Supplier<? extends AbstractCache.StatsCounter> statsCounterSupplier = NULL_STATS_COUNTER;

    private CacheBuilder() {
    }

    public static CacheBuilder<Object, Object> newBuilder() {
        return new CacheBuilder<Object, Object>();
    }

    @GwtIncompatible
    public static CacheBuilder<Object, Object> from(CacheBuilderSpec spec) {
        return spec.toCacheBuilder().lenientParsing();
    }

    @GwtIncompatible
    public static CacheBuilder<Object, Object> from(String spec) {
        return CacheBuilder.from(CacheBuilderSpec.parse(spec));
    }

    @GwtIncompatible
    final CacheBuilder<K, V> lenientParsing() {
        this.strictParsing = false;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    final CacheBuilder<K, V> keyEquivalence(Equivalence<Object> equivalence) {
        void var1_1;
        Preconditions.checkState(this.keyEquivalence == null, "key equivalence was already set to %s", this.keyEquivalence);
        this.keyEquivalence = (Equivalence)Preconditions.checkNotNull(var1_1);
        return this;
    }

    final Equivalence<Object> getKeyEquivalence() {
        return MoreObjects.firstNonNull(this.keyEquivalence, this.getKeyStrength().defaultEquivalence());
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    final CacheBuilder<K, V> valueEquivalence(Equivalence<Object> equivalence) {
        void var1_1;
        Preconditions.checkState(this.valueEquivalence == null, "value equivalence was already set to %s", this.valueEquivalence);
        this.valueEquivalence = (Equivalence)Preconditions.checkNotNull(var1_1);
        return this;
    }

    final Equivalence<Object> getValueEquivalence() {
        return MoreObjects.firstNonNull(this.valueEquivalence, this.getValueStrength().defaultEquivalence());
    }

    /*
     * WARNING - void declaration
     */
    public final CacheBuilder<K, V> initialCapacity(int initialCapacity) {
        void var1_1;
        Preconditions.checkState(this.initialCapacity == -1, "initial capacity was already set to %s", this.initialCapacity);
        Preconditions.checkArgument(initialCapacity >= 0);
        this.initialCapacity = var1_1;
        return this;
    }

    final int getInitialCapacity() {
        if (this.initialCapacity == -1) {
            return 16;
        }
        return this.initialCapacity;
    }

    /*
     * WARNING - void declaration
     */
    public final CacheBuilder<K, V> concurrencyLevel(int concurrencyLevel) {
        void var1_1;
        Preconditions.checkState(this.concurrencyLevel == -1, "concurrency level was already set to %s", this.concurrencyLevel);
        Preconditions.checkArgument(concurrencyLevel > 0);
        this.concurrencyLevel = var1_1;
        return this;
    }

    final int getConcurrencyLevel() {
        if (this.concurrencyLevel == -1) {
            return 4;
        }
        return this.concurrencyLevel;
    }

    /*
     * WARNING - void declaration
     */
    public final CacheBuilder<K, V> maximumSize(long maximumSize) {
        void var1_1;
        Preconditions.checkState(this.maximumSize == -1L, "maximum size was already set to %s", this.maximumSize);
        Preconditions.checkState(this.maximumWeight == -1L, "maximum weight was already set to %s", this.maximumWeight);
        Preconditions.checkState(this.weigher == null, "maximum size can not be combined with weigher");
        Preconditions.checkArgument(maximumSize >= 0L, "maximum size must not be negative");
        this.maximumSize = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    public final CacheBuilder<K, V> maximumWeight(long maximumWeight) {
        void var1_1;
        Preconditions.checkState(this.maximumWeight == -1L, "maximum weight was already set to %s", this.maximumWeight);
        Preconditions.checkState(this.maximumSize == -1L, "maximum size was already set to %s", this.maximumSize);
        Preconditions.checkArgument(maximumWeight >= 0L, "maximum weight must not be negative");
        this.maximumWeight = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    public final <K1 extends K, V1 extends V> CacheBuilder<K1, V1> weigher(Weigher<? super K1, ? super V1> weigher) {
        void var2_2;
        void var1_1;
        Preconditions.checkState(this.weigher == null);
        if (this.strictParsing) {
            Preconditions.checkState(this.maximumSize == -1L, "weigher can not be combined with maximum size", this.maximumSize);
        }
        CacheBuilder me = this;
        this.weigher = (Weigher)Preconditions.checkNotNull(var1_1);
        return var2_2;
    }

    final long getMaximumWeight() {
        if (this.expireAfterWriteNanos == 0L || this.expireAfterAccessNanos == 0L) {
            return 0L;
        }
        if (this.weigher == null) {
            return this.maximumSize;
        }
        return this.maximumWeight;
    }

    final <K1 extends K, V1 extends V> Weigher<K1, V1> getWeigher() {
        return MoreObjects.firstNonNull(this.weigher, OneWeigher.INSTANCE);
    }

    @GwtIncompatible
    public final CacheBuilder<K, V> weakKeys() {
        return this.setKeyStrength(LocalCache.Strength.WEAK);
    }

    /*
     * WARNING - void declaration
     */
    final CacheBuilder<K, V> setKeyStrength(LocalCache.Strength strength) {
        void var1_1;
        Preconditions.checkState(this.keyStrength == null, "Key strength was already set to %s", (Object)this.keyStrength);
        this.keyStrength = (LocalCache.Strength)Preconditions.checkNotNull(var1_1);
        return this;
    }

    final LocalCache.Strength getKeyStrength() {
        return MoreObjects.firstNonNull(this.keyStrength, LocalCache.Strength.STRONG);
    }

    @GwtIncompatible
    public final CacheBuilder<K, V> weakValues() {
        return this.setValueStrength(LocalCache.Strength.WEAK);
    }

    @GwtIncompatible
    public final CacheBuilder<K, V> softValues() {
        return this.setValueStrength(LocalCache.Strength.SOFT);
    }

    /*
     * WARNING - void declaration
     */
    final CacheBuilder<K, V> setValueStrength(LocalCache.Strength strength) {
        void var1_1;
        Preconditions.checkState(this.valueStrength == null, "Value strength was already set to %s", (Object)this.valueStrength);
        this.valueStrength = (LocalCache.Strength)Preconditions.checkNotNull(var1_1);
        return this;
    }

    final LocalCache.Strength getValueStrength() {
        return MoreObjects.firstNonNull(this.valueStrength, LocalCache.Strength.STRONG);
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    public final CacheBuilder<K, V> expireAfterWrite(Duration duration) {
        void var1_1;
        return this.expireAfterWrite(CacheBuilder.toNanosSaturated((Duration)var1_1), TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - void declaration
     */
    public final CacheBuilder<K, V> expireAfterWrite(long duration, TimeUnit unit) {
        void var1_1;
        void var3_2;
        Preconditions.checkState(this.expireAfterWriteNanos == -1L, "expireAfterWrite was already set to %s ns", this.expireAfterWriteNanos);
        Preconditions.checkArgument(duration >= 0L, "duration cannot be negative: %s %s", duration, (Object)unit);
        this.expireAfterWriteNanos = var3_2.toNanos((long)var1_1);
        return this;
    }

    final long getExpireAfterWriteNanos() {
        if (this.expireAfterWriteNanos == -1L) {
            return 0L;
        }
        return this.expireAfterWriteNanos;
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    public final CacheBuilder<K, V> expireAfterAccess(Duration duration) {
        void var1_1;
        return this.expireAfterAccess(CacheBuilder.toNanosSaturated((Duration)var1_1), TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - void declaration
     */
    public final CacheBuilder<K, V> expireAfterAccess(long duration, TimeUnit unit) {
        void var1_1;
        void var3_2;
        Preconditions.checkState(this.expireAfterAccessNanos == -1L, "expireAfterAccess was already set to %s ns", this.expireAfterAccessNanos);
        Preconditions.checkArgument(duration >= 0L, "duration cannot be negative: %s %s", duration, (Object)unit);
        this.expireAfterAccessNanos = var3_2.toNanos((long)var1_1);
        return this;
    }

    final long getExpireAfterAccessNanos() {
        if (this.expireAfterAccessNanos == -1L) {
            return 0L;
        }
        return this.expireAfterAccessNanos;
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    public final CacheBuilder<K, V> refreshAfterWrite(Duration duration) {
        void var1_1;
        return this.refreshAfterWrite(CacheBuilder.toNanosSaturated((Duration)var1_1), TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    public final CacheBuilder<K, V> refreshAfterWrite(long duration, TimeUnit unit) {
        void var1_1;
        void var3_2;
        Preconditions.checkNotNull(unit);
        Preconditions.checkState(this.refreshNanos == -1L, "refresh was already set to %s ns", this.refreshNanos);
        Preconditions.checkArgument(duration > 0L, "duration must be positive: %s %s", duration, (Object)unit);
        this.refreshNanos = var3_2.toNanos((long)var1_1);
        return this;
    }

    final long getRefreshNanos() {
        if (this.refreshNanos == -1L) {
            return 0L;
        }
        return this.refreshNanos;
    }

    /*
     * WARNING - void declaration
     */
    public final CacheBuilder<K, V> ticker(Ticker ticker) {
        void var1_1;
        Preconditions.checkState(this.ticker == null);
        this.ticker = (Ticker)Preconditions.checkNotNull(var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    final Ticker getTicker(boolean recordsTime) {
        void var1_1;
        if (this.ticker != null) {
            return this.ticker;
        }
        if (var1_1 != false) {
            return Ticker.systemTicker();
        }
        return NULL_TICKER;
    }

    /*
     * WARNING - void declaration
     */
    public final <K1 extends K, V1 extends V> CacheBuilder<K1, V1> removalListener(RemovalListener<? super K1, ? super V1> listener) {
        void var2_2;
        void var1_1;
        Preconditions.checkState(this.removalListener == null);
        CacheBuilder me = this;
        this.removalListener = (RemovalListener)Preconditions.checkNotNull(var1_1);
        return var2_2;
    }

    final <K1 extends K, V1 extends V> RemovalListener<K1, V1> getRemovalListener() {
        return MoreObjects.firstNonNull(this.removalListener, NullListener.INSTANCE);
    }

    public final CacheBuilder<K, V> recordStats() {
        this.statsCounterSupplier = CACHE_STATS_COUNTER;
        return this;
    }

    final boolean isRecordingStats() {
        return this.statsCounterSupplier == CACHE_STATS_COUNTER;
    }

    final Supplier<? extends AbstractCache.StatsCounter> getStatsCounterSupplier() {
        return this.statsCounterSupplier;
    }

    /*
     * WARNING - void declaration
     */
    public final <K1 extends K, V1 extends V> LoadingCache<K1, V1> build(CacheLoader<? super K1, V1> loader) {
        void var1_1;
        this.checkWeightWithWeigher();
        return new LocalCache.LocalLoadingCache(this, var1_1);
    }

    public final <K1 extends K, V1 extends V> Cache<K1, V1> build() {
        this.checkWeightWithWeigher();
        this.checkNonLoadingCache();
        return new LocalCache.LocalManualCache(this);
    }

    private void checkNonLoadingCache() {
        Preconditions.checkState(this.refreshNanos == -1L, "refreshAfterWrite requires a LoadingCache");
    }

    private void checkWeightWithWeigher() {
        if (this.weigher == null) {
            Preconditions.checkState(this.maximumWeight == -1L, "maximumWeight requires weigher");
            return;
        }
        if (this.strictParsing) {
            Preconditions.checkState(this.maximumWeight != -1L, "weigher requires maximumWeight");
            return;
        }
        if (this.maximumWeight == -1L) {
            logger.log(Level.WARNING, "ignoring weigher specified without maximumWeight");
        }
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        long l;
        MoreObjects.ToStringHelper s = MoreObjects.toStringHelper(this);
        if (this.initialCapacity != -1) {
            s.add("initialCapacity", this.initialCapacity);
        }
        if (this.concurrencyLevel != -1) {
            s.add("concurrencyLevel", this.concurrencyLevel);
        }
        if (this.maximumSize != -1L) {
            s.add("maximumSize", this.maximumSize);
        }
        if (this.maximumWeight != -1L) {
            s.add("maximumWeight", this.maximumWeight);
        }
        if (this.expireAfterWriteNanos != -1L) {
            l = this.expireAfterWriteNanos;
            s.add("expireAfterWrite", new StringBuilder(22).append(l).append("ns").toString());
        }
        if (this.expireAfterAccessNanos != -1L) {
            l = this.expireAfterAccessNanos;
            s.add("expireAfterAccess", new StringBuilder(22).append(l).append("ns").toString());
        }
        if (this.keyStrength != null) {
            s.add("keyStrength", Ascii.toLowerCase(this.keyStrength.toString()));
        }
        if (this.valueStrength != null) {
            s.add("valueStrength", Ascii.toLowerCase(this.valueStrength.toString()));
        }
        if (this.keyEquivalence != null) {
            s.addValue("keyEquivalence");
        }
        if (this.valueEquivalence != null) {
            s.addValue("valueEquivalence");
        }
        if (this.removalListener != null) {
            s.addValue("removalListener");
        }
        return var1_1.toString();
    }

    @GwtIncompatible
    private static long toNanosSaturated(Duration duration) {
        try {
            return duration.toNanos();
        }
        catch (ArithmeticException arithmeticException) {
            Duration duration2;
            if (duration2.isNegative()) {
                return Long.MIN_VALUE;
            }
            return Long.MAX_VALUE;
        }
    }

    static enum OneWeigher implements Weigher<Object, Object>
    {
        INSTANCE;


        @Override
        public final int weigh(Object key, Object value) {
            return 1;
        }
    }

    static enum NullListener implements RemovalListener<Object, Object>
    {
        INSTANCE;


        @Override
        public final void onRemoval(RemovalNotification<Object, Object> notification) {
        }
    }
}

