/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.cache;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.cache.AbstractCache;
import com.google.common.cache.ElementTypesAreNonnullByDefault;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.concurrent.ExecutionException;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
public abstract class AbstractLoadingCache<K, V>
extends AbstractCache<K, V>
implements LoadingCache<K, V> {
    protected AbstractLoadingCache() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V getUnchecked(K key) {
        try {
            return this.get(key);
        }
        catch (ExecutionException e) {
            void var1_2;
            throw new UncheckedExecutionException(var1_2.getCause());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ImmutableMap<K, V> getAll(Iterable<? extends K> keys) throws ExecutionException {
        void var2_2;
        Iterator iterator;
        LinkedHashMap result = Maps.newLinkedHashMap();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_3;
            Object key = iterator.next();
            if (result.containsKey(key)) continue;
            result.put(key, this.get(var3_3));
        }
        return ImmutableMap.copyOf(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V apply(K key) {
        void var1_1;
        return this.getUnchecked(var1_1);
    }

    @Override
    public void refresh(K key) {
        throw new UnsupportedOperationException();
    }
}

