/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.cache;

import com.google.common.annotations.GwtCompatible;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheStats;
import com.google.common.cache.ElementTypesAreNonnullByDefault;
import com.google.common.cache.LongAddable;
import com.google.common.cache.LongAddables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public abstract class AbstractCache<K, V>
implements Cache<K, V> {
    protected AbstractCache() {
    }

    @Override
    public V get(K key, Callable<? extends V> valueLoader) throws ExecutionException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ImmutableMap<K, V> getAllPresent(Iterable<? extends Object> keys) {
        void var2_2;
        Iterator iterator;
        LinkedHashMap result = Maps.newLinkedHashMap();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_3;
            Object key = iterator.next();
            if (result.containsKey(key)) continue;
            Object castKey = key;
            Object value = this.getIfPresent(key);
            if (value == null) continue;
            result.put(castKey, var3_3);
        }
        return ImmutableMap.copyOf(var2_2);
    }

    @Override
    public void put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            void var2_2;
            this.put(entry.getKey(), var2_2.getValue());
        }
    }

    @Override
    public void cleanUp() {
    }

    @Override
    public long size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void invalidate(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void invalidateAll(Iterable<? extends Object> keys) {
        for (Object object : keys) {
            this.invalidate(object);
        }
    }

    @Override
    public void invalidateAll() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CacheStats stats() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ConcurrentMap<K, V> asMap() {
        throw new UnsupportedOperationException();
    }

    public static final class SimpleStatsCounter
    implements StatsCounter {
        private final LongAddable hitCount = LongAddables.create();
        private final LongAddable missCount = LongAddables.create();
        private final LongAddable loadSuccessCount = LongAddables.create();
        private final LongAddable loadExceptionCount = LongAddables.create();
        private final LongAddable totalLoadTime = LongAddables.create();
        private final LongAddable evictionCount = LongAddables.create();

        /*
         * WARNING - void declaration
         */
        @Override
        public final void recordHits(int count) {
            void var1_1;
            this.hitCount.add((long)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void recordMisses(int count) {
            void var1_1;
            this.missCount.add((long)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void recordLoadSuccess(long loadTime) {
            void var1_1;
            this.loadSuccessCount.increment();
            this.totalLoadTime.add((long)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void recordLoadException(long loadTime) {
            void var1_1;
            this.loadExceptionCount.increment();
            this.totalLoadTime.add((long)var1_1);
        }

        @Override
        public final void recordEviction() {
            this.evictionCount.increment();
        }

        @Override
        public final CacheStats snapshot() {
            return new CacheStats(SimpleStatsCounter.negativeToMaxValue(this.hitCount.sum()), SimpleStatsCounter.negativeToMaxValue(this.missCount.sum()), SimpleStatsCounter.negativeToMaxValue(this.loadSuccessCount.sum()), SimpleStatsCounter.negativeToMaxValue(this.loadExceptionCount.sum()), SimpleStatsCounter.negativeToMaxValue(this.totalLoadTime.sum()), SimpleStatsCounter.negativeToMaxValue(this.evictionCount.sum()));
        }

        private static long negativeToMaxValue(long value) {
            if (value >= 0L) {
                long l;
                return l;
            }
            return Long.MAX_VALUE;
        }

        /*
         * WARNING - void declaration
         */
        public final void incrementBy(StatsCounter other) {
            void var1_1;
            CacheStats otherStats = other.snapshot();
            this.hitCount.add(otherStats.hitCount());
            this.missCount.add(otherStats.missCount());
            this.loadSuccessCount.add(otherStats.loadSuccessCount());
            this.loadExceptionCount.add(otherStats.loadExceptionCount());
            this.totalLoadTime.add(otherStats.totalLoadTime());
            this.evictionCount.add(var1_1.evictionCount());
        }
    }

    public static interface StatsCounter {
        public void recordHits(int var1);

        public void recordMisses(int var1);

        public void recordLoadSuccess(long var1);

        public void recordLoadException(long var1);

        public void recordEviction();

        public CacheStats snapshot();
    }
}

