/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base.internal;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Finalizer
implements Runnable {
    private static final Logger logger = Logger.getLogger(Finalizer.class.getName());
    private static final String FINALIZABLE_REFERENCE = "com.google.common.base.FinalizableReference";
    private final WeakReference<Class<?>> finalizableReferenceClassReference;
    private final PhantomReference<Object> frqReference;
    private final ReferenceQueue<Object> queue;
    private static final Constructor<Thread> bigThreadConstructor = Finalizer.getBigThreadConstructor();
    private static final Field inheritableThreadLocals = bigThreadConstructor == null ? Finalizer.getInheritableThreadLocalsField() : null;

    /*
     * WARNING - void declaration
     */
    public static void startFinalizer(Class<?> finalizableReferenceClass, ReferenceQueue<Object> queue, PhantomReference<Object> frqReference) {
        void var2_2;
        if (!finalizableReferenceClass.getName().equals(FINALIZABLE_REFERENCE)) {
            throw new IllegalArgumentException("Expected com.google.common.base.FinalizableReference.");
        }
        Finalizer finalizer = new Finalizer(finalizableReferenceClass, queue, frqReference);
        String threadName = Finalizer.class.getName();
        Thread thread = null;
        if (bigThreadConstructor != null) {
            try {
                thread = bigThreadConstructor.newInstance(null, finalizer, threadName, 0L, Boolean.FALSE);
            }
            catch (Throwable t) {
                logger.log(Level.INFO, "Failed to create a thread without inherited thread-local values", t);
            }
        }
        if (thread == null) {
            void var1_1;
            Finalizer finalizer2;
            thread = new Thread(null, finalizer2, (String)var1_1);
        }
        thread.setDaemon(true);
        try {
            if (inheritableThreadLocals != null) {
                inheritableThreadLocals.set(thread, null);
            }
        }
        catch (Throwable t) {
            void var3_4;
            logger.log(Level.INFO, "Failed to clear thread local values inherited by reference finalizer thread.", (Throwable)var3_4);
        }
        var2_2.start();
    }

    /*
     * WARNING - void declaration
     */
    private Finalizer(Class<?> finalizableReferenceClass, ReferenceQueue<Object> queue, PhantomReference<Object> frqReference) {
        void var3_3;
        void var1_1;
        void var2_2;
        this.queue = var2_2;
        this.finalizableReferenceClassReference = new WeakReference<void>(var1_1);
        this.frqReference = var3_3;
    }

    @Override
    public void run() {
        while (true) {
            try {
                Finalizer finalizer;
                do {
                    finalizer = this;
                } while (finalizer.cleanUp(finalizer.queue.remove()));
                return;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean cleanUp(Reference<?> reference) {
        Reference<Object> reference2;
        Method finalizeReferentMethod = this.getFinalizeReferentMethod();
        if (finalizeReferentMethod == null) {
            return false;
        }
        do {
            reference.clear();
            if (reference == this.frqReference) {
                return false;
            }
            try {
                finalizeReferentMethod.invoke(reference, new Object[0]);
            }
            catch (Throwable t) {
                void var1_2;
                logger.log(Level.SEVERE, "Error cleaning up after reference.", (Throwable)var1_2);
            }
        } while ((reference2 = this.queue.poll()) != null);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private Method getFinalizeReferentMethod() {
        Class finalizableReferenceClass = (Class)this.finalizableReferenceClassReference.get();
        if (finalizableReferenceClass == null) {
            return null;
        }
        try {
            return finalizableReferenceClass.getMethod("finalizeReferent", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            void var1_2;
            throw new AssertionError(var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Field getInheritableThreadLocalsField() {
        try {
            void var0;
            Field inheritableThreadLocals = Thread.class.getDeclaredField("inheritableThreadLocals");
            inheritableThreadLocals.setAccessible(true);
            return var0;
        }
        catch (Throwable throwable) {
            logger.log(Level.INFO, "Couldn't access Thread.inheritableThreadLocals. Reference finalizer threads will inherit thread local values.");
            return null;
        }
    }

    private static Constructor<Thread> getBigThreadConstructor() {
        try {
            return Thread.class.getConstructor(ThreadGroup.class, Runnable.class, String.class, Long.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

