/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.ElementTypesAreNonnullByDefault;
import com.google.common.base.Preconditions;

@ElementTypesAreNonnullByDefault
@Beta
@GwtCompatible(emulated=true)
public final class Utf8 {
    /*
     * WARNING - void declaration
     */
    public static int encodedLength(CharSequence sequence) {
        void var2_2;
        void var1_1;
        int i;
        int utf16Length;
        int utf8Length = utf16Length = sequence.length();
        for (i = 0; i < utf16Length && sequence.charAt(i) < '\u0080'; ++i) {
        }
        while (i < utf16Length) {
            char c = sequence.charAt(i);
            if (c < '\u0800') {
                utf8Length += 127 - c >>> 31;
            } else {
                utf8Length += Utf8.encodedLengthGeneral(sequence, i);
                break;
            }
            ++i;
        }
        if (utf8Length < var1_1) {
            long l = (long)utf8Length + 0x100000000L;
            throw new IllegalArgumentException(new StringBuilder(54).append("UTF-8 length does not fit in int: ").append(l).toString());
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static int encodedLengthGeneral(CharSequence sequence, int start) {
        void var3_3;
        void i;
        int utf16Length = sequence.length();
        int utf8Length = 0;
        while (i < utf16Length) {
            char c = sequence.charAt((int)i);
            if (c < '\u0800') {
                utf8Length += 127 - c >>> 31;
            } else {
                utf8Length += 2;
                if ('\ud800' <= c && c <= '\udfff') {
                    if (Character.codePointAt(sequence, (int)i) == c) {
                        throw new IllegalArgumentException(Utf8.unpairedSurrogateMsg((int)i));
                    }
                    ++i;
                }
            }
            ++i;
        }
        return (int)var3_3;
    }

    public static boolean isWellFormed(byte[] bytes) {
        byte[] byArray;
        return Utf8.isWellFormed(bytes, 0, byArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isWellFormed(byte[] bytes, int off, int len) {
        void i;
        int end = off + len;
        Preconditions.checkPositionIndexes(off, end, bytes.length);
        while (i < end) {
            if (bytes[i] < 0) {
                return Utf8.isWellFormedSlowPath(bytes, (int)i, end);
            }
            ++i;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isWellFormedSlowPath(byte[] bytes, int off, int end) {
        int index = off;
        while (true) {
            void var3_3;
            byte byte2;
            byte byte1;
            if (index >= end) {
                return true;
            }
            if ((byte1 = bytes[index++]) >= 0) continue;
            if (byte1 < -32) {
                if (index == end) {
                    return false;
                }
                if (byte1 >= -62 && bytes[index++] <= -65) continue;
                return false;
            }
            if (byte1 < -16) {
                if (index + 1 >= end) {
                    return false;
                }
                if (!((byte2 = bytes[index++]) > -65 || byte1 == -32 && byte2 < -96 || byte1 == -19 && -96 <= byte2) && bytes[index++] <= -65) continue;
                return false;
            }
            if (index + 2 >= end) {
                return false;
            }
            if ((byte2 = bytes[index++]) > -65 || (var3_3 << 28) + (byte2 - -112) >> 30 != false || bytes[index++] > -65 || bytes[index++] > -65) break;
        }
        return false;
    }

    private static String unpairedSurrogateMsg(int i) {
        int n;
        return new StringBuilder(39).append("Unpaired surrogate at index ").append(n).toString();
    }

    private Utf8() {
    }
}

