/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.ElementTypesAreNonnullByDefault;
import com.google.common.base.Preconditions;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class Throwables {
    @GwtIncompatible
    private static final String JAVA_LANG_ACCESS_CLASSNAME = "sun.misc.JavaLangAccess";
    @GwtIncompatible
    @VisibleForTesting
    static final String SHARED_SECRETS_CLASSNAME = "sun.misc.SharedSecrets";
    @GwtIncompatible
    private static final Object jla = Throwables.getJLA();
    @GwtIncompatible
    private static final Method getStackTraceElementMethod = jla == null ? null : Throwables.getGetMethod();
    @GwtIncompatible
    private static final Method getStackTraceDepthMethod = jla == null ? null : Throwables.getSizeMethod(jla);

    private Throwables() {
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    public static <X extends Throwable> void throwIfInstanceOf(Throwable throwable, Class<X> declaredType) throws X {
        Preconditions.checkNotNull(throwable);
        if (declaredType.isInstance(throwable)) {
            Throwable throwable2;
            void var1_1;
            throw (Throwable)var1_1.cast(throwable2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @GwtIncompatible
    public static <X extends Throwable> void propagateIfInstanceOf(Throwable throwable, Class<X> declaredType) throws X {
        if (throwable != null) {
            void var1_1;
            Throwable throwable2;
            Throwables.throwIfInstanceOf(throwable2, var1_1);
        }
    }

    public static void throwIfUnchecked(Throwable throwable) {
        Preconditions.checkNotNull(throwable);
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            Throwable throwable2;
            throw (Error)throwable2;
        }
    }

    @Deprecated
    @GwtIncompatible
    public static void propagateIfPossible(Throwable throwable) {
        if (throwable != null) {
            Throwable throwable2;
            Throwables.throwIfUnchecked(throwable2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    public static <X extends Throwable> void propagateIfPossible(Throwable throwable, Class<X> declaredType) throws X {
        Throwable throwable2;
        void var1_1;
        Throwables.propagateIfInstanceOf(throwable, var1_1);
        Throwables.propagateIfPossible(throwable2);
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    public static <X1 extends Throwable, X2 extends Throwable> void propagateIfPossible(Throwable throwable, Class<X1> declaredType1, Class<X2> declaredType2) throws X1, X2 {
        void var2_2;
        Throwable throwable2;
        void var1_1;
        Preconditions.checkNotNull(declaredType2);
        Throwables.propagateIfInstanceOf(throwable, var1_1);
        Throwables.propagateIfPossible(throwable2, var2_2);
    }

    @Deprecated
    @GwtIncompatible
    public static RuntimeException propagate(Throwable throwable) {
        Throwable throwable2;
        Throwables.throwIfUnchecked(throwable);
        throw new RuntimeException(throwable2);
    }

    /*
     * WARNING - void declaration
     */
    public static Throwable getRootCause(Throwable throwable) {
        Throwable throwable2;
        Throwable cause;
        Throwable slowPointer = throwable;
        boolean advanceSlowPointer = false;
        while ((cause = throwable.getCause()) != null) {
            void var3_3;
            throwable = var3_3;
            if (throwable == slowPointer) {
                throw new IllegalArgumentException("Loop in causal chain detected.", throwable);
            }
            if (advanceSlowPointer) {
                slowPointer = slowPointer.getCause();
            }
            advanceSlowPointer = !advanceSlowPointer;
        }
        return throwable2;
    }

    /*
     * WARNING - void declaration
     */
    public static List<Throwable> getCausalChain(Throwable throwable) {
        void var1_1;
        Throwable cause;
        Preconditions.checkNotNull(throwable);
        ArrayList<Throwable> causes = new ArrayList<Throwable>(4);
        causes.add(throwable);
        Throwable slowPointer = throwable;
        boolean advanceSlowPointer = false;
        while ((cause = throwable.getCause()) != null) {
            Throwable throwable2;
            causes.add(throwable2);
            if (throwable2 == slowPointer) {
                throw new IllegalArgumentException("Loop in causal chain detected.", throwable2);
            }
            if (advanceSlowPointer) {
                slowPointer = slowPointer.getCause();
            }
            advanceSlowPointer = !advanceSlowPointer;
        }
        return Collections.unmodifiableList(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    public static <X extends Throwable> X getCauseAs(Throwable throwable, Class<X> expectedCauseType) {
        try {
            return (X)((Throwable)expectedCauseType.cast(throwable.getCause()));
        }
        catch (ClassCastException classCastException) {
            void var1_1;
            Throwable throwable2;
            ClassCastException e = classCastException;
            classCastException.initCause(throwable2);
            throw var1_1;
        }
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    public static String getStackTraceAsString(Throwable throwable) {
        void var1_1;
        Throwable throwable2;
        StringWriter stringWriter = new StringWriter();
        throwable2.printStackTrace(new PrintWriter(stringWriter));
        return var1_1.toString();
    }

    @Deprecated
    @GwtIncompatible
    public static List<StackTraceElement> lazyStackTrace(Throwable throwable) {
        Throwable throwable2;
        if (Throwables.lazyStackTraceIsLazy()) {
            return Throwables.jlaStackTrace(throwable);
        }
        return Collections.unmodifiableList(Arrays.asList(throwable2.getStackTrace()));
    }

    @Deprecated
    @GwtIncompatible
    public static boolean lazyStackTraceIsLazy() {
        return getStackTraceElementMethod != null && getStackTraceDepthMethod != null;
    }

    @GwtIncompatible
    private static List<StackTraceElement> jlaStackTrace(Throwable t) {
        Throwable throwable;
        Preconditions.checkNotNull(t);
        return new AbstractList<StackTraceElement>(){

            /*
             * WARNING - void declaration
             */
            @Override
            public StackTraceElement get(int n) {
                void var1_1;
                return (StackTraceElement)Throwables.access$200(Objects.requireNonNull(getStackTraceElementMethod), Objects.requireNonNull(jla), new Object[]{throwable, (int)var1_1});
            }

            @Override
            public int size() {
                return (Integer)Throwables.access$200(Objects.requireNonNull(getStackTraceDepthMethod), Objects.requireNonNull(jla), new Object[]{throwable});
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    private static Object invokeAccessibleNonThrowingMethod(Method method, Object receiver, Object ... params) {
        try {
            void var2_3;
            void var1_2;
            return method.invoke((Object)var1_2, (Object[])var2_3);
        }
        catch (IllegalAccessException e) {
            void var0_1;
            throw new RuntimeException((Throwable)var0_1);
        }
        catch (InvocationTargetException invocationTargetException) {
            InvocationTargetException invocationTargetException2 = invocationTargetException;
            throw Throwables.propagate(invocationTargetException.getCause());
        }
    }

    @GwtIncompatible
    private static Object getJLA() {
        try {
            GenericDeclaration genericDeclaration = Class.forName(SHARED_SECRETS_CLASSNAME, false, null);
            genericDeclaration = genericDeclaration.getMethod("getJavaLangAccess", new Class[0]);
            return ((Method)genericDeclaration).invoke(null, new Object[0]);
        }
        catch (ThreadDeath threadDeath) {
            ThreadDeath threadDeath2 = threadDeath;
            throw threadDeath;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @GwtIncompatible
    private static Method getGetMethod() {
        return Throwables.getJlaMethod("getStackTraceElement", Throwable.class, Integer.TYPE);
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    private static Method getSizeMethod(Object jla) {
        try {
            void var1_1;
            Object object;
            Method getStackTraceDepth = Throwables.getJlaMethod("getStackTraceDepth", Throwable.class);
            if (getStackTraceDepth == null) {
                return null;
            }
            getStackTraceDepth.invoke(object, new Throwable());
            return var1_1;
        }
        catch (IllegalAccessException | UnsupportedOperationException | InvocationTargetException exception) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    private static Method getJlaMethod(String name, Class<?> ... parameterTypes) throws ThreadDeath {
        ThreadDeath threadDeath;
        try {
            void var1_1;
            return Class.forName(JAVA_LANG_ACCESS_CLASSNAME, false, null).getMethod((String)((Object)threadDeath), (Class<?>)var1_1);
        }
        catch (ThreadDeath threadDeath2) {
            threadDeath = threadDeath2;
            throw threadDeath2;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Object access$200(Method x0, Object x1, Object[] x2) {
        void var2_2;
        void var1_1;
        return Throwables.invokeAccessibleNonThrowingMethod(x0, var1_1, (Object[])var2_2);
    }
}

